/*
 * Decompiled with CFR 0.152.
 */
package com.yy.audioengine;

import com.yy.audioengine.Constant;
import com.yy.audioengine.IAudioCaptureNotify;
import com.yy.audioengine.IAudioEngine;
import com.yy.audioengine.IAudioEngineNotify;
import com.yy.audioengine.IAudioPullFrameInfo;
import com.yy.audioengine.IAudioPullFrameNotify;
import com.yy.audioengine.IAudioRenderInfo;
import com.yy.audioengine.IAudioRenderNotify;
import com.yy.audioengine.IKaraokeScoreNotify;
import com.yy.audioengine.ISpeechMsgPlayerNotify;
import com.yy.audioengine.ISpeechMsgRecorderNotify;
import com.yy.audioengine.SpeechMsgPlayer;
import com.yy.audioengine.SpeechMsgRecorder;
import com.yy.audioengine.TimeRange;

public class AudioEngine
implements IAudioEngine {
    private static final String TAG = "AudioEngine";
    private long engineCtx = this.nativeCreateAudioEngine(this);
    private IAudioCaptureNotify mCaptureNotify = null;
    private IAudioPullFrameNotify mPullFrameNotify = null;
    private IAudioRenderNotify mRenderNotify = null;
    private SpeechMsgRecorder mSpeechMsgRecorder;
    private SpeechMsgPlayer mSpeechMsgPlayer;
    private IAudioEngineNotify mAudioEngineNotify = null;
    private IKaraokeScoreNotify mKaraokeScoreNotify;

    public void destroy() {
        this.nativeDestroyAudioEngine(this.engineCtx);
        this.engineCtx = 0L;
    }

    @Override
    public void startAudioEngine(Constant.AudioEngineMode mode) {
        this.nativeStartAudioEngine(this.engineCtx, mode.ordinal());
    }

    @Override
    public void stopAudioEngine() {
        this.nativeStopAudioEngine(this.engineCtx);
    }

    public void setAudioEngineNotify(IAudioEngineNotify notify) {
        this.mAudioEngineNotify = notify;
    }

    public void startCapture(IAudioCaptureNotify notify, Constant.EncoderType encoderType) {
        this.mCaptureNotify = notify;
        this.nativeStartCapture(this.engineCtx, encoderType.ordinal());
    }

    public void enablePackerVad(boolean enable) {
        this.nativeEnablePackerVad(this.engineCtx, enable);
    }

    public void stopCapture() {
        this.nativeStopCapture(this.engineCtx);
    }

    public void startPlayout(long uid, IAudioPullFrameNotify notify) {
        this.mPullFrameNotify = notify;
        this.nativeStartPlay(this.engineCtx, uid);
    }

    public void startPlayout2(long uid, IAudioRenderNotify notify) {
        this.mRenderNotify = notify;
        this.nativeStartPlay(this.engineCtx, uid);
    }

    public void stopPlayout(long uid) {
        this.nativeStopPlay(this.engineCtx, uid);
    }

    public void setVirtualSpeakerVolume(int volume) {
        this.nativeSetVirtualSpeakerVolume(this.engineCtx, volume);
    }

    public void setVirtualMicVolume(int volume) {
        this.nativeSetVirtualMicVolume(this.engineCtx, volume);
    }

    public boolean startAudioSaver(String fileName, Constant.AudioSaverMode mode, Constant.AudioSaverWriteFileMode wfMode) {
        int modeInt = mode.ordinal();
        int wfModeInt = wfMode.ordinal();
        return this.nativeStartAudioSaver(this.engineCtx, fileName, modeInt, wfModeInt);
    }

    public boolean stopAudioSaver() {
        return this.nativeStopAudioSaver(this.engineCtx);
    }

    public void startSpeechMsgRecorder(String fileName, SpeechMsgRecorder.SpeechMsgCodecType codecType, int maxTime, ISpeechMsgRecorderNotify cb) {
        this.mSpeechMsgRecorder = new SpeechMsgRecorder(fileName, 1, codecType, maxTime);
        this.mSpeechMsgRecorder.init();
        this.mSpeechMsgRecorder.start(cb);
    }

    public void stopSpeechMsgRecorder() {
        this.mSpeechMsgRecorder.stop();
        this.mSpeechMsgRecorder.destroy();
        this.mSpeechMsgRecorder = null;
    }

    public void startSpeechMsgPlayer(String fileName, ISpeechMsgPlayerNotify cb) {
        this.mSpeechMsgPlayer = new SpeechMsgPlayer(fileName);
        this.mSpeechMsgPlayer.init();
        this.mSpeechMsgPlayer.start(cb);
    }

    public void stopSpeechMsgPlayer() {
        this.mSpeechMsgPlayer.stop();
        this.mSpeechMsgPlayer.destroy();
    }

    public void setReverbMode(Constant.ReverbMode mode) {
        int modeInt = mode.ordinal();
        this.nativeSetReverbmode(this.engineCtx, modeInt);
    }

    public void enableRenderVolumeNotify(boolean enable) {
        this.nativeEnableRenderVolumeNotify(this.engineCtx, enable);
    }

    public void enableCaptureVolumeNotify(boolean enable) {
        this.nativeEnableCaptureVolumeNotify(this.engineCtx, enable);
    }

    public void enableVoiceBeautify(boolean enable) {
        this.nativeEnableVoiceBeautify(this.engineCtx, enable);
    }

    public void setVoiceBeautifyMode(Constant.VoiceBeautifyMode mode) {
        int modeInt = mode.ordinal();
        float pitch = 0.0f;
        float reverb = 0.0f;
        this.nativeSetVoiceBeautifyMode(this.engineCtx, modeInt, pitch, reverb);
    }

    public void setVoiceChangerMode(Constant.VoiceChangerMode mode) {
        int modeInt = mode.ordinal();
        this.nativeSetVoiceChangerMode(this.engineCtx, modeInt);
    }

    public void startWavDebugLogger(String path) {
        this.nativeStartWavDebugLogger(this.engineCtx, path);
    }

    public void stopWavDebugLogger() {
        this.nativeStopWavDebugLogger(this.engineCtx);
    }

    public boolean isHeadsetMode() {
        return true;
    }

    public void enableEqualizer(boolean enable) {
        this.nativeEnableEqualizer(this.engineCtx, enable);
    }

    public void setEqualizerParameter(float[] parameterArray) {
        this.nativeSetEqualizerParameter(this.engineCtx, parameterArray);
    }

    public void enableReverbEx(boolean enable) {
        this.nativeEnableReverbEx(this.engineCtx, enable);
    }

    public void setReverbParameter(float[] parameterArray) {
        this.nativeSetReverbParamEx(this.engineCtx, parameterArray);
    }

    public void enableLimiter(boolean enable) {
        this.nativeEnableLimiter(this.engineCtx, enable);
    }

    public void setLimiterParameter(float[] parameterArray) {
        this.nativeSetLimiterParameter(this.engineCtx, parameterArray);
    }

    public void enableCompressor(boolean enable) {
        this.nativeEnableCompressor(this.engineCtx, enable);
    }

    public void setCompressor(int[] parameterArray) {
        this.nativeSetCompressorParameter(this.engineCtx, parameterArray);
    }

    public void startAudioPreview() {
        this.nativeStartAudioPreview(this.engineCtx);
    }

    public void stopAudioPreview() {
        this.nativeStopAudioPreview(this.engineCtx);
    }

    public void setLoudspeakerStatus(boolean enable) {
        this.nativeSetLoudspeakerStatus(this.engineCtx, enable);
    }

    public void enableKaraokeScoreEx(boolean enable) {
        this.nativeEnableKaraokeScoreEx(this.engineCtx, enable);
    }

    public void enableKaraokeScore(boolean enable) {
        this.nativeEnableKaraokeScore(this.engineCtx, enable);
    }

    public void startKaraokeScore(IKaraokeScoreNotify notify) {
        this.mKaraokeScoreNotify = notify;
        this.nativeStartKaraokeScore(this.engineCtx);
    }

    public void pauseKaraokeScore(boolean enable) {
        this.nativePauseKaraokeScore(this.engineCtx, enable);
    }

    public void stopKaraokeScore() {
        this.nativeStopKaraokeScore(this.engineCtx);
    }

    public void resetKaraokeScore(long value) {
        this.nativeResetKaraokeScore(this.engineCtx, value);
    }

    public boolean openScoreRefFile(String fileName) {
        return this.nativeOpenScoreRefFile(this.engineCtx, fileName);
    }

    public byte[] setScoreTimeRange(TimeRange[] timeRanges, int count) {
        return this.nativeSetScoreTimeRange(this.engineCtx, timeRanges, count);
    }

    public void enableSingingAutoTune(boolean enable) {
        this.nativeEnableSingingAutoTune(this.engineCtx, enable);
    }

    public void setCurrentPlayingPosition(long value) {
        this.nativeSetCurrentPlayingPosition(this.engineCtx, value);
    }

    public boolean setSingRefPitchFile(String fileName) {
        return this.nativeSetSingRefPitchFile(this.engineCtx, fileName);
    }

    public boolean setSingRefLyricTimeRange(TimeRange[] timeRanges, int count) {
        return this.nativeSetSingRefLyricTimeRange(this.engineCtx, timeRanges, count);
    }

    public boolean setSingRefLyricFile(String fileName) {
        return this.nativeSetSingRefLyricFile(this.engineCtx, fileName);
    }

    public boolean setSingRefMfccFile(String fileName) {
        return this.nativeSetSingRefMfccFile(this.engineCtx, fileName);
    }

    public boolean oneKeySingingAutoTuneProcess(int mode, String inputPath, String outputPath) {
        return this.nativeOneKeySingingAutoTuneProcess(this.engineCtx, mode, inputPath, outputPath);
    }

    public boolean setPlaybackModeOn(boolean enable) {
        return this.nativeSetPlaybackModeOn(this.engineCtx, enable);
    }

    public boolean setRemoteStreamVolume(long uid, int volume) {
        return this.nativeSetRemoteStreamVolume(this.engineCtx, uid, volume);
    }

    public boolean setRemoteVoicePosition(long uid, int azimuth, int elevation) {
        return this.nativeSetRemoteVoicePosition(this.engineCtx, uid, azimuth, elevation);
    }

    public void enableSoundPositionIndication(boolean enable) {
        this.nativeEnableSoundPositionIndication(this.engineCtx, enable);
    }

    public void setAudioSourceType(Constant.AudioSourceType sourceType) {
        this.nativeSetAudioSourceType(this.engineCtx, sourceType.ordinal());
    }

    public void enableDebugLoopDelay(boolean enable) {
        this.nativeEnableDebugLoopDelay(this.engineCtx, enable);
    }

    public void setLocalVoicePitch(float value) {
        this.nativeSetLocalVoicePitch(this.engineCtx, value);
    }

    private void onEncodedAudioDataEvent(byte[] data, long timeStamp, int ssrc, int vadRes) {
        if (this.mCaptureNotify != null) {
            this.mCaptureNotify.onEncodedAudioData(data, timeStamp, ssrc, vadRes);
        }
    }

    private void onCaptureAudioVolumeEvent(int volume) {
        if (this.mCaptureNotify != null) {
            this.mCaptureNotify.onCaptureAudioVolume(volume);
        }
    }

    private IAudioRenderInfo onRenderAudioDataEvent(int dataSize, int nBytesPerSample, int playoutDelayMS) {
        if (this.mRenderNotify != null) {
            return this.mRenderNotify.onRenderAudioData(dataSize, nBytesPerSample, playoutDelayMS);
        }
        return null;
    }

    private IAudioPullFrameInfo onPullAudioFrameEvent(long id, boolean forcePull, boolean acceleratePlay, boolean fasterPlayOn, boolean stretchPlay, double accelerateMS, double stretchMS, double playDelayMS) {
        if (this.mPullFrameNotify != null) {
            return this.mPullFrameNotify.onPullAudioFrame(id, forcePull, acceleratePlay, fasterPlayOn, stretchPlay, accelerateMS, stretchMS, playDelayMS);
        }
        return null;
    }

    private void onAudioCaptureErrorEvent(int errorType) {
        if (this.mAudioEngineNotify != null) {
            Constant.AudioDeviceErrorType error = Constant.AudioDeviceErrorType.values()[errorType];
            this.mAudioEngineNotify.onAudioCaptureError(error);
        }
    }

    private void onAudioRenderErrorEvent(int errorType) {
        if (this.mAudioEngineNotify != null) {
            Constant.AudioDeviceErrorType error = Constant.AudioDeviceErrorType.values()[errorType];
            this.mAudioEngineNotify.onAudioRenderError(error);
        }
    }

    private void onReceivePhoneCallEvent(boolean isInCall) {
        if (this.mAudioEngineNotify != null) {
            this.mAudioEngineNotify.onReceivePhoneCall(isInCall);
        }
    }

    private void onAudioModeChangeEvent() {
        if (this.mAudioEngineNotify != null) {
            this.mAudioEngineNotify.onAudioModeChange();
        }
    }

    private void onHeadsetPlugEvent(boolean enable) {
        if (this.mAudioEngineNotify != null) {
            this.mAudioEngineNotify.onHeadsetPlug(enable);
        }
    }

    private void onCalcKaraokeScore(byte score, long lineId) {
        if (this.mKaraokeScoreNotify != null) {
            this.mKaraokeScoreNotify.onCalcKaraokeScore(score, lineId);
        }
    }

    private void onSingerPitchVisual(byte val, long lineId, long wordId, long wordNum) {
        if (this.mKaraokeScoreNotify != null) {
            this.mKaraokeScoreNotify.onSingerPitchVisual(val, lineId, wordId, wordNum);
        }
    }

    private native long nativeCreateAudioEngine(Object var1);

    private native void nativeDestroyAudioEngine(long var1);

    private native void nativeStartAudioEngine(long var1, int var3);

    private native void nativeStopAudioEngine(long var1);

    private native void nativeStartCapture(long var1, int var3);

    private native void nativeEnablePackerVad(long var1, boolean var3);

    private native void nativeStopCapture(long var1);

    private native void nativeStartPlay(long var1, long var3);

    private native void nativeStopPlay(long var1, long var3);

    private native void nativeEnableCaptureVolumeNotify(long var1, boolean var3);

    private native void nativeEnableRenderVolumeNotify(long var1, boolean var3);

    private native void nativeSetVirtualSpeakerVolume(long var1, int var3);

    private native void nativeSetVirtualMicVolume(long var1, int var3);

    private native boolean nativeStartAudioSaver(long var1, String var3, int var4, int var5);

    private native boolean nativeStopAudioSaver(long var1);

    private native void nativeEnableVoiceBeautify(long var1, boolean var3);

    private native void nativeSetVoiceBeautifyMode(long var1, int var3, float var4, float var5);

    private native void nativeSetVoiceChangerMode(long var1, int var3);

    private native void nativeSetReverbmode(long var1, int var3);

    private native void nativeStartWavDebugLogger(long var1, String var3);

    private native void nativeStopWavDebugLogger(long var1);

    private native void nativeSetEqualizerParameter(long var1, float[] var3);

    private native void nativeEnableEqualizer(long var1, boolean var3);

    private native void nativeEnableReverbEx(long var1, boolean var3);

    private native void nativeEnableCompressor(long var1, boolean var3);

    private native void nativeEnableLimiter(long var1, boolean var3);

    private native void nativeSetReverbParamEx(long var1, float[] var3);

    private native void nativeSetLimiterParameter(long var1, float[] var3);

    private native void nativeSetCompressorParameter(long var1, int[] var3);

    private native void nativeStartAudioPreview(long var1);

    private native void nativeStopAudioPreview(long var1);

    private native void nativeSetLoudspeakerStatus(long var1, boolean var3);

    private native void nativeEnableKaraokeScoreEx(long var1, boolean var3);

    private native void nativeEnableKaraokeScore(long var1, boolean var3);

    private native void nativeStartKaraokeScore(long var1);

    private native void nativePauseKaraokeScore(long var1, boolean var3);

    private native void nativeStopKaraokeScore(long var1);

    private native void nativeResetKaraokeScore(long var1, long var3);

    private native boolean nativeOpenScoreRefFile(long var1, String var3);

    private native byte[] nativeSetScoreTimeRange(long var1, TimeRange[] var3, long var4);

    private native void nativeEnableSingingAutoTune(long var1, boolean var3);

    private native void nativeSetCurrentPlayingPosition(long var1, long var3);

    private native boolean nativeSetSingRefPitchFile(long var1, String var3);

    private native boolean nativeSetSingRefLyricTimeRange(long var1, TimeRange[] var3, long var4);

    private native boolean nativeSetSingRefLyricFile(long var1, String var3);

    private native boolean nativeSetSingRefMfccFile(long var1, String var3);

    private native boolean nativeOneKeySingingAutoTuneProcess(long var1, int var3, String var4, String var5);

    private native boolean nativeSetPlaybackModeOn(long var1, boolean var3);

    private native boolean nativeSetRemoteStreamVolume(long var1, long var3, int var5);

    private native void nativeEnableSoundPositionIndication(long var1, boolean var3);

    private native boolean nativeSetRemoteVoicePosition(long var1, long var3, int var5, int var6);

    private native void nativeSetAudioSourceType(long var1, int var3);

    private native void nativeEnableDebugLoopDelay(long var1, boolean var3);

    private native void nativeSetLocalVoicePitch(long var1, float var3);
}

