/*
 * Decompiled with CFR 0.152.
 */
package com.yy.hiidostatis.provider;

import com.yy.hiidostatis.provider.MessageConfig;
import com.yy.hiidostatis.provider.Provider;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;

public enum GlobalProvider {
    instance;

    private ConcurrentMap<Class, Provider> classProvider = new ConcurrentHashMap<Class, Provider>();
    private ConcurrentMap<String, Provider> nameProvider = new ConcurrentHashMap<String, Provider>();

    public void registerProvider(Class cl, Provider provider) {
        this.classProvider.put(cl, provider);
    }

    public void registerProvider(String name, Provider provider) {
        this.nameProvider.put(name, provider);
    }

    public <T> T get(Class cl, MessageConfig config) {
        Provider p = (Provider)this.classProvider.get(cl);
        if (p != null) {
            return p.generate(config);
        }
        return null;
    }

    public <T> T get(String name, MessageConfig config) {
        Provider p = (Provider)this.nameProvider.get(name);
        if (p != null) {
            return p.generate(config);
        }
        return null;
    }
}

