/*
 * Decompiled with CFR 0.152.
 */
package com.yy.hiidostatis.message.storage;

import android.content.Context;
import com.yy.hiidostatis.inner.implementation.TaskData;
import com.yy.hiidostatis.inner.implementation.TaskDataSqLiteCacheManager;
import com.yy.hiidostatis.inner.util.Util;
import com.yy.hiidostatis.inner.util.log.L;
import com.yy.hiidostatis.message.MessageMonitor;
import com.yy.hiidostatis.message.MessageSupplier;
import com.yy.hiidostatis.message.bean.Message;
import com.yy.hiidostatis.provider.MessageConfig;
import java.io.UnsupportedEncodingException;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Locale;
import java.util.Set;

public class MessageSupplierProxy
implements MessageSupplier {
    private static final int BLACK_LIST_CAPACITY = 200;
    private final Context context;
    private final TaskDataSqLiteCacheManager cacheManager;
    private Set<String> blackListIndex = new HashSet<String>(200);
    private List<String> blackList = new LinkedList<String>();
    private MessageMonitor monitor;
    private final MessageConfig config;

    public MessageSupplierProxy(Context context, MessageConfig config, TaskDataSqLiteCacheManager cacheManager, MessageMonitor monitor) {
        this.context = context;
        this.cacheManager = cacheManager;
        this.monitor = monitor;
        this.config = config;
    }

    private synchronized void addBlackList(String msgId) {
        if (msgId == null) {
            return;
        }
        if (this.blackList.size() >= 200) {
            String id = this.blackList.remove(0);
            this.blackListIndex.remove(id);
        }
        this.blackList.add(msgId);
        this.blackListIndex.add(msgId);
    }

    private synchronized boolean isInBlackList(String msgId) {
        if (msgId == null) {
            return false;
        }
        return this.blackListIndex.contains(msgId);
    }

    @Override
    public Message fetchMessage(int limitSize) {
        List<TaskData> data = this.cacheManager.getAndMoveToSendingList(this.context, limitSize);
        if (data == null || data.isEmpty()) {
            L.brief("data is null,end send. ", new Object[0]);
            return null;
        }
        Message msg = null;
        msg = data.size() == 1 ? this.trans(data.get(0)) : this.trans(data);
        return msg;
    }

    @Override
    public void removeMessage(String msgId) {
        String[] actIds = msgId.split(",");
        try {
            ArrayList<String> ids = new ArrayList<String>();
            for (String actId : actIds) {
                if (actId.isEmpty()) continue;
                String[] arr = actId.split("_");
                ids.add(arr[1]);
            }
            this.cacheManager.removeSendListBatch(this.context, ids);
        }
        catch (Throwable e) {
            e.printStackTrace();
        }
    }

    @Override
    public void restoreMessage(String msgId) {
        String[] actIds = msgId.split(",");
        try {
            ArrayList<String[]> ids = new ArrayList<String[]>();
            for (String actId : actIds) {
                if (actId.isEmpty()) continue;
                String[] arr = actId.split("_");
                ids.add(arr);
            }
            this.cacheManager.restoreSendList(this.context, ids);
        }
        catch (Throwable e) {
            e.printStackTrace();
        }
    }

    private Message trans(TaskData taskData) {
        String str = String.format(Locale.CHINA, "act=mbsdkdata&EC=%d&appkey=%s&item=%s", taskData.getTryTimes(), taskData.getAppkey(), taskData.getAct());
        Message msg = null;
        try {
            String content = taskData.getCrepid() == this.monitor.getProcessId() ? String.format(Locale.CHINA, "%s&%s=%d&%s=%d&hd_stime=%d", taskData.getContent(), "hd_packid", taskData.getPackId(), "hd_remain", taskData.getRemain(), Util.wallTimeMillis()) : String.format(Locale.CHINA, "%s&%s=%d&%s=%d&%s=%d&hd_stime=%d", taskData.getContent(), "hd_packid", taskData.getPackId(), "hd_curpid", this.monitor.getProcessId(), "hd_remain", taskData.getRemain(), Util.wallTimeMillis());
            msg = new Message(taskData.getAct() + "_" + taskData.getDataId(), 1, str, content.getBytes("UTF-8"), content.length());
        }
        catch (UnsupportedEncodingException e) {
            e.printStackTrace();
        }
        return msg;
    }

    private Message trans(List<TaskData> taskData) {
        String str = "act=mbsdkdata";
        Message msg = null;
        try {
            long ct = Util.wallTimeMillis();
            StringBuilder builder = new StringBuilder();
            builder.append("[");
            StringBuilder ids = new StringBuilder();
            for (TaskData td : taskData) {
                builder.append("\"");
                builder.append(td.getContent());
                builder.append("&");
                builder.append("hd_packid");
                builder.append("=");
                builder.append(td.getPackId());
                builder.append("&");
                builder.append("hd_remain");
                builder.append("=");
                builder.append(td.getRemain());
                if (td.getCrepid() != this.monitor.getProcessId()) {
                    builder.append("&");
                    builder.append("hd_curpid");
                    builder.append("=");
                    builder.append(this.monitor.getProcessId());
                }
                builder.append("&hd_stime=");
                builder.append(ct);
                builder.append("\",");
                ids.append(td.getAct());
                ids.append("_");
                ids.append(td.getDataId());
                ids.append(",");
            }
            builder.setLength(builder.length() - 1);
            builder.append("]");
            ids.setLength(ids.length() - 1);
            msg = new Message(ids.toString(), taskData.size(), str, builder.toString().getBytes("UTF-8"), builder.length());
        }
        catch (UnsupportedEncodingException e) {
            e.printStackTrace();
        }
        return msg;
    }
}

