/*
 * Decompiled with CFR 0.152.
 */
package com.yy.hiidostatis.message.sender;

import com.yy.hiidostatis.inner.util.SharedTimerTask;
import com.yy.hiidostatis.inner.util.ThreadPool;
import com.yy.hiidostatis.inner.util.log.L;
import com.yy.hiidostatis.message.ISingleton;
import com.yy.hiidostatis.message.MessageProcessor;
import com.yy.hiidostatis.message.MessageSender;
import com.yy.hiidostatis.message.MessageSupplier;
import com.yy.hiidostatis.message.Task;
import com.yy.hiidostatis.message.bean.Message;
import com.yy.hiidostatis.message.log.TraceLog;
import com.yy.hiidostatis.message.utils.TimeUtil;
import com.yy.hiidostatis.provider.MessageConfig;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.atomic.AtomicInteger;

public class SendMsgDispatcher
implements Task,
Runnable,
MessageSender.ResultListener,
ISingleton {
    private static final int LIMIT_SIZE = 40960;
    private static final int LIMIT_SIZE_STEP = 10240;
    private static final int SENDING_CAPACITY = 10;
    private static final int CHANGE_LIMIT_SIZE_THRESHOLD = 3;
    private static final int STOP_SEND_THRESHOLD = 3;
    private static final long MAX_WAIT_MILLIS = 30000L;
    private MessageSupplier supplier;
    private MessageSender sender;
    private List<MessageProcessor> messageProcessors = new ArrayList<MessageProcessor>();
    private volatile boolean running;
    private volatile int state = 0;
    private volatile AtomicInteger errorCount = new AtomicInteger();
    private volatile int limitSize = 40960;
    private AtomicInteger sendingCount = new AtomicInteger(0);
    private AtomicInteger sfCount = new AtomicInteger();
    private MessageConfig config;
    private SharedTimerTask timerTask;
    private int preRunTime = 0;

    public SendMsgDispatcher(MessageSupplier supplier, MessageSender sender, List<MessageProcessor> messageProcessors) {
        this.supplier = supplier;
        this.sender = sender;
        if (messageProcessors != null) {
            this.messageProcessors.addAll(messageProcessors);
        }
        sender.setResultListener(this);
    }

    @Override
    public void setMainConfig(MessageConfig config) {
        if (this.config != null) {
            return;
        }
        this.config = config;
        this.timerTask = new SharedTimerTask(){

            @Override
            public void run() {
                SendMsgDispatcher.this.execute();
            }
        };
        long interval = 30000L;
        if (config.getInterval() > 0) {
            interval = (long)Math.max(config.getInterval(), 5) * 1000L;
        }
        ThreadPool.getPool().getTimer().schedule(this.timerTask, interval, interval);
    }

    public void appendMessageProcessor(MessageProcessor mp) {
        this.messageProcessors.add(mp);
    }

    public void insertMessageProcessor(int index, MessageProcessor mp) {
        this.messageProcessors.add(index, mp);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void run() {
        try {
            SendMsgDispatcher sendMsgDispatcher;
            if (this.running) {
                return;
            }
            SendMsgDispatcher sendMsgDispatcher2 = this;
            synchronized (sendMsgDispatcher2) {
                if (this.running) {
                    return;
                }
                this.running = true;
            }
            int count = 0;
            while (this.running && count < 10) {
                MessageProcessor mp;
                Object object;
                sendMsgDispatcher = this;
                synchronized (sendMsgDispatcher) {
                    this.state = 1;
                }
                this.preRunTime = TimeUtil.currentTimeInSecond();
                Message msg = this.supplier.fetchMessage(this.limitSize);
                if (msg == null) {
                    object = this;
                    synchronized (object) {
                        if (this.state != 2) {
                            this.state = 0;
                        }
                        break;
                    }
                }
                if (this.limitSize > msg.getContent().length) {
                    this.running = false;
                }
                object = this.messageProcessors.iterator();
                while (object.hasNext() && (msg = (mp = (MessageProcessor)object.next()).process(msg)) != null) {
                }
                if (msg == null) continue;
                count = this.sendingCount.incrementAndGet();
                this.sender.asyncSend(msg);
            }
            sendMsgDispatcher = this;
            synchronized (sendMsgDispatcher) {
                if (this.state == 1) {
                    this.state = 0;
                }
                this.running = false;
            }
        }
        catch (Exception e) {
            e.printStackTrace();
            SendMsgDispatcher sendMsgDispatcher = this;
            synchronized (sendMsgDispatcher) {
                if (this.state == 1) {
                    this.state = 0;
                }
                this.running = false;
            }
        }
    }

    @Override
    public void onResult(int code, Message msg, String errorMsg) {
        int count = this.sendingCount.decrementAndGet();
        if (code == 0) {
            L.info(this, "Send Success:%s", msg.getMsgId());
            TraceLog.successMessageLog(msg.getMsgId());
            this.supplier.removeMessage(msg.getMsgId());
            this.errorCount.set(this.errorCount.get() / 2);
            if (count < 5) {
                this.execute();
            }
            int ss = this.sfCount.incrementAndGet();
            if (!msg.isSingle() && ss > 3) {
                this.sfCount.set(0);
                this.limitSize = Math.min(this.limitSize + 10240, 40960);
                L.info(this, "change limit size:%d add", this.limitSize);
            } else if (ss > 9) {
                this.sfCount.set(0);
                this.limitSize = Math.min(this.limitSize + 10240, 40960);
                L.info(this, "change limit size:%d add", this.limitSize);
            }
        } else {
            int ss;
            TraceLog.failedMessageLog(msg.getMsgId());
            L.info(this, "Send Error:%s", msg.getMsgId());
            this.supplier.restoreMessage(msg.getMsgId());
            int ec = this.errorCount.incrementAndGet();
            if (ec > 3) {
                this.execute(Math.min((long)ec * 1000L, 30000L));
            }
            if (!msg.isSingle() && (ss = this.sfCount.decrementAndGet()) < -3) {
                this.sfCount.set(0);
                this.limitSize = Math.max(this.limitSize - 10240, 0);
                L.info(this, "change limit size:%d reduce", this.limitSize);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void execute() {
        SendMsgDispatcher sendMsgDispatcher = this;
        synchronized (sendMsgDispatcher) {
            if (this.state == 0 || (long)(TimeUtil.currentTimeInSecond() - this.preRunTime) > 30000L) {
                this.state = 1;
                this.preRunTime = TimeUtil.currentTimeInSecond();
                ThreadPool.getPool().execute(this);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void execute(long delayMillis) {
        SendMsgDispatcher sendMsgDispatcher = this;
        synchronized (sendMsgDispatcher) {
            if (this.state != 2 || (long)(TimeUtil.currentTimeInSecond() - this.preRunTime) > 30000L) {
                this.state = 2;
                this.running = false;
                this.preRunTime = TimeUtil.currentTimeInSecond();
                ThreadPool.getPool().execute(this, delayMillis);
            }
        }
    }
}

