/*
 * Decompiled with CFR 0.152.
 */
package com.yy.hiidostatis.message.sender;

import com.yy.hiidostatis.inner.util.log.L;
import com.yy.hiidostatis.message.AppInfo;
import com.yy.hiidostatis.message.HostManager;
import com.yy.hiidostatis.message.MessageSender;
import com.yy.hiidostatis.message.bean.Message;
import com.yy.hiidostatis.message.utils.NoNull;
import java.io.IOException;
import java.net.InetAddress;
import java.net.URLEncoder;
import java.net.UnknownHostException;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.concurrent.TimeUnit;
import okhttp3.Call;
import okhttp3.Callback;
import okhttp3.Dns;
import okhttp3.MediaType;
import okhttp3.OkHttpClient;
import okhttp3.Protocol;
import okhttp3.Request;
import okhttp3.RequestBody;
import okhttp3.Response;

public class OKSender
implements MessageSender {
    private HostManager host;
    private MyDns dns = new MyDns();
    private MyCallback callback = new MyCallback();
    private MessageSender.ResultListener listener;
    private MediaType mediaType;
    private AppInfo appInfo;
    private OkHttpClient client = new OkHttpClient.Builder().protocols(Collections.unmodifiableList(Arrays.asList(Protocol.HTTP_1_1, Protocol.HTTP_2))).connectTimeout(5L, TimeUnit.SECONDS).retryOnConnectionFailure(true).dns((Dns)this.dns).readTimeout(30L, TimeUnit.SECONDS).build();

    public OKSender(HostManager host, AppInfo appInfo) {
        this.host = host;
        this.appInfo = appInfo;
    }

    @Override
    public void asyncSend(Message msg) {
        if (this.mediaType == null) {
            try {
                this.mediaType = MediaType.parse((String)"text/plain");
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        RequestBody body = RequestBody.create((MediaType)this.mediaType, (byte[])msg.toBody());
        String url = this.smartUrl(msg);
        L.debug(this, "send url: %s", url);
        ReqTag tag = new ReqTag(msg);
        Request request = new Request.Builder().url(url).post(body).tag((Object)tag).build();
        Call call = this.client.newCall(request);
        call.enqueue((Callback)this.callback);
    }

    @Override
    public void setResultListener(MessageSender.ResultListener listener) {
        this.listener = listener;
    }

    private String smartUrl(Message message) {
        String hostApp = "";
        String hostVer = "";
        try {
            hostApp = URLEncoder.encode(NoNull.noNull(this.appInfo.getAppAppkey()), "UTF-8");
            hostVer = URLEncoder.encode(NoNull.noNull(this.appInfo.getAppVer()), "UTF-8");
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        if (message.isSingle()) {
            return String.format("https://%s/c.gif?%s&host_appkey=%s&host_ver=%s", this.host.getHost(message), message.getUrlParams(), hostApp, hostVer);
        }
        return String.format("https://%s/x.gif?%s&host_appkey=%s&host_ver=%s", this.host.getHost(message), message.getUrlParams(), hostApp, hostVer);
    }

    private static class ReqTag {
        private Message msg;

        ReqTag(Message msg) {
            this.msg = msg;
        }

        public Message getMsg() {
            return this.msg;
        }
    }

    private class MyCallback
    implements Callback {
        private MyCallback() {
        }

        public void onFailure(Call call, IOException e) {
            OKSender.this.host.onFailure(call, e);
            Request req = call.request();
            ReqTag tag = (ReqTag)req.tag();
            if (tag != null) {
                OKSender.this.listener.onResult(1000, tag.getMsg(), e.getMessage());
            }
        }

        public void onResponse(Call call, Response response) {
            ReqTag tag = (ReqTag)call.request().tag();
            if (response.isSuccessful()) {
                OKSender.this.host.onSuccess(call);
                if (OKSender.this.listener != null) {
                    assert (tag != null);
                    OKSender.this.listener.onResult(0, tag.getMsg(), null);
                }
            } else {
                assert (tag != null);
                OKSender.this.listener.onResult(response.code(), tag.getMsg(), response.message());
                OKSender.this.host.onFailure(call, null);
            }
        }
    }

    private class MyDns
    implements Dns {
        private MyDns() {
        }

        public List<InetAddress> lookup(String hostname) throws UnknownHostException {
            return OKSender.this.host.lookup(hostname);
        }
    }
}

