/*
 * Decompiled with CFR 0.152.
 */
package com.yy.hiidostatis.message.sender;

import android.content.Context;
import com.yy.hiidostatis.inner.util.ThreadPool;
import com.yy.hiidostatis.message.AppInfo;
import com.yy.hiidostatis.provider.MessageConfig;
import java.io.File;
import java.io.FilenameFilter;
import java.io.IOException;
import java.util.Locale;

public class AppInfoManager
implements AppInfo {
    private long preFetchTime;
    private boolean init;
    private String appkey;
    private String ver;
    private Context context;

    public AppInfoManager(Context context) {
        this.context = context;
    }

    @Override
    public String getAppAppkey() {
        if (!this.init) {
            this.load();
        }
        return this.appkey;
    }

    @Override
    public String getAppVer() {
        if (!this.init) {
            this.load();
        }
        return this.ver;
    }

    private synchronized void load() {
        try {
            int pos;
            if (this.preFetchTime != 0L && System.currentTimeMillis() - this.preFetchTime < 3000L) {
                return;
            }
            if (this.preFetchTime > 0L) {
                this.init = true;
            }
            this.preFetchTime = System.currentTimeMillis();
            String[] dir = new File(this.getDir(this.context)).list(this.getFileFilter());
            if (dir != null && dir.length > 0 && (pos = dir[0].indexOf("_")) > 0) {
                String ak = dir[0].substring(0, pos);
                String v = dir[0].substring(pos + 1, dir[0].length() - 8);
                this.appkey = ak;
                this.ver = v;
                this.init = true;
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    @Override
    public synchronized void updateAppInfo(MessageConfig config) {
        this.init = true;
        if (!config.getAppkey().equals(this.appkey) || !config.getVer().equals(this.ver)) {
            this.appkey = config.getAppkey();
            this.ver = config.getVer();
            this.updateLocalRecord(config.getApplicationContext(), this.appkey, this.ver);
        }
    }

    private void updateLocalRecord(final Context context, final String appkey, final String ver) {
        ThreadPool.getPool().execute(new Runnable(){

            @Override
            public void run() {
                String fileName = String.format(Locale.CHINA, "%s/%s_%s.appinfo", AppInfoManager.this.getDir(context), appkey, ver);
                File file = new File(fileName);
                if (file.exists()) {
                    return;
                }
                try {
                    AppInfoManager.this.clearDir();
                    file.createNewFile();
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
            }
        });
    }

    private String getDir(Context context) {
        return String.format(Locale.CHINA, "%s/hiido", context.getFilesDir().getAbsolutePath());
    }

    private void clearDir() {
        try {
            File dirFile = new File(this.getDir(this.context));
            dirFile.mkdirs();
            File[] fs = dirFile.listFiles(this.getFileFilter());
            if (fs != null && fs.length > 0) {
                for (File f : fs) {
                    f.delete();
                }
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private FilenameFilter getFileFilter() {
        return new FilenameFilter(){

            @Override
            public boolean accept(File dir, String name) {
                return name.endsWith(".appinfo");
            }
        };
    }
}

