/*
 * Decompiled with CFR 0.152.
 */
package com.yy.hiidostatis.message.log;

import android.app.Application;
import android.content.Context;
import com.yy.hiidostatis.api.StatisContent;
import com.yy.hiidostatis.inner.util.ArdUtil;
import com.yy.hiidostatis.inner.util.ProcessUtil;
import com.yy.hiidostatis.inner.util.ThreadPool;
import com.yy.hiidostatis.inner.util.Util;
import com.yy.hiidostatis.inner.util.hdid.DeviceProxy;
import java.io.File;
import java.io.FileOutputStream;
import java.io.FilenameFilter;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Comparator;
import java.util.Locale;

public class TraceLog {
    private static final int LENGTH_APPKEY = 8;
    private static final String LOG_FILE_SUB_PATH = "hdstatis";
    private static final String LOG_FILE_PREFIX = "hdtrace";
    private static final long LOG_FILE_CAPACITY = 0x6400000L;
    private static final int UNINIT = 0;
    private static final int INIT_SUCCESS = 1;
    private static final int INIT_FAILED = -1;
    private static TraceLog logger = new TraceLog();
    private static boolean enable = true;
    private final StringBuilder cache = new StringBuilder();
    private volatile int initResult = 0;
    private volatile boolean writing;
    private FileOutputStream stream;
    private String innerPath;
    private String outerPath;
    private Context appContext;
    private Runnable writeRunnable = new Runnable(){

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            TraceLog.this.writing = false;
            if (TraceLog.this.initResult != 1) {
                TraceLog.this.cache.setLength(0);
                return;
            }
            if (TraceLog.this.stream == null) {
                try {
                    TraceLog.this.stream = new FileOutputStream(TraceLog.this.getFileName());
                }
                catch (Throwable e) {
                    e.printStackTrace();
                    return;
                }
            }
            try {
                String str;
                StringBuilder stringBuilder = TraceLog.this.cache;
                synchronized (stringBuilder) {
                    str = TraceLog.this.cache.toString();
                    TraceLog.this.cache.setLength(0);
                }
                if (!str.isEmpty()) {
                    TraceLog.this.stream.write(str.getBytes("UTF-8"));
                }
                TraceLog.this.stream.flush();
            }
            catch (Throwable e) {
                e.printStackTrace();
            }
        }
    };

    public synchronized void init(Context context) {
        if (this.initResult == 0) {
            try {
                this.appContext = context instanceof Application ? context : context.getApplicationContext();
                this.innerPath = String.format(Locale.CHINA, "%s%s%s", context.getCacheDir().getAbsolutePath(), File.separator, LOG_FILE_SUB_PATH);
                if (ArdUtil.checkPermissions(context, "android.permission.WRITE_EXTERNAL_STORAGE") && context.getExternalCacheDir() != null) {
                    this.outerPath = String.format(Locale.CHINA, "%s%s%s", context.getExternalCacheDir().getAbsolutePath(), File.separator, LOG_FILE_SUB_PATH);
                }
                this.initResult = 1;
                this.startLogClean();
            }
            catch (Throwable e) {
                e.printStackTrace();
                this.initResult = -1;
            }
        }
    }

    private void startLogClean() {
        ThreadPool.getPool().execute(new Runnable(){

            @Override
            public void run() {
                File[] outer;
                File[] inner;
                ArrayList<File> files = new ArrayList<File>();
                long size = 0L;
                if (TraceLog.this.innerPath != null && (inner = new File(TraceLog.this.innerPath).listFiles(new FilenameFilter(){

                    @Override
                    public boolean accept(File dir, String name) {
                        return name.startsWith(TraceLog.LOG_FILE_PREFIX);
                    }
                })) != null && inner.length > 0) {
                    files.addAll(Arrays.asList(inner));
                }
                if (TraceLog.this.outerPath != null && (outer = new File(TraceLog.this.outerPath).listFiles(new FilenameFilter(){

                    @Override
                    public boolean accept(File dir, String name) {
                        return name.startsWith(TraceLog.LOG_FILE_PREFIX);
                    }
                })) != null && outer.length > 0) {
                    files.addAll(Arrays.asList(outer));
                }
                Collections.sort(files, new Comparator<File>(){

                    @Override
                    public int compare(File o1, File o2) {
                        return o1.getName().compareTo(o2.getName());
                    }
                });
                if (files.size() > 2) {
                    for (int i = files.size() - 2; i > 0; --i) {
                        boolean delete;
                        File f = (File)files.get(i);
                        if ((size += f.length()) <= 0x6400000L || !(delete = f.delete())) continue;
                        size -= f.length();
                    }
                }
            }
        });
    }

    private String getFileName() {
        String path = this.outerPath == null ? this.innerPath : this.outerPath;
        try {
            new File(path).mkdirs();
        }
        catch (Throwable e) {
            e.printStackTrace();
        }
        return String.format(Locale.CHINA, "%s%s%s_%s_%s.txt", path, File.separator, LOG_FILE_PREFIX, this.ts(), ProcessUtil.getFileNameBindProcess(this.appContext, DeviceProxy.getHdid(this.appContext)));
    }

    public static void initLog(Context context) {
        logger.init(context);
    }

    public static void setEnable(boolean e) {
        enable = e;
    }

    public static void addMessageLog(String appkey, StatisContent content) {
        if (enable) {
            logger.addMessage(appkey, content);
        }
    }

    public static void saveMessageLog(String ids) {
        if (enable) {
            logger.saveMessage(ids);
        }
    }

    public static void successMessageLog(String ids) {
        if (enable) {
            logger.successMessage(ids);
        }
    }

    public static void failedMessageLog(String ids) {
        if (enable) {
            logger.failedMessage(ids);
        }
    }

    public static void dropMessageLog(String act, String id) {
        if (enable) {
            logger.dropMessage(act, id);
        }
    }

    private void addMessage(String appkey, StatisContent content) {
        if (this.initResult == -1) {
            return;
        }
        try {
            String log = String.format(Locale.CHINA, "A,%s,%s,%s,%s,%d,%d\n", this.ts(), appkey.substring(0, 8), content.getAct(), content.getGuid(), content.getAutoId(), content.isNotSave() ? 0 : 1);
            this.addLog(log);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void addLog(String log) {
        StringBuilder stringBuilder = this.cache;
        synchronized (stringBuilder) {
            this.cache.append(log);
        }
        this.write();
    }

    private String ts() {
        return Util.formatDate("yyyyMMddHHmmssSSS", System.currentTimeMillis());
    }

    private void write() {
        if (this.initResult != 1) {
            return;
        }
        if (!this.writing) {
            this.writing = true;
            ThreadPool.getPool().execute(this.writeRunnable);
        }
    }

    private void saveMessage(String ids) {
        if (this.initResult == -1) {
            return;
        }
        this.addLog(String.format(Locale.CHINA, "S,%s,%s\n", this.ts(), ids));
    }

    private void successMessage(String ids) {
        if (this.initResult == -1) {
            return;
        }
        String log = String.format(Locale.CHINA, "F,%s,%s\n", this.ts(), ids);
        this.addLog(log);
    }

    private void failedMessage(String ids) {
        if (this.initResult == -1) {
            return;
        }
        String log = String.format(Locale.CHINA, "E,%s,%s\n", this.ts(), ids);
        this.addLog(log);
    }

    private void dropMessage(String act, String id) {
        if (this.initResult == -1) {
            return;
        }
        String log = String.format(Locale.CHINA, "D,%s,%s_%s\n", this.ts(), act, id);
        this.addLog(log);
    }
}

