/*
 * Decompiled with CFR 0.152.
 */
package com.yy.hiidostatis.message.processor;

import com.yy.hiidostatis.inner.util.Util;
import com.yy.hiidostatis.inner.util.cipher.AesCipher;
import com.yy.hiidostatis.inner.util.cipher.Base64Util;
import com.yy.hiidostatis.inner.util.cipher.RsaCipher;
import com.yy.hiidostatis.message.MessageProcessor;
import com.yy.hiidostatis.message.bean.Message;
import java.io.ByteArrayInputStream;
import java.net.URLEncoder;
import java.util.Locale;
import java.util.Map;

public class EncryptProcessor
implements MessageProcessor {
    private RsaCipher mRsaCipher = null;
    private static final String RSA_PUB_KEY = "MCwwDQYJKoZIhvcNAQEBBQADGwAwGAIRAMRSvSVZEbyQwtFwNtNiZKkCAwEAAQ==";

    @Override
    public Message process(Message msg) {
        try {
            return this.encrypt(msg);
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
    }

    private Message encrypt(Message msg) throws Exception {
        String aesKey = Util.getRandStringEx(4);
        AesCipher aesCipher = new AesCipher(aesKey.getBytes());
        byte[] data = aesCipher.encrypt(msg.getContent());
        aesKey = this.getRsaCipher().encryptTlogAesKey(aesKey.getBytes());
        if (msg.isSingle()) {
            Map<String, String> ps = Util.parseParams(msg.getUrlParams());
            String params = String.format(Locale.CHINA, "act=mbsdkdata&smkdata=%s&EC=%s&appkey=%s&item=%s&enc=b64&hiido_time=%.3f", URLEncoder.encode(aesKey, "UTF-8"), ps.get("EC"), ps.get("appkey"), ps.get("item"), (double)System.currentTimeMillis() / 1000.0);
            msg.setUrlParams(params);
        } else {
            String params = String.format(Locale.CHINA, "smkdata=%s&enc=b64", URLEncoder.encode(aesKey, "UTF-8"));
            msg.setUrlParams(params);
        }
        msg.setContent(data);
        return msg;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private RsaCipher getRsaCipher() throws Exception {
        if (this.mRsaCipher != null) {
            return this.mRsaCipher;
        }
        EncryptProcessor encryptProcessor = this;
        synchronized (encryptProcessor) {
            if (this.mRsaCipher != null) {
                return this.mRsaCipher;
            }
            byte[] keyBytes = Base64Util.decode(RSA_PUB_KEY);
            ByteArrayInputStream bis = new ByteArrayInputStream(keyBytes);
            RsaCipher rc = new RsaCipher();
            rc.loadPublicKey(bis);
            this.mRsaCipher = rc;
            return this.mRsaCipher;
        }
    }
}

