/*
 * Decompiled with CFR 0.152.
 */
package com.yy.hiidostatis.message.monitor;

import com.yy.hiidostatis.message.MessageMonitor;
import com.yy.hiidostatis.message.utils.KVIO;
import com.yy.hiidostatis.provider.MessageConfig;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicLong;

public class MessageMonitorImpl
implements MessageMonitor {
    private static final String PROCESS_ID_KEY = "hiido_process_id";
    private final ConcurrentHashMap<String, MessageParams> msgParams;
    private MessageConfig config;
    private int processId;

    public MessageMonitorImpl(MessageConfig config) {
        this.config = config;
        this.msgParams = new ConcurrentHashMap();
        this.processId = KVIO.get().decodeInt(PROCESS_ID_KEY, 1);
        KVIO.get().encode(PROCESS_ID_KEY, this.processId + 1);
    }

    @Override
    public long getAutoId(String act) {
        MessageParams aid = this.getAct(act);
        long id = aid.incrementAndGetAutoId();
        this.writeAutoIdToRecord(aid);
        return id;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private MessageParams getAct(String act) {
        MessageParams aid = this.msgParams.get(act);
        if (aid == null) {
            ConcurrentHashMap<String, MessageParams> concurrentHashMap = this.msgParams;
            synchronized (concurrentHashMap) {
                aid = this.msgParams.get(act);
                if (aid == null) {
                    aid = new MessageParams(act);
                    this.msgParams.put(act, aid);
                }
            }
        }
        return aid;
    }

    @Override
    public int getProcessId() {
        return this.processId;
    }

    @Override
    public int getPackId(String act) {
        return this.getAct(act).incrementAndGetPackId();
    }

    @Override
    public void init() {
    }

    @Override
    public void commit() {
        KVIO.get().commit();
    }

    private synchronized void writeAutoIdToRecord(MessageParams msg) {
        KVIO.get().encode(msg.getAutoIdKey(), msg.getAutoId());
    }

    private static class MessageParams {
        private String act;
        private String autoIdKey;
        private AtomicLong autoId;
        private AtomicInteger packId;

        MessageParams(String act) {
            this.act = act;
            this.autoIdKey = act + "_auid";
            this.autoId = new AtomicLong(KVIO.get().decodeLong(this.autoIdKey));
            this.packId = new AtomicInteger();
        }

        String getAutoIdKey() {
            return this.autoIdKey;
        }

        long incrementAndGetAutoId() {
            return this.autoId.incrementAndGet();
        }

        int incrementAndGetPackId() {
            return this.packId.incrementAndGet();
        }

        public String getAct() {
            return this.act;
        }

        long getAutoId() {
            return this.autoId.get();
        }
    }
}

