/*
 * Decompiled with CFR 0.152.
 */
package com.yy.hiidostatis.inner.util;

public class NumberUtil {
    public static byte[] getBytes(char data) {
        byte[] bytes = new byte[]{(byte)data, (byte)(data >> 8)};
        return bytes;
    }

    public static byte[] getBytes(int data) {
        byte[] bytes = new byte[]{(byte)(data & 0xFF), (byte)((data & 0xFF00) >> 8), (byte)((data & 0xFF0000) >> 16), (byte)((data & 0xFF000000) >> 24)};
        return bytes;
    }

    public static byte[] getBytes(long data) {
        byte[] bytes = new byte[]{(byte)(data & 0xFFL), (byte)(data >> 8 & 0xFFL), (byte)(data >> 16 & 0xFFL), (byte)(data >> 24 & 0xFFL), (byte)(data >> 32 & 0xFFL), (byte)(data >> 40 & 0xFFL), (byte)(data >> 48 & 0xFFL), (byte)(data >> 56 & 0xFFL)};
        return bytes;
    }

    public static byte[] getBytes(float data) {
        int intBits = Float.floatToIntBits(data);
        return NumberUtil.getBytes(intBits);
    }

    public static byte[] getBytes(double data) {
        long intBits = Double.doubleToLongBits(data);
        return NumberUtil.getBytes(intBits);
    }

    public static short getShort(byte[] bytes, int offset) {
        return (short)(0xFF & bytes[0 + offset] | 0xFF00 & bytes[1 + offset] << 8);
    }

    public static char getChar(byte[] bytes, int offset) {
        return (char)(0xFF & bytes[0 + offset] | 0xFF00 & bytes[1 + offset] << 8);
    }

    public static int getInt(byte[] bytes) {
        return 0xFF & bytes[0] | 0xFF00 & bytes[1] << 8 | 0xFF0000 & bytes[2] << 16 | 0xFF000000 & bytes[3] << 24;
    }

    public static int getInt(byte[] bytes, int offset) {
        return 0xFF & bytes[0 + offset] | 0xFF00 & bytes[1 + offset] << 8 | 0xFF0000 & bytes[2 + offset] << 16 | 0xFF000000 & bytes[3 + offset] << 24;
    }

    public static long getLong(byte[] bytes) {
        return 0xFFL & (long)bytes[0] | 0xFF00L & (long)bytes[1] << 8 | 0xFF0000L & (long)bytes[2] << 16 | 0xFF000000L & (long)bytes[3] << 24 | 0xFF00000000L & (long)bytes[4] << 32 | 0xFF0000000000L & (long)bytes[5] << 40 | 0xFF000000000000L & (long)bytes[6] << 48 | 0xFF00000000000000L & (long)bytes[7] << 56;
    }

    public static long getLong(byte[] bytes, int offset) {
        return 0xFFL & (long)bytes[0 + offset] | 0xFF00L & (long)bytes[1 + offset] << 8 | 0xFF0000L & (long)bytes[2 + offset] << 16 | 0xFF000000L & (long)bytes[3 + offset] << 24 | 0xFF00000000L & (long)bytes[4 + offset] << 32 | 0xFF0000000000L & (long)bytes[5 + offset] << 40 | 0xFF000000000000L & (long)bytes[6 + offset] << 48 | 0xFF00000000000000L & (long)bytes[7 + offset] << 56;
    }

    public static float getFloat(byte[] bytes) {
        return NumberUtil.getFloat(bytes, 0);
    }

    public static float getFloat(byte[] bytes, int offset) {
        return Float.intBitsToFloat(NumberUtil.getInt(bytes, offset));
    }

    public static double getDouble(byte[] bytes) {
        return NumberUtil.getDouble(bytes, 0);
    }

    public static double getDouble(byte[] bytes, int offset) {
        long l = NumberUtil.getLong(bytes, offset);
        System.out.println(l);
        return Double.longBitsToDouble(l);
    }

    public static String toHex(byte[] bytes) {
        return NumberUtil.toHex(bytes, 0, bytes.length);
    }

    public static String toHex(byte[] bytes, int offset, int len) {
        StringBuilder builder = new StringBuilder(len * 2);
        for (int i = 0; i < len; ++i) {
            int v = bytes[offset + i] & 0xFF;
            String hv = Integer.toHexString(v);
            if (hv.length() < 2) {
                builder.append(0);
            }
            builder.append(hv);
        }
        return builder.toString().toUpperCase();
    }

    public static byte[] toBytes(String hex) {
        if (hex.isEmpty()) {
            return new byte[0];
        }
        byte[] byteArray = new byte[hex.length() / 2];
        for (int i = 0; i < byteArray.length; ++i) {
            String subStr = hex.substring(2 * i, 2 * i + 2);
            byteArray[i] = (byte)Integer.parseInt(subStr, 16);
        }
        return byteArray;
    }
}

