/*
 * Decompiled with CFR 0.152.
 */
package com.yy.hiidostatis.inner;

import android.content.Context;
import com.yy.hiidostatis.inner.AbstractConfig;
import com.yy.hiidostatis.inner.FlushManager;
import com.yy.hiidostatis.inner.GeneralConfigTool;
import com.yy.hiidostatis.inner.GeneralStatisTool;
import com.yy.hiidostatis.inner.util.ProcessUtil;
import com.yy.hiidostatis.inner.util.log.L;
import java.util.Enumeration;
import java.util.Hashtable;

public class GeneralProxy {
    private static Hashtable<String, GeneralStatisTool> statisToolContainer = new Hashtable();
    private static Hashtable<String, GeneralConfigTool> configToolContainer = new Hashtable();
    private static FlushManager mFlushManager;
    private static Object OBJ_KEY;

    public static GeneralStatisTool getGeneralStatisInstance(Context context, AbstractConfig config) {
        GeneralProxy.initFlushManager(context);
        GeneralStatisTool agent = statisToolContainer.get(config.getConfigKey());
        if (agent == null) {
            agent = new GeneralStatisTool(context, config);
            statisToolContainer.put(config.getConfigKey(), agent);
            agent.getTaskManager().flush(context);
            L.infoOn(GeneralProxy.class, "new GeneralStatisTool && configKey:%s", config.getConfigKey());
        }
        return agent;
    }

    public static GeneralConfigTool getGeneralConfigInstance(Context context, AbstractConfig config) {
        GeneralConfigTool agent = configToolContainer.get(config.getConfigKey());
        if (agent == null) {
            agent = new GeneralConfigTool(context, config);
            configToolContainer.put(config.getConfigKey(), agent);
            L.infoOn(GeneralProxy.class, "new GeneralConfigTool && configKey:%s", config.getConfigKey());
        }
        return agent;
    }

    public static synchronized void flushCache(Context context) {
        GeneralProxy.flushCache(context, true);
    }

    private static void flushCache(Context context, boolean isForce) {
        try {
            if (!isForce && ProcessUtil.isBackground(context)) {
                L.verbose(GeneralProxy.class, "app is Background ,no flush.", new Object[0]);
                return;
            }
            Enumeration<GeneralStatisTool> e = statisToolContainer.elements();
            GeneralStatisTool gs = null;
            while (e.hasMoreElements()) {
                gs = e.nextElement();
                gs.getTaskManager().flush(context);
            }
            Object var3_4 = null;
        }
        catch (Throwable e) {
            e.printStackTrace();
        }
    }

    public static synchronized void start(Context context) {
        try {
            GeneralProxy.initFlushManager(context);
            GeneralProxy.flushCache(context);
        }
        catch (Throwable e) {
            e.printStackTrace();
        }
    }

    public static synchronized void exit(Context context, boolean isNormal) {
        try {
            Enumeration<GeneralStatisTool> e = statisToolContainer.elements();
            while (e.hasMoreElements()) {
                GeneralStatisTool gs = e.nextElement();
                if (isNormal) {
                    gs.getTaskManager().flush(context);
                    continue;
                }
                gs.getTaskManager().enableSend(isNormal);
            }
        }
        catch (Throwable e) {
            e.printStackTrace();
        }
    }

    public static synchronized void startTimer(Context context, Long interval) {
        GeneralProxy.initFlushManager(context);
        mFlushManager.startTimer(context, interval);
    }

    public static synchronized void stopTimer(Context context) {
        GeneralProxy.initFlushManager(context);
        mFlushManager.stopTimer(context);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void initFlushManager(Context context) {
        if (mFlushManager == null) {
            Object object = OBJ_KEY;
            synchronized (object) {
                if (mFlushManager == null) {
                    mFlushManager = new FlushManager();
                    mFlushManager.setFlushListener(new FlushManager.FlushListener(){

                        @Override
                        public void fluch(Context context) {
                            GeneralProxy.flushCache(context);
                        }
                    });
                    mFlushManager.regConnectionChangeReceiver(context);
                }
            }
        }
    }

    static {
        OBJ_KEY = FlushManager.class;
    }
}

