/*
 * Decompiled with CFR 0.152.
 */
package com.yy.hiidostatis.defs.controller;

import android.content.Context;
import com.yy.hiidostatis.defs.interf.IConfigAPI;
import com.yy.hiidostatis.defs.interf.IStatisAPI;
import com.yy.hiidostatis.inner.util.ArdUtil;
import com.yy.hiidostatis.inner.util.DefaultPreference;
import com.yy.hiidostatis.inner.util.ThreadPool;
import com.yy.hiidostatis.inner.util.Util;
import com.yy.hiidostatis.inner.util.log.L;
import java.io.File;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;

public class SdkAnalyzeController {
    private static final String PACKAGE_NAME = "%PACKAGE_NAME%";
    private static final String PREF_KEY_SDK_ANALYZE_REPORT_DATE = "PREF_KEY_SDK_ANALYZE_REPORT_DATE";
    private IStatisAPI statisAPI;
    private IConfigAPI mConfigAPI;

    public SdkAnalyzeController(IStatisAPI statisAPI, IConfigAPI configApi) {
        this.statisAPI = statisAPI;
        this.mConfigAPI = configApi;
    }

    public void reportSdkAnalyze(Context context, long uid) {
        this.startSdkAnalyzeReport(context, uid);
    }

    private void startSdkAnalyzeReport(final Context context, final long uid) {
        Runnable r = new Runnable(){

            @Override
            public void run() {
                boolean isReported = false;
                String currDate = Util.formatDate("yyyyMMdd", System.currentTimeMillis());
                String reportDate = DefaultPreference.getPreference().getPrefString(context, SdkAnalyzeController.PREF_KEY_SDK_ANALYZE_REPORT_DATE, "");
                isReported = reportDate.equals(currDate);
                if (isReported) {
                    L.debug(SdkAnalyzeController.class, "sdk Analyze is reported today[%s]\uff0cso not report again!", currDate);
                    return;
                }
                JSONObject json = SdkAnalyzeController.this.mConfigAPI.getSdkListConfig(context, true);
                boolean enable = false;
                try {
                    if (json != null && json.has("enable") && "1".equals(json.get("enable") + "")) {
                        enable = true;
                    }
                }
                catch (JSONException e) {
                    L.error(SdkAnalyzeController.class, "get json.enable exception: %s", new Object[]{e});
                }
                L.debug(SdkAnalyzeController.class, "sdkAnalyze enable is %b", enable);
                if (enable) {
                    JSONArray sdkListJsonArray = null;
                    try {
                        sdkListJsonArray = json.getJSONArray("sdkListConfig");
                    }
                    catch (JSONException e) {
                        L.error(SdkAnalyzeController.class, "get json.sdkListConfig exception: %s", new Object[]{e});
                    }
                    if (sdkListJsonArray == null || sdkListJsonArray.length() == 0) {
                        L.debug(SdkAnalyzeController.class, "get sdkListJsonArray is null!", new Object[0]);
                    } else {
                        SdkAnalyzeController.this.reportSdkList(context, uid, sdkListJsonArray);
                    }
                }
                DefaultPreference.getPreference().setPrefString(context, SdkAnalyzeController.PREF_KEY_SDK_ANALYZE_REPORT_DATE, currDate);
            }
        };
        ThreadPool.getPool().execute(r, 16000L);
    }

    private void reportSdkList(Context context, long uid, JSONArray sdkListJsonArray) {
        String sdkList = this.getSdkList(context, sdkListJsonArray);
        this.statisAPI.reportSdkList(uid, sdkList);
    }

    private String getSdkList(Context context, JSONArray sdkListJsonArray) {
        StringBuffer sb = new StringBuffer();
        JSONObject json = null;
        String sdkName = null;
        String sdkClassName = null;
        String sdkFileName = null;
        String sdkKey = null;
        for (int i = 0; i < sdkListJsonArray.length(); ++i) {
            try {
                json = sdkListJsonArray.getJSONObject(i);
                sdkName = json.getString("sdkName");
                sdkFileName = json.has("sdkFileName") ? json.getString("sdkFileName") : null;
                sdkClassName = json.has("sdkClassName") ? json.getString("sdkClassName") : null;
                String string = sdkKey = json.has("sdkConfigKey") ? json.getString("sdkConfigKey") : null;
                if (Util.empty(ArdUtil.getMetaDataParam(context, sdkKey)) && !Util.isExistClass(sdkClassName) && !this.isExistFile(context, sdkFileName)) continue;
                sb.append(sdkName).append("|");
                continue;
            }
            catch (JSONException e) {
                L.error(SdkAnalyzeController.class, "getSdkList exception: %s", new Object[]{e});
            }
        }
        if (sb.length() > 0) {
            sb.setLength(sb.length() - 1);
        }
        L.debug(SdkAnalyzeController.class, "sdklist length=%d,sdklist bypes length=%d", sb.toString().length(), sb.toString().getBytes().length);
        L.debug(SdkAnalyzeController.class, "sdklist=%s", sb.toString());
        return sb.toString();
    }

    private boolean isExistFile(Context context, String fileName) {
        if (context == null || Util.empty(fileName)) {
            return false;
        }
        try {
            String packageName = context.getPackageName();
            String newFileName = fileName.replaceAll(PACKAGE_NAME, packageName);
            File file = new File(newFileName);
            boolean isExist = file.exists();
            L.debug(this, "fileName:%s,newFileName:%s,isExist:%b", fileName, newFileName, isExist);
            return isExist;
        }
        catch (Throwable e) {
            L.error(this, e.getMessage(), new Object[0]);
            return false;
        }
    }
}

