/*
 * Decompiled with CFR 0.152.
 */
package com.yy.hiidostatis.defs;

import android.content.Context;
import com.yy.hiidostatis.api.StatisContent;
import com.yy.hiidostatis.api.StatisOption;
import com.yy.hiidostatis.config.ABNameDefine;
import com.yy.hiidostatis.config.ABTestHandler;
import com.yy.hiidostatis.defs.IStatisApi;
import com.yy.hiidostatis.defs.StatisAPINew;
import com.yy.hiidostatis.defs.StatisAPINull;
import com.yy.hiidostatis.defs.StatisAPIOld;
import com.yy.hiidostatis.defs.interf.IStatisAPI;
import com.yy.hiidostatis.defs.listener.ActListener;
import com.yy.hiidostatis.defs.listener.HiidoSdkAdditionDelegate;
import com.yy.hiidostatis.defs.obj.Property;
import com.yy.hiidostatis.defs.obj.ShareType;
import com.yy.hiidostatis.message.Packer;
import com.yy.hiidostatis.provider.MessageConfig;
import com.yy.hiidostatis.provider.MessageConfigFactory;
import java.util.Date;
import java.util.Map;

public class StatisAPI
implements IStatisAPI {
    IStatisApi sApi = new StatisAPINull();

    @Override
    public void init(Context context, StatisOption option) {
        ABTestHandler.initInstance(context);
        if (ABTestHandler.getAbBoolean(ABNameDefine.NEW_PACKER_MODULE)) {
            MessageConfig config = MessageConfigFactory.generate(context, option.getAppkey());
            config.setFrom(option.getFrom());
            config.setAppId(option.getAppId());
            config.setVer(option.getVer());
            StatisAPINew apiNew = new StatisAPINew(config);
            apiNew.onInitSuccess();
            this.sApi = apiNew;
        } else {
            this.sApi = new StatisAPIOld();
            this.sApi.init(context, option);
        }
    }

    public void setTestServer(String testServer) {
        this.sApi.setTestServer(testServer);
    }

    public void setAbroad(boolean isAbroad) {
        this.sApi.setAbroad(isAbroad);
    }

    public void setBusinessType(int businessType) {
        this.sApi.setBusinessType(businessType);
    }

    public void reportStatisticContentTemporary(String act, StatisContent content, boolean fillCommon, boolean isCover) {
        this.sApi.reportStatisticContentTemporary(act, content, fillCommon, isCover);
    }

    public void reportStatisticContent(String act, StatisContent content, boolean fillCommon, boolean isCover) {
        this.sApi.reportStatisticContent(act, content, fillCommon, isCover);
    }

    public void reportStatisticContent(String act, StatisContent content, boolean fillCommon, boolean isCover, boolean isPriority) {
        this.sApi.reportStatisticContent(act, content, fillCommon, isCover, isPriority);
    }

    public void reportStatisticContentWithNoComm(Context context, String act, StatisContent content) {
        this.sApi.reportStatisticContentWithNoComm(context, act, content);
    }

    public void reportStatisticContentWithNoComm(Context context, String act, StatisContent content, boolean isPriority) {
        this.sApi.reportStatisticContentWithNoComm(context, act, content, isPriority);
    }

    @Override
    public void reportInstall(int type, IStatisAPI.ReportResult resultReceiver) {
        this.sApi.reportInstall(type, resultReceiver);
    }

    public void reportRun(long uid) {
        this.sApi.reportRun(uid);
    }

    public void reportDo(long uid) {
        this.sApi.reportDo(uid);
    }

    public void reportDo5(long uid) {
        this.sApi.reportDo5(uid);
    }

    public void reportDoShort(long uid, Map<String, String> prop) {
        this.sApi.reportDoShort(uid, prop);
    }

    public void reportLogin(long uid) {
        this.sApi.reportLogin(uid);
    }

    public void reportAppsflyer(String data) {
        this.sApi.reportAppsflyer(data);
    }

    public void reportShare(String platform, int mediaType, String content, ShareType stype, String errmsg, String screen, String userData) {
        this.sApi.reportShare(platform, mediaType, content, stype, errmsg, screen, userData);
    }

    public void reportIM(String sender, String receiver, String content, Date editTime, Date sendTime, String errormsg, int mediaType, String userData) {
        this.sApi.reportIM(sender, receiver, content, editTime, sendTime, errormsg, mediaType, userData);
    }

    public void reportUrlScheme(String scheme, String host, int port, String path, String query) {
        this.sApi.reportUrlScheme(scheme, host, port, path, query);
    }

    public void reportReg(String uid, String name, String type, Map<String, String> prop) {
        this.sApi.reportReg(uid, name, type, prop);
    }

    public void reportAction(long uid, String appa, String page, String event) {
        this.sApi.reportAction(uid, appa, page, event);
    }

    @Override
    public void reportLanuch(long uid, String appa, StatisContent sensor) {
        this.sApi.reportLanuch(uid, appa, sensor);
    }

    @Override
    public void reportPage(long uid, String page) {
        this.sApi.reportPage(uid, page);
    }

    @Override
    public void reportPageState(long uid, String page, long duration) {
        this.sApi.reportPageState(uid, page, duration);
    }

    @Override
    public void reportEvent(long uid, String event) {
        this.sApi.reportEvent(uid, event);
    }

    public void reportError(long uid, String eid, String emsg, String param) {
        this.sApi.reportError(uid, eid, emsg, param);
    }

    @Override
    public void reportCrash(long uid, String crashMsg) {
        this.sApi.reportCrash(uid, crashMsg);
    }

    @Override
    public void reportCrashInner(long uid, Throwable throwable) {
        this.sApi.reportCrashInner(uid, throwable);
    }

    @Override
    public boolean reportDevice(long uid, StatisContent extra) {
        return this.sApi.reportDevice(uid, extra);
    }

    @Override
    public boolean reportDevice(long uid) {
        return this.sApi.reportDevice(uid);
    }

    @Override
    public void reportInstall(int type, Packer.OnSavedListener listener) {
        this.sApi.reportInstall(type, listener);
    }

    @Override
    public boolean reportInstall(int type) {
        return this.sApi.reportInstall(type);
    }

    @Override
    public void reportCrash(long uid, Throwable throwable) {
        this.sApi.reportCrash(uid, throwable);
    }

    public void reportSuccess(long uid, String aid, String type, long duration, String parm) {
        this.sApi.reportSuccess(uid, aid, type, duration, parm);
    }

    public void reportFailure(long uid, String aid, String type, String failCode, String failMsg, String parm) {
        this.sApi.reportFailure(uid, aid, type, failCode, failMsg, parm);
    }

    public void reportCustomContent(long uid, String type, String content) {
        this.sApi.reportCustomContent(uid, type, content);
    }

    @Override
    public void reportAppList(long uid, String type, String applist) {
        this.sApi.reportAppList(uid, type, applist);
    }

    @Override
    public void reportAppList(long uid, String type, String applist, String applist2) {
        this.sApi.reportAppList(uid, type, applist, applist2);
    }

    public void reportTimesEvent(long uid, String eid) {
        this.sApi.reportTimesEvent(uid, eid);
    }

    public void reportTimesEvent(long uid, String eid, String label) {
        this.sApi.reportTimesEvent(uid, eid, label);
    }

    public void reportTimesEvent(long uid, String eid, String label, Property property) {
        this.sApi.reportTimesEvent(uid, eid, label, property);
    }

    public void reportCountEvent(long uid, String eid, double evalue) {
        this.sApi.reportCountEvent(uid, eid, evalue);
    }

    public void reportCountEvent(long uid, String eid, double evalue, String label) {
        this.sApi.reportCountEvent(uid, eid, evalue, label);
    }

    public void reportCountEvent(long uid, String eid, double evalue, String label, Property property) {
        this.sApi.reportCountEvent(uid, eid, evalue, label, property);
    }

    @Override
    public void reportSdkList(long uid, String sdkList) {
        this.sApi.reportSdkList(uid, sdkList);
    }

    @Override
    public void reportDevice(long uid, StatisContent extra, IStatisAPI.ReportResult resultReceiver) {
        this.sApi.reportDevice(uid, extra, resultReceiver);
    }

    public void reportLocation(long uid, double longitude, double latitude, double altitude, IStatisAPI.ReportResult resultReceiver) {
        this.sApi.reportLocation(uid, longitude, latitude, altitude, resultReceiver);
    }

    public void reportFeedback(long uid, String fbId, String cont, String link, String remk, IStatisAPI.ReportResult resultReceiver) {
        this.sApi.reportFeedback(uid, fbId, cont, link, remk, resultReceiver);
    }

    public void reportPushToken(long uid, String token) {
        this.sApi.reportPushToken(uid, token);
    }

    public void addActAdditionListener(ActListener listener) {
        this.sApi.addActAdditionListener(listener);
    }

    public void removeActAdditionListener(ActListener listener) {
        this.sApi.addActAdditionListener(listener);
    }

    public HiidoSdkAdditionDelegate getAdditionParamsDelegate() {
        return this.sApi.getAdditionParamsDelegate();
    }

    public void setAdditionParamsDelegate(HiidoSdkAdditionDelegate hiidoSdkAdditionDelegate) {
        this.sApi.setAdditionParamsDelegate(hiidoSdkAdditionDelegate);
    }

    public void generateSession() {
        this.sApi.generateSession();
    }

    @Override
    public String getSession() {
        return this.sApi.getSession();
    }

    @Override
    public void setSession(String sessionId) {
        this.sApi.setSession(sessionId);
    }

    @Override
    public StatisOption getOption() {
        return this.sApi.getOption();
    }

    @Override
    public IStatisAPI create() {
        return this;
    }

    public void exit() {
        this.sApi.exit();
    }

    @Override
    public Long getLaunchTime() {
        return this.sApi.getLaunchTime();
    }

    @Override
    public void reportRecentAppList(long uid, String userApp, String systemApp) {
        this.sApi.reportRecentAppList(uid, userApp, systemApp);
    }

    public Context getContext() {
        return this.sApi.getContext();
    }
}

