/*
 * Decompiled with CFR 0.152.
 */
package com.yy.hiidostatis.config;

import android.content.Context;
import android.content.SharedPreferences;
import com.yy.hiidostatis.config.ABNameDefine;
import com.yy.hiidostatis.inner.util.ThreadPool;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import org.json.JSONObject;

public final class ABTestHandler {
    private static final String KEY_PREFERENCE_ABTEST = "ab_test_config";
    public static final int FALSE = 1;
    public static final int TRUE = 2;
    private static ABTestHandler instance = new ABTestHandler();
    private static boolean loaded = false;
    private volatile Map<String, Integer> map = new HashMap<String, Integer>();

    public static void initInstance(Context context) {
        instance.loadConfig(context);
    }

    private ABTestHandler() {
    }

    private synchronized void loadConfig(Context context) {
        if (loaded) {
            return;
        }
        try {
            SharedPreferences sp = context.getSharedPreferences(KEY_PREFERENCE_ABTEST, 4);
            String data = sp.getString(KEY_PREFERENCE_ABTEST, null);
            if (data != null) {
                String[] test;
                for (String one : test = data.split(";")) {
                    try {
                        String[] two = one.split("=");
                        if (two.length != 2) continue;
                        int value = Integer.parseInt(two[1]);
                        this.map.put(two[0], value);
                    }
                    catch (Throwable e) {
                        e.printStackTrace();
                    }
                }
            }
            loaded = true;
        }
        catch (Throwable e) {
            e.printStackTrace();
        }
    }

    private static ABTestHandler getInstance() {
        return instance;
    }

    private static void updateValueInner(Context context, Map<String, String> ab) {
        if (ab != null && !ab.isEmpty()) {
            try {
                StringBuilder builder = new StringBuilder();
                for (Map.Entry<String, String> entry : ab.entrySet()) {
                    if (!entry.getKey().startsWith("hiido_")) continue;
                    String[] ks = entry.getKey().split("_");
                    builder.append(ks[ks.length - 1]);
                    builder.append("=");
                    builder.append(entry.getValue());
                    builder.append(";");
                }
                builder.setLength(builder.length() - 1);
                String data = builder.toString();
                SharedPreferences sp = context.getSharedPreferences(KEY_PREFERENCE_ABTEST, 4);
                sp.edit().putString(KEY_PREFERENCE_ABTEST, data).apply();
            }
            catch (Throwable e) {
                e.printStackTrace();
            }
        }
    }

    public static void updateValue(final Context context, final Map<String, String> ab) {
        if (ab != null && !ab.isEmpty()) {
            ThreadPool.getPool().execute(new Runnable(){

                @Override
                public void run() {
                    ABTestHandler.updateValueInner(context, ab);
                }
            });
        }
    }

    public static void updateValue(final Context context, final String[] json) {
        if (json == null || json.length == 0) {
            return;
        }
        ThreadPool.getPool().execute(new Runnable(){

            @Override
            public void run() {
                HashMap<String, String> map = new HashMap<String, String>();
                for (String j : json) {
                    try {
                        JSONObject data = new JSONObject(j);
                        Iterator keys = data.keys();
                        while (keys.hasNext()) {
                            JSONObject test;
                            String val;
                            String key = (String)keys.next();
                            if (!key.startsWith("hiido_") || (val = ABTestHandler.parseTest(test = data.getJSONObject(key))) == null || val.isEmpty()) continue;
                            map.put(key, val);
                        }
                    }
                    catch (Exception e) {
                        e.printStackTrace();
                    }
                }
                if (!map.isEmpty()) {
                    ABTestHandler.updateValueInner(context, map);
                }
            }
        });
    }

    private static String parseTest(JSONObject test) {
        String ret = null;
        try {
            JSONObject action;
            if (test != null && (action = test.getJSONObject("val")) != null) {
                ret = action.getString("action");
            }
        }
        catch (Throwable e) {
            e.printStackTrace();
        }
        return ret;
    }

    public static boolean getAbBoolean(ABNameDefine ab) {
        Integer ret = ABTestHandler.getInstance().map.get(ab.getName());
        return ret == null ? ab.getDefaultValue() == 2 : ret == 2;
    }

    public static int getAbInteger(ABNameDefine ab) {
        Integer ret = ABTestHandler.getInstance().map.get(ab.getName());
        return ret == null ? ab.getDefaultValue() : ret.intValue();
    }

    public static void updateMemoryValue(Context context, Map<String, String> ab) {
        if (!loaded) {
            ABTestHandler.getInstance().loadConfig(context);
        }
        for (Map.Entry<String, String> one : ab.entrySet()) {
            ABTestHandler.getInstance().map.put(one.getKey(), Integer.parseInt(one.getValue()));
        }
    }
}

