/*
 * Decompiled with CFR 0.152.
 */
package com.yy.hiidostatis.message.storage;

import android.content.Context;
import com.yy.hiidostatis.api.StatisContent;
import com.yy.hiidostatis.inner.implementation.TaskData;
import com.yy.hiidostatis.inner.implementation.TaskDataSqLiteCacheManager;
import com.yy.hiidostatis.message.MessageStore;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;

public class MessageStoreProxy
implements MessageStore {
    private Context context;
    private TaskDataSqLiteCacheManager cacheManager;

    public MessageStoreProxy(Context context, TaskDataSqLiteCacheManager cacheManager) {
        this.context = context;
        this.cacheManager = cacheManager;
    }

    @Override
    public int save(List<StatisContent> messages) {
        ArrayList<TaskData> set = new ArrayList<TaskData>();
        HashMap<String, Integer> actCount = new HashMap<String, Integer>();
        for (StatisContent m : messages) {
            TaskData data = new TaskData(m.getAct());
            data.setContent(m.getContent());
            data.setDataId(m.getGuid());
            data.setVerifyMd5(data.createVerifyMd5());
            data.setAid(m.getAutoId());
            data.setCrepid(m.getCrepid());
            switch (m.getPriority()) {
                case PRIORITY_LOW: {
                    data.setOrder(System.currentTimeMillis() - 3600000L);
                    break;
                }
                case PRIORITY_NORMAL: {
                    data.setOrder(System.currentTimeMillis());
                    break;
                }
                case PRIORITY_HIGH: {
                    data.setOrder(System.currentTimeMillis() + 86400000L);
                    break;
                }
            }
            Integer count = (Integer)actCount.get(m.getAct());
            if (count == null) {
                actCount.put(m.getAct(), 1);
            } else {
                actCount.put(m.getAct(), count + 1);
            }
            set.add(data);
        }
        return this.cacheManager.saveAll(this.context, set, actCount);
    }

    @Override
    public int notSave(List<StatisContent> messages) {
        ArrayList<TaskData> set = new ArrayList<TaskData>();
        for (StatisContent m : messages) {
            TaskData data = new TaskData(m.getAct());
            data.setContent(m.getContent());
            data.setDataId(m.getGuid());
            data.setVerifyMd5(data.createVerifyMd5());
            data.setAid(m.getAutoId());
            data.setCrepid(m.getCrepid());
            set.add(data);
        }
        return this.cacheManager.cacheData(this.context, set);
    }
}

