/*
 * Decompiled with CFR 0.152.
 */
package com.yy.hiidostatis.inner.util.http;

import com.yy.hiidostatis.inner.util.ArdUtil;
import com.yy.hiidostatis.inner.util.Util;
import com.yy.hiidostatis.inner.util.http.AbstractStatisHttpUtil;
import com.yy.hiidostatis.inner.util.log.L;

public class StatisHttpUtil
extends AbstractStatisHttpUtil {
    private static final String URL_SERVICE = "";
    private static final String URL_FORMAT = "http://%s/c.gif";
    private static final String[] ADDRESSES = new String[]{"183.61.2.91", "183.61.2.92", "183.61.2.93", "183.61.2.94", "183.61.2.95", "183.61.2.96", "183.61.2.97", "183.61.2.98"};
    private String urlParams;
    private String body;

    @Override
    protected boolean sendContent(String url, String content, int tryTimes) {
        L.brief("hiido service address is %s", url);
        this.mThrowable = null;
        int initialTimes = tryTimes;
        do {
            try {
                if (this.getLastTryTimes() > 0 && !ArdUtil.isNetworkReach()) {
                    L.warn(this, "isNetworkReach false.", new Object[0]);
                    return false;
                }
                if (initialTimes != tryTimes) {
                    L.brief("Try again to send %s with url %s, tried times %d.", content, url, initialTimes - tryTimes);
                }
                ++this.lastTryTimes;
                if (this.get(url, content)) {
                    this.mThrowable = null;
                    L.debug(this, "Successfully sent %s to %s", content, url);
                    return true;
                }
                L.debug(this, "Failed to send %s to %s.", content, url);
            }
            catch (Throwable e) {
                this.mThrowable = e;
                L.error(StatisHttpUtil.class, "guid:%s. http statis exception %s", Util.parseParam(content, "guid"), e);
            }
        } while (tryTimes-- > 0);
        return false;
    }

    @Override
    protected String[] getUrlAddress() {
        return ADDRESSES;
    }

    @Override
    protected String getUrlFormat() {
        return URL_FORMAT;
    }

    @Override
    protected String getUrlService() {
        return URL_SERVICE;
    }

    @Override
    public String getHost() {
        return URL_SERVICE;
    }
}

