/*
 * Decompiled with CFR 0.152.
 */
package com.yy.hiidostatis.inner.util.hdid;

import android.content.Context;
import android.os.Build;
import android.os.Environment;
import android.text.TextUtils;
import com.yy.hiidostatis.inner.util.ArdUtil;
import com.yy.hiidostatis.inner.util.FileUtil;
import com.yy.hiidostatis.inner.util.cipher.Coder;
import com.yy.hiidostatis.inner.util.hdid.Device;
import com.yy.hiidostatis.inner.util.hdid.DeviceProxy;
import com.yy.hiidostatis.inner.util.log.L;
import java.io.File;
import java.util.Random;
import java.util.UUID;

public enum DeviceManager {
    instance;

    private Device mDi = null;
    private static final Object LOCK;
    private static final String KEY_MAGIC1 = "!qazxsw@";
    private static final String KEY_MAGIC2 = "#edcvfr$";
    private static final String NULL_STRING = "-";
    private static final String OUT1_PATH;
    private static final String OUT2_PATH;

    private String getInnerPath(Context c) {
        StringBuffer sb = new StringBuffer();
        try {
            sb.append(c.getFilesDir().getAbsolutePath());
        }
        catch (Throwable ex) {
            return "";
        }
        sb.append(File.separator);
        sb.append("hdid.bck");
        String local = sb.toString();
        sb.setLength(0);
        sb = null;
        return local;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Device getDevice(Context c) {
        if (this.mDi != null) {
            return this.mDi;
        }
        Object object = LOCK;
        synchronized (object) {
            if (this.mDi != null) {
                return this.mDi;
            }
            this.mDi = this.initDevice(c);
        }
        return this.mDi;
    }

    private Device initDevice(Context c) {
        Device inner = this.getInner(c);
        Device o1 = this.getOut1(c);
        Device o2 = this.getOut2(c);
        if (inner != null) {
            inner.hFrom = 1;
            if (o1 == null && o2 == null) {
                L.debug((Object)this, "saveOut1,saveOut2", new Object[0]);
                this.saveOut1(c, inner);
                this.saveOut2(c, inner);
            }
            return inner;
        }
        if (o1 != null) {
            o1.hFrom = 2;
            L.debug((Object)this, "saveInner", new Object[0]);
            this.saveInner(c, o1);
            if (o2 == null) {
                L.debug((Object)this, "saveOut2", new Object[0]);
                this.saveOut2(c, o1);
            }
            return o1;
        }
        if (o2 != null) {
            o2.hFrom = 2;
            this.saveInner(c, o2);
            this.saveOut1(c, o2);
            L.debug((Object)this, "saveInner,saveOut2", new Object[0]);
            return o2;
        }
        Device d = this.createNewDevice(c);
        d.hFrom = 0;
        this.saveInner(c, d);
        this.saveOut1(c, d);
        this.saveOut2(c, d);
        L.debug((Object)this, "others,createNewDevice,saveInner,saveOut1,saveOut2", new Object[0]);
        return d;
    }

    void syncAll(Context c, Device di) {
        Device inner = this.getInner(c);
        Device out1 = this.getOut1(c);
        Device out2 = this.getOut2(c);
        if (inner == null && out1 == null && out2 == null) {
            this.saveInner(c, di);
            this.saveOut1(c, di);
            this.saveOut2(c, di);
            L.debug((Object)this, "syncAll", new Object[0]);
        }
    }

    private Device createNewDevice(Context c) {
        Device di = new Device();
        di.imei = ArdUtil.getImei(c);
        di.mac = ArdUtil.getMacAddrV23(c);
        di.arid = ArdUtil.getAndroidId(c);
        di.crtTime = System.currentTimeMillis();
        try {
            boolean isValidArid = this.isValidArid(di.arid);
            boolean isValidMac = this.isValidMac(di.mac);
            if (isValidArid || isValidMac) {
                di.type = ((isValidArid ? 1 : 0) | (isValidMac ? 2 : 0)) + "";
                String arid = di.arid == null ? "" : di.arid;
                String mac = di.mac == null ? "" : di.mac;
                di.hdid = Coder.encryptMD5(arid + "_" + mac);
                return di;
            }
            di.type = "0";
            di.hdid = this.getUniqueId();
            return di;
        }
        catch (Throwable e) {
            di.type = "0";
            di.hdid = this.getUniqueId();
            return di;
        }
    }

    private String getUniqueId() {
        try {
            String id = UUID.randomUUID().toString() + System.currentTimeMillis() + System.nanoTime() + new Random().nextInt(10000000);
            return Coder.encryptMD5(id);
        }
        catch (Throwable e) {
            return UUID.randomUUID().toString().replace(NULL_STRING, "");
        }
    }

    private boolean isValidMac(String mac) {
        return ArdUtil.isValidMac(mac);
    }

    private boolean isValidArid(String arid) {
        return !TextUtils.isEmpty((CharSequence)arid);
    }

    private Device getInner(Context c) {
        try {
            String s = FileUtil.readFile(this.getInnerPath(c));
            if (s != null) {
                return this.s2d(Coder.decryptDES(s, "!qazxsw@#edcvfr$"));
            }
        }
        catch (Throwable e) {
            L.warn((Object)this, "getInner exception = %s", e);
        }
        return null;
    }

    private Device getOut1(Context c) {
        if (Build.VERSION.SDK_INT > 22) {
            return null;
        }
        try {
            String s = FileUtil.readFile(OUT1_PATH);
            if (s != null) {
                return this.s2d(Coder.decryptDES(s, KEY_MAGIC1));
            }
        }
        catch (Throwable e) {
            L.warn((Object)this, "getOut1 exception = %s", e);
        }
        return null;
    }

    private Device getOut2(Context c) {
        if (Build.VERSION.SDK_INT > 22) {
            return null;
        }
        try {
            String s = FileUtil.readFile(OUT2_PATH);
            if (s != null) {
                return this.s2d(Coder.decryptDES(s, KEY_MAGIC2));
            }
        }
        catch (Throwable e) {
            L.warn((Object)this, "getOut2 exception = %s", e);
        }
        return null;
    }

    private void saveInner(Context c, Device di) {
        try {
            FileUtil.saveFile(this.getInnerPath(c), Coder.encryptDES(this.d2s(di), "!qazxsw@#edcvfr$"));
        }
        catch (Throwable e) {
            L.warn((Object)this, "saveInner exception = %s", e);
        }
    }

    private void saveOut1(Context c, Device di) {
        if (Build.VERSION.SDK_INT > 22) {
            return;
        }
        try {
            FileUtil.saveFile(OUT1_PATH, Coder.encryptDES(this.d2s(di), KEY_MAGIC1));
        }
        catch (Throwable e) {
            L.warn((Object)this, "saveOut1 exception = %s", e);
        }
    }

    private void saveOut2(Context c, Device di) {
        if (Build.VERSION.SDK_INT > 22) {
            return;
        }
        try {
            FileUtil.saveFile(OUT2_PATH, Coder.encryptDES(this.d2s(di), KEY_MAGIC2));
        }
        catch (Throwable e) {
            L.warn((Object)this, "saveOut2 exception = %s", e);
        }
    }

    private String d2s(Device di) {
        String imei = TextUtils.isEmpty((CharSequence)di.imei) ? NULL_STRING : di.imei;
        String mac = TextUtils.isEmpty((CharSequence)di.mac) ? NULL_STRING : di.mac;
        return String.format("%s,%s,%s,%s", di.hdid, imei, mac, this.key(di.hdid + imei + mac));
    }

    private Device s2d(String s) {
        Device di = null;
        if (s == null) {
            return di;
        }
        String[] a = s.split(",", -1);
        if (a.length >= 4) {
            if (this.key(a[0] + a[1] + a[2]).equals(a[3])) {
                di = new Device();
                di.hdid = a[0];
                di.imei = NULL_STRING.equals(a[1]) ? null : a[1];
                di.mac = NULL_STRING.equals(a[2]) ? null : a[2];
            } else {
                L.warn(DeviceProxy.class, "verify fail. %s", s + "");
            }
        }
        return di;
    }

    private String key(String s) {
        try {
            return Coder.encryptMD5(s + KEY_MAGIC1 + KEY_MAGIC2);
        }
        catch (Throwable e) {
            L.error((Object)this, e.getMessage(), new Object[0]);
            return "";
        }
    }

    static {
        LOCK = DeviceManager.class;
        OUT1_PATH = Environment.getExternalStorageDirectory().getAbsolutePath() + File.separator + ".hiidosdk" + File.separator + "Device";
        OUT2_PATH = Environment.getExternalStorageDirectory().getAbsolutePath() + File.separator + ".android" + File.separator + "Global";
    }
}

