/*
 * Decompiled with CFR 0.152.
 */
package com.yy.hiidostatis.inner.util.hdid;

import android.content.SharedPreferences;
import android.os.Build;
import android.os.Environment;
import android.text.TextUtils;
import android.util.Log;
import com.yy.hiidostatis.inner.util.hdid.IClientIdConfig;
import com.yy.hiidostatis.inner.util.log.L;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileWriter;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStreamWriter;
import java.util.UUID;

public class ClientIdHelper {
    private static final String PREFIX_NORMAL = "bi_";
    private static final String PREFIX_BUILD = "bp_";
    private static final String PREFIX_SERIAL = "bs_";
    private static final String PREFIX_CUSTOM = "bc_";
    private static final String BI_CLIENT_ID_FOLDER = ".android";
    private static final String BI_CLIENT_ID_FOLDER_ROOT = Environment.getExternalStorageDirectory().getPath();
    private static final String BI_CLIENT_ID_FILE_SUFFIX = ".ini";
    private static final String BI_CLIENT_ID_FILE_NAME = "hdcltid.ini";
    private static final String BI_CLIENT_ID_PREF_FILE_NAME = "hdcltid";
    private static final String BI_CLIENT_ID_FILE_DIR = BI_CLIENT_ID_FOLDER_ROOT + File.separator + ".android";
    private static final String BI_CLIENT_ID_FILE_PATH = BI_CLIENT_ID_FILE_DIR + File.separator + "hdcltid.ini";
    private static final String SP_BI_CLIENT_ID_KEY = "hdcltid";
    private static final String TAG = "ClientIdHelper";
    private final int boardDigit = this.boardDigit();
    private final int brandDigit = this.brandDigit();
    private final int cpuAbiDigit = this.cpuAbiDigit();
    private final int deviceDigit = this.deviceDigit();
    private final int manufacturerDigit = this.manufacturerDigit();
    private final int modelDigit = this.modelDigit();
    private final int productDigit = this.productDigit();
    private static volatile ClientIdHelper mInstance;
    private static String mClientID;
    private IClientIdConfig mConfig;

    private ClientIdHelper(IClientIdConfig config) {
        this.mConfig = config;
        this.checkConfig();
        this.initClientId();
        if (this.mConfig.logEnable()) {
            Log.d((String)TAG, (String)("boardDigit = " + this.boardDigit));
            Log.d((String)TAG, (String)("brandDigit = " + this.brandDigit));
            Log.d((String)TAG, (String)("cpuAbiDigit = " + this.cpuAbiDigit));
            Log.d((String)TAG, (String)("deviceDigit = " + this.deviceDigit));
            Log.d((String)TAG, (String)("manufacturerDigit = " + this.manufacturerDigit));
            Log.d((String)TAG, (String)("modelDigit = " + this.modelDigit));
            Log.d((String)TAG, (String)("productDigit = " + this.productDigit));
        }
    }

    private void checkConfig() {
        if (null == this.mConfig) {
            throw new RuntimeException("IConfig must be initialized !!");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static void init(IClientIdConfig config) {
        if (null != mInstance) return;
        Class<ClientIdHelper> clazz = ClientIdHelper.class;
        synchronized (ClientIdHelper.class) {
            if (null != mInstance) return;
            mInstance = new ClientIdHelper(config);
            // ** MonitorExit[var1_1] (shouldn't be in output)
            return;
        }
    }

    public static ClientIdHelper getInstance() {
        if (null == mInstance) {
            throw new RuntimeException("ClientIdHelper must be initialized ! init should be called Firstly !");
        }
        return mInstance;
    }

    private String createUniquePsuedoID() {
        String serial;
        boolean buildParamOk;
        block8: {
            buildParamOk = this.checkBuild();
            serial = "";
            try {
                if (Build.VERSION.SDK_INT >= 26) {
                    try {
                        serial = Build.getSerial();
                    }
                    catch (Throwable e) {
                        L.error(this, e.getMessage(), new Object[0]);
                    }
                }
                if (serial == null || serial.isEmpty()) {
                    serial = Build.class.getField("SERIAL").get(null).toString();
                }
            }
            catch (Throwable exception) {
                if (!this.mConfig.logEnable()) break block8;
                exception.printStackTrace();
            }
        }
        if (this.mConfig.logEnable()) {
            Log.e((String)TAG, (String)("serial = " + serial));
            Log.e((String)TAG, (String)("buildParamOk = " + buildParamOk));
        }
        boolean serialOk = !TextUtils.isEmpty((CharSequence)serial) && !serial.equalsIgnoreCase("unKnown");
        serial = serialOk ? serial : "";
        String m_szDevIDShort = "35" + this.boardDigit + this.brandDigit + this.cpuAbiDigit + this.deviceDigit + this.manufacturerDigit + this.modelDigit + this.productDigit;
        String id = null;
        id = buildParamOk && !TextUtils.isEmpty((CharSequence)serial) ? PREFIX_NORMAL + new UUID(m_szDevIDShort.hashCode(), serial.hashCode()).toString() : (buildParamOk ? PREFIX_BUILD + new UUID(m_szDevIDShort.hashCode(), serial.hashCode()).toString() : (!TextUtils.isEmpty((CharSequence)serial) ? PREFIX_SERIAL + new UUID(m_szDevIDShort.hashCode(), serial.hashCode()).toString() : PREFIX_CUSTOM + this.createPsuedoID()));
        if (TextUtils.isEmpty((CharSequence)id)) {
            id = this.createPsuedoID();
        }
        return id.replaceAll("_", "").replaceAll("-", "");
    }

    private int boardDigit() {
        if (!TextUtils.isEmpty((CharSequence)Build.BOARD)) {
            return Build.BOARD.length() % 10;
        }
        return 0;
    }

    private int brandDigit() {
        if (!TextUtils.isEmpty((CharSequence)Build.BRAND)) {
            return Build.BRAND.length() % 10;
        }
        return 0;
    }

    private int cpuAbiDigit() {
        if (!TextUtils.isEmpty((CharSequence)Build.CPU_ABI)) {
            return Build.CPU_ABI.length() % 10;
        }
        return 0;
    }

    private int deviceDigit() {
        if (!TextUtils.isEmpty((CharSequence)Build.DEVICE)) {
            return Build.DEVICE.length() % 10;
        }
        return 0;
    }

    private int manufacturerDigit() {
        if (!TextUtils.isEmpty((CharSequence)Build.MANUFACTURER)) {
            return Build.MANUFACTURER.length() % 10;
        }
        return 0;
    }

    private int modelDigit() {
        if (!TextUtils.isEmpty((CharSequence)Build.MODEL)) {
            return Build.MODEL.length() % 10;
        }
        return 0;
    }

    private int productDigit() {
        if (!TextUtils.isEmpty((CharSequence)Build.PRODUCT)) {
            return Build.PRODUCT.length() % 10;
        }
        return 0;
    }

    private boolean sdCardWriteEnabled() {
        boolean enable;
        boolean bl = enable = this.mConfig.sdWriteGranted() && this.sdMounted();
        if (this.mConfig.logEnable()) {
            Log.d((String)TAG, (String)("sdCardWriteEnabled = " + enable));
        }
        return enable;
    }

    private boolean sdCardReadEnabled() {
        boolean enable;
        boolean bl = enable = this.mConfig.sdReadGranted() && this.sdMounted();
        if (this.mConfig.logEnable()) {
            Log.d((String)TAG, (String)("sdCardReadEnabled = " + enable));
        }
        return enable;
    }

    private boolean writeIntoSp() {
        if (this.mConfig.logEnable()) {
            Log.d((String)TAG, (String)("writeIntoSp" + mClientID));
        }
        SharedPreferences sp = this.sharedPref();
        return sp.edit().putString("hdcltid", mClientID).commit();
    }

    private String readFromSp() {
        if (this.mConfig.logEnable()) {
            Log.d((String)TAG, (String)"readFromSp");
        }
        SharedPreferences sp = this.sharedPref();
        return sp.getString("hdcltid", null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean writeIntoSdCard() {
        if (this.mConfig.logEnable()) {
            Log.d((String)TAG, (String)("writeIntoSdCard" + mClientID));
        }
        if (!this.sdCardWriteEnabled()) {
            return false;
        }
        if (TextUtils.isEmpty((CharSequence)mClientID)) {
            return false;
        }
        OutputStreamWriter fileWriter = null;
        try {
            boolean result;
            boolean success;
            File dir = new File(BI_CLIENT_ID_FILE_DIR);
            if (!dir.exists() && !(success = dir.mkdir())) {
                boolean bl = false;
                return bl;
            }
            File f = new File(dir, BI_CLIENT_ID_FILE_NAME);
            if (!f.exists() && !(result = f.createNewFile())) {
                boolean e = false;
                return e;
            }
            fileWriter = new FileWriter(f, false);
            fileWriter.write(mClientID);
            fileWriter.flush();
            boolean bl = true;
            return bl;
        }
        catch (IOException e) {
            L.error(this, e.getMessage(), new Object[0]);
        }
        finally {
            if (null != fileWriter) {
                try {
                    fileWriter.close();
                }
                catch (IOException e) {
                    L.error(this, e.getMessage(), new Object[0]);
                }
            }
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private String readFromSdCard() {
        if (this.mConfig.logEnable()) {
            Log.d((String)TAG, (String)"readFromSdCard");
        }
        if (!this.sdCardReadEnabled()) {
            return "";
        }
        File file = new File(BI_CLIENT_ID_FILE_PATH);
        String clientID = "";
        if (null == file || !file.isFile()) {
            return null;
        }
        BufferedReader reader = null;
        try {
            InputStreamReader is = new InputStreamReader((InputStream)new FileInputStream(file), "utf-8");
            reader = new BufferedReader(is);
            clientID = reader.readLine();
        }
        catch (IOException e) {
            L.error(this, e.getMessage(), new Object[0]);
        }
        finally {
            if (null != reader) {
                try {
                    reader.close();
                }
                catch (IOException e) {
                    L.error(this, e.getMessage(), new Object[0]);
                }
            }
        }
        return clientID;
    }

    private boolean initClientId() {
        String clientId = this.readFromSp();
        if (!TextUtils.isEmpty((CharSequence)clientId)) {
            this.setMemoryClientId(clientId);
            return true;
        }
        clientId = this.readFromSdCard();
        if (!TextUtils.isEmpty((CharSequence)clientId)) {
            this.setMemoryClientId(clientId);
            this.writeIntoSp();
            return true;
        }
        clientId = this.createUniquePsuedoID();
        if (!TextUtils.isEmpty((CharSequence)clientId)) {
            this.setClientId(clientId);
            return true;
        }
        return false;
    }

    private void setMemoryClientId(String id) {
        mClientID = id;
    }

    private void setClientId(String clientID) {
        this.setMemoryClientId(clientID);
        this.writeIntoSp();
        this.writeIntoSdCard();
    }

    private String createPsuedoID() {
        return UUID.randomUUID().toString();
    }

    private boolean sdMounted() {
        return "mounted".equals(Environment.getExternalStorageState());
    }

    private SharedPreferences sharedPref() {
        return this.mConfig.getAppContext().getSharedPreferences("hdcltid", 0);
    }

    public String getClientId() {
        return mClientID;
    }

    public byte[] getByteClientId() {
        if (null != mClientID) {
            return mClientID.getBytes();
        }
        return null;
    }

    private boolean checkBuild() {
        return 0 != this.boardDigit + this.brandDigit + this.cpuAbiDigit + this.deviceDigit + this.manufacturerDigit + this.modelDigit + this.productDigit;
    }

    static {
        mClientID = "";
    }
}

