/*
 * Decompiled with CFR 0.152.
 */
package com.yy.hiidostatis.inner.implementation;

import android.content.Context;
import android.database.Cursor;
import android.database.sqlite.SQLiteDatabase;
import android.database.sqlite.SQLiteOpenHelper;
import com.yy.hiidostatis.inner.implementation.TaskData;
import com.yy.hiidostatis.inner.implementation.TaskDataSet;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.atomic.AtomicInteger;

public class TaskDataSqLiteDBManager
extends SQLiteOpenHelper {
    private SQLiteDatabase db = this.getWritableDatabase();
    private static final int DATABASE_VERSION = 2;

    public void onCreate(SQLiteDatabase db) {
        db.execSQL("CREATE TABLE IF NOT EXISTS TASK_DATA(_DATAID VARCHAR PRIMARY KEY, _ACT VARCHAR(100),_AID BIGINT, _CREPID INTEGER,_CONTENT TEXT, _TRYTIMES INTEGER,_TIME BIGINT, _ORDER BIGINT, _VERIFYMD5 VARCHAR,_TYPE VARCHAR)");
    }

    public void onUpgrade(SQLiteDatabase db, int oldVersion, int newVersion) {
        if (oldVersion == 1) {
            List<TaskData> all = this.getVersion1(db);
            db.execSQL("drop table TASK_DATA");
            this.onCreate(db);
            if (!all.isEmpty()) {
                try {
                    this.db = db;
                    this.saveAll(all);
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void saveAll(Collection<TaskData> tds) {
        try {
            this.db.beginTransaction();
            TaskData td2 = null;
            for (TaskData td2 : tds) {
                this.db.execSQL(this.insertSql(), this.allArgs(td2));
            }
            this.db.setTransactionSuccessful();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        finally {
            this.db.endTransaction();
        }
    }

    public TaskDataSqLiteDBManager(Context context, String name) {
        super(context, name, null, 2);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeAll(TaskDataSet tds) {
        this.db.beginTransaction();
        try {
            TaskData td = null;
            Iterator<TaskData> it = tds.iterator();
            while (it.hasNext()) {
                td = it.next();
                this.db.execSQL("DELETE FROM TASK_DATA WHERE _DATAID = ?", new Object[]{td.getDataId()});
            }
            this.db.setTransactionSuccessful();
        }
        finally {
            this.db.endTransaction();
        }
    }

    public TaskDataSet getAll() {
        TaskDataSet tds = null;
        String sql = String.format(Locale.ENGLISH, "SELECT %s FROM TASK_DATA ORDER BY _ORDER", this.allColumn());
        Cursor c = this.db.rawQuery(sql, null);
        if (c != null) {
            tds = new TaskDataSet();
            TaskData td = null;
            while (c.moveToNext()) {
                td = this.transToTaskData(c);
                tds.save(td);
            }
            c.close();
            c = null;
        }
        return tds;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private List<TaskData> getVersion1(SQLiteDatabase database) {
        ArrayList<TaskData> tds = new ArrayList<TaskData>();
        try (Cursor c = null;){
            c = database.rawQuery("SELECT _DATAID ,_CONTENT , _TRYTIMES , _TIME, _ORDER , _VERIFYMD5 , _TYPE FROM TASK_DATA", null);
            if (c != null) {
                TaskData td = null;
                while (c.moveToNext()) {
                    String dataId = c.getString(0);
                    String content = c.getString(1);
                    String[] ps = content.split("&");
                    String act = "";
                    String guid = "";
                    for (String kv : ps) {
                        if (kv.startsWith("act=")) {
                            act = kv.substring(4);
                            continue;
                        }
                        if (!kv.startsWith("guid=")) continue;
                        guid = kv.substring(5);
                    }
                    td = new TaskData(act);
                    td.setDataId(guid);
                    td.setContent(content);
                    td.setTryTimes(c.getInt(2));
                    td.setTime(c.getLong(3));
                    td.setOrder(c.getLong(4));
                    td.setVerifyMd5(c.getString(5));
                    td.setAid(0L);
                    td.setCrepid(0);
                    tds.add(td);
                }
            }
        }
        return tds;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ConcurrentHashMap<String, AtomicInteger> countActRemain() {
        ConcurrentHashMap<String, AtomicInteger> map = new ConcurrentHashMap<String, AtomicInteger>();
        try (Cursor c = null;){
            c = this.db.rawQuery("select _ACT,COUNT(_ACT) from TASK_DATA group by _ACT", null);
            if (c != null) {
                Object td = null;
                while (c.moveToNext()) {
                    String act = c.getString(0);
                    int num = c.getInt(1);
                    map.put(act, new AtomicInteger(num));
                }
            }
        }
        return map;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public TaskDataSet getFirstList(int size) {
        TaskDataSet tds = null;
        String sql = String.format(Locale.ENGLISH, "SELECT %s FROM TASK_DATA ORDER BY _ORDER LIMIT 0,%d", this.allColumn(), size);
        try (Cursor c = null;){
            c = this.db.rawQuery(sql, null);
            if (c != null) {
                tds = new TaskDataSet();
                TaskData td = null;
                while (c.moveToNext()) {
                    td = this.transToTaskData(c);
                    tds.save(td);
                }
            }
        }
        return tds;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public TaskDataSet getFirstList(int size, Collection<String> exclude) {
        TaskDataSet tds = null;
        if (exclude == null || exclude.isEmpty()) {
            return this.getFirstList(size);
        }
        StringBuilder builder = new StringBuilder(500);
        builder.append("(");
        for (String td : exclude) {
            builder.append("'");
            builder.append(td);
            builder.append("'");
            builder.append(",");
        }
        builder.deleteCharAt(builder.length() - 1);
        builder.append(")");
        String sql = String.format(Locale.ENGLISH, "SELECT %s FROM TASK_DATA where _DATAID not in %s ORDER BY _ORDER LIMIT 0,%d", this.allColumn(), builder.toString(), size);
        try (Cursor c = null;){
            c = this.db.rawQuery(sql, null);
            if (c != null) {
                tds = new TaskDataSet();
                TaskData td = null;
                while (c.moveToNext()) {
                    td = this.transToTaskData(c);
                    tds.save(td);
                }
            }
        }
        return tds;
    }

    public int size() {
        int size = 0;
        Cursor c = this.db.rawQuery("SELECT COUNT(*) FROM TASK_DATA", null);
        if (c != null) {
            while (c.moveToNext()) {
                size = c.getInt(0);
            }
            c.close();
        }
        return size;
    }

    public boolean save(TaskData td) {
        try {
            this.db.execSQL(this.insertSql(), this.allArgs(td));
            return true;
        }
        catch (Throwable e) {
            return false;
        }
    }

    public void update(TaskData td) {
        this.db.beginTransaction();
        try {
            this.db.execSQL("DELETE FROM TASK_DATA WHERE _DATAID = ?", new Object[]{td.getDataId()});
            this.db.execSQL(this.insertSql(), this.allArgs(td));
            this.db.setTransactionSuccessful();
        }
        finally {
            this.db.endTransaction();
        }
    }

    public int remove(TaskData td) {
        try {
            int row = this.db.delete("TASK_DATA", "_DATAID = ?", new String[]{td.getDataId()});
            return row;
        }
        catch (Throwable e) {
            return 0;
        }
    }

    public int remove(String id) {
        try {
            int row = this.db.delete("TASK_DATA", "_DATAID = ?", new String[]{id});
            return row;
        }
        catch (Throwable e) {
            return 0;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void remove(List<String> ids) {
        try {
            this.db.beginTransaction();
            for (String id : ids) {
                this.db.delete("TASK_DATA", "_DATAID = ?", new String[]{id});
            }
            this.db.setTransactionSuccessful();
        }
        catch (Throwable e) {
            e.printStackTrace();
        }
        finally {
            this.db.endTransaction();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public TaskData getFirst() {
        TaskData td = null;
        String sql = String.format("SELECT %s FROM TASK_DATA ORDER BY _ORDER LIMIT 0,1", this.allColumn());
        try (Cursor c = null;){
            c = this.db.rawQuery(sql, null);
            if (c != null && c.moveToNext()) {
                td = this.transToTaskData(c);
            }
        }
        return td;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public TaskData getLast() {
        TaskData td = null;
        String sql = String.format("SELECT %s FROM TASK_DATA ORDER BY _ORDER DESC LIMIT 0,1", this.allColumn());
        try (Cursor c = null;){
            c = this.db.rawQuery(sql, null);
            if (c != null && c.moveToNext()) {
                td = this.transToTaskData(c);
            }
        }
        return td;
    }

    private String allColumn() {
        return "_DATAID ,_ACT,_AID, _CONTENT , _TRYTIMES , _TIME, _ORDER , _VERIFYMD5 , _TYPE,_CREPID";
    }

    private String insertSql() {
        return "INSERT INTO TASK_DATA(_DATAID ,_ACT,_AID, _CONTENT , _TRYTIMES , _TIME, _ORDER , _VERIFYMD5 , _TYPE, _CREPID) VALUES(?,?,?,?,?,?,?,?,?,?)";
    }

    private Object[] allArgs(TaskData td) {
        return new Object[]{td.getDataId(), td.getAct(), td.getAid(), td.getContent(), td.getTryTimes(), td.getTime(), td.getOrder(), td.getVerifyMd5(), null, td.getCrepid()};
    }

    private TaskData transToTaskData(Cursor c) {
        TaskData td = new TaskData(c.getString(1));
        td.setDataId(c.getString(0));
        td.setAid(c.getLong(2));
        td.setContent(c.getString(3));
        td.setTryTimes(c.getInt(4));
        td.setTime(c.getLong(5));
        td.setOrder(c.getLong(6));
        td.setVerifyMd5(c.getString(7));
        td.setCrepid(c.getInt(8));
        return td;
    }
}

