/*
 * Decompiled with CFR 0.152.
 */
package com.yy.hiidostatis.defs.controller;

import android.app.ActivityManager;
import android.content.Context;
import android.content.Intent;
import android.content.IntentFilter;
import android.net.DhcpInfo;
import android.net.wifi.WifiInfo;
import android.net.wifi.WifiManager;
import android.os.Build;
import android.os.SystemClock;
import com.yy.hiidostatis.api.StatisContent;
import com.yy.hiidostatis.defs.controller.CacheManager;
import com.yy.hiidostatis.defs.interf.IStatisAPI;
import com.yy.hiidostatis.inner.util.ArdUtil;
import com.yy.hiidostatis.inner.util.DefaultPreference;
import com.yy.hiidostatis.inner.util.FindEmulator;
import com.yy.hiidostatis.inner.util.ThreadPool;
import com.yy.hiidostatis.inner.util.Util;
import com.yy.hiidostatis.inner.util.log.L;
import java.util.List;

public class DeviceController {
    private static final String PREF_KEY_DEVICE_REPORT_DATE = "PREF_KEY_DEVICE_REPORT_DATE";
    private IStatisAPI statisAPI;
    private int mSysvol = -1;
    private static final String FILTER_PROC_NAMES = "|ps|sh|/sbin/adbd|/sbin/cbd|logcat|com.sec.android.app.FlashBarService|com.android.systemui|com.android.phone|com.sec.android.provider.logsprovider|com.android.nfc|com.android.smspush|android.process.acore|android.process.media|com.android.defcontainer|com.android.email|com.android.contacts|com.sec.phone|com.sec.pcw.device|com.osp.app.signin|com.sec.android.service.cm|com.sec.android.app.controlpanel|com.android.musicfx|com.sec.android.gallery3d|com.sec.android.app.music:service|com.sec.android.favoriteappwidget|com.android.connectionhandler|com.sec.android.fotaclient|com.sec.spp.push|com.sec.android.app.launcher|com.sec.android.widgetapp.alarmclock|com.sec.android.app.clockpackage|com.sec.android.provider.badge|com.sec.android.widgetapp.favoriteswidget|com.sec.android.widgetapp.digitalclock|com.sec.android.app.videoplayer|com.sec.pcw|com.nd.assistance.ServerService|screencap|com.sec.pcw:CameraAutoUpload|com.android.browser|com.android.mms|com.android.incallui|com.android.providers.calendar|com.android.calendar:birthday|com.android.calendar|com.android.dialer|com.android.browser:turbo|com.android.browser:webeye|";

    public DeviceController(IStatisAPI statisAPI, Context context) {
        this.statisAPI = statisAPI;
        this.mSysvol = ArdUtil.getVolume(context, 1);
    }

    public void reportDevice(final Context context, long uid) {
        if (context == null) {
            L.error(DeviceController.class, "Null context when reporting to hiido, cancelled.", new Object[0]);
            return;
        }
        boolean isReport = false;
        String nowDate = "";
        try {
            nowDate = Util.formatDate("yyyyMMdd", System.currentTimeMillis());
            String reportDate = DefaultPreference.getPreference().getPrefString(context, PREF_KEY_DEVICE_REPORT_DATE, "");
            isReport = !Util.empty(reportDate) && reportDate.equals(nowDate);
        }
        catch (Throwable e) {
            L.warn(this, "reportDevice exception=%s", e);
        }
        L.brief("reportDevice:isReport:%b", isReport);
        if (!isReport) {
            final String finalNowDate = nowDate;
            this.statisAPI.reportDevice(uid, null, new IStatisAPI.ReportResult(){

                @Override
                public void onReportResult(boolean suc) {
                    if (suc) {
                        DefaultPreference.getPreference().setPrefString(context, DeviceController.PREF_KEY_DEVICE_REPORT_DATE, finalNowDate);
                    }
                }
            });
        }
    }

    public void reportDeviceOnLaunch(final Context context, final long uid) {
        if (context == null) {
            L.error(DeviceController.class, "Null context when reporting to hiido, cancelled.", new Object[0]);
            return;
        }
        ThreadPool.getPool().execute(new Runnable(){

            @Override
            public void run() {
                DeviceController.this.doReport(context, uid);
            }
        }, 14000L);
    }

    private void doReport(Context context, long uid) {
        try {
            StatisContent extra = new StatisContent();
            WifiInfo wi = ArdUtil.getWifiInfo(context);
            if (wi != null) {
                extra.put("bssid", wi.getBSSID());
                extra.put("ssid", wi.getSSID());
                extra.put("rssi", wi.getRssi());
            }
            wi = null;
            extra.put("sysuptm", SystemClock.elapsedRealtime() / 1000L);
            extra.put("srbr", ArdUtil.getScreenBrightness(context));
            extra.put("debug", ArdUtil.isDebugEnable(context) ? 1 : 0);
            IntentFilter ifilter = new IntentFilter("android.intent.action.BATTERY_CHANGED");
            Intent batteryStatus = context.registerReceiver(null, ifilter);
            int status = batteryStatus.getIntExtra("status", -1);
            boolean isCharging = status == 2 || status == 5;
            int level = batteryStatus.getIntExtra("level", -1);
            int scale = batteryStatus.getIntExtra("scale", -1);
            float batteryPct = (float)(100 * level) / (float)scale;
            int chargePlug = batteryStatus.getIntExtra("plugged", -1);
            boolean usbCharge = chargePlug == 2;
            boolean acCharge = chargePlug == 1;
            extra.put("plug", usbCharge || acCharge ? 1 : 0);
            extra.put("charging", isCharging ? 1 : 0);
            extra.put("batlv", String.format("%.2f", Float.valueOf(batteryPct)));
            extra.put("cpunuma", ArdUtil.getAvailableProcessors());
            extra.put("cpuarc", ArdUtil.getCpuAbi());
            extra.put("headph", ArdUtil.isHeadphone(context) ? 1 : 0);
            extra.put("devori", ArdUtil.getDeviceOrientation(context));
            extra.put("tz", ArdUtil.getTimeZone());
            extra.put("cip", ArdUtil.getCellIp());
            String[] w = DeviceController.getWifiInfo(context);
            if (w != null && w.length == 3) {
                extra.put("wip", w[0]);
                extra.put("wmac", w[1]);
                extra.put("wmask", w[2]);
            }
            extra.put("fmem", ArdUtil.getAvailMemory(context));
            extra.put("tdisk", ArdUtil.getTotalInternalStorgeSize());
            extra.put("fdisk", ArdUtil.getAvailInternalStorgeSize());
            extra.put("sysvol", this.mSysvol);
            extra.put("bundleid", ArdUtil.getPackageName(context));
            extra.put("proclist", DeviceController.getRunningProcess(context));
            extra.put("bluemac", ArdUtil.getBluetoothMac(context));
            extra.put("scene", ArdUtil.getSceneMode(context));
            extra.put("manutime", Build.TIME);
            extra.put("manuid", Build.ID);
            extra.put("emu", FindEmulator.isEmulator(context) ? 1 : 0);
            extra.put("emurs", FindEmulator.checkEmu(context));
            this.statisAPI.reportDevice(uid, extra);
        }
        catch (Throwable e) {
            L.warn(this, "reportDeviceOnLaunch exception =%s", e);
        }
    }

    private static String[] getWifiInfo(Context c) {
        String[] s = new String[3];
        try {
            WifiInfo localWifiInfo;
            WifiManager localWifiManager;
            if (ArdUtil.checkPermissions(c, "android.permission.ACCESS_WIFI_STATE") && (localWifiManager = (WifiManager)c.getSystemService("wifi")).isWifiEnabled() && localWifiManager.getWifiState() == 3 && (localWifiInfo = localWifiManager.getConnectionInfo()) != null) {
                int i = localWifiInfo.getIpAddress();
                localWifiInfo.getMacAddress();
                DhcpInfo localDhcpInfo = localWifiManager.getDhcpInfo();
                s[0] = DeviceController.a(i);
                s[1] = localWifiInfo.getMacAddress();
                s[2] = DeviceController.a(localDhcpInfo.netmask);
            }
        }
        catch (Throwable e) {
            L.warn(DeviceController.class, "getWifiInfo exception = %s", e);
        }
        return s;
    }

    private static String a(int paramInt) {
        return (paramInt & 0xFF) + "." + (paramInt >> 8 & 0xFF) + "." + (paramInt >> 16 & 0xFF) + "." + (paramInt >> 24 & 0xFF);
    }

    private static String getRunningProcess(Context c) {
        StringBuffer sb = new StringBuffer();
        try {
            ActivityManager am = (ActivityManager)c.getSystemService("activity");
            CacheManager cm = new CacheManager(c, "PREF_KEY_CACHE_PROC_KEY", "PREF_KEY_CACHE_PROCS");
            List run = am.getRunningAppProcesses();
            for (ActivityManager.RunningAppProcessInfo ra : run) {
                if (DeviceController.isFilterName(ra.processName) || cm.isContains(ra.processName)) continue;
                sb.append(ra.processName).append("|");
                cm.add(ra.processName);
            }
            List ll = am.getRunningServices(500);
            for (ActivityManager.RunningServiceInfo r : ll) {
                if (DeviceController.isFilterName(r.process) || cm.isContains(r.process)) continue;
                sb.append(r.process).append("|");
                cm.add(r.process);
            }
            cm.finish();
        }
        catch (Throwable e) {
            L.warn(DeviceController.class, "getRunningProcess exception = %s", e);
        }
        return sb.length() > 0 ? sb.toString().substring(0, sb.length() - 1) : sb.toString();
    }

    private static boolean isFilterName(String str) {
        if (str.startsWith("/system/")) {
            return true;
        }
        return FILTER_PROC_NAMES.contains("|" + str + "|");
    }
}

