/*
 * Decompiled with CFR 0.152.
 */
package com.yy.hiidostatis.defs;

import android.content.Context;
import android.net.wifi.WifiInfo;
import android.os.Process;
import android.telephony.CellLocation;
import android.telephony.cdma.CdmaCellLocation;
import android.telephony.gsm.GsmCellLocation;
import com.yy.hiidostatis.api.StatisContent;
import com.yy.hiidostatis.api.StatisOption;
import com.yy.hiidostatis.defs.IStatisApi;
import com.yy.hiidostatis.defs.interf.IStatisAPI;
import com.yy.hiidostatis.defs.listener.ActAdditionListenerController;
import com.yy.hiidostatis.defs.listener.ActListener;
import com.yy.hiidostatis.defs.listener.HiidoSdkAdditionDelegate;
import com.yy.hiidostatis.defs.monitor.ScreenMonitor;
import com.yy.hiidostatis.defs.monitor.TrafficMonitor;
import com.yy.hiidostatis.defs.obj.Act;
import com.yy.hiidostatis.defs.obj.EventElementInfo;
import com.yy.hiidostatis.defs.obj.EventInfo;
import com.yy.hiidostatis.defs.obj.Property;
import com.yy.hiidostatis.defs.obj.ShareType;
import com.yy.hiidostatis.inner.util.ArdUtil;
import com.yy.hiidostatis.inner.util.DefaultPreference;
import com.yy.hiidostatis.inner.util.ProcessUtil;
import com.yy.hiidostatis.inner.util.StringUtil;
import com.yy.hiidostatis.inner.util.Util;
import com.yy.hiidostatis.inner.util.cipher.Base64Util;
import com.yy.hiidostatis.inner.util.cipher.Coder;
import com.yy.hiidostatis.inner.util.log.L;
import com.yy.hiidostatis.message.Packer;
import com.yy.hiidostatis.message.log.TraceLog;
import com.yy.hiidostatis.message.utils.KVIO;
import com.yy.hiidostatis.provider.DefaultProviderLoader;
import com.yy.hiidostatis.provider.GlobalProvider;
import com.yy.hiidostatis.provider.MessageConfig;
import com.yy.hiidostatis.provider.MessageConfigFactory;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.io.Writer;
import java.net.URLEncoder;
import java.util.Date;
import java.util.Map;
import java.util.Set;
import java.util.UUID;

public class StatisAPINew
implements IStatisApi {
    private static final int MAX_EVENT_FIELD_BYTES = 256;
    private Context mContext;
    private ActAdditionListenerController mActListernerController = new ActAdditionListenerController();
    private Long launchTime = null;
    private MessageConfig config;
    private Packer packer;

    @Override
    public StatisOption getOption() {
        StatisOption option = new StatisOption();
        if (this.config != null) {
            option.setVer(this.config.getVer());
            option.setFrom(this.config.getFrom());
            option.setAppkey(this.config.getAppkey());
            option.setAppId(this.config.getAppId());
        }
        return option;
    }

    @Override
    public IStatisAPI create() {
        return this;
    }

    @Override
    public Context getContext() {
        return this.mContext;
    }

    public StatisAPINew(MessageConfig config) {
        this.config = config;
        KVIO.initialize(config.getApplicationContext());
        DefaultProviderLoader.init();
        TraceLog.initLog(config.getApplicationContext());
        this.init();
    }

    @Override
    public void init(Context context, StatisOption option) {
        MessageConfig config = MessageConfigFactory.generate(context, option.getAppkey());
        config.setFrom(option.getFrom());
        config.setAppId(option.getAppId());
        config.setVer(option.getVer());
        this.config = config;
        KVIO.initialize(config.getApplicationContext());
        TraceLog.initLog(config.getApplicationContext());
        this.init();
        this.onInitSuccess();
    }

    @Override
    public void setTestServer(String testServer) {
    }

    @Override
    public void setAbroad(boolean isAbroad) {
    }

    @Override
    public void setBusinessType(int businessType) {
    }

    private void init() {
        this.packer = (Packer)GlobalProvider.instance.get(Packer.class, this.config);
        this.mContext = this.config.getApplicationContext();
    }

    public void onInitSuccess() {
        this.packer.onInited(true);
    }

    private boolean reportStatisticContentAll(String act, StatisContent content, boolean fillCommon, boolean fillConcrete, boolean isCover, Packer.OnSavedListener resultReceiver) {
        if (this.mContext == null || Util.empty(act) || Util.empty(content)) {
            L.error(StatisAPINew.class, "Input error! context is null || act is null || content is null ", new Object[0]);
            return false;
        }
        content.setAct(act);
        content.setCover(isCover);
        content.setFillCommon(fillCommon);
        content.setFillConcrete(fillConcrete);
        return this.packer.addMessage(content, resultReceiver);
    }

    @Override
    public void reportStatisticContentTemporary(String act, StatisContent content, boolean fillCommon, boolean isCover) {
        if (this.mContext == null || Util.empty(act) || Util.empty(content)) {
            L.error(StatisAPINew.class, "Input error! context is null || act is null || content is null ", new Object[0]);
            return;
        }
        content.setNotSave(true);
        this.reportStatisticContent(act, content, fillCommon, isCover);
    }

    @Override
    public void reportStatisticContent(String act, StatisContent content, boolean fillCommon, boolean isCover) {
        this.reportStatisticContentAll(act, content, fillCommon, fillCommon, isCover, null);
    }

    @Override
    public void reportStatisticContent(String act, StatisContent content, boolean fillCommon, boolean isCover, boolean isPriority) {
        this.reportStatisticContentAll(act, content, fillCommon, fillCommon, isCover, null);
    }

    @Override
    public void reportStatisticContentWithNoComm(Context context, String act, StatisContent content) {
        this.reportStatisticContentAll(act, content, false, false, false, null);
    }

    @Override
    public void reportStatisticContentWithNoComm(Context context, String act, StatisContent content, boolean isPriority) {
        this.reportStatisticContentAll(act, content, false, false, false, null);
    }

    private boolean reportStatisticContentInner(Act act, StatisContent content, boolean fillCommon, boolean fillConcrete, boolean isPriority) {
        return this.reportStatisticContentInner(act, content, fillCommon, fillConcrete, isPriority, null);
    }

    private boolean reportStatisticContentInner(Act act, StatisContent content, boolean fillCommon, boolean fillConcrete, boolean isPriority, Packer.OnSavedListener resultReceiver) {
        ActListener listener = this.mActListernerController.getListerner(act);
        StatisContent addContent = this.mActListernerController.getActAddition(act, listener);
        if (addContent != null) {
            content.putContent(addContent, false);
        }
        content.setPriority(isPriority ? StatisContent.Priority.PRIORITY_HIGH : StatisContent.Priority.PRIORITY_NORMAL);
        return this.reportStatisticContentAll(act.toString(), content, fillCommon, fillConcrete, false, resultReceiver);
    }

    @Override
    public void reportInstall(int type, Packer.OnSavedListener resultReceiver) {
        StatisContent content = new StatisContent();
        content.put("new", type);
        this.reportStatisticContentInner(Act.MBSDK_INSTALL, content, true, true, true, resultReceiver);
    }

    @Override
    public void reportInstall(int type, IStatisAPI.ReportResult resultReceiver) {
        StatisContent content = new StatisContent();
        content.put("new", type);
        boolean b = this.reportStatisticContentInner(Act.MBSDK_INSTALL, content, true, true, true, null);
        if (resultReceiver != null) {
            resultReceiver.onReportResult(b);
        }
    }

    @Override
    public void reportRun(long uid) {
        this.launchTime = System.currentTimeMillis();
        StatisContent content = new StatisContent();
        content.put("uid", uid);
        this.reportStatisticContentInner(Act.MBSDK_RUN, content, true, true, true, null);
    }

    @Override
    public void reportDo(long uid) {
        StatisContent content = new StatisContent();
        content.put("uid", uid);
        this.reportStatisticContentInner(Act.MBSDK_DO, content, true, true, true, null);
    }

    @Override
    public void reportDo5(long uid) {
    }

    @Override
    public void reportDoShort(long uid, Map<String, String> prop) {
    }

    private String getPropString(Map<String, String> prop) {
        String propStr = null;
        if (prop != null && prop.size() > 0) {
            StringBuffer sb = new StringBuffer();
            Set<Map.Entry<String, String>> entrySet = prop.entrySet();
            for (Map.Entry<String, String> entry : entrySet) {
                try {
                    sb.append(URLEncoder.encode(entry.getKey(), "UTF-8")).append("=").append(URLEncoder.encode(entry.getValue(), "UTF-8")).append(",");
                }
                catch (Throwable e) {
                    L.error(this, e.getMessage(), new Object[0]);
                }
            }
            if (sb.length() > 0) {
                propStr = sb.toString().substring(0, sb.length() - 1);
            }
            sb.setLength(0);
            sb = null;
            entrySet = null;
        }
        return propStr;
    }

    @Override
    public void reportLogin(long uid) {
        StatisContent content = new StatisContent();
        content.put("uid", uid);
        this.reportStatisticContentInner(Act.MBSDK_LOGIN, content, true, true, false, null);
    }

    @Override
    public void reportAppsflyer(String data) {
        this.config.setAppsflyer(data);
        StatisContent content = new StatisContent();
        content.put("mdsr", data);
        this.reportStatisticContentInner(Act.MBSDK_APPSFLYER, content, true, true, false, null);
    }

    @Override
    public void reportShare(String platform, int mediaType, String content, ShareType stype, String errmsg, String screen, String userData) {
        StatisContent cont = new StatisContent();
        cont.put("platform", platform);
        cont.put("mediatype", mediaType);
        cont.put("content", content);
        cont.put("stype", stype.ordinal());
        cont.put("errmsg", errmsg);
        cont.put("screen", screen);
        cont.put("userdata", userData);
        this.reportStatisticContentInner(Act.MBSDK_SHARE, cont, true, true, false, null);
    }

    @Override
    public void reportIM(String sender, String receiver, String content, Date editTime, Date sendTime, String errormsg, int mediaType, String userData) {
        StatisContent cont = new StatisContent();
        cont.put("sender", sender);
        cont.put("receiver", receiver);
        cont.put("content", content);
        cont.put("edit_time", editTime.getTime() / 1000L);
        cont.put("send_time", sendTime.getTime() / 1000L);
        cont.put("errormsg", errormsg);
        cont.put("mediatype", mediaType);
        cont.put("userdata", userData);
        this.reportStatisticContentInner(Act.MBSDK_IM, cont, true, true, false, null);
    }

    @Override
    public void reportUrlScheme(String scheme, String host, int port, String path, String query) {
        StatisContent content = new StatisContent();
        content.put("scheme", scheme);
        content.put("host", host);
        content.put("port", port);
        content.put("path", path);
        content.put("query", query);
        this.reportStatisticContentInner(Act.MBSDK_URL_SCHEME, content, true, true, false);
    }

    @Override
    public void reportReg(String uid, String name, String type, Map<String, String> prop) {
        StatisContent content = new StatisContent();
        content.put("uid", uid);
        content.put("acc", uid);
        content.put("name", name);
        content.put("type", type);
        content.put("prop", this.getPropString(prop));
        this.reportStatisticContentInner(Act.MBSDK_REG, content, true, true, false);
    }

    @Override
    public void reportAction(long uid, String appa, String page, String event) {
        if (Util.empty(appa) && Util.empty(page) && Util.empty(event)) {
            L.warn(StatisAPINew.class, "Input appa is null && page is null && event is null ", new Object[0]);
            return;
        }
        StatisContent content = new StatisContent();
        content.put("uid", uid);
        content.put("appa", appa);
        content.put("page", page);
        content.put("even", event);
        this.reportStatisticContentInner(Act.MBSDK_ACTION, content, true, true, false);
    }

    @Override
    public void reportLanuch(long uid, String appa, StatisContent sensor) {
        if (Util.empty(appa)) {
            L.warn(StatisAPINew.class, "Input appa is null ", new Object[0]);
            return;
        }
        StatisContent content = new StatisContent();
        content.put("uid", uid);
        content.put("appa", appa);
        content.putContent(sensor, true);
        try {
            content.put("alr", TrafficMonitor.instance.getAlr());
            content.put("als", TrafficMonitor.instance.getAls());
            content.put("apr", TrafficMonitor.instance.getApr());
            content.put("aps", TrafficMonitor.instance.getAps());
            int cht = (ScreenMonitor.instance.getClick() < 4 ? 0 : 2) | (ScreenMonitor.instance.getSlide() < 3 ? 0 : 1);
            content.put("cht", cht);
            content.put("pan", ScreenMonitor.instance.getSlide());
            content.put("tap", ScreenMonitor.instance.getClick());
        }
        catch (Throwable e) {
            L.warn(this, "reportLanuch exception=%s", e);
        }
        this.reportStatisticContentInner(Act.MBSDK_LAUNCH, content, true, true, true);
    }

    @Override
    public void reportPage(long uid, String page) {
        if (Util.empty(page)) {
            L.warn(StatisAPINew.class, "Input page is null ", new Object[0]);
            return;
        }
        StatisContent content = new StatisContent();
        content.put("uid", uid);
        content.put("page", page);
        this.reportStatisticContentInner(Act.MBSDK_PAGE, content, true, true, false);
    }

    @Override
    public void reportPageState(long uid, String page, long duration) {
        if (Util.empty(page)) {
            L.warn(StatisAPINew.class, "Input page is null ", new Object[0]);
            return;
        }
        StatisContent content = new StatisContent();
        content.put("uid", uid);
        content.put("page", page);
        content.put("duration", duration);
        this.reportStatisticContentInner(Act.MBSDK_PAGE_STATE, content, true, true, true);
    }

    @Override
    public void reportEvent(long uid, String event) {
        if (Util.empty(event)) {
            L.warn(StatisAPINew.class, "Input event is null ", new Object[0]);
            return;
        }
        StatisContent content = new StatisContent();
        content.put("uid", uid);
        content.put("event", event);
        L.debug(this, "add mbsdkevent %s", event);
        this.reportStatisticContentInner(Act.MBSDK_EVENT, content, true, true, false);
    }

    @Override
    public void reportError(long uid, String eid, String emsg, String param) {
        StatisContent content = new StatisContent();
        content.put("uid", uid);
        content.put("eid", eid);
        content.put("emsg", emsg);
        content.put("parm", param);
        this.reportStatisticContentInner(Act.MBSDK_ERROR, content, true, true, false);
    }

    @Override
    public void reportCrash(long uid, String crashMsg) {
        if (this.mContext == null) {
            L.warn(StatisAPINew.class, "Input context is null", new Object[0]);
            return;
        }
        StatisContent content = new StatisContent();
        content.put("uid", uid);
        content.put("crashmsg", crashMsg);
        content.put("rtyp", 2);
        content.put("rot", ArdUtil.isRoot() ? 1 : 0);
        content.put("tram", ArdUtil.getTotalMemory(this.mContext));
        content.put("trom", ArdUtil.getTotalInternalStorgeSize());
        content.put("tsd", ArdUtil.getTotalExternalStorgeSize());
        content.put("aram", ArdUtil.getAvailMemory(this.mContext));
        content.put("arom", ArdUtil.getAvailInternalStorgeSize());
        content.put("asd", ArdUtil.getAvailExternalStorgeSize());
        content.put("ctyp", "1");
        content.put("crashid", UUID.randomUUID().toString());
        if (this.launchTime != null) {
            content.put("ltime", (System.currentTimeMillis() - this.launchTime) / 1000L);
        }
        content.put("cpage", DefaultPreference.getPreference().getPrefString(this.mContext, "PREF_CPAGE", null));
        content.put("cpkg", ArdUtil.getPackageName(this.mContext));
        content.put("cthread", ProcessUtil.getCurProcessName(this.mContext) + "#" + Process.myTid());
        this.reportStatisticContentInner(Act.MBSDK_CRASH, content, true, true, false);
    }

    @Override
    public void reportCrashInner(long uid, Throwable throwable) {
        if (this.mContext == null) {
            L.warn(StatisAPINew.class, "Input context is null", new Object[0]);
            return;
        }
        StatisContent content = new StatisContent();
        content.put("uid", uid);
        content.put("crashmsg", this.getErrorInfo(throwable));
        content.put("rtyp", 1);
        content.put("rot", ArdUtil.isRoot() ? 1 : 0);
        content.put("tram", ArdUtil.getTotalMemory(this.mContext));
        content.put("trom", ArdUtil.getTotalInternalStorgeSize());
        content.put("tsd", ArdUtil.getTotalExternalStorgeSize());
        content.put("aram", ArdUtil.getAvailMemory(this.mContext));
        content.put("arom", ArdUtil.getAvailInternalStorgeSize());
        content.put("asd", ArdUtil.getAvailExternalStorgeSize());
        content.put("ctyp", "1");
        content.put("crashid", UUID.randomUUID().toString());
        if (this.launchTime != null) {
            content.put("ltime", (System.currentTimeMillis() - this.launchTime) / 1000L);
        }
        content.put("cpage", DefaultPreference.getPreference().getPrefString(this.mContext, "PREF_CPAGE", null));
        content.put("cpkg", ArdUtil.getPackageName(this.mContext));
        content.put("cthread", ProcessUtil.getCurProcessName(this.mContext) + "#" + Process.myTid());
        this.reportStatisticContentInner(Act.MBSDK_CRASH, content, true, true, false);
    }

    @Override
    public boolean reportDevice(long uid, StatisContent extra) {
        this.reportDevice(uid, extra, null);
        return true;
    }

    @Override
    public boolean reportDevice(long uid) {
        this.reportDevice(uid, null, null);
        return true;
    }

    @Override
    public boolean reportInstall(int type) {
        this.reportInstall(type, (Packer.OnSavedListener)null);
        return true;
    }

    @Override
    public void reportCrash(long uid, Throwable throwable) {
        this.reportCrash(uid, this.getErrorInfo(throwable));
    }

    private String getErrorInfo(Throwable throwable) {
        try {
            StringWriter writer = new StringWriter();
            PrintWriter pw = new PrintWriter(writer);
            throwable.printStackTrace(pw);
            String errorinfo = ((Object)writer).toString();
            pw.close();
            ((Writer)writer).close();
            pw = null;
            writer = null;
            return errorinfo;
        }
        catch (Throwable e) {
            L.error(StatisAPINew.class, "SDK Get Crash Error Info Exception!" + e, new Object[0]);
            return "SDK Get Crash Error Info Exception!" + e;
        }
    }

    @Override
    public void reportSuccess(long uid, String aid, String type, long duration, String parm) {
        if (this.mContext == null) {
            L.warn(StatisAPINew.class, "Input context is null!", new Object[0]);
            return;
        }
        StatisContent statisContent = new StatisContent();
        statisContent.put("uid", uid);
        statisContent.put("actionid", aid);
        statisContent.put("type", type);
        statisContent.put("duration", duration);
        statisContent.put("parm", parm);
        this.reportStatisticContentInner(Act.MBSDK_SUCCESS, statisContent, true, true, false);
    }

    @Override
    public void reportFailure(long uid, String aid, String type, String failCode, String failMsg, String parm) {
        if (this.mContext == null) {
            L.warn(StatisAPINew.class, "Input context is null!", new Object[0]);
            return;
        }
        StatisContent statisContent = new StatisContent();
        statisContent.put("uid", uid);
        statisContent.put("actionid", aid);
        statisContent.put("type", type);
        statisContent.put("failcode", failCode);
        statisContent.put("failmsg", failMsg);
        statisContent.put("parm", parm);
        this.reportStatisticContentInner(Act.MBSDK_FAILURE, statisContent, true, true, false);
    }

    @Override
    public void reportCustomContent(long uid, String type, String content) {
        if (this.mContext == null || content == null || content.length() == 0) {
            L.warn(StatisAPINew.class, "Input context is null || content is null", new Object[0]);
            return;
        }
        StatisContent statisContent = new StatisContent();
        statisContent.put("uid", uid);
        statisContent.put("type", type);
        statisContent.put("content", content);
        this.reportStatisticContentInner(Act.MBSDK_REPORT, statisContent, true, true, false);
    }

    @Override
    public void reportAppList(long uid, String type, String applist) {
        this.reportAppList(uid, type, applist, null);
    }

    @Override
    public void reportAppList(long uid, String type, String applist, String applist2) {
        if (!(applist != null && applist.length() != 0 || applist2 != null && applist2.length() != 0)) {
            L.warn(StatisAPINew.class, "applist is empty\uff0cno report applist !", new Object[0]);
            return;
        }
        StatisContent content = new StatisContent();
        try {
            content.put("uid", uid);
            content.put("type", type);
            content.put("applist", applist);
            content.put("applist2", applist2);
            this.reportStatisticContentInner(Act.MBSDK_APPLIST, content, true, true, false);
        }
        catch (Throwable e) {
            L.error(StatisAPINew.class, "encrypt exception %s", e);
        }
    }

    @Override
    public void reportTimesEvent(long uid, String eid) {
        this.reportTimesEvent(uid, eid, null);
    }

    @Override
    public void reportTimesEvent(long uid, String eid, String label) {
        this.reportTimesEvent(uid, eid, label, null);
    }

    @Override
    public void reportTimesEvent(long uid, String eid, String label, Property property) {
        Property pro = property;
        if (Util.empty(eid)) {
            L.error(this, "eid is not allow null.", new Object[0]);
            return;
        }
        if (eid.getBytes().length > 256) {
            L.warn(this, "eid[%s] bytes[%d] must under %d bytes.", eid, eid.getBytes().length, 256);
        }
        if (!Util.empty(label) && label.getBytes().length > 256) {
            L.warn(this, "label[%s] bytes[%d] must under %d bytes.", label, label.getBytes().length, 256);
        }
        EventInfo mEventInfo = new EventInfo();
        EventElementInfo event = new EventElementInfo(eid, 1);
        event.addParam(label);
        event.setProperty(pro);
        mEventInfo.addElem(event);
        String ev = mEventInfo.getResult();
        mEventInfo = null;
        event = null;
        this.reportEvent(uid, ev);
    }

    @Override
    public void reportCountEvent(long uid, String eid, double evalue) {
        this.reportCountEvent(uid, eid, evalue, null);
    }

    @Override
    public void reportCountEvent(long uid, String eid, double evalue, String label) {
        this.reportCountEvent(uid, eid, evalue, label, null);
    }

    @Override
    public void reportCountEvent(long uid, String eid, double evalue, String label, Property property) {
        Property pro;
        Property property2 = pro = property == null ? null : property.copy();
        if (Util.empty(eid)) {
            L.error(this, "eid is not allow null.", new Object[0]);
            return;
        }
        if (eid.getBytes().length > 256) {
            L.warn(this, "eid[%s] bytes[%d] must under %d bytes.", eid, eid.getBytes().length, 256);
        }
        if (!Util.empty(label) && label.getBytes().length > 256) {
            L.warn(this, "label[%s] bytes[%d] must under %d bytes.", label, label.getBytes().length, 256);
        }
        EventInfo mEventInfo = new EventInfo();
        EventElementInfo event = new EventElementInfo(eid, String.valueOf(evalue));
        event.addParam(label);
        event.setProperty(pro);
        mEventInfo.addElem(event);
        String ev = mEventInfo.getResult();
        mEventInfo = null;
        event = null;
        this.reportEvent(uid, ev);
    }

    @Override
    public void reportSdkList(long uid, String sdkList) {
        if (this.mContext == null || sdkList == null || sdkList.length() == 0) {
            L.warn(StatisAPINew.class, "Input context is null || sdkList is null", new Object[0]);
            return;
        }
        String enSdkList = sdkList;
        try {
            enSdkList = Base64Util.encode(enSdkList.getBytes("UTF-8"));
        }
        catch (Throwable e) {
            L.error(StatisAPINew.class, "encrypt exception %s", e);
        }
        StatisContent statisContent = new StatisContent();
        statisContent.put("uid", uid);
        statisContent.put("sdklist", enSdkList);
        this.reportStatisticContentInner(Act.MBSDK_SDKLIST, statisContent, true, true, false);
    }

    @Override
    public void reportDevice(long uid, StatisContent extra, IStatisAPI.ReportResult resultReceiver) {
        if (this.mContext == null) {
            L.warn(StatisAPINew.class, "Input context is null", new Object[0]);
            if (resultReceiver != null) {
                resultReceiver.onReportResult(false);
            }
        }
        StatisContent statisContent = new StatisContent();
        statisContent.put("uid", uid);
        statisContent.put("cpunum", ArdUtil.getCpuNum());
        statisContent.put("cpu", ArdUtil.getMaxCpuFreq());
        statisContent.put("memory", ArdUtil.getTotalMemory(this.mContext));
        statisContent.put("rot", ArdUtil.isRoot() ? 1 : 0);
        if (extra != null) {
            statisContent.putContent(extra, true);
        }
        boolean b = this.reportStatisticContentInner(Act.MBSDK_SDKDEVICE, statisContent, true, true, false);
        if (resultReceiver != null) {
            resultReceiver.onReportResult(b);
        }
    }

    @Override
    public void reportLocation(long uid, double longitude, double latitude, double altitude, IStatisAPI.ReportResult resultReceiver) {
        WifiInfo wi;
        if (this.mContext == null) {
            L.warn(StatisAPINew.class, "Input context is null", new Object[0]);
            if (resultReceiver != null) {
                resultReceiver.onReportResult(false);
            }
        }
        StatisContent statisContent = new StatisContent();
        statisContent.put("uid", uid);
        statisContent.put("lon", longitude);
        statisContent.put("lat", latitude);
        statisContent.put("alt", altitude);
        CellLocation c = ArdUtil.getCellId(this.mContext);
        if (c != null) {
            if (c instanceof GsmCellLocation) {
                statisContent.put("ceid", ((GsmCellLocation)c).getCid());
                statisContent.put("lac", ((GsmCellLocation)c).getLac());
            } else if (c instanceof CdmaCellLocation) {
                statisContent.put("ceid", ((CdmaCellLocation)c).getBaseStationId());
                statisContent.put("lac", ((CdmaCellLocation)c).getNetworkId());
            }
            c = null;
        }
        if ((wi = ArdUtil.getWifiInfo(this.mContext)) != null) {
            statisContent.put("bssid", wi.getBSSID());
            statisContent.put("ssid", wi.getSSID());
            statisContent.put("rssi", wi.getRssi());
            wi = null;
        }
        boolean b = this.reportStatisticContentInner(Act.MBSDK_LOCATION, statisContent, true, true, false);
        if (resultReceiver != null) {
            resultReceiver.onReportResult(b);
        }
    }

    @Override
    public void reportFeedback(long uid, String fbId, String cont, String link, String remk, IStatisAPI.ReportResult resultReceiver) {
        if (this.mContext == null || Util.empty(cont)) {
            L.warn(StatisAPINew.class, "Input context is null||cont is null", new Object[0]);
            if (resultReceiver != null) {
                resultReceiver.onReportResult(false);
            }
        }
        StatisContent statisContent = new StatisContent();
        statisContent.put("uid", uid);
        statisContent.put("fbid", fbId);
        statisContent.put("cont", cont);
        statisContent.put("link", link);
        statisContent.put("remk", remk);
        boolean b = this.reportStatisticContentInner(Act.MBSDK_FBACK, statisContent, true, true, false);
        if (resultReceiver != null) {
            resultReceiver.onReportResult(b);
        }
    }

    @Override
    public void reportPushToken(long uid, String token) {
        if (this.mContext == null || Util.empty(token)) {
            L.warn(StatisAPINew.class, "Input context is null||token is null", new Object[0]);
            return;
        }
        StatisContent statisContent = new StatisContent();
        statisContent.put("uid", uid);
        statisContent.put("pushtoken", token);
        this.reportStatisticContentInner(Act.MBSDK_PUSH, statisContent, true, true, false);
    }

    @Override
    public void addActAdditionListener(ActListener listener) {
        this.mActListernerController.add(listener);
    }

    @Override
    public void removeActAdditionListener(ActListener listener) {
        this.mActListernerController.remove(listener);
    }

    @Override
    public HiidoSdkAdditionDelegate getAdditionParamsDelegate() {
        return this.mActListernerController.getHiidoSdkAdditionDelegate();
    }

    @Override
    public void setAdditionParamsDelegate(HiidoSdkAdditionDelegate hiidoSdkAdditionDelegate) {
        this.mActListernerController.setHiidoSdkAdditionDelegate(hiidoSdkAdditionDelegate);
    }

    @Override
    public void generateSession() {
        try {
            this.config.setSessionId(Coder.encryptMD5(StringUtil.geneGuid()).substring(0, 20));
        }
        catch (Throwable e) {
            L.error(this, "generateSession exception:%s", e);
        }
    }

    @Override
    public String getSession() {
        return this.config.getSessionId();
    }

    @Override
    public void setSession(String sessionId) {
        if (sessionId == null || sessionId.isEmpty()) {
            this.generateSession();
        } else {
            this.config.setSessionId(sessionId);
        }
    }

    @Override
    public void exit() {
        this.config.setSessionId(null);
        this.launchTime = null;
    }

    @Override
    public Long getLaunchTime() {
        return this.launchTime;
    }

    @Override
    public void reportRecentAppList(long uid, String userApp, String systemApp) {
    }
}

