/*
 * Decompiled with CFR 0.152.
 */
package com.yy.hiidostatis.message.utils;

import android.content.Context;
import android.content.SharedPreferences;
import com.yy.hiidostatis.inner.util.NumberUtil;
import com.yy.hiidostatis.inner.util.ProcessUtil;
import java.util.HashSet;
import java.util.Set;

public class KVIO {
    private static KVIO kvio;
    SharedPreferences cache;
    SharedPreferences.Editor editor;

    private KVIO(Context context) {
        String newFileName = ProcessUtil.getFileNameBindProcess(context, "hiido_kv.dat");
        this.cache = context.getSharedPreferences(newFileName, 0);
        this.editor = this.cache.edit();
    }

    public static synchronized void initialize(Context context) {
        if (kvio != null) {
            return;
        }
        kvio = new KVIO(context);
    }

    public static KVIO get() {
        return kvio;
    }

    public boolean encode(String key, boolean value) {
        this.editor.putBoolean(key, value).apply();
        return true;
    }

    public boolean decodeBool(String key) {
        return this.decodeBool(key, false);
    }

    public boolean decodeBool(String key, boolean defaultValue) {
        return this.cache.getBoolean(key, defaultValue);
    }

    public boolean encode(String key, int value) {
        this.editor.putInt(key, value).apply();
        return true;
    }

    public int decodeInt(String key) {
        return this.decodeInt(key, 0);
    }

    public int decodeInt(String key, int defaultValue) {
        return this.cache.getInt(key, defaultValue);
    }

    public boolean encode(String key, long value) {
        this.editor.putLong(key, value).apply();
        return true;
    }

    public boolean commit() {
        return this.editor.commit();
    }

    public long decodeLong(String key) {
        return this.decodeLong(key, 0L);
    }

    public long decodeLong(String key, long defaultValue) {
        return this.cache.getLong(key, defaultValue);
    }

    public boolean encode(String key, float value) {
        this.editor.putFloat(key, value).apply();
        return true;
    }

    public float decodeFloat(String key) {
        return this.decodeFloat(key, 0.0f);
    }

    public float decodeFloat(String key, float defaultValue) {
        return this.cache.getFloat(key, defaultValue);
    }

    public boolean encode(String key, double value) {
        this.editor.putLong(key, (long)value).apply();
        return true;
    }

    public double decodeDouble(String key) {
        return this.decodeDouble(key, 0.0);
    }

    public double decodeDouble(String key, double defaultValue) {
        return this.cache.getLong(key, (long)defaultValue);
    }

    public boolean encode(String key, String value) {
        this.editor.putString(key, value).apply();
        return true;
    }

    public String decodeString(String key) {
        return this.decodeString(key, null);
    }

    public String decodeString(String key, String defaultValue) {
        return this.cache.getString(key, defaultValue);
    }

    public boolean encode(String key, Set<String> value) {
        this.editor.putStringSet(key, value);
        return true;
    }

    public Set<String> decodeStringSet(String key) {
        return this.decodeStringSet(key, null);
    }

    public Set<String> decodeStringSet(String key, Set<String> defaultValue) {
        return this.decodeStringSet(key, defaultValue, HashSet.class);
    }

    private Set<String> decodeStringSet(String key, Set<String> defaultValue, Class<? extends Set> cls) {
        return this.cache.getStringSet(key, defaultValue);
    }

    public boolean encode(String key, byte[] value) {
        String str = NumberUtil.toHex(value);
        this.editor.putString(key, str).apply();
        return true;
    }

    public byte[] decodeBytes(String key) {
        return this.decodeBytes(key, null);
    }

    public byte[] decodeBytes(String key, byte[] defaultValue) {
        String hex = this.cache.getString(key, null);
        if (hex == null) {
            return defaultValue;
        }
        try {
            return NumberUtil.toBytes(hex);
        }
        catch (Throwable e) {
            return defaultValue;
        }
    }
}

