/*
 * Decompiled with CFR 0.152.
 */
package com.yy.hiidostatis.message.sender;

import com.yy.hiidostatis.api.HiidoSDK;
import com.yy.hiidostatis.inner.util.log.L;
import com.yy.hiidostatis.message.HostManager;
import com.yy.hiidostatis.message.bean.Message;
import java.io.IOException;
import java.net.InetAddress;
import java.net.UnknownHostException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicLong;
import okhttp3.Call;
import okhttp3.Dns;

public class HostInfo
implements HostManager {
    private static final int CHANGE_DNS_MIN_ERR_COUNT = 5000;
    private static final long CHANGE_DNS_MIN_INTERVAL = 5000L;
    private static final String TEST_HOST = "datatest.hiido.com";
    private volatile List<InetAddress> ips;
    private volatile boolean useIp = false;
    private AtomicInteger errorCount = new AtomicInteger(0);
    private volatile String testServer = "datatest.hiido.com";
    private AtomicLong preChangeTime = new AtomicLong();

    public HostInfo() {
        this.ips = this.trans(HiidoSDK.getHiidoIps());
    }

    private List<InetAddress> trans(String[] backup) {
        ArrayList<InetAddress> ret = new ArrayList<InetAddress>(backup.length);
        for (String one : backup) {
            try {
                ret.add(InetAddress.getByName(one));
            }
            catch (UnknownHostException e) {
                e.printStackTrace();
            }
        }
        Collections.shuffle(ret);
        return ret;
    }

    private boolean isDebug() {
        return HiidoSDK.isDebugMode;
    }

    @Override
    public String getHost(Message msg) {
        return this.isDebug() ? this.testServer : HiidoSDK.getHiidoHost();
    }

    @Override
    public List<InetAddress> lookup(String hostname) throws UnknownHostException {
        if (this.useIp && !this.isDebug()) {
            L.info(this, "Host:%s", this.ips.get(0));
            return this.ips;
        }
        L.info(this, "Host:%s", hostname);
        return Dns.SYSTEM.lookup(hostname);
    }

    @Override
    public synchronized void onFailure(Call call, IOException exception) {
        if (this.errorCount.incrementAndGet() > 5000 && System.currentTimeMillis() - this.preChangeTime.get() > 5000L) {
            if (this.useIp) {
                if (this.ips.size() == 1) {
                    this.useIp = false;
                    this.ips = this.trans(HiidoSDK.getHiidoIps());
                } else {
                    this.ips.remove(0);
                }
            } else {
                this.useIp = true;
            }
        }
    }

    @Override
    public void onSuccess(Call call) {
        int a = this.errorCount.decrementAndGet();
        if (a < 0) {
            this.errorCount.set(0);
        }
    }
}

