/*
 * Decompiled with CFR 0.152.
 */
package com.yy.hiidostatis.message.module.sessionreport;

import com.yy.hiidostatis.message.module.sessionreport.CalAction;
import com.yy.hiidostatis.message.module.sessionreport.CalValue;

public final class DefaultCalAction {
    public static final CalAction SUM = new CalAction(){

        @Override
        public CalValue cal(Number value, CalValue curValue) {
            if (DefaultCalAction.isInt(value) && DefaultCalAction.isInt(curValue.value)) {
                return curValue.updateValue(DefaultCalAction.safeToInt(value) + DefaultCalAction.safeToInt(curValue.value));
            }
            return curValue.updateValue(DefaultCalAction.safeToFloat(value) + DefaultCalAction.safeToFloat(curValue.value));
        }
    };
    public static final CalAction AVERAGE = new CalAction(){

        @Override
        public CalValue cal(Number value, CalValue curValue) {
            Double v = (DefaultCalAction.safeToFloat(value) + DefaultCalAction.safeToFloat(curValue.value)) / (double)(curValue.times.get() + 1);
            return curValue.updateValue(v);
        }
    };
    public static final CalAction MAX = new CalAction(){

        @Override
        public CalValue cal(Number value, CalValue curValue) {
            if (curValue.value == null) {
                return curValue.updateValue(value);
            }
            if (DefaultCalAction.isInt(value) && DefaultCalAction.isInt(curValue.value)) {
                return curValue.updateValue(Math.max(DefaultCalAction.safeToInt(value), DefaultCalAction.safeToInt(curValue.value)));
            }
            return curValue.updateValue(Math.max(DefaultCalAction.safeToFloat(value), DefaultCalAction.safeToFloat(curValue.value)));
        }
    };
    public static final CalAction MIN = new CalAction(){

        @Override
        public CalValue cal(Number value, CalValue curValue) {
            if (curValue.value == null) {
                return curValue.updateValue(value);
            }
            if (DefaultCalAction.isInt(value) && DefaultCalAction.isInt(curValue.value)) {
                return curValue.updateValue(Math.min(DefaultCalAction.safeToInt(value), DefaultCalAction.safeToInt(curValue.value)));
            }
            return curValue.updateValue(Math.min(DefaultCalAction.safeToFloat(value), DefaultCalAction.safeToFloat(curValue.value)));
        }
    };
    public static final CalAction TEMP_STORE = new CalAction(){

        @Override
        public CalValue cal(Number value, CalValue curValue) {
            return curValue.updateTempStorage(value);
        }
    };
    public static final CalAction SUM_DEVIATION = new CalAction(){

        @Override
        public CalValue cal(Number value, CalValue curValue) {
            if (DefaultCalAction.isInt(value) && DefaultCalAction.isInt((Number)curValue.tempStorage)) {
                return curValue.updateValue(DefaultCalAction.safeToInt(curValue.value) + DefaultCalAction.safeToInt(value) - DefaultCalAction.safeToInt((Number)curValue.tempStorage));
            }
            return curValue.updateValue((double)DefaultCalAction.safeToInt(curValue.value) + DefaultCalAction.safeToFloat(value) - DefaultCalAction.safeToFloat((Number)curValue.tempStorage));
        }
    };
    public static final CalAction SUM_DEVIATION_AND_UPDATE_TEMP = new CalAction(){

        @Override
        public CalValue cal(Number value, CalValue curValue) {
            if (DefaultCalAction.isInt(value) && DefaultCalAction.isInt((Number)curValue.tempStorage)) {
                return curValue.updateValue(DefaultCalAction.safeToInt(curValue.value) + DefaultCalAction.safeToInt(value) - DefaultCalAction.safeToInt((Number)curValue.tempStorage)).updateTempStorage(value);
            }
            return curValue.updateValue((double)DefaultCalAction.safeToInt(curValue.value) + DefaultCalAction.safeToFloat(value) - DefaultCalAction.safeToFloat((Number)curValue.tempStorage)).updateTempStorage(value);
        }
    };

    private static boolean isInt(Number num) {
        return num == null || num instanceof Long || num instanceof Integer;
    }

    private static long safeToInt(Number num) {
        return num == null ? 0L : num.longValue();
    }

    private static double safeToFloat(Number num) {
        return num == null ? 0.0 : num.doubleValue();
    }
}

