/*
 * Decompiled with CFR 0.152.
 */
package com.yy.hiidostatis.message.hiidoapi;

import android.content.Context;
import android.net.wifi.WifiInfo;
import com.yy.hiidostatis.api.StatisContent;
import com.yy.hiidostatis.defs.StatisAPI;
import com.yy.hiidostatis.defs.controller.OaidController;
import com.yy.hiidostatis.defs.obj.Act;
import com.yy.hiidostatis.inner.GeneralProxy;
import com.yy.hiidostatis.inner.implementation.CommonFiller;
import com.yy.hiidostatis.inner.util.ArdUtil;
import com.yy.hiidostatis.inner.util.ThreadPool;
import com.yy.hiidostatis.inner.util.cipher.Coder;
import com.yy.hiidostatis.inner.util.hdid.DeviceProxy;
import com.yy.hiidostatis.inner.util.hdid.GAIDClient;
import com.yy.hiidostatis.inner.util.log.L;
import com.yy.hiidostatis.message.MessageMonitor;
import com.yy.hiidostatis.message.MessageStore;
import com.yy.hiidostatis.message.Packer;
import com.yy.hiidostatis.message.Task;
import com.yy.hiidostatis.message.log.TraceLog;
import com.yy.hiidostatis.pref.HdStatisConfig;
import com.yy.hiidostatis.provider.GlobalProvider;
import com.yy.hiidostatis.provider.MessageConfig;
import com.yy.hiidostatis.provider.MessageConfigFactory;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentLinkedQueue;
import java.util.concurrent.atomic.AtomicInteger;

public class MessagePacker
implements Packer {
    private static final String KEY_MAGIC = "HiidoData";
    private static final int MESSAGE_CACHE_SIZE = 3000;
    private volatile boolean isInited;
    private volatile boolean initedFailed = false;
    private volatile boolean isRunning;
    private MessageConfig config;
    private MessageStore store;
    private ConcurrentLinkedQueue<StatisContent> cache = new ConcurrentLinkedQueue();
    private ConcurrentHashMap<Integer, Packer.OnSavedListener> listens = new ConcurrentHashMap();
    private Task sender;
    private AtomicInteger saveCount = new AtomicInteger();
    private MessageMonitor monitor;

    public MessagePacker(MessageConfig config, MessageMonitor monitor) {
        this.config = config;
        this.monitor = monitor;
    }

    @Override
    public void onInited(boolean suc) {
        if (suc) {
            this.store = (MessageStore)GlobalProvider.instance.get(MessageStore.class, this.config);
            this.sender = (Task)GlobalProvider.instance.get("SEND_MODULE_TASK", this.config);
            this.isInited = true;
            this.initedFailed = false;
        } else {
            this.initedFailed = true;
        }
    }

    @Override
    public boolean addMessage(StatisContent msg, Packer.OnSavedListener listener) {
        TraceLog.addMessageLog(this.config.getAppkey(), msg);
        if (this.initedFailed) {
            TraceLog.dropMessageLog(msg.getAct(), msg.getGuid());
            return false;
        }
        if (this.cache.size() > 3000) {
            L.error(this, "cache out size", new Object[0]);
            TraceLog.dropMessageLog(msg.getAct(), msg.getGuid());
            return false;
        }
        StatisContent sc = msg.copy();
        sc.setAutoId(this.monitor.getAutoId(sc.getAct()));
        if (listener != null) {
            this.listens.put(sc.getTmpId(), listener);
        }
        this.cache.add(sc);
        this.execute();
        return true;
    }

    @Override
    public boolean addMessage(StatisContent msg) {
        return this.addMessage(msg, null);
    }

    public void execute() {
        if (this.isRunning || !this.isInited) {
            return;
        }
        this.isRunning = true;
        ThreadPool.getPool().execute(new Runnable(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void run() {
                try {
                    MessagePacker.this.monitor.commit();
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
                try {
                    ArrayList<StatisContent> one = new ArrayList<StatisContent>(MessagePacker.this.cache.size() + 10);
                    ArrayList<StatisContent> notSave = new ArrayList<StatisContent>();
                    ArrayList ls = null;
                    boolean sendNow = false;
                    StringBuilder onSaveIds = new StringBuilder();
                    StringBuilder saveIds = new StringBuilder();
                    while (!MessagePacker.this.cache.isEmpty()) {
                        StatisContent content = (StatisContent)MessagePacker.this.cache.poll();
                        if (MessagePacker.this.listens.containsKey(content.getTmpId())) {
                            if (ls == null) {
                                ls = new ArrayList();
                            }
                            ls.add(MessagePacker.this.listens.remove(content.getTmpId()));
                        }
                        if (content.getPriority() == StatisContent.Priority.PRIORITY_HIGH) {
                            sendNow = true;
                        }
                        MessagePacker.this.packContent(content);
                        if (content.isNotSave()) {
                            notSave.add(content);
                            onSaveIds.append(content.getGuid());
                            onSaveIds.append(",");
                            continue;
                        }
                        one.add(content);
                        saveIds.append(content.getGuid());
                        saveIds.append(",");
                    }
                    int cc = 0;
                    if (!one.isEmpty()) {
                        cc = MessagePacker.this.store.save(one);
                        TraceLog.saveMessageLog(saveIds.toString());
                    }
                    if (!notSave.isEmpty()) {
                        cc = MessagePacker.this.store.notSave(notSave);
                        TraceLog.saveMessageLog(onSaveIds.toString());
                    }
                    MessagePacker.this.notifyListeners(ls);
                    int count = MessagePacker.this.saveCount.addAndGet(one.size());
                    L.info(this, "save count:" + count, new Object[0]);
                    if (sendNow || cc >= MessagePacker.this.config.getBatchThreshold() || MessageConfigFactory.getMainConfig() != null && MessageConfigFactory.getMainConfig().getInterval() == 0) {
                        MessagePacker.this.sender.execute();
                    }
                }
                catch (Throwable e) {
                    e.printStackTrace();
                }
                finally {
                    MessagePacker.this.isRunning = false;
                }
            }
        });
    }

    private void notifyListeners(final List<Packer.OnSavedListener> ls) {
        if (ls == null) {
            return;
        }
        ThreadPool.getPool().execute(new Runnable(){

            @Override
            public void run() {
                for (Packer.OnSavedListener l : ls) {
                    l.onSaved(true);
                }
                ls.clear();
            }
        });
    }

    private void packContent(StatisContent content) {
        this.packForSpecialAct(content);
        if (content.isFillCommon() || content.isFillConcrete()) {
            if (content.isFillCommon()) {
                CommonFiller.fillCommonNew(this.config.getApplicationContext(), content, content.getAct(), "4.0.3");
            }
            if (content.isFillConcrete()) {
                CommonFiller.fillConcreteInfoNew(this.config.getApplicationContext(), content);
            }
        }
        if (this.config.getUidProvider() != null) {
            content.put("uid", this.config.getUidProvider().getCurrentUid());
        }
        content.put("act", content.getAct());
        content.put("app", this.config.getAppId());
        content.put("appkey", this.config.getAppkey());
        content.put("from", this.config.getFrom());
        content.put("ver", this.config.getVer());
        content.put("sessionid", this.config.getSessionId());
        content.put("hd_autoid", content.getAutoId());
        content.put("hd_crepid", this.monitor.getProcessId());
        if (this.config.getAppsflyer() != null) {
            content.put("mdsr", this.config.getAppsflyer());
        }
        content.put("timezone", ArdUtil.getTimeZone());
        content.put("oaid", OaidController.INSTANCE.oaid());
        if (this.config.isGaidEnable()) {
            content.put("gaid", GAIDClient.getGAID(this.config.getApplicationContext()));
        }
    }

    private void packForSpecialAct(StatisContent content) {
        try {
            String act = content.getAct();
            Context context = this.config.getApplicationContext();
            if (act.equals(Act.MBSDK_INSTALL.toString())) {
                content.put("htype", DeviceProxy.getType(context));
                content.put("hfrom", DeviceProxy.getHFrom(context));
                content.put("htime", DeviceProxy.getCreateTime(context));
                content.put("sdpm", DeviceProxy.getSdPermission(context));
            } else if (act.equals(Act.MBSDK_RUN.toString())) {
                content.put("root", ArdUtil.isRoot() ? 1 : 0);
                WifiInfo wi = ArdUtil.getWifiInfo(context);
                if (wi != null) {
                    content.put("bssid", wi.getBSSID());
                    content.put("ssid", wi.getSSID());
                    content.put("rssi", wi.getRssi());
                }
            } else if (act.equals(Act.MBSDK_DO.toString())) {
                content.put("htype", DeviceProxy.getType(context));
                content.put("hfrom", DeviceProxy.getHFrom(context));
                content.put("htime", DeviceProxy.getCreateTime(context));
                content.put("sdpm", DeviceProxy.getSdPermission(context));
                try {
                    content.put("srvtm", GeneralProxy.getGeneralConfigInstance(context, HdStatisConfig.getConfig(this.config.getAppkey())).getSrvTime());
                }
                catch (Throwable e) {
                    L.error(this, "get srvtm error,%s", e);
                }
            } else if (act.equals(Act.MBSDK_EVENT.toString())) {
                try {
                    content.put("srvtm", GeneralProxy.getGeneralConfigInstance(context, HdStatisConfig.getConfig(this.config.getAppkey())).getSrvTime());
                }
                catch (Throwable e) {
                    L.error(this, "get srvtm error,%s", e);
                }
            } else if (act.equals(Act.MBSDK_APPLIST.toString())) {
                String applist = content.get("applist");
                if (applist == null || applist.isEmpty()) {
                    return;
                }
                try {
                    String desKey = content.get("act") + content.get("time") + KEY_MAGIC;
                    desKey = Coder.encryptMD5(desKey);
                    desKey = desKey.toLowerCase().substring(0, 8);
                    L.verbose(StatisAPI.class, "des key is %s", desKey);
                    String applistEncrypt = Coder.encryptDES(applist, desKey);
                    content.put("applist", applistEncrypt);
                }
                catch (Throwable e) {
                    content.put("applist", "");
                }
            }
        }
        catch (Throwable e) {
            e.printStackTrace();
        }
    }
}

