/*
 * Decompiled with CFR 0.152.
 */
package com.yy.hiidostatis.inner.util.log;

import android.app.Application;
import android.content.Context;
import android.os.Process;
import android.text.TextUtils;
import com.yy.hiidostatis.api.HiidoSDK;
import com.yy.hiidostatis.inner.util.ArdUtil;
import com.yy.hiidostatis.inner.util.DefaultPreference;
import com.yy.hiidostatis.inner.util.ThreadPool;
import com.yy.hiidostatis.inner.util.Util;
import com.yy.hiidostatis.inner.util.ZipUtil;
import com.yy.hiidostatis.inner.util.http.HttpUtil;
import com.yy.hiidostatis.inner.util.log.L;
import com.yy.hiidostatis.testui.FloatingService;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileFilter;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.io.InputStreamReader;
import java.net.InetAddress;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.Date;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentLinkedQueue;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicLong;
import org.json.JSONObject;

public class ActLog {
    public static final String TYPE_ADD = "Add";
    public static final String TYPE_SAVE = "Save";
    public static final String TYPE_DISCARD = "Dis";
    public static final String TYPE_SUC = "Suc";
    public static final String TYPE_FAIL = "Fail";
    public static final String TYPE_RETRY = "Retry";
    private static volatile String innerPath;
    private static volatile String outerPath;
    private static volatile boolean innerPathValid;
    private static volatile boolean outerPathValid;
    private static Context mContext;
    private static String mLogNamePre;
    private static final String SEND_SUC_LOG_SUFFIX = "-slog";
    private static final String SEND_FAIL_LOG_SUFFIX = "-flog";
    private static final int LENGTH_APPKEY = 8;
    private static volatile ActLogListener mActLogListener;
    private static volatile AtomicLong countLength;
    private static volatile boolean initActLog;
    private static volatile boolean logEnable;
    private static ConcurrentHashMap<String, LogWriter> logWriters;
    private static AtomicBoolean isDelete;
    private static volatile boolean isWriteSucLog;
    private static volatile boolean isWriteFailLog;
    private static volatile String mUploadUrl;

    public static boolean isLogEnable() {
        return logEnable;
    }

    public static void setLogEnable(boolean b) {
        logEnable = b;
    }

    private static Context getCtx(Context ctx) {
        return ctx == null ? mContext : ctx;
    }

    private static void addLogLength(long len) {
        long count = countLength.addAndGet(len);
        if (count > 0x3200000L) {
            long delLen = ActLog.delLog(count - 0xA00000L);
            countLength.getAndAdd(-1L * delLen);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static boolean initActLog(Context ctx) {
        if (initActLog) {
            return initActLog;
        }
        AtomicLong atomicLong = countLength;
        synchronized (atomicLong) {
            if (initActLog) {
                return initActLog;
            }
            if (ctx == null) {
                return false;
            }
            mContext = (Application)(ctx instanceof Application ? ctx : ctx.getApplicationContext());
            try {
                File[] listFiles;
                innerPath = String.format("%s/%s", ctx.getCacheDir().getAbsolutePath(), mLogNamePre);
                if (ArdUtil.checkPermissions(ctx, "android.permission.WRITE_EXTERNAL_STORAGE") && ctx.getExternalCacheDir() != null) {
                    outerPath = String.format("%s/%s", ctx.getExternalCacheDir().getAbsolutePath(), mLogNamePre);
                    outerPathValid = true;
                }
                long count = 0L;
                File file = new File(innerPath);
                if (file.exists()) {
                    innerPathValid = true;
                    for (File f : listFiles = file.listFiles()) {
                        count += f.length();
                    }
                } else if (!outerPathValid) {
                    innerPathValid = true;
                }
                if (outerPathValid) {
                    file = new File(outerPath);
                    if (file.exists()) {
                        for (File f : listFiles = file.listFiles()) {
                            count += f.length();
                        }
                    }
                } else {
                    innerPathValid = true;
                }
                countLength.set(count);
                initActLog = true;
            }
            catch (Throwable e) {
                L.error("ActLog", e.getMessage(), new Object[0]);
            }
            return initActLog;
        }
    }

    private static long delLog(long delLength, String path) {
        File file = new File(path);
        File[] listFiles = file.listFiles();
        ArrayList<File> list = new ArrayList<File>(listFiles.length);
        long count = 0L;
        for (int i = 0; i < listFiles.length; ++i) {
            File f = listFiles[i];
            list.add(f);
        }
        Collections.sort(list, new Comparator<File>(){

            @Override
            public int compare(File o1, File o2) {
                return o1.lastModified() <= o2.lastModified() ? -1 : 1;
            }
        });
        for (File f : list) {
            long len = f.length();
            boolean b = f.delete();
            if (b) {
                count += len;
            }
            if (count < delLength) continue;
            break;
        }
        return count;
    }

    private static long delLog(long delLength) {
        long count = 0L;
        try {
            if (innerPathValid) {
                count = ActLog.delLog(delLength, innerPath);
            }
            if (outerPathValid && count < delLength) {
                count += ActLog.delLog(delLength - count, outerPath);
            }
        }
        catch (Throwable e) {
            L.warn(ActLog.class, "delLogFile exception = %s", e);
        }
        return count;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static LogWriter getLogWriter(String suffix) {
        LogWriter lw = logWriters.get(suffix = suffix == null ? "" : suffix);
        if (lw != null) {
            return lw;
        }
        ConcurrentHashMap<String, LogWriter> concurrentHashMap = logWriters;
        synchronized (concurrentHashMap) {
            lw = logWriters.get(suffix);
            if (lw != null) {
                return lw;
            }
            String fileNameTemplate = null;
            fileNameTemplate = outerPathValid ? String.format("%s%s%s_#yyyyMMdd##pid#.log%s", outerPath, File.separator, mLogNamePre, suffix) : String.format("%s%s%s_#yyyyMMdd##pid#.log%s", innerPath, File.separator, mLogNamePre, suffix);
            lw = new LogWriter(fileNameTemplate);
            logWriters.put(suffix, lw);
            return lw;
        }
    }

    private static void write(String logSuffix, String format, Object ... args) {
        try {
            String log = Util.formatStr(format, args);
            ActLog.addLogLength(log.length());
            LogWriter lw = ActLog.getLogWriter(logSuffix);
            lw.writeLine(log);
        }
        catch (Throwable e) {
            L.error(ActLog.class, "write Exception = %s", e);
        }
    }

    public static void setActLogListener(ActLogListener actLogListener) {
        mActLogListener = actLogListener;
    }

    @Deprecated
    public static void setLogNamePre(String logNamePre) {
    }

    private static String getAppkey(String appkey) {
        return appkey.length() > 8 ? appkey.substring(0, 8) : appkey;
    }

    public static void writeActLog(Context ctx, final String type, final String act, final String appkey, final String guid, final String smkdata, final String host, final String extra) {
        if (!logEnable) {
            return;
        }
        if (!ActLog.initActLog(ctx)) {
            return;
        }
        ThreadPool.getPool().execute(new Runnable(){

            @Override
            public void run() {
                try {
                    long ltime = System.currentTimeMillis();
                    String time = Util.formatDate("yyyyMMddHHmmss", ltime);
                    String hms = Util.formatDate("HH:mm:ss", System.currentTimeMillis());
                    FloatingService.INSTANCT.addLog(hms, appkey, type, guid, act);
                    ActLog.write(null, "%d,%s,%s,%s,%s,%s,%s,%s,%s", new Object[]{ltime, time, guid, appkey, type, act, smkdata == null ? "-" : smkdata, host == null ? "-" : host, extra == null ? "-" : extra});
                }
                catch (Throwable e) {
                    L.error(ActLog.class, "writeActLog Exception = %s", e);
                }
            }
        });
    }

    public static void writeActLog(Context ctx, final String type, final String content, final String smkdata, final String host, final String extra) {
        if (!logEnable) {
            return;
        }
        if (!ActLog.initActLog(ctx)) {
            return;
        }
        ThreadPool.getPool().execute(new Runnable(){

            @Override
            public void run() {
                try {
                    long ltime = System.currentTimeMillis();
                    String time = Util.formatDate("yyyyMMddHHmmss", ltime);
                    Map<String, String> map = Util.parseParams(content);
                    String hms = Util.formatDate("HH:mm:ss", System.currentTimeMillis());
                    String guid = map.get("guid");
                    String act = map.get("act");
                    String appkey = map.get("appkey");
                    map.clear();
                    map = null;
                    appkey = ActLog.getAppkey(appkey);
                    FloatingService.INSTANCT.addLog(hms, appkey, type, guid, act);
                    ActLog.write(null, "%d,%s,%s,%s,%s,%s,%s,%s,%s", new Object[]{ltime, time, guid, appkey, type, act, smkdata == null ? "-" : smkdata, host == null ? "-" : host, extra == null ? "-" : extra});
                }
                catch (Throwable e) {
                    L.error(ActLog.class, "writeActLog Exception = %s", e);
                }
            }
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static int[] getTotal(Context context, String appkey) {
        if (!ActLog.initActLog(context)) {
            return new int[]{0, 0, 0, 0, 0};
        }
        int cur = 0;
        int fait = 0;
        int suc = 0;
        int del = 0;
        int retry = 0;
        BufferedReader br = null;
        InputStreamReader fr = null;
        try {
            File[] files;
            File dir;
            ArrayList fs = new ArrayList();
            if (innerPathValid) {
                dir = new File(innerPath);
                files = dir.listFiles(new FileFilter(){
                    private String pre = String.format("%s_%s", ActLog.access$400(), Util.formatDate("yyyyMMdd", System.currentTimeMillis()));

                    @Override
                    public boolean accept(File pathname) {
                        return pathname.isFile() && pathname.getName().endsWith(".log") && pathname.getName().startsWith(this.pre);
                    }
                });
                Collections.addAll(fs, files);
            }
            if (outerPathValid) {
                dir = new File(outerPath);
                files = dir.listFiles(new FileFilter(){
                    private String pre = String.format("%s_%s", ActLog.access$400(), Util.formatDate("yyyyMMdd", System.currentTimeMillis()));

                    @Override
                    public boolean accept(File pathname) {
                        return pathname.isFile() && pathname.getName().endsWith(".log") && pathname.getName().startsWith(this.pre);
                    }
                });
                Collections.addAll(fs, files);
            }
            for (File f : fs) {
                try {
                    fr = new FileReader(f);
                    br = new BufferedReader(fr);
                    String line = null;
                    String type = null;
                    String[] arg = null;
                    while ((line = br.readLine()) != null) {
                        if (appkey != null && ((arg = line.split(",")).length < 4 || !appkey.startsWith(arg[arg.length > 8 ? 3 : 2]))) continue;
                        type = arg[arg.length > 8 ? 4 : 3];
                        if (TYPE_ADD.equals(type)) {
                            ++cur;
                            continue;
                        }
                        if (TYPE_FAIL.equals(type)) {
                            ++fait;
                            continue;
                        }
                        if (TYPE_SUC.equals(type)) {
                            ++suc;
                            continue;
                        }
                        if (TYPE_DISCARD.equals(type)) {
                            ++del;
                            continue;
                        }
                        if (!TYPE_RETRY.equals(type)) continue;
                        ++retry;
                    }
                    if (fr != null) {
                        fr.close();
                        fr = null;
                    }
                    if (br == null) continue;
                    br.close();
                    br = null;
                }
                catch (Throwable e) {
                    L.error("ActLog", e.getMessage(), new Object[0]);
                }
            }
        }
        catch (Throwable e) {
            L.error(ActLog.class, "getTotal Exception = %s", e);
        }
        finally {
            try {
                if (fr != null) {
                    fr.close();
                    fr = null;
                }
                if (br != null) {
                    br.close();
                    br = null;
                }
            }
            catch (Throwable e) {
                L.error("ActLog", e.getMessage(), new Object[0]);
            }
        }
        return new int[]{cur, fait, suc, del, retry};
    }

    private static void delLogFile(final String path, final int dayAgo) {
        if (!isDelete.compareAndSet(false, true)) {
            return;
        }
        Runnable r = new Runnable(){

            @Override
            public void run() {
                try {
                    File file = new File(path);
                    File[] listFiles = file.listFiles();
                    if (listFiles != null) {
                        int fileCount = listFiles.length;
                        int delCount = 0;
                        String tmpFileName = null;
                        for (int i = 0; i < listFiles.length; ++i) {
                            File f = listFiles[i];
                            tmpFileName = f.getName();
                            if (!ActLog.matchFileName(tmpFileName, dayAgo)) continue;
                            boolean b = f.delete();
                            if (b) {
                                ++delCount;
                            }
                            L.debug(ActLog.class, "delLogFile [%s] = %b ", tmpFileName, b);
                        }
                        if (delCount == fileCount) {
                            file.delete();
                        }
                    }
                }
                catch (Throwable e) {
                    L.warn(ActLog.class, "delLogFile exception = %s", e);
                }
            }
        };
        ThreadPool.getPool().execute(r);
    }

    private static boolean matchFileName(String fileName, int dayAgo) {
        try {
            String fileDateStr = fileName.substring(fileName.lastIndexOf("_") + 1, fileName.lastIndexOf("."));
            Date fileDate = Util.parseDate("yyyyMMdd", fileDateStr.substring(0, 8));
            return Util.daysBetween(fileDate.getTime(), System.currentTimeMillis()) > dayAgo;
        }
        catch (Throwable e) {
            L.warn(ActLog.class, "matchFileName excetion = %s", e);
            return false;
        }
    }

    public static void writeSendSucLog(Context ctx, final String smkdata, final String host, final String content) {
        if (!logEnable) {
            return;
        }
        if (!L.isLogOn() && !isWriteSucLog) {
            return;
        }
        if (!ActLog.initActLog(ctx)) {
            return;
        }
        ThreadPool.getPool().execute(new Runnable(){

            @Override
            public void run() {
                try {
                    String time = Util.formatDate("yyyyMMddHHmmss", System.currentTimeMillis());
                    Map<String, String> map = Util.parseParams(content);
                    String guid = map.get("guid");
                    String act = map.get("act");
                    String appkey = map.get("appkey");
                    map.clear();
                    map = null;
                    appkey = ActLog.getAppkey(appkey);
                    ActLog.write(ActLog.SEND_SUC_LOG_SUFFIX, "%s,%s,%s,%s,%s,%s", new Object[]{time, guid, appkey, act, smkdata == null ? "-" : smkdata, host == null ? "-" : host});
                }
                catch (Throwable e) {
                    L.error(ActLog.class, "writeSendSucLog Exception = %s", e);
                }
            }
        });
    }

    public static void writeSendFailLog(Context ctx, final String smkdata, final String host, final String content, final String error, final String errorCode, final Integer retry) {
        if (!logEnable) {
            return;
        }
        if (!L.isLogOn() && !isWriteFailLog) {
            return;
        }
        if (!ActLog.initActLog(ctx)) {
            return;
        }
        ThreadPool.getPool().execute(new Runnable(){

            @Override
            public void run() {
                try {
                    String tmpHost = host;
                    if (tmpHost != null) {
                        try {
                            tmpHost = tmpHost + "\n" + InetAddress.getByName(host).getHostAddress();
                            tmpHost = tmpHost + "\n" + TextUtils.join((CharSequence)" ", (Object[])InetAddress.getAllByName(host));
                        }
                        catch (Throwable e) {
                            L.error(this, e.getMessage(), new Object[0]);
                        }
                    }
                    String time = Util.formatDate("yyyyMMddHHmmss", System.currentTimeMillis());
                    Map<String, String> map = Util.parseParams(content);
                    String guid = map.get("guid");
                    String act = map.get("act");
                    String appkey = map.get("appkey");
                    map.clear();
                    String subAppkey = ActLog.getAppkey(appkey);
                    ActLog.write(ActLog.SEND_FAIL_LOG_SUFFIX, "%s,%s,%s,%s,%s,%s,%s,%s,%s", new Object[]{time, guid, subAppkey, act, smkdata == null ? "-" : smkdata, host == null ? "-" : host, retry == null ? "-" : retry, errorCode, error + tmpHost});
                    if (mActLogListener != null) {
                        mActLogListener.sendFail(appkey, guid, smkdata, act, retry, host, errorCode, error);
                    }
                }
                catch (Throwable e) {
                    L.error(ActLog.class, "writeSendFailLog Exception = %s", e);
                }
            }
        });
    }

    private static boolean upload() {
        boolean inner = true;
        boolean outer = true;
        if (innerPathValid) {
            inner = ActLog.upload(innerPath);
        }
        if (outerPathValid) {
            outer = ActLog.upload(outerPath);
        }
        return inner && outer;
    }

    private static boolean upload(String path) {
        try {
            L.brief("upload begin,waiting...", new Object[0]);
            File parentPath = new File(path);
            if (!parentPath.exists() || parentPath.listFiles() == null || parentPath.listFiles().length == 0) {
                L.brief("no upload file, end", new Object[0]);
                return true;
            }
            String logFileZip = mLogNamePre + "_" + ArdUtil.getPackageName(mContext) + "_" + HiidoSDK.instance().getHdid(mContext) + "_" + Util.formatDate("yyyyMMddHHmmssSSS", System.currentTimeMillis()) + ".zip";
            String logFileZipPath = parentPath.getParent() + File.separator + logFileZip;
            ZipUtil.zipFolder(path, logFileZipPath);
            L.debug(ActLog.class, "create zip=%s", logFileZipPath);
            boolean isUpload = false;
            isUpload = ActLog.uploadFile(logFileZipPath, logFileZip);
            L.debug(ActLog.class, "upload zip=%s isUpload=%b", logFileZipPath, isUpload);
            File f = new File(logFileZipPath);
            L.debug(ActLog.class, "zip=%s length =%s ", logFileZipPath, f.length());
            boolean dsu = f.delete();
            L.debug(ActLog.class, "delete zip=%s, delete =%b", logFileZipPath, dsu);
            L.brief(isUpload ? "upload file success!" : "upload file fail!", new Object[0]);
            if (isUpload) {
                isDelete.set(false);
                ActLog.delLogFile(path, 1);
            }
            return isUpload;
        }
        catch (Throwable e) {
            L.error(ActLog.class, "upload error = %s", e);
            L.brief("upload file fail!", new Object[0]);
            return false;
        }
    }

    private static boolean uploadFile(String uploadFile, String fileName) {
        try {
            HashMap<String, String> fileMap = new HashMap<String, String>();
            fileMap.put("file", uploadFile);
            HttpUtil.HttpResp resp = HttpUtil.postFileByUrlConn(mUploadUrl, null, fileMap);
            return resp.isSucceed;
        }
        catch (Throwable e) {
            L.error(ActLog.class, "uploadFile error.%s", e);
            return false;
        }
    }

    public static void setUploadUrl(String uploadUrl) {
        mUploadUrl = uploadUrl;
    }

    public static void uploadLog(Context ctx, final ILogConfigListener logConfigListener) {
        if (!ActLog.initActLog(ctx)) {
            return;
        }
        Runnable r = new Runnable(){

            @Override
            public void run() {
                try {
                    String prefKey = mLogNamePre + "_uploadDate";
                    String uploadDate = Util.formatDate("yyyyMMdd", System.currentTimeMillis());
                    String cacheUploadDate = DefaultPreference.getPreference().getPrefString(mContext, prefKey, null);
                    boolean isReport = uploadDate.equals(cacheUploadDate);
                    L.debug(ActLog.class, "uploadDate = %s,isReport = %b", uploadDate, isReport);
                    if (isReport) {
                        return;
                    }
                    JSONObject json = logConfigListener.getLogConfig();
                    if (json == null || !json.has("sdkConfig")) {
                        L.debug(ActLog.class, "sdkConfig is null", new Object[0]);
                        return;
                    }
                    JSONObject sdkConfigJson = json.getJSONObject("sdkConfig");
                    if (sdkConfigJson.has("uploadUrl")) {
                        mUploadUrl = sdkConfigJson.getString("uploadUrl");
                    }
                    isWriteSucLog = sdkConfigJson.has("suc") ? "1".equals(sdkConfigJson.get("suc")) : isWriteSucLog;
                    L.debug(ActLog.class, "isWriteSucLog = %b ", isWriteSucLog);
                    isWriteFailLog = sdkConfigJson.has("fai") ? "1".equals(sdkConfigJson.get("fai")) : isWriteFailLog;
                    L.debug(ActLog.class, "isWriteFailLog = %b ", isWriteFailLog);
                    if (ArdUtil.isWifiActive(mContext) && ActLog.upload()) {
                        DefaultPreference.getPreference().setPrefString(mContext, prefKey, uploadDate);
                    }
                }
                catch (Throwable e) {
                    L.error(ActLog.class, "uploadLog exception = %s", e);
                }
            }
        };
        ThreadPool.getPool().execute(r);
    }

    static {
        mLogNamePre = "hdstatis";
        mActLogListener = null;
        countLength = new AtomicLong(0L);
        initActLog = false;
        logEnable = true;
        logWriters = new ConcurrentHashMap(3);
        isDelete = new AtomicBoolean(false);
        isWriteSucLog = false;
        isWriteFailLog = false;
        mUploadUrl = "https://config.hiido.com/api/upload";
    }

    private static class LogWriter {
        private static final int BUFFER_MAX_LEN = 50;
        private String pid = String.valueOf(Process.myPid());
        private FileWriter logWriter;
        private String dateString;
        private ConcurrentLinkedQueue<String> logBuffer = new ConcurrentLinkedQueue();
        private volatile AtomicBoolean writing = new AtomicBoolean(false);
        private String fileNameTemplate;
        private volatile AtomicInteger bufferCount = new AtomicInteger(0);

        private LogWriter(String fileNameTemplate) {
            this.fileNameTemplate = fileNameTemplate;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private FileWriter getFileWriter() {
            String date = Util.formatDate("yyyyMMdd", System.currentTimeMillis());
            if (this.logWriter != null && date.equals(this.dateString)) {
                return this.logWriter;
            }
            LogWriter logWriter = this;
            synchronized (logWriter) {
                if (this.logWriter != null && date.equals(this.dateString)) {
                    return this.logWriter;
                }
                if (this.logWriter != null) {
                    try {
                        this.logWriter.close();
                    }
                    catch (IOException e) {
                        e.printStackTrace();
                    }
                }
                this.dateString = date;
                String fileName = this.fileNameTemplate.replaceAll("#yyyyMMdd#", this.dateString).replaceAll("#pid#", "");
                File file = new File(fileName);
                if (file.exists() && !file.canWrite()) {
                    fileName = this.fileNameTemplate.replaceAll("#yyyyMMdd#", this.dateString).replaceAll("#pid#", this.pid);
                    file = new File(fileName);
                }
                if (!file.getParentFile().exists()) {
                    file.getParentFile().mkdirs();
                }
                try {
                    this.logWriter = new FileWriter(file, true);
                    return this.logWriter;
                }
                catch (IOException e) {
                    e.printStackTrace();
                    return null;
                }
            }
        }

        private void writeLine(String log) {
            int c = this.bufferCount.get();
            if (c > 50) {
                return;
            }
            this.bufferCount.incrementAndGet();
            this.logBuffer.add(log);
            if (!this.writing.compareAndSet(false, true)) {
                return;
            }
            String str = this.logBuffer.poll();
            FileWriter writer = this.getFileWriter();
            while (str != null && writer != null) {
                this.bufferCount.decrementAndGet();
                try {
                    writer.write(str);
                    writer.write("\n");
                    writer.flush();
                    str = this.logBuffer.poll();
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
            }
            this.writing.set(false);
        }

        public synchronized void close() {
            if (this.logWriter != null) {
                try {
                    this.logWriter.close();
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
                this.logWriter = null;
            }
        }
    }

    public static interface ILogConfigListener {
        public JSONObject getLogConfig();
    }

    public static interface ActLogListener {
        public void sendFail(String var1, String var2, String var3, String var4, Integer var5, String var6, String var7, String var8);
    }
}

