/*
 * Decompiled with CFR 0.152.
 */
package com.yy.hiidostatis.inner.implementation;

import android.content.Context;
import com.yy.hiidostatis.inner.AbstractConfig;
import com.yy.hiidostatis.inner.implementation.TaskData;
import com.yy.hiidostatis.inner.implementation.TaskDataSet;
import com.yy.hiidostatis.inner.implementation.TaskDataSqLiteDBManager;
import com.yy.hiidostatis.inner.util.ProcessUtil;
import com.yy.hiidostatis.inner.util.Util;
import com.yy.hiidostatis.inner.util.log.ActLog;
import com.yy.hiidostatis.inner.util.log.L;
import com.yy.hiidostatis.message.MessageMonitor;
import com.yy.hiidostatis.message.log.TraceLog;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.locks.ReentrantLock;

public class TaskDataSqLiteCacheManager {
    private static final int MAX_RETRY_TIMES = AbstractConfig.MAX_DATA_RETRY_TIME;
    private static final int MAX_CACHE_DAY = AbstractConfig.MAX_DATA_CACHE_DAY;
    private static final int MAX_CACHE_SIZE = 100;
    private TaskDataSet memoryCacheDataSet = new TaskDataSet();
    private ReentrantLock lock = new ReentrantLock();
    private String mCacheFileName;
    private Context mCtx;
    private TaskDataSqLiteDBManager mDbManager;
    private int mLastFileSize = -1;
    private boolean isFirstSyncFromFile = true;
    private List<String> sendingData = new ArrayList<String>();
    private ConcurrentHashMap<String, AtomicInteger> actRemain;
    private MessageMonitor monitor;

    public TaskDataSqLiteCacheManager(Context ctx, String fileName) {
        this.mCtx = ctx;
        this.mCacheFileName = fileName;
    }

    public TaskDataSqLiteCacheManager(Context ctx, String fileName, MessageMonitor monitor) {
        this.mCtx = ctx;
        this.mCacheFileName = fileName;
        this.monitor = monitor;
    }

    public void add(Context context, TaskData data) {
        this.lock.lock();
        try {
            if (this.memoryCacheDataSet.size() < 100) {
                this.memoryCacheDataSet.save(data);
            }
        }
        finally {
            this.lock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean save(Context context, TaskData data) {
        boolean bl;
        long bTime = System.currentTimeMillis();
        this.lock.lock();
        try {
            this.getDbManager().save(data);
            this.memoryCacheDataSet.add(data);
            if (this.memoryCacheDataSet.size() > 100) {
                this.memoryCacheDataSet.removeLast();
            }
            this.addRemain(data.getAct(), 1);
            L.verbose(this, "save data : %s to file . memory cache dataset size = %d. mLastFileSize = %d", data.getDataId(), this.memoryCacheDataSet.size(), this.mLastFileSize);
            bl = true;
            this.lock.unlock();
        }
        catch (Throwable e) {
            try {
                L.error(this, "Failed to save data : %s Exception:%s", data.getDataId(), e);
                this.lock.unlock();
            }
            catch (Throwable throwable) {
                this.lock.unlock();
                L.brief("save elapsed time :%d ms", System.currentTimeMillis() - bTime);
                throw throwable;
            }
            L.brief("save elapsed time :%d ms", System.currentTimeMillis() - bTime);
            return false;
        }
        L.brief("save elapsed time :%d ms", System.currentTimeMillis() - bTime);
        return bl;
    }

    private int addRemain(String act, int num) {
        AtomicInteger remain = this.actRemain.get(act);
        if (remain == null) {
            remain = new AtomicInteger();
            this.actRemain.put(act, remain);
        }
        return remain.addAndGet(num);
    }

    private int reduceRemain(String act, int num) {
        AtomicInteger remain = this.actRemain.get(act);
        if (remain != null) {
            return remain.addAndGet(-1 * num);
        }
        return 0;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int saveAll(Context context, Collection<TaskData> tds, Map<String, Integer> actCount) {
        long bTime = System.currentTimeMillis();
        this.lock.lock();
        try {
            try {
                this.getDbManager().saveAll(tds);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
            for (Map.Entry<String, Integer> td : actCount.entrySet()) {
                this.addRemain(td.getKey(), td.getValue());
            }
            this.memoryCacheDataSet.addAll(tds);
            if (this.memoryCacheDataSet.size() > 100) {
                while (this.memoryCacheDataSet.size() > 100) {
                    this.memoryCacheDataSet.removeLast();
                }
            }
            L.verbose(this, "saveAll data : dataSize [%d] to file . memory cache dataset size = %d. mLastFileSize = %d", tds.size(), this.memoryCacheDataSet.size(), this.mLastFileSize);
            int e = this.memoryCacheDataSet.size();
            this.lock.unlock();
        }
        catch (Throwable e) {
            int n;
            try {
                L.error(this, "Failed to saveAll data : dataSize [%d] Exception:%s", tds.size(), e);
                n = this.memoryCacheDataSet.size();
                this.lock.unlock();
            }
            catch (Throwable throwable) {
                this.lock.unlock();
                L.brief("saveAll elapsed time :%d ms", System.currentTimeMillis() - bTime);
                throw throwable;
            }
            L.brief("saveAll elapsed time :%d ms", System.currentTimeMillis() - bTime);
            return n;
        }
        L.brief("saveAll elapsed time :%d ms", System.currentTimeMillis() - bTime);
        return e;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean update(Context context, TaskData data) {
        boolean bl;
        long bTime = System.currentTimeMillis();
        this.lock.lock();
        try {
            this.getDbManager().update(data);
            L.verbose(this, "update data : %s to file . memory cache dataset size = %d. mLastFileSize = %d", data.getDataId(), this.memoryCacheDataSet.size(), this.mLastFileSize);
            bl = true;
            this.lock.unlock();
        }
        catch (Throwable e) {
            try {
                L.error(this, "Failed to update data : %s Exception:%s", data.getDataId(), e);
                this.lock.unlock();
            }
            catch (Throwable throwable) {
                this.lock.unlock();
                L.brief("update elapsed time :%d ms", System.currentTimeMillis() - bTime);
                throw throwable;
            }
            L.brief("update elapsed time :%d ms", System.currentTimeMillis() - bTime);
            return false;
        }
        L.brief("update elapsed time :%d ms", System.currentTimeMillis() - bTime);
        return bl;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public TaskData getFirst(Context context) {
        long bTime = System.currentTimeMillis();
        this.lock.lock();
        TaskData data = null;
        try {
            if (this.memoryCacheDataSet.isEmpty()) {
                this.syncFromFile(context);
            }
            if (!this.memoryCacheDataSet.isEmpty()) {
                data = this.memoryCacheDataSet.getFirst();
            }
            L.verbose(this, "getFirst from  memory cache. memory cache dataset size = %d. mLastFileSize = %d", this.memoryCacheDataSet.size(), this.mLastFileSize);
            this.lock.unlock();
        }
        catch (Throwable e) {
            try {
                L.error(this, "Failed to getFirst data .Exception:%s", e);
                this.lock.unlock();
            }
            catch (Throwable throwable) {
                this.lock.unlock();
                L.brief("getFirst elapsed time :%d ms", System.currentTimeMillis() - bTime);
                throw throwable;
            }
            L.brief("getFirst elapsed time :%d ms", System.currentTimeMillis() - bTime);
        }
        L.brief("getFirst elapsed time :%d ms", System.currentTimeMillis() - bTime);
        return data;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<TaskData> getAndMoveToSendingList(Context ctx, int limit) {
        this.lock.lock();
        ArrayList<TaskData> list = new ArrayList<TaskData>();
        try {
            this.getDbManager();
            if (this.memoryCacheDataSet.isEmpty()) {
                this.syncFromFile(ctx);
            }
            if (!this.memoryCacheDataSet.isEmpty()) {
                int size;
                int sel = size = this.memoryCacheDataSet.size();
                TaskData data = null;
                int cz = 0;
                HashMap<String, Integer> packids = new HashMap<String, Integer>();
                for (int i = 0; i < sel; ++i) {
                    data = this.memoryCacheDataSet.removeFirst();
                    if (data == null) {
                        this.syncFromFile(ctx);
                        if (this.memoryCacheDataSet.isEmpty()) break;
                    }
                    if (this.isOverdue(data) || this.isOverMaxTryTimes(data)) {
                        this.getDbManager().remove(data);
                        TraceLog.dropMessageLog(data.getAct(), data.getDataId());
                        --i;
                        continue;
                    }
                    cz += data.getContent().length();
                    int remain = this.reduceRemain(data.getAct(), 1);
                    data.setRemain(remain);
                    Integer pack = (Integer)packids.get(data.getAct());
                    if (pack == null) {
                        pack = this.monitor.getPackId(data.getAct());
                        packids.put(data.getAct(), pack);
                    }
                    data.setPackId(pack);
                    list.add(data);
                    this.sendingData.add(data.getDataId());
                    if (cz > limit) break;
                }
            }
            L.verbose(this, "getFirst from  memory cache. memory cache dataset size = %d. mLastFileSize = %d", this.memoryCacheDataSet.size(), this.mLastFileSize);
        }
        catch (Throwable e) {
            L.error(this, "Failed to getFirst data .Exception:%s", e);
        }
        finally {
            this.lock.unlock();
        }
        return list;
    }

    private boolean isOverdue(TaskData data) {
        try {
            return Util.daysBetween(data.getTime(), System.currentTimeMillis()) > MAX_CACHE_DAY;
        }
        catch (Throwable e) {
            L.error(this, e.getMessage(), new Object[0]);
            return false;
        }
    }

    private boolean isOverMaxTryTimes(TaskData data) {
        return data.getTryTimes() >= MAX_RETRY_TIMES;
    }

    public void removeSendListBatch(Context c, List<String> ids) {
        this.lock.lock();
        try {
            this.sendingData.removeAll(ids);
            this.getDbManager().remove(ids);
        }
        finally {
            this.lock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void restoreSendList(Context c, List<String[]> actAndIds) {
        this.lock.lock();
        try {
            for (String[] one : actAndIds) {
                this.sendingData.remove(one[1]);
                this.addRemain(one[0], 1);
            }
        }
        finally {
            this.lock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void remove(Context context, TaskData data) {
        long bTime = System.currentTimeMillis();
        this.lock.lock();
        try {
            if (!this.memoryCacheDataSet.isEmpty()) {
                boolean isRemove = this.memoryCacheDataSet.remove(data);
                L.verbose(this, "remove from  memory cache [%b].", isRemove);
            }
            this.getDbManager().remove(data);
            L.verbose(this, "remove data : %s from file . memory cache dataset size = %d. mLastFileSize = %d ", data.getDataId(), this.memoryCacheDataSet.size(), this.mLastFileSize);
            this.lock.unlock();
        }
        catch (Throwable e) {
            try {
                L.error(this, "Failed to remove data .Exception:%s", e);
                this.lock.unlock();
            }
            catch (Throwable throwable) {
                this.lock.unlock();
                L.brief("remove elapsed time :%d ms", System.currentTimeMillis() - bTime);
                throw throwable;
            }
            L.brief("remove elapsed time :%d ms", System.currentTimeMillis() - bTime);
        }
        L.brief("remove elapsed time :%d ms", System.currentTimeMillis() - bTime);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public int size(Context context) {
        int n;
        long bTime = System.currentTimeMillis();
        this.lock.lock();
        try {
            n = this.getDbManager().size();
            this.lock.unlock();
        }
        catch (Throwable e) {
            try {
                L.error(this, "Failed to get size .Exception:%s", e);
                this.lock.unlock();
            }
            catch (Throwable throwable) {
                this.lock.unlock();
                L.brief("get size elapsed time :%d ms", System.currentTimeMillis() - bTime);
                throw throwable;
            }
            L.brief("get size elapsed time :%d ms", System.currentTimeMillis() - bTime);
            return 0;
        }
        L.brief("get size elapsed time :%d ms", System.currentTimeMillis() - bTime);
        return n;
    }

    private void syncFromFile(Context context) {
        this.mLastFileSize = this.getDbManager().size();
        int fetchSize = this.isFirstSyncFromFile ? 50 : 100;
        this.isFirstSyncFromFile = false;
        TaskDataSet ds = this.getDbManager().getFirstList(fetchSize, this.sendingData);
        if (ds != null) {
            TaskDataSet failTds = new TaskDataSet();
            TaskData td = null;
            int succ = 0;
            int fail = 0;
            while ((td = ds.removeFirst()) != null) {
                if (td.verifyMd5()) {
                    this.memoryCacheDataSet.save(td);
                    ++succ;
                    continue;
                }
                failTds.save(td);
                ++fail;
                L.warn(this, "data verify failure ,give up .data=[%s]", td.getContent());
                ActLog.writeSendFailLog(context, "-", null, td.getContent(), "drop one data.verifyMd5 Failure", "-1", null);
                ActLog.writeActLog(null, "Dis", td.getContent(), null, null, null);
            }
            this.getDbManager().removeAll(failTds);
            L.debug(this, "syncFromFile. succ dataset size = [%d],fail dataset size = [%d], file dataset size = [%d]", succ, fail, this.mLastFileSize);
        } else {
            L.debug(this, "syncFromFile dataset size = 0", new Object[0]);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private TaskDataSqLiteDBManager getDbManager() {
        if (this.mDbManager != null) {
            return this.mDbManager;
        }
        TaskDataSqLiteCacheManager taskDataSqLiteCacheManager = this;
        synchronized (taskDataSqLiteCacheManager) {
            if (this.mDbManager != null) {
                return this.mDbManager;
            }
            String dbName = String.format("%s.db", ProcessUtil.getFileNameBindProcess(this.mCtx, this.mCacheFileName));
            L.brief("dbName = %s", dbName);
            this.mDbManager = new TaskDataSqLiteDBManager(this.mCtx, dbName);
            this.actRemain = this.mDbManager.countActRemain();
            return this.mDbManager;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int cacheData(Context context, List<TaskData> set) {
        this.lock.lock();
        try {
            this.memoryCacheDataSet.addAll(set);
            if (this.memoryCacheDataSet.size() > 100) {
                while (this.memoryCacheDataSet.size() > 100) {
                    this.memoryCacheDataSet.removeLast();
                }
            }
            int n = this.memoryCacheDataSet.size();
            return n;
        }
        finally {
            this.lock.unlock();
        }
    }
}

