/*
 * Decompiled with CFR 0.152.
 */
package com.yy.hiidostatis.defs.controller;

import android.content.Context;
import com.yy.hiidostatis.inner.util.ArdUtil;
import com.yy.hiidostatis.inner.util.ThreadPool;
import com.yy.hiidostatis.inner.util.hdid.DeviceProxy;
import com.yy.hiidostatis.inner.util.http.HttpUtil;
import com.yy.hiidostatis.inner.util.log.L;
import java.io.ByteArrayOutputStream;
import java.io.FilterOutputStream;
import java.io.InputStream;
import java.io.UnsupportedEncodingException;
import java.net.HttpURLConnection;
import java.net.URL;
import java.net.URLEncoder;
import javax.net.ssl.HttpsURLConnection;

public class BindTestPhoneController {
    public static void bind(String url, Context context) {
        int index = url.indexOf(":");
        if (index < 0) {
            return;
        }
        StringBuilder builder = new StringBuilder();
        String trim = url.substring(index + 3);
        if (!trim.toLowerCase().startsWith("https://")) {
            builder.append("https://");
        }
        builder.append(trim);
        if (url.indexOf("?") > 0) {
            builder.append("&hdid=");
            builder.append(DeviceProxy.getHdid(context));
        } else {
            builder.append("?hdid=");
            builder.append(DeviceProxy.getHdid(context));
        }
        try {
            builder.append("&sjp=");
            builder.append(URLEncoder.encode(ArdUtil.getSjp(context), "UTF-8"));
        }
        catch (UnsupportedEncodingException e) {
            e.printStackTrace();
        }
        try {
            builder.append("&sjm=");
            builder.append(URLEncoder.encode(ArdUtil.getSjm(context), "UTF-8"));
        }
        catch (UnsupportedEncodingException e) {
            e.printStackTrace();
        }
        builder.append("&sys=");
        builder.append(2);
        try {
            builder.append("&mbos=");
            builder.append(URLEncoder.encode(ArdUtil.getOS(), "UTF-8"));
        }
        catch (UnsupportedEncodingException e) {
            e.printStackTrace();
        }
        try {
            builder.append("&name=");
            builder.append(URLEncoder.encode(ArdUtil.getDeviceName(context), "UTF-8"));
        }
        catch (UnsupportedEncodingException e) {
            e.printStackTrace();
        }
        final String nurl = builder.toString();
        ThreadPool.getPool().execute(new Runnable(){

            @Override
            public void run() {
                BindTestPhoneController.get(nurl);
            }
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void get(String urlAddr) {
        HttpURLConnection urlConn = null;
        FilterOutputStream dos = null;
        InputStream is = null;
        try {
            URL url = new URL(urlAddr);
            urlConn = (HttpsURLConnection)url.openConnection();
            urlConn.setConnectTimeout(30000);
            urlConn.setReadTimeout(60000);
            urlConn.setUseCaches(false);
            urlConn.setRequestMethod("GET");
            urlConn.setInstanceFollowRedirects(true);
            urlConn.setRequestProperty("User-Agent", "Hiido");
            urlConn.connect();
            if (urlConn.getResponseCode() == 200) {
                L.verbose(HttpUtil.class, "get url=[%s] is ok", urlAddr);
                is = urlConn.getInputStream();
                ByteArrayOutputStream bao = new ByteArrayOutputStream();
                byte[] b = new byte[1024];
                int len = 0;
                while ((len = is.read(b)) != -1) {
                    bao.write(b, 0, len);
                }
                String res = new String(bao.toByteArray(), "UTF-8");
                L.verbose(HttpUtil.class, "the result is %s", res);
                b = null;
                bao.close();
            } else {
                L.warn(HttpUtil.class, "http get [%s] error! status:%d", urlAddr, urlConn.getResponseCode());
            }
        }
        catch (Throwable e) {
            L.error("BindTestPhoneController", e.getMessage(), new Object[0]);
        }
        finally {
            try {
                if (urlConn != null) {
                    urlConn.disconnect();
                    urlConn = null;
                }
                if (dos != null) {
                    dos.close();
                    dos = null;
                }
                if (is != null) {
                    is.close();
                    is = null;
                }
            }
            catch (Throwable e) {
                L.error("BindTestPhoneController", e.getMessage(), new Object[0]);
            }
        }
    }
}

