/*
 * Decompiled with CFR 0.152.
 */
package com.yy.hiidostatis.api;

import android.app.Activity;
import android.app.Application;
import android.content.Context;
import android.net.Uri;
import android.os.Build;
import android.os.Bundle;
import android.os.Handler;
import android.os.Looper;
import android.view.MotionEvent;
import android.widget.Toast;
import com.yy.hiidostatis.api.HiidoApi;
import com.yy.hiidostatis.api.HiidoSDK;
import com.yy.hiidostatis.api.MetricsWorker;
import com.yy.hiidostatis.api.OnLineConfigListener;
import com.yy.hiidostatis.api.OnStatisListener;
import com.yy.hiidostatis.api.StatisContent;
import com.yy.hiidostatis.api.StatisLogWriter;
import com.yy.hiidostatis.api.StatisOption;
import com.yy.hiidostatis.defs.ConfigAPI;
import com.yy.hiidostatis.defs.StatisAPI;
import com.yy.hiidostatis.defs.StatisAPINew;
import com.yy.hiidostatis.defs.controller.ActivityLifecycleController;
import com.yy.hiidostatis.defs.controller.AppAnalyzeController;
import com.yy.hiidostatis.defs.controller.BasicBehaviorController;
import com.yy.hiidostatis.defs.controller.BindTestPhoneController;
import com.yy.hiidostatis.defs.controller.CrashController;
import com.yy.hiidostatis.defs.controller.DeviceController;
import com.yy.hiidostatis.defs.controller.InstallController;
import com.yy.hiidostatis.defs.controller.OaidController;
import com.yy.hiidostatis.defs.controller.OnLineConfigController;
import com.yy.hiidostatis.defs.controller.PageStateController;
import com.yy.hiidostatis.defs.controller.SdkAnalyzeController;
import com.yy.hiidostatis.defs.controller.SdkVerController;
import com.yy.hiidostatis.defs.controller.SensorController;
import com.yy.hiidostatis.defs.handler.MetricsHandler;
import com.yy.hiidostatis.defs.listener.ActListener;
import com.yy.hiidostatis.defs.listener.HiidoSdkAdditionDelegate;
import com.yy.hiidostatis.defs.monitor.ScreenMonitor;
import com.yy.hiidostatis.defs.monitor.TrafficMonitor;
import com.yy.hiidostatis.defs.obj.Property;
import com.yy.hiidostatis.defs.obj.ShareType;
import com.yy.hiidostatis.inner.AppInfo;
import com.yy.hiidostatis.inner.GeneralProxy;
import com.yy.hiidostatis.inner.implementation.CommonFiller;
import com.yy.hiidostatis.inner.util.ArdUtil;
import com.yy.hiidostatis.inner.util.Counter;
import com.yy.hiidostatis.inner.util.DefaultPreference;
import com.yy.hiidostatis.inner.util.ThreadPool;
import com.yy.hiidostatis.inner.util.Util;
import com.yy.hiidostatis.inner.util.cipher.Coder;
import com.yy.hiidostatis.inner.util.hdid.DeviceProxy;
import com.yy.hiidostatis.inner.util.log.ActLog;
import com.yy.hiidostatis.inner.util.log.L;
import com.yy.hiidostatis.message.SessionReportWrapper;
import com.yy.hiidostatis.message.log.TraceLog;
import com.yy.hiidostatis.message.module.sessionreport.CalAction;
import com.yy.hiidostatis.message.module.sessionreport.EventValue;
import com.yy.hiidostatis.message.utils.KVIO;
import com.yy.hiidostatis.provider.DefaultProviderLoader;
import com.yy.hiidostatis.provider.GlobalProvider;
import com.yy.hiidostatis.provider.MessageConfig;
import com.yy.hiidostatis.provider.MessageConfigFactory;
import com.yy.hiidostatis.testui.FloatingService;
import com.yy.hiidostatis.track.DataTrack;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Random;
import java.util.Set;
import java.util.UUID;
import org.json.JSONObject;

public class HiidoSDKNew
implements HiidoApi {
    private static final int INTERVAL_HEART_BEAT = 900000;
    private static final int STATE_STARTED = 1;
    private static final int STATE_QUITED = 2;
    private static final int STATE_INVALID = -1;
    private static final int SDK_METRICS_TIMER_INTERVAL = 900;
    private int mState = -1;
    private boolean appRunIsCalled = false;
    private static final String DEFAULT_METRICS_NAME = "DEFAULT_METRICS";
    public static final String SDK_METRICS_NAME = "SDK_METRICS";
    private static OnStatisListener nullListener = new OnStatisListener(){

        @Override
        public long getCurrentUid() {
            return 0L;
        }
    };
    private volatile StatisOption mStatisOption = new StatisOption();
    private volatile Context mContext;
    private final Handler mHandler = new Handler(Looper.getMainLooper());
    private final Counter mHeartbeatInvoker = new Counter(this.mHandler, 0, 900000L, true);
    private volatile Counter.Callback mHeartbeatReportExecutor;
    private final Counter mHeartbeatInvokerShort = new Counter(this.mHandler, 0, 60000L, true);
    private volatile Counter.Callback mHeartbeatReportExecutorShort;
    private volatile OnStatisListener mOnStatisListener = nullListener;
    private volatile QuitTimer mQuittimer = new QuitTimer();
    private static volatile boolean isResumeCall = false;
    private StatisAPINew mStatisAPI = null;
    private volatile MessageConfig config = null;
    private static ConfigAPI mConfigApi;
    private BasicBehaviorController mBasicBehaviorController;
    private AppAnalyzeController mAppAnalyzeController;
    private SdkAnalyzeController mSdkAnalyzeController;
    private SdkVerController mSdkVerController;
    private InstallController mInstallController;
    private DeviceController mDeviceController;
    private CrashController mCrashController;
    private SensorController sensorController;
    private MetricsHandler metricsHandler;
    private static OnLineConfigController mOnLineConfigController;
    private PageStateController pageStateController;
    private static volatile boolean mIsInit;
    private Map<String, String> mDoShortProp = new HashMap<String, String>();
    private boolean isAppRunning;
    private volatile boolean userAgreed = true;
    private ActivityLifecycleController mActivityLifecycleController = new ActivityLifecycleController();
    private SessionReportWrapper sessionReport;
    private boolean isFrontground;

    HiidoSDKNew() {
    }

    @Override
    public void appStartLaunchWithAppKey(Context context, StatisOption sOption, OnStatisListener listener) {
        if (mIsInit) {
            L.warn(this, "sdk only be init once", new Object[0]);
            return;
        }
        this.config = this.initMessageConfig(context, sOption, listener);
        if (this.config == null) {
            return;
        }
        this.appStartLaunchWithAppKey(this.config, listener);
    }

    private MessageConfig initMessageConfig(Context context, StatisOption sOption, OnStatisListener listener) {
        String appkey = sOption.getAppkey();
        if (Util.empty(appkey)) {
            String string = ArdUtil.getMetaDataParam(context, "HIIDO_APPKEY");
        }
        if (Util.empty(appkey)) {
            return null;
        }
        MessageConfig config = MessageConfigFactory.generateMainConfig(context, appkey);
        config.setVer(sOption.getVer());
        config.setAppId(sOption.getAppId());
        config.setVer(sOption.getVer());
        config.setFrom(sOption.getFrom());
        config.setInterval(HiidoSDK.instance().getOptions().getInterval());
        config.setDefaultMetricsExpire(HiidoSDK.instance().getOptions().getDefaultMetricsExpire());
        config.setLogOn(HiidoSDK.instance().getOptions().isLogOn);
        config.setGaidEnable(HiidoSDK.instance().getOptions().isGaidEnable());
        config.setDefaultMetricsExpire(HiidoSDK.instance().getOptions().getDefaultMetricsExpire());
        config.setUidProvider(listener);
        return config;
    }

    public void appStartLaunchWithAppKey(MessageConfig config, OnStatisListener listener) {
        Application app = (Application)config.getApplicationContext().getApplicationContext();
        this.mContext = app;
        KVIO.initialize((Context)app);
        DefaultProviderLoader.init();
        TraceLog.initLog(config.getApplicationContext());
        this.config = config;
        if (listener == null) {
            L.brief("the Input listener is null ,so get the default listener instead", new Object[0]);
            this.mOnStatisListener = nullListener;
        } else {
            this.mOnStatisListener = listener;
        }
        this.mStatisAPI = new StatisAPINew(config);
        this.sessionReport = (SessionReportWrapper)GlobalProvider.instance.get(SessionReportWrapper.class, config);
        this.startCrashMonitor();
        app.registerActivityLifecycleCallbacks(new Application.ActivityLifecycleCallbacks(){

            public void onActivityCreated(Activity activity, Bundle savedInstanceState) {
            }

            public void onActivityStarted(Activity activity) {
                final String cn = activity.getClass().getName();
                ThreadPool.getPool().executeQueue(new Runnable(){

                    @Override
                    public void run() {
                        HiidoSDKNew.this.pageStateController.onStart(cn);
                    }
                });
                if (activity.getIntent() != null) {
                    Uri uri;
                    try {
                        uri = activity.getIntent().getData();
                        HiidoSDKNew.this.reportUrlScheme(uri);
                    }
                    catch (Throwable e) {
                        L.error(this, e.getMessage(), new Object[0]);
                    }
                    try {
                        uri = activity.getIntent().getData();
                        if (uri != null && uri.getScheme().toLowerCase().startsWith("hiidodct.")) {
                            HiidoSDK.isDebugMode = true;
                            BindTestPhoneController.bind(uri.toString(), activity.getApplicationContext());
                            Toast.makeText((Context)activity.getApplicationContext(), (CharSequence)"\u53ef\u4ee5\u6d4b\u8bd5\u4e86", (int)1).show();
                        }
                    }
                    catch (Throwable e) {
                        L.error(this, e.getMessage(), new Object[0]);
                    }
                }
            }

            public void onActivityResumed(Activity activity) {
                if (FloatingService.INSTANCT.isDebug() && !FloatingService.INSTANCT.isInit()) {
                    FloatingService.INSTANCT.showFloatingWindow(activity);
                }
            }

            public void onActivityPaused(Activity activity) {
            }

            public void onActivityStopped(Activity activity) {
                final String cn = activity.getClass().getName();
                final Context app = activity.getApplicationContext();
                ThreadPool.getPool().executeQueue(new Runnable(){

                    @Override
                    public void run() {
                        boolean isBackground = HiidoSDKNew.this.pageStateController.onStop(cn);
                        if (isBackground) {
                            HiidoSDKNew.this.metricsHandler.onBackground();
                            HiidoSDKNew.this.sensorController.onStop(app);
                        }
                    }
                });
            }

            public void onActivitySaveInstanceState(Activity activity, Bundle outState) {
            }

            public void onActivityDestroyed(Activity activity) {
            }
        });
        mConfigApi = new ConfigAPI(this.mContext, this.config.getAppkey());
        this.mSdkAnalyzeController = new SdkAnalyzeController(this.mStatisAPI, mConfigApi);
        this.mSdkVerController = new SdkVerController(mConfigApi);
        this.mInstallController = new InstallController(this.mStatisAPI);
        mOnLineConfigController = new OnLineConfigController(mConfigApi);
        this.mAppAnalyzeController = new AppAnalyzeController(this.mStatisAPI, mConfigApi);
        this.metricsHandler = new MetricsHandler(this.mContext, config.getAppkey(), config.getVer(), HiidoSDK.instance().getOptions().getDefaultMetricsExpire());
        ThreadPool.getPool().executeQueue(new Runnable(){

            @Override
            public void run() {
                HiidoSDKNew.this.asynInit();
            }
        });
        mIsInit = true;
    }

    private void asynInit() {
        try {
            com.yy.hiidostatis.message.AppInfo appInfo = (com.yy.hiidostatis.message.AppInfo)GlobalProvider.instance.get(com.yy.hiidostatis.message.AppInfo.class, this.config);
            appInfo.updateAppInfo(this.config);
            this.sensorController = new SensorController(this.mContext, this.config.getGyroscopeThreshold(), this.config.getAccelerometerThreshold(), this.config.getLightThreshold(), this.config.isOpenSensorMonitor());
            FloatingService.INSTANCT.setFilterAppkey(this.config.getAppkey());
            this.pageStateController = new PageStateController(this.mStatisAPI, this.mContext, this.mOnStatisListener);
            AppInfo.INSTANCE.init(this.mContext);
            L.initLogConfig(this.mContext);
            if (Util.empty(this.config.getFrom())) {
                String from = ArdUtil.getMetaDataParam(this.mContext, "HIIDO_CHANNEL");
                this.config.setFrom(from);
            }
            if (HiidoSDK.instance().getOptions().isUseOaid()) {
                OaidController.loadLib(this.config.getApplicationContext());
                OaidController.INSTANCE.initOaidAsyn(this.config.getApplicationContext(), new OaidController.OaidInitListener(){

                    @Override
                    public void initFinish(boolean success, String oaid, String error) {
                        HiidoSDKNew.this.oaidInitFinish();
                    }
                });
            }
            if (Util.empty(this.config.getVer())) {
                this.config.setVer(ArdUtil.getVersionName(this.mContext));
                this.metricsHandler.setVer(this.config.getVer());
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        finally {
            this.mStatisAPI.onInitSuccess();
        }
        DataTrack.instance.init(this.mContext, this.mStatisOption, new DataTrack.IDataTrackListener(){

            @Override
            public JSONObject getConfig(String appkey, long uid, String deviceid) {
                return mConfigApi.getDeviceConfig(HiidoSDKNew.this.mContext, appkey, deviceid, uid, true);
            }
        });
        this.mDeviceController = new DeviceController(this.mStatisAPI, this.mContext);
        SensorController.initRecord(this.mContext);
        L.setLogOn(HiidoSDK.instance().getOptions().isLogOn);
        L.infoOn(this, "testServer = %s", HiidoSDK.instance().getOptions().testServer);
        L.infoOn(this, "isAbroad = %b", HiidoSDK.instance().getOptions().isAbroad);
        L.infoOn(this, "isLogOn = %b", HiidoSDK.instance().getOptions().isLogOn);
    }

    private boolean checkSDKInit() {
        if (!mIsInit) {
            L.warnOn(this, "The SDK is NOT init", new Object[0]);
        }
        return mIsInit;
    }

    private void reportOnAppStartLaunch(Context context, OnStatisListener listener) {
        try {
            TrafficMonitor.instance.init(this.mContext);
            TrafficMonitor.instance.start();
            ScreenMonitor.instance.reset();
            this.mSdkVerController.startSdkVerCheck(context);
            this.mStatisAPI.generateSession();
            this.sendInstallationReportIfNotYet(context);
            this.reportDo(context, listener.getCurrentUid());
            this.reportRun(context, listener.getCurrentUid());
            this.mDeviceController.reportDeviceOnLaunch(context, listener.getCurrentUid());
            this.sensorController.reset(context);
            this.mSdkAnalyzeController.reportSdkAnalyze(context, listener.getCurrentUid());
            this.startHeartbeatReport();
            if (HiidoSDK.instance().getOptions().isOpenDoShort) {
                this.reportDoShort(context, listener.getCurrentUid());
                this.startHeartbeatReportShort();
            }
            GeneralProxy.start(context);
            GeneralProxy.stopTimer(context);
            DataTrack.instance.triggerTrack(true);
            ActLog.uploadLog(this.mContext, new ActLog.ILogConfigListener(){

                @Override
                public JSONObject getLogConfig() {
                    return mConfigApi.getAppListConfig(HiidoSDKNew.this.mContext, true);
                }
            });
        }
        catch (Throwable e) {
            L.error(this, "reportOnAppStartLaunch exception =%s", e);
        }
    }

    private void quitApp(boolean isNormal) {
        try {
            if (this.mState == 1) {
                BasicBehaviorController.PageActionReporter rpt = this.getPageActionReporter();
                if (rpt != null) {
                    if (!isNormal) {
                        rpt.onLeavingUI(null, null);
                        isResumeCall = false;
                    }
                    rpt.onFinishGotoUI(this.mOnStatisListener == null ? 0L : this.mOnStatisListener.getCurrentUid(), null, true);
                }
                this.metricsHandler.onExit();
                this.onQuitApp(isNormal);
                this.mState = 2;
                L.infoOn(this, "app quit. it is one appa finish. isNormal quit is [%b]\u3002", isNormal);
            }
        }
        catch (Throwable e) {
            L.error(this, "quitApp exception =%s", e);
        }
    }

    @Override
    public void reportApplist() {
        ThreadPool.getPool().executeQueue(new Runnable(){

            @Override
            public void run() {
                try {
                    HiidoSDKNew.this.mAppAnalyzeController.reportAppAnalyze(HiidoSDKNew.this.mContext, HiidoSDKNew.this.mOnStatisListener.getCurrentUid());
                }
                catch (Throwable e) {
                    L.error(this, e.getMessage(), new Object[0]);
                }
            }
        });
    }

    @Override
    public boolean registerActivityLifecycleMonitor(Context context) {
        this.mActivityLifecycleController.registerActivityLifecycleCallbacks(context, new ActivityLifecycleController.ActivityLifecycleCallback(){

            @Override
            public void onActivityResumed(Activity activity) {
                long uid = 0L;
                OnStatisListener listener = HiidoSDKNew.this.getOnStatisListener();
                if (listener != null) {
                    uid = listener.getCurrentUid();
                }
                HiidoSDKNew.this.onResumeInner(uid, HiidoSDKNew.this.getPageId(activity));
            }

            @Override
            public void onActivityPaused(Activity activity) {
                HiidoSDKNew.this.onPauseInner(HiidoSDKNew.this.getPageId(activity), HiidoSDK.PageActionReportOption.REPORT_ON_FUTURE_RESUME);
            }
        });
        L.infoOn(this, "registerActivityLifecycleMonitor = %b", this.mActivityLifecycleController.isRegister());
        return this.mActivityLifecycleController.isRegister();
    }

    private void reportUrlScheme(Uri uri) {
        if (uri == null) {
            return;
        }
        if (!this.checkSDKInit()) {
            return;
        }
        try {
            String scheme = uri.getScheme();
            String host = uri.getHost();
            int port = uri.getPort();
            String path = uri.getPath();
            String query = uri.getQuery();
            L.info(this, "URL SCHEME:%s://%s:%d/%s?%s", scheme, host, port, path, query);
            this.mStatisAPI.reportUrlScheme(scheme, host, port, path, query);
        }
        catch (Throwable e) {
            L.error(this, e.getMessage(), new Object[0]);
        }
    }

    private boolean oaidPrepared() {
        return !HiidoSDK.instance().getOptions().isUseOaid() || OaidController.ignore(this.mContext) || OaidController.INSTANCE.isLoaded();
    }

    private boolean imeiPrepared() {
        return !HiidoSDK.instance().getOptions().isWaitGrant() || Build.VERSION.SDK_INT > 28 || this.appRunIsCalled || ArdUtil.checkPermissions(this.mContext, "android.permission.READ_PHONE_STATE");
    }

    private void onResumeInner(final long uid, final String pageId) {
        this.isFrontground = true;
        ThreadPool.getPool().executeQueue(new Runnable(){

            @Override
            public void run() {
                if (!HiidoSDKNew.this.checkSDKInit()) {
                    return;
                }
                if (HiidoSDK.instance().getOptions().getIgnoreActivity() != null && HiidoSDK.instance().getOptions().getIgnoreActivity().contains(pageId)) {
                    return;
                }
                try {
                    L.verbose(this, "clearQuitTimer in onResume", new Object[0]);
                    HiidoSDKNew.this.mQuittimer.clearQuitTimer();
                    isResumeCall = true;
                    if (HiidoSDKNew.this.imeiPrepared() && HiidoSDKNew.this.oaidPrepared()) {
                        HiidoSDKNew.this.appInitRun();
                    } else if (HiidoSDKNew.this.mState == 2 || HiidoSDKNew.this.mState == -1) {
                        HiidoSDKNew.this.getAppActionReporter().onStartApp();
                        HiidoSDKNew.this.reportDo(HiidoSDKNew.this.mContext, HiidoSDKNew.this.getOnStatisListener() != null ? HiidoSDKNew.this.getOnStatisListener().getCurrentUid() : 0L);
                    }
                    BasicBehaviorController.PageActionReporter reporter = HiidoSDKNew.this.getPageActionReporter();
                    if (reporter != null) {
                        reporter.onResumeUI(uid, pageId);
                    }
                    String tmpPageId = pageId;
                    try {
                        DefaultPreference.getPreference().setPrefString(HiidoSDKNew.this.mContext, "PREF_CPAGE", tmpPageId);
                    }
                    catch (Throwable e) {
                        e.printStackTrace();
                    }
                }
                catch (Throwable e) {
                    L.error(this, "onResume exception =%s", e);
                }
            }
        });
    }

    private void onPauseInner(final String pageId, final HiidoSDK.PageActionReportOption reportOption) {
        ThreadPool.getPool().executeQueue(new Runnable(){

            @Override
            public void run() {
                if (!HiidoSDKNew.this.checkSDKInit()) {
                    return;
                }
                if (HiidoSDK.instance().getOptions().getIgnoreActivity() != null && HiidoSDK.instance().getOptions().getIgnoreActivity().contains(pageId)) {
                    return;
                }
                try {
                    if (isResumeCall) {
                        if (reportOption == HiidoSDK.PageActionReportOption.DO_NOT_REPORT_ON_FUTURE_RESUME) {
                            L.info(this, " DO_NOT_REPORT_ON_FUTURE_RESUME,Clear current page element on page %s", pageId);
                            HiidoSDKNew.this.getPageActionReporter().clearCurPageElement();
                        } else {
                            HiidoSDKNew.this.getPageActionReporter().onLeavingUI(pageId, null);
                        }
                        L.verbose(this, "startQuitTimer in onPause", new Object[0]);
                        HiidoSDKNew.this.mQuittimer.startQuitTimer();
                        isResumeCall = false;
                        HiidoSDKNew.this.getBehaviorCollector(HiidoSDKNew.this.getCtx(HiidoSDKNew.this.mContext)).saveLastOnPauseTime(Util.wallTimeMillis());
                    } else {
                        L.error(this, "call onPause() must call onResume() first", new Object[0]);
                    }
                }
                catch (Throwable e) {
                    L.error(this, "onPause exception =%s", e);
                }
            }
        });
    }

    private synchronized void appInitRun() {
        if (this.isFrontground && (this.mState == 2 || this.mState == -1)) {
            L.infoOn(this, "app enter. it is a new appa begin", new Object[0]);
            this.reportOnAppStartLaunch(this.mContext, this.mOnStatisListener);
            BasicBehaviorController.AppActionReporter reporter = this.getAppActionReporter();
            this.metricsHandler.onForeground();
            if (reporter != null) {
                reporter.onAppStarted();
            }
            this.mState = 1;
        }
    }

    @Override
    public synchronized void appRun() {
        this.appRunIsCalled = true;
        if (this.oaidPrepared()) {
            ThreadPool.getPool().executeQueue(new Runnable(){

                @Override
                public void run() {
                    HiidoSDKNew.this.appInitRun();
                }
            });
        }
    }

    private synchronized void oaidInitFinish() {
        if (this.imeiPrepared()) {
            ThreadPool.getPool().executeQueue(new Runnable(){

                @Override
                public void run() {
                    HiidoSDKNew.this.appInitRun();
                }
            });
        }
    }

    @Override
    public void onResume(long uid, String pageId) {
        if (this.mActivityLifecycleController.isRegister()) {
            return;
        }
        this.onResumeInner(uid, pageId);
    }

    @Override
    public void onPause(String pageId, HiidoSDK.PageActionReportOption reportOption) {
        if (this.mActivityLifecycleController.isRegister()) {
            return;
        }
        this.onPauseInner(pageId, reportOption);
    }

    @Override
    public void onResume(long uid, Activity activity) {
        if (this.mActivityLifecycleController.isRegister()) {
            return;
        }
        String pageId = this.getPageId(activity);
        this.onResume(uid, pageId);
    }

    @Override
    public void onPause(Activity activity, HiidoSDK.PageActionReportOption reportOption) {
        if (this.mActivityLifecycleController.isRegister()) {
            return;
        }
        String pageId = this.getPageId(activity);
        this.onPause(pageId, reportOption);
    }

    @Override
    public void onScreenResume(final String screen) {
        ThreadPool.getPool().executeQueue(new Runnable(){

            @Override
            public void run() {
                if (!HiidoSDKNew.this.checkSDKInit()) {
                    return;
                }
                try {
                    BasicBehaviorController.PageActionReporter reporter = HiidoSDKNew.this.getPageActionReporter();
                    long uid = 0L;
                    if (HiidoSDKNew.this.mOnStatisListener != null) {
                        uid = HiidoSDKNew.this.mOnStatisListener.getCurrentUid();
                    }
                    if (reporter != null) {
                        reporter.onResumeUI(uid, screen);
                    }
                    ThreadPool.getPool().executeQueue(new Runnable(){

                        @Override
                        public void run() {
                            try {
                                DefaultPreference.getPreference().setPrefString(HiidoSDKNew.this.mContext, "PREF_CPAGE", screen);
                            }
                            catch (Throwable e) {
                                e.printStackTrace();
                            }
                        }
                    });
                }
                catch (Throwable e) {
                    L.error(this, "onScreenResume exception =%s", e);
                }
            }
        });
    }

    @Override
    public void onScreenPause(final String screen) {
        ThreadPool.getPool().executeQueue(new Runnable(){

            @Override
            public void run() {
                try {
                    HiidoSDKNew.this.getPageActionReporter().onLeavingUI(screen, null);
                }
                catch (Throwable e) {
                    L.error(this, "onScreenPause exception =%s", e);
                }
            }
        });
    }

    @Override
    public void setCurPageParam(String param) {
        if (this.getPageActionReporter() != null) {
            this.getPageActionReporter().setCurPageParam(param);
        }
    }

    @Override
    public void onScreenMonitor(MotionEvent event) {
        ScreenMonitor.instance.onTouchEvent(event);
    }

    @Override
    public Context getContext() {
        return this.config.getApplicationContext();
    }

    public HiidoApi setLogWriter(StatisLogWriter logWriter) {
        L.setLogSetting(logWriter);
        return this;
    }

    private void onQuitApp(boolean isNormal) {
        Context c = this.mContext;
        if (c == null) {
            L.error(this, "No context, cannot do quit things properly, data lost.", new Object[0]);
            return;
        }
        Counter heartBeatInvoker = this.mHeartbeatInvoker;
        Counter heartBeatInvokerShort = this.mHeartbeatInvokerShort;
        if (heartBeatInvoker != null) {
            heartBeatInvoker.stop();
        }
        if (heartBeatInvokerShort != null) {
            heartBeatInvokerShort.stop();
        }
        this.mHeartbeatReportExecutor = null;
        this.mHeartbeatReportExecutorShort = null;
        TrafficMonitor.instance.end();
        BasicBehaviorController.AppActionReporter reporter = this.peekAppaActionReporter();
        if (reporter != null) {
            reporter.onExitApp(false, isNormal);
        } else {
            L.error(this, "No behavior reporter to report app action, sdk not initialized.", new Object[0]);
        }
        this.mStatisAPI.exit();
        GeneralProxy.exit(this.getContext(), isNormal);
        if (isNormal) {
            Context ctx = this.getContext();
            if (ctx != null) {
                GeneralProxy.startTimer(this.getContext(), 1800000L);
            }
            ThreadPool.getPool().execute(new Runnable(){

                @Override
                public void run() {
                    try {
                        Thread.sleep(1000L);
                    }
                    catch (InterruptedException e) {
                        e.printStackTrace();
                    }
                    DataTrack.instance.triggerTrack(true);
                }
            });
        }
    }

    private BasicBehaviorController.AppActionReporter getAppActionReporter() {
        BasicBehaviorController collector = this.getBehaviorCollector(this.getCtx(this.mContext));
        return collector == null ? null : collector.getAppActionCollector();
    }

    private BasicBehaviorController.PageActionReporter getPageActionReporter() {
        BasicBehaviorController collector = this.getBehaviorCollector(this.getCtx(this.mContext));
        return collector == null ? null : collector.getPageActionCollector();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private BasicBehaviorController getBehaviorCollector(Context context) {
        if ((context = this.getCtx(context)) == null) {
            L.error(this, "Input context is null when getBehaviorCollector", new Object[0]);
            return null;
        }
        BasicBehaviorController collector = this.mBasicBehaviorController;
        if (collector != null) {
            return collector;
        }
        HiidoSDKNew hiidoSDKNew = this;
        synchronized (hiidoSDKNew) {
            collector = this.mBasicBehaviorController;
            if (collector == null) {
                L.brief("mOnStatisListener is %s", this.mOnStatisListener);
                this.mBasicBehaviorController = collector = new BasicBehaviorController(context, this.mHandler, this.mOnStatisListener, this.mStatisAPI, HiidoSDK.instance().getOptions().backgroundDurationMillisAsQuit, HiidoSDK.instance().getOptions().behaviorSendThreshold, 10);
            }
            return collector;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private BasicBehaviorController.AppActionReporter peekAppaActionReporter() {
        BasicBehaviorController collector = this.mBasicBehaviorController;
        if (collector != null) {
            return collector.getAppActionCollector();
        }
        HiidoSDKNew hiidoSDKNew = this;
        synchronized (hiidoSDKNew) {
            collector = this.mBasicBehaviorController;
            return collector == null ? null : collector.getAppActionCollector();
        }
    }

    @Override
    public void reportLogin(long uid) {
        if (!this.checkSDKInit()) {
            return;
        }
        this.mStatisAPI.reportLogin(uid);
        if (this.mState == 1) {
            this.mStatisAPI.reportDo(uid);
        }
    }

    @Override
    public void reportAppsflyer(String data) {
        if (!this.checkSDKInit()) {
            return;
        }
        this.mStatisAPI.reportAppsflyer(data);
        if (this.mState == 1) {
            this.reportDo(this.mContext, this.mOnStatisListener == null ? 0L : this.mOnStatisListener.getCurrentUid());
        }
    }

    @Override
    public void reportShare(String platform, int mediaType, String content, ShareType stype, String errmsg, String screen, String userData) {
        if (this.checkSDKInit()) {
            this.mStatisAPI.reportShare(platform, mediaType, content, stype, errmsg, screen, userData);
        }
    }

    @Override
    public void reportIM(String sender, String receiver, String content, Date editTime, Date sendTime, String errormsg, int mediaType, String userData) {
        if (this.checkSDKInit()) {
            this.mStatisAPI.reportIM(sender, receiver, content, editTime, sendTime, errormsg, mediaType, userData);
        }
    }

    @Override
    public void reportReg(String uid, String name, String type, Map<String, String> prop) {
        if (!this.checkSDKInit()) {
            return;
        }
        this.mStatisAPI.reportReg(uid, name, type, prop);
    }

    private void reportRun(Context context, long uid) {
        try {
            if (this.mState == -1 || this.mState == 2) {
                this.mStatisAPI.reportRun(uid);
                L.info(this, "reportRun call", new Object[0]);
            } else {
                L.warn(this, "reportRun has been called, one launch only one call!", new Object[0]);
            }
        }
        catch (Throwable e) {
            L.error(this, "reportRun exception=%s", e);
        }
    }

    private void reportDo(Context context, long uid) {
        try {
            this.mStatisAPI.reportDo(uid);
            L.info(this, "report heart beat for %d", uid);
        }
        catch (Throwable e) {
            L.error(this, "report heart beat for %d.exception=%s", uid, e);
        }
    }

    private void reportDoShort(Context context, long uid) {
        try {
            if (this.mDoShortProp.size() == 0) {
                L.brief("report heart beat short for %d do nothing , mDoShortProp size  = 0", uid);
                return;
            }
            L.info(this, "report heart beat short for %d", uid);
        }
        catch (Throwable e) {
            L.error(this, "report heart beat short for %d.exception=%s", uid, e);
        }
    }

    private void flushCache(Context context) {
        if (new Random().nextInt(2) % 2 == 0) {
            if (context != null) {
                GeneralProxy.flushCache(context);
            }
            if (this.mCrashController != null) {
                this.mCrashController.flushCache();
            }
        }
    }

    @Override
    public void setHeartbeatField(String key, String value) {
        String sid = this.mDoShortProp.get("sid");
        String subsid = this.mDoShortProp.get("subsid");
        String auid = this.mDoShortProp.get("auid");
        if (value == null) {
            this.mDoShortProp.remove(key);
        } else {
            this.mDoShortProp.put(key, value);
        }
        boolean isChange = false;
        if ("sid".equals(key) && (value != null && !value.equals(sid) || sid != null && !sid.equals(value))) {
            isChange = true;
        }
        if ("subsid".equals(key) && (value != null && !value.equals(subsid) || subsid != null && !subsid.equals(value))) {
            isChange = true;
        }
        if ("auid".equals(key) && (value != null && !value.equals(auid) || auid != null && !auid.equals(value))) {
            isChange = true;
        }
        if (isChange) {
            this.resetHeartbeatReportShort(1000L);
        }
    }

    @Override
    public void reportErrorEvent(long uid, String errorId, String errorMessage, String param) {
        if (!this.checkSDKInit()) {
            return;
        }
        this.mStatisAPI.reportError(uid, errorId, errorMessage, param);
    }

    @Override
    public void reportStatisticContentTemporary(String act, StatisContent content) {
        if (!this.checkSDKInit()) {
            return;
        }
        this.mStatisAPI.reportStatisticContentTemporary(act, content, true, true);
    }

    @Override
    public void reportStatisticContent(String act, StatisContent content) {
        if (!this.checkSDKInit()) {
            return;
        }
        this.mStatisAPI.reportStatisticContent(act, content, true, true);
    }

    @Override
    public void reportStatisticContent(String act, StatisContent content, boolean isPriority) {
        if (!this.checkSDKInit()) {
            return;
        }
        this.mStatisAPI.reportStatisticContent(act, content, true, true, isPriority);
    }

    @Override
    public void reportStatisticContentWithNoComm(Context context, String act, StatisContent content) {
        if (!this.checkSDKInit()) {
            return;
        }
        this.mStatisAPI.reportStatisticContentWithNoComm(this.getCtx(context), act, content);
    }

    @Override
    public void reportStatisticContentWithNoComm(Context context, String act, StatisContent content, boolean isPriority) {
        if (!this.checkSDKInit()) {
            return;
        }
        this.mStatisAPI.reportStatisticContentWithNoComm(this.getCtx(context), act, content, isPriority);
    }

    @Override
    public void reportCustomContent(long uid, String type, String content) {
        if (!this.checkSDKInit()) {
            return;
        }
        this.mStatisAPI.reportCustomContent(uid, type, content);
    }

    @Override
    public void reportCrash(long uid, String crashMsg) {
        if (!this.checkSDKInit()) {
            return;
        }
        this.mStatisAPI.reportCrash(uid, crashMsg);
    }

    @Override
    public void reportCrash(long uid, Throwable throwable) {
        if (!this.checkSDKInit()) {
            return;
        }
        this.mStatisAPI.reportCrash(uid, throwable);
    }

    @Override
    public void reportTimesEvent(long uid, String eid) {
        if (!this.checkSDKInit()) {
            return;
        }
        this.reportTimesEvent(uid, eid, null);
    }

    @Override
    public void reportTimesEvent(long uid, String eid, String label) {
        if (!this.checkSDKInit()) {
            return;
        }
        this.reportTimesEvent(uid, eid, label, null);
    }

    @Override
    public void reportTimesEvent(long uid, String eid, String label, Property property) {
        if (!this.checkSDKInit()) {
            return;
        }
        this.mStatisAPI.reportTimesEvent(uid, eid, label, property);
    }

    @Override
    public void reportCountEvent(long uid, String eid, double evalue) {
        if (!this.checkSDKInit()) {
            return;
        }
        this.reportCountEvent(uid, eid, evalue, null);
    }

    @Override
    public void reportCountEvent(long uid, String eid, double evalue, String label) {
        this.reportCountEvent(uid, eid, evalue, label, null);
    }

    @Override
    public void reportCountEvent(long uid, String eid, double evalue, String label, Property property) {
        if (!this.checkSDKInit()) {
            return;
        }
        this.mStatisAPI.reportCountEvent(uid, eid, evalue, label, property);
    }

    @Override
    public void reportSuccess(long uid, String aid, String type, long duration, String parm) {
        if (!this.checkSDKInit()) {
            return;
        }
        this.mStatisAPI.reportSuccess(uid, aid, type, duration, parm);
    }

    @Override
    public void reportFailure(long uid, String aid, String type, String failCode, String failMsg, String parm) {
        if (!this.checkSDKInit()) {
            return;
        }
        this.mStatisAPI.reportFailure(uid, aid, type, failCode, failMsg, parm);
    }

    private Context getCtx(Context context) {
        return context == null ? this.mContext : context;
    }

    private void sendInstallationReportIfNotYet(Context context) {
        Context ctx = this.getCtx(context);
        if (ctx == null || this.mInstallController == null) {
            L.error(this, "Input context is null,sdk is not init?", new Object[0]);
            return;
        }
        if (!this.checkSDKInit()) {
            return;
        }
        this.mInstallController.sendInstallationReportIfNotYet(ctx);
    }

    private void startHeartbeatReport() {
        Counter.Callback executor = this.mHeartbeatReportExecutor;
        if (executor != null) {
            L.warn(this, "heart beat as for mbsdkdo has been started.", new Object[0]);
            return;
        }
        this.mHeartbeatReportExecutor = executor = new Counter.Callback(){

            @Override
            public void onCount(int counter) {
                long uid = HiidoSDKNew.this.mOnStatisListener.getCurrentUid();
                HiidoSDKNew.this.reportDo(HiidoSDKNew.this.mContext, uid);
            }
        };
        this.mHeartbeatInvoker.setCallback(executor);
        this.mHeartbeatInvoker.start(this.mHeartbeatInvoker.getInterval());
        L.info(this, "start heart beat invoker for mbsdkdo.", new Object[0]);
    }

    private void startHeartbeatReportShort() {
        Counter.Callback executor = this.mHeartbeatReportExecutorShort;
        if (executor != null) {
            L.warn(this, "heart beat as for mbsdkdo short has been started.", new Object[0]);
            return;
        }
        this.mHeartbeatReportExecutorShort = executor = new Counter.Callback(){

            @Override
            public void onCount(int counter) {
                long uid = HiidoSDKNew.this.mOnStatisListener.getCurrentUid();
                HiidoSDKNew.this.reportDoShort(HiidoSDKNew.this.mContext, uid);
                HiidoSDKNew.this.flushCache(HiidoSDKNew.this.mContext);
                DataTrack.instance.triggerTrack(false);
            }
        };
        this.mHeartbeatInvokerShort.setCallback(executor);
        this.mHeartbeatInvokerShort.start(this.mHeartbeatInvokerShort.getInterval());
        L.info(this, "start heart beat invoker for mbsdkdo short.", new Object[0]);
    }

    private void resetHeartbeatReportShort(long delayMs) {
        try {
            if (this.mHeartbeatInvokerShort != null && this.mHeartbeatInvokerShort.running()) {
                this.mHeartbeatInvokerShort.stop();
                this.mHeartbeatInvokerShort.start(delayMs);
            }
        }
        catch (Throwable e) {
            L.error(this, "resetHeartbeatReportShort exception = %s", e);
        }
    }

    @Override
    public void updateOnlineConfigs(final Context context) {
        ThreadPool.getPool().executeQueue(new Runnable(){

            @Override
            public void run() {
                Context c;
                Context context2 = c = context == null ? HiidoSDKNew.this.mContext : context;
                if (c == null || mOnLineConfigController == null) {
                    L.warn(this, "updateOnlineConfigs error,Input context is null", new Object[0]);
                    return;
                }
                mOnLineConfigController.updateOnlineConfigs(c, HiidoSDKNew.this.getAppKey());
            }
        });
    }

    @Override
    public String getOnlineConfigParams(Context context, String onlineKey) {
        Context c;
        Context context2 = c = context == null ? this.mContext : context;
        if (c == null) {
            L.warn(this, "getOnlineConfigParams error,Input context is null", new Object[0]);
            return null;
        }
        if (!mIsInit) {
            L.warn(this, "getOnlineConfigParams error,not init sdk?", new Object[0]);
            return null;
        }
        return mOnLineConfigController.getOnlineConfigParams(c, onlineKey);
    }

    @Override
    public void setOnLineConfigListener(final OnLineConfigListener onLineConfigListener) {
        ThreadPool.getPool().executeQueue(new Runnable(){

            @Override
            public void run() {
                if (!HiidoSDKNew.this.checkSDKInit()) {
                    return;
                }
                mOnLineConfigController.setOnLineConfigListener(onLineConfigListener);
            }
        });
    }

    @Override
    public String getAppId() {
        return this.config.getAppId();
    }

    @Override
    public String getAppKey() {
        return this.config.getAppkey();
    }

    @Override
    public String getFrom() {
        return this.config.getFrom();
    }

    private void startCrashMonitor() {
        if (this.config.isOpenCrashMonitor()) {
            if (this.mCrashController != null) {
                L.warn(this, "crash monitor has been started.", new Object[0]);
                return;
            }
            this.mCrashController = new CrashController(this.getContext(), this.mStatisAPI, this.mOnStatisListener, new CrashController.OnCrashListener(){

                @Override
                public void handler(JSONObject json) {
                    ThreadPool.getPool().execute(new Runnable(){

                        @Override
                        public void run() {
                            HiidoSDKNew.this.quitApp(false);
                        }
                    });
                }
            });
            this.mCrashController.startCrashMonitor();
        }
    }

    private String getPageId(Activity activity) {
        if (activity != null) {
            return activity.getClass().getName();
        }
        return "";
    }

    @Override
    public StatisAPI createNewStatisApi() {
        StatisAPI sApi = new StatisAPI();
        sApi.setAbroad(HiidoSDK.instance().getOptions().isAbroad);
        sApi.setTestServer(HiidoSDK.instance().getOptions().testServer);
        sApi.setBusinessType(HiidoSDK.instance().getOptions().businessType);
        return sApi;
    }

    @Override
    public void addActAdditionListener(ActListener listener) {
        if (!this.checkSDKInit()) {
            return;
        }
        this.mStatisAPI.addActAdditionListener(listener);
    }

    @Override
    public void setAdditionParamsDelegate(HiidoSdkAdditionDelegate hiidoSdkAdditionDelegate) {
        if (!this.checkSDKInit()) {
            return;
        }
        this.mStatisAPI.setAdditionParamsDelegate(hiidoSdkAdditionDelegate);
    }

    @Override
    public void removeActAdditionListerner(ActListener listener) {
        if (!this.checkSDKInit()) {
            return;
        }
        this.mStatisAPI.removeActAdditionListener(listener);
    }

    @Override
    public StatisOption getStatisOption() {
        return this.mStatisOption;
    }

    @Override
    public OnStatisListener getOnStatisListener() {
        return this.mOnStatisListener;
    }

    @Override
    public String getDeviceId(Context context) {
        return CommonFiller.getIMEI(context);
    }

    @Override
    public String getMac(Context context) {
        return CommonFiller.getMacAddr(context);
    }

    @Override
    @Deprecated
    public String getHdid(Context context) {
        return DeviceProxy.getHdid(context);
    }

    @Override
    public void getHdid(final Context context, final HiidoSDK.HdidReceiver receiver) {
        ThreadPool.getPool().execute(new Runnable(){

            @Override
            public void run() {
                String hdid = DeviceProxy.getHdid(context);
                if (receiver != null) {
                    receiver.onHdidReceived(hdid);
                }
            }
        });
    }

    @Override
    public boolean reportFeedBack(String cont, String link, String remk) {
        String fbId = null;
        try {
            fbId = Coder.encryptMD5(UUID.randomUUID().toString());
        }
        catch (Throwable e) {
            L.error(this, e.getMessage(), new Object[0]);
        }
        if (!this.checkSDKInit()) {
            return false;
        }
        this.mStatisAPI.reportFeedback(this.mOnStatisListener.getCurrentUid(), fbId, cont, link, remk, null);
        return true;
    }

    @Override
    public void reportLocation(double longitude, double latitude, double altitude) {
        if (!this.checkSDKInit()) {
            return;
        }
        this.mStatisAPI.reportLocation(this.mOnStatisListener.getCurrentUid(), longitude, latitude, altitude, null);
    }

    @Override
    public void reportPushToken(String token) {
        if (!this.checkSDKInit()) {
            return;
        }
        this.mStatisAPI.reportPushToken(this.mOnStatisListener.getCurrentUid(), token);
    }

    @Override
    public MetricsWorker addMetricsWorker(String workName, long interval) {
        if (!this.checkSDKInit()) {
            return null;
        }
        return this.metricsHandler.addMetricsWorker(workName, interval);
    }

    @Override
    public void reportReturnCode(int scode, String uri, long timeConsumption, String code, Map<String, String> moreinfo) {
        if (!this.checkSDKInit()) {
            return;
        }
        if (!this.metricsHandler.containMetric(DEFAULT_METRICS_NAME)) {
            this.metricsHandler.addMetricsWorker(DEFAULT_METRICS_NAME, HiidoSDK.instance().getOptions().defaultMetricsInterval);
        }
        this.metricsHandler.reportReturnCode(DEFAULT_METRICS_NAME, scode, uri, timeConsumption, code, moreinfo);
    }

    @Override
    public void reportCount(int scode, String uri, String countName, long count) {
        if (!this.checkSDKInit()) {
            return;
        }
        if (!this.metricsHandler.containMetric(DEFAULT_METRICS_NAME)) {
            this.metricsHandler.addMetricsWorker(DEFAULT_METRICS_NAME, HiidoSDK.instance().getOptions().defaultMetricsInterval);
        }
        this.metricsHandler.reportCount(DEFAULT_METRICS_NAME, scode, uri, countName, count);
    }

    @Override
    public void reportCount(int scode, String uri, String countName, long count, int times) {
        if (!this.checkSDKInit()) {
            return;
        }
        if (!this.metricsHandler.containMetric(DEFAULT_METRICS_NAME)) {
            this.metricsHandler.addMetricsWorker(DEFAULT_METRICS_NAME, HiidoSDK.instance().getOptions().defaultMetricsInterval);
        }
        this.metricsHandler.reportCount(DEFAULT_METRICS_NAME, scode, uri, countName, count, times);
    }

    @Override
    public void reportReturnCode(String metricsName, int scode, String uri, long timeConsumption, String code, Map<String, String> moreinfo) {
        if (!this.checkSDKInit()) {
            return;
        }
        this.metricsHandler.reportReturnCode(metricsName, scode, uri, timeConsumption, code, moreinfo);
    }

    public void reportCount(String metricsName, int scode, String uri, String countName, long count) {
        if (!this.checkSDKInit()) {
            return;
        }
        this.metricsHandler.reportCount(metricsName, scode, uri, countName, count);
    }

    @Override
    public void reportCount(String metricsName, int scode, String uri, String countName, long count, int times) {
        if (!this.checkSDKInit()) {
            return;
        }
        this.metricsHandler.reportCount(metricsName, scode, uri, countName, count, times);
    }

    @Override
    public void reportSrcData(int scode, String uri, String topic, long val, Map<String, String> extra) {
        if (!this.checkSDKInit()) {
            return;
        }
        if (!this.metricsHandler.containMetric(DEFAULT_METRICS_NAME)) {
            this.metricsHandler.addMetricsWorker(DEFAULT_METRICS_NAME, HiidoSDK.instance().getOptions().defaultMetricsInterval);
        }
        this.metricsHandler.reportSrcData(DEFAULT_METRICS_NAME, scode, uri, topic, val, extra);
    }

    @Override
    public void reportSrcData(String metricsName, int scode, String uri, String topic, long val, Map<String, String> extra) {
        if (!this.checkSDKInit()) {
            return;
        }
        this.metricsHandler.reportSrcData(metricsName, scode, uri, topic, val, extra);
    }

    @Override
    public void beginSession(String session, String act, long globePeriod, Map<String, Long> period) {
        this.sessionReport.beginSession(session, act, globePeriod, period);
    }

    @Override
    public boolean pushToSession(String session, String eventId, List<EventValue> values, Map<String, String> dimens, Map<String, String> extra) {
        return this.sessionReport.pushToSession(session, eventId, values, dimens, extra);
    }

    @Override
    public boolean pushToSession(String session, String eventId, CalAction cal, String key, Number value, Map<String, String> dimens, Map<String, String> extra) {
        return this.sessionReport.pushToSession(session, eventId, cal, key, value, dimens, extra);
    }

    @Override
    public boolean flushSession(String session, String eventId) {
        return this.sessionReport.flushSession(session, eventId);
    }

    @Override
    public boolean flushSessionAll(String session, Set<String> ignoreEvent) {
        return this.sessionReport.flushSessionAll(session, ignoreEvent);
    }

    @Override
    public void closeSession(String session) {
        this.sessionReport.closeSession(session);
    }

    static {
        mIsInit = false;
    }

    public static interface HdidReceiver {
        public void onHdidReceived(String var1);
    }

    private class QuitTimer {
        private final Runnable mQuitTimer = new Runnable(){

            @Override
            public void run() {
                HiidoSDKNew.this.quitApp(true);
            }
        };

        private QuitTimer() {
        }

        public void startQuitTimer() {
            HiidoSDKNew.this.mHandler.postDelayed(this.mQuitTimer, HiidoSDK.instance().getOptions().backgroundDurationMillisAsQuit);
        }

        public void clearQuitTimer() {
            HiidoSDKNew.this.mHandler.removeCallbacks(this.mQuitTimer);
        }
    }
}

