/*
 * Decompiled with CFR 0.152.
 */
package com.yy.hiidostatis.message.module.sessionreport;

import com.yy.hiidostatis.inner.util.SharedThreadTimer;
import com.yy.hiidostatis.inner.util.SharedTimerTask;
import com.yy.hiidostatis.message.SessionReport;
import com.yy.hiidostatis.message.SessionReportWrapper;
import com.yy.hiidostatis.message.module.sessionreport.CalAction;
import com.yy.hiidostatis.message.module.sessionreport.CalValue;
import com.yy.hiidostatis.message.module.sessionreport.CommonSessionState;
import com.yy.hiidostatis.message.module.sessionreport.EventValue;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;

public class SessionReportWrapperImpl
implements SessionReportWrapper,
SessionReport.AfterFlush,
SessionReport.Processor {
    private SessionReport sessionReport;
    private SharedThreadTimer globeTimer;
    private Map<String, Set<String>> exclude = new ConcurrentHashMap<String, Set<String>>();
    private Map<Long, OnTimer> cache = new HashMap<Long, OnTimer>();
    private Set<String> sessions = new HashSet<String>();

    public SessionReportWrapperImpl(SessionReport sessionReport) {
        this.sessionReport = sessionReport;
    }

    private synchronized boolean sessionClosed(String session) {
        return !this.sessions.contains(session);
    }

    @Override
    public synchronized void beginSession(String session, String act, long globePeriod, Map<String, Long> period) {
        this.sessionReport.beginSession(session, act, this, this);
        this.sessions.add(session);
        if (globePeriod > 0L) {
            OnTimer ot = this.cache.get(globePeriod);
            if (ot == null) {
                ot = new OnTimer();
                ot.addGlobe(session);
                this.cache.put(globePeriod, ot);
                if (this.globeTimer == null) {
                    this.globeTimer = new SharedThreadTimer();
                }
                this.globeTimer.schedule((SharedTimerTask)ot, globePeriod, globePeriod);
            } else {
                ot.addGlobe(session);
            }
        }
        if (period != null) {
            HashMap<Long, OnTimer> addTimer = new HashMap<Long, OnTimer>();
            HashSet<String> eid = new HashSet<String>();
            for (Map.Entry<String, Long> entry : period.entrySet()) {
                OnTimer ot = this.cache.get(entry.getValue());
                if (ot == null) {
                    ot = new OnTimer();
                    this.cache.put(entry.getValue(), ot);
                    addTimer.put(entry.getValue(), ot);
                }
                ot.addEventId(session, entry.getKey());
                eid.add(entry.getKey());
            }
            if (globePeriod > 0L) {
                this.exclude.put(session, eid);
            }
            if (this.globeTimer == null) {
                this.globeTimer = new SharedThreadTimer();
            }
            for (Map.Entry<String, Long> entry : addTimer.entrySet()) {
                this.globeTimer.schedule((SharedTimerTask)((Object)entry.getValue()), (Long)((Object)entry.getKey()), (long)((Long)((Object)entry.getKey())));
            }
        }
    }

    @Override
    public boolean pushToSession(String session, String eventId, List<EventValue> values, Map<String, String> dimens, Map<String, String> extra) {
        for (EventValue ev : values) {
            ev.dimens = dimens;
            ev.extra = extra;
            this.sessionReport.pushToSession(session, eventId, ev);
        }
        return true;
    }

    @Override
    public boolean pushToSession(String session, String eventId, CalAction cal, String key, Number value, Map<String, String> dimens, Map<String, String> extra) {
        EventValue ev = new EventValue(cal, key, value);
        ev.dimens = dimens;
        ev.extra = extra;
        return this.sessionReport.pushToSession(session, eventId, ev);
    }

    @Override
    public boolean flushSession(String session, String eventId) {
        return this.sessionReport.flushSession(session, eventId);
    }

    public boolean flushSessionAll(String session) {
        return this.flushSessionAll(session, null);
    }

    @Override
    public boolean flushSessionAll(String session, Set<String> ignoreEvent) {
        return this.sessionReport.flushSessionAll(session, ignoreEvent);
    }

    @Override
    public void closeSession(String session) {
        this.sessionReport.closeSession(session);
        this.exclude.remove(session);
        this.removeSession(session);
    }

    private synchronized void removeSession(String session) {
        this.sessions.remove(session);
    }

    public SessionReport.StatisContentAble reset(String type, SessionReport.StatisContentAble oldState) {
        return null;
    }

    public SessionReport.StatisContentAble process(SessionReport.StatisContentAble oldState, String type, Object obj) {
        String identification;
        CalValue curValue;
        EventValue ev = (EventValue)obj;
        CommonSessionState state = (CommonSessionState)oldState;
        if (state == null) {
            state = new CommonSessionState();
        }
        if ((curValue = state.get(identification = ev.dimIdentification(), ev.key)) == null) {
            curValue = new CalValue();
        }
        CalValue newState = ev.calAction.cal(ev.value, curValue);
        state.put(identification, ev.key, newState, ev.extra);
        return state;
    }

    public class OnTimer
    extends SharedTimerTask {
        Map<String, List<String>> eventIds = new HashMap<String, List<String>>();
        Set<String> globe = new HashSet<String>();

        public synchronized void addEventId(String session, String ev) {
            List<String> ss = this.eventIds.get(session);
            if (ss == null) {
                ss = new ArrayList<String>();
                this.eventIds.put(session, ss);
            }
            ss.add(ev);
        }

        public synchronized void addGlobe(String session) {
            this.globe.add(session);
        }

        @Override
        public synchronized void run() {
            ArrayList<String> needRemove = new ArrayList<String>();
            for (String string : this.globe) {
                if (SessionReportWrapperImpl.this.sessionClosed(string)) {
                    needRemove.add(string);
                    continue;
                }
                Set ex = (Set)SessionReportWrapperImpl.this.exclude.get(string);
                SessionReportWrapperImpl.this.sessionReport.flushSessionAll(string, ex);
            }
            for (Map.Entry entry : this.eventIds.entrySet()) {
                if (SessionReportWrapperImpl.this.sessionClosed((String)entry.getKey())) {
                    needRemove.add((String)entry.getKey());
                    continue;
                }
                for (String eid : (List)entry.getValue()) {
                    SessionReportWrapperImpl.this.sessionReport.flushSession((String)entry.getKey(), eid);
                }
            }
            for (String string : needRemove) {
                this.globe.remove(string);
                this.eventIds.remove(string);
            }
        }
    }
}

