/*
 * Decompiled with CFR 0.152.
 */
package com.yy.hiidostatis.message.module.sessionreport;

import com.yy.hiidostatis.api.StatisContent;
import com.yy.hiidostatis.message.Packer;
import com.yy.hiidostatis.message.SessionReport;
import com.yy.hiidostatis.message.utils.NoNull;
import com.yy.hiidostatis.provider.MessageConfig;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;

public class SessionReportImpl
implements SessionReport {
    private MessageConfig config;
    private Packer packer;
    private Map<String, Session> sessions = new ConcurrentHashMap<String, Session>();

    public SessionReportImpl(MessageConfig config, Packer packer) {
        this.config = config;
        this.packer = packer;
    }

    @Override
    public void beginSession(String session, String act, SessionReport.Processor processor, SessionReport.AfterFlush flush) {
        Session ss = new Session(session, act, processor, flush);
        this.sessions.put(session, ss);
    }

    @Override
    public boolean pushToSession(String session, String type, Object obj) {
        Session ss = this.sessions.get(session);
        if (ss != null) {
            return ss.pushToSession(type, obj);
        }
        return false;
    }

    @Override
    public boolean flushSession(String session, String type) {
        Session ss = this.sessions.get(session);
        if (ss == null) {
            return false;
        }
        ss.flushSession(type);
        return true;
    }

    @Override
    public boolean flushSessionAll(String session) {
        return this.flushSessionAll(session, null);
    }

    @Override
    public boolean flushSessionAll(String session, Set<String> exclude) {
        Session ss = this.sessions.get(session);
        if (ss == null) {
            return false;
        }
        ArrayList entries = new ArrayList(ss.values.entrySet());
        for (Map.Entry entry : entries) {
            if (exclude != null && exclude.contains(entry.getKey())) continue;
            ss.flushSession((String)entry.getKey());
        }
        return true;
    }

    @Override
    public void closeSession(String session) {
        Session ss = this.sessions.remove(session);
        if (ss == null) {
            return;
        }
        ss.close();
    }

    private class Session {
        private final SessionReport.Processor processor;
        private final SessionReport.AfterFlush afterFlush;
        private Map<String, SessionReport.StatisContentAble> values = new HashMap<String, SessionReport.StatisContentAble>();
        private final String act;
        private final String session;

        Session(String session, String act, SessionReport.Processor processor, SessionReport.AfterFlush afterFlush) {
            this.session = session;
            this.act = act;
            this.processor = processor;
            this.afterFlush = afterFlush;
        }

        synchronized boolean pushToSession(String type, Object obj) {
            try {
                SessionReport.StatisContentAble state = this.values.get(type);
                SessionReport.StatisContentAble nstate = this.processor.process(state, type, obj);
                this.values.put(type, nstate);
                return true;
            }
            catch (Exception e) {
                e.printStackTrace();
                return false;
            }
        }

        private void send(String type, SessionReport.StatisContentAble kv) {
            List<StatisContent> data = kv.toStatisContent(this.act, type);
            if (data != null && !data.isEmpty()) {
                for (StatisContent sc : data) {
                    sc.put("session", this.session);
                    SessionReportImpl.this.packer.addMessage(sc);
                }
            }
        }

        private synchronized void flushSession(String type) {
            SessionReport.StatisContentAble kv = this.values.get(type);
            if (kv == null) {
                return;
            }
            this.send(type, kv);
            if (this.afterFlush != null) {
                SessionReport.StatisContentAble nkv = this.afterFlush.reset(type, kv);
                if (nkv == null) {
                    this.values.remove(type);
                } else {
                    this.values.put(type, nkv);
                }
            }
        }

        public void close() {
            if (!NoNull.isEmpty(this.values)) {
                try {
                    for (Map.Entry<String, SessionReport.StatisContentAble> able : this.values.entrySet()) {
                        this.send(able.getKey(), able.getValue());
                    }
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            }
        }
    }
}

