/*
 * Decompiled with CFR 0.152.
 */
package com.yy.hiidostatis.message.module.sessionreport;

import com.yy.hiidostatis.api.StatisContent;
import com.yy.hiidostatis.message.SessionReport;
import com.yy.hiidostatis.message.module.sessionreport.CalValue;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

class CommonSessionState
implements SessionReport.StatisContentAble {
    private volatile Map<String, Map<String, CalValue>> stateStore = new HashMap<String, Map<String, CalValue>>();
    private volatile Map<String, Map<String, String>> extras = new HashMap<String, Map<String, String>>();

    public CalValue get(String dim, String key) {
        Map<String, CalValue> ret = this.stateStore.get(dim);
        if (ret != null) {
            return ret.get(key);
        }
        return null;
    }

    public void put(String dim, String key, CalValue value, Map<String, String> extra) {
        Map<String, CalValue> map = this.stateStore.get(dim);
        if (map == null) {
            map = new HashMap<String, CalValue>();
            this.stateStore.put(dim, map);
        }
        map.put(key, value);
        if (extra != null && !extra.isEmpty()) {
            this.extras.put(dim, extra);
        }
    }

    @Override
    public List<StatisContent> toStatisContent(String act, String type) {
        Map<String, Map<String, CalValue>> tempStore = this.stateStore;
        Map<String, Map<String, String>> ex = this.extras;
        this.stateStore = new HashMap<String, Map<String, CalValue>>();
        this.extras = new HashMap<String, Map<String, String>>();
        ArrayList<StatisContent> ret = new ArrayList<StatisContent>();
        for (Map.Entry<String, Map<String, CalValue>> one : tempStore.entrySet()) {
            try {
                Map<String, String> extraParams;
                StatisContent sc = new StatisContent(act);
                sc.put("eventid", type);
                if (!one.getKey().isEmpty()) {
                    String[] ds = one.getKey().split(",");
                    for (int i = 0; i < ds.length; ++i) {
                        String[] stringArray = ds[i].split("=");
                        try {
                            sc.put(stringArray[0], stringArray[1]);
                            continue;
                        }
                        catch (Exception e) {
                            e.printStackTrace();
                        }
                    }
                }
                if ((extraParams = ex.get(one.getKey())) != null && !extraParams.isEmpty()) {
                    for (Map.Entry<String, String> entry : extraParams.entrySet()) {
                        sc.put(entry.getKey(), entry.getValue());
                    }
                }
                for (Map.Entry<String, CalValue> entry : one.getValue().entrySet()) {
                    if (entry.getValue().value instanceof Long) {
                        sc.put(entry.getKey(), entry.getValue().value.longValue());
                        continue;
                    }
                    sc.put(entry.getKey(), entry.getValue().value.doubleValue());
                }
                ret.add(sc);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        return ret;
    }

    public void clear() {
        this.stateStore.clear();
        this.extras.clear();
    }
}

