/*
 * Decompiled with CFR 0.152.
 */
package com.yy.hiidostatis.inner.util.hdid;

import android.content.ComponentName;
import android.content.Context;
import android.content.Intent;
import android.content.ServiceConnection;
import android.content.pm.PackageManager;
import android.os.IBinder;
import android.os.IInterface;
import android.os.Looper;
import android.os.Parcel;
import android.os.RemoteException;
import com.yy.hiidostatis.inner.util.log.L;
import java.io.IOException;
import java.lang.reflect.Method;
import java.util.concurrent.LinkedBlockingQueue;

public class GAIDClient {
    private static AdInfo mAdInfo = null;

    public static AdInfo getAdvertisingIdInfo(Context context) throws Exception {
        if (Looper.myLooper() == Looper.getMainLooper()) {
            throw new IllegalStateException("Cannot be called from the main thread");
        }
        try {
            PackageManager pm = context.getPackageManager();
            pm.getPackageInfo("com.android.vending", 0);
        }
        catch (Throwable e) {
            throw new Exception(e);
        }
        AdvertisingConnection connection = new AdvertisingConnection();
        Intent intent = new Intent("com.google.android.gms.ads.identifier.service.START");
        intent.setPackage("com.google.android.gms");
        if (context.bindService(intent, (ServiceConnection)connection, 1)) {
            try {
                AdInfo adInfo;
                AdvertisingInterface adInterface = new AdvertisingInterface(connection.getBinder());
                AdInfo adInfo2 = adInfo = new AdInfo(adInterface.getId(), adInterface.isLimitAdTrackingEnabled(true));
                return adInfo2;
            }
            catch (Throwable exception) {
                throw new Exception(exception);
            }
            finally {
                context.unbindService((ServiceConnection)connection);
            }
        }
        throw new IOException("Google Play connection failed");
    }

    public static AdInfo getAdvertisingIdInfoReflect(Context context) {
        try {
            Class<?> AdvertisingIdClient = Class.forName("com.google.android.gms.ads.identifier.AdvertisingIdClient");
            Method getAdvertisingIdInfoMethod = AdvertisingIdClient.getMethod("getAdvertisingIdInfo", Context.class);
            Object adInfoObj = getAdvertisingIdInfoMethod.invoke(null, context);
            if (adInfoObj != null) {
                Class<?> adInfoClass = Class.forName("com.google.android.gms.ads.identifier.AdvertisingIdClient$Info");
                Method getId = adInfoClass.getMethod("getId", new Class[0]);
                Method isLimitAdTrackingEnabled = adInfoClass.getMethod("isLimitAdTrackingEnabled", new Class[0]);
                String gaid = (String)getId.invoke(adInfoObj, new Object[0]);
                boolean isLimit = (Boolean)isLimitAdTrackingEnabled.invoke(adInfoObj, (Object[])null);
                return new AdInfo(gaid, isLimit);
            }
        }
        catch (Throwable e) {
            e.printStackTrace();
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String getGAID(Context context) {
        if (mAdInfo != null) {
            return mAdInfo.getId();
        }
        Class<GAIDClient> clazz = GAIDClient.class;
        synchronized (GAIDClient.class) {
            if (mAdInfo != null) {
                // ** MonitorExit[var1_1] (shouldn't be in output)
                return mAdInfo.advertisingId;
            }
            mAdInfo = GAIDClient.init(context);
            // ** MonitorExit[var1_1] (shouldn't be in output)
            return mAdInfo.getId();
        }
    }

    private static AdInfo init(Context context) {
        AdInfo adInfo = null;
        try {
            adInfo = GAIDClient.getAdvertisingIdInfoReflect(context);
            if (adInfo == null) {
                adInfo = GAIDClient.getAdvertisingIdInfo(context);
                if (adInfo != null) {
                    L.brief("getAdvertisingIdInfo succeed. gaid=%s,isLimitAdTrackingEnabled=%b", adInfo.getId(), adInfo.isLimitAdTrackingEnabled());
                }
            } else {
                L.brief("getAdvertisingIdInfoReflect succeed. gaid=%s,isLimitAdTrackingEnabled=%b", adInfo.getId(), adInfo.isLimitAdTrackingEnabled());
            }
        }
        catch (Throwable e) {
            e.printStackTrace();
        }
        if (adInfo == null) {
            L.brief("get gaid failed, create null AdInfo ", new Object[0]);
            adInfo = new AdInfo(null, false);
        }
        return adInfo;
    }

    private static final class AdvertisingInterface
    implements IInterface {
        private IBinder binder;

        public AdvertisingInterface(IBinder pBinder) {
            this.binder = pBinder;
        }

        public IBinder asBinder() {
            return this.binder;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public String getId() throws RemoteException {
            String id;
            Parcel data = Parcel.obtain();
            Parcel reply = Parcel.obtain();
            try {
                data.writeInterfaceToken("com.google.android.gms.ads.identifier.internal.IAdvertisingIdService");
                this.binder.transact(1, data, reply, 0);
                reply.readException();
                id = reply.readString();
            }
            finally {
                reply.recycle();
                data.recycle();
            }
            return id;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public boolean isLimitAdTrackingEnabled(boolean paramBoolean) throws RemoteException {
            boolean limitAdTracking;
            Parcel data = Parcel.obtain();
            Parcel reply = Parcel.obtain();
            try {
                data.writeInterfaceToken("com.google.android.gms.ads.identifier.internal.IAdvertisingIdService");
                data.writeInt(paramBoolean ? 1 : 0);
                this.binder.transact(2, data, reply, 0);
                reply.readException();
                limitAdTracking = 0 != reply.readInt();
            }
            finally {
                reply.recycle();
                data.recycle();
            }
            return limitAdTracking;
        }
    }

    private static final class AdvertisingConnection
    implements ServiceConnection {
        boolean retrieved = false;
        private final LinkedBlockingQueue<IBinder> queue = new LinkedBlockingQueue(1);

        private AdvertisingConnection() {
        }

        public void onServiceConnected(ComponentName name, IBinder service) {
            try {
                this.queue.put(service);
            }
            catch (InterruptedException e) {
                L.error(this, e.getMessage(), new Object[0]);
            }
        }

        public void onServiceDisconnected(ComponentName name) {
        }

        public IBinder getBinder() throws InterruptedException {
            if (this.retrieved) {
                throw new IllegalStateException();
            }
            this.retrieved = true;
            return this.queue.take();
        }
    }

    public static final class AdInfo {
        private final String advertisingId;
        private final boolean limitAdTrackingEnabled;

        AdInfo(String advertisingId, boolean limitAdTrackingEnabled) {
            this.advertisingId = advertisingId;
            this.limitAdTrackingEnabled = limitAdTrackingEnabled;
        }

        public String getId() {
            return this.advertisingId;
        }

        public boolean isLimitAdTrackingEnabled() {
            return this.limitAdTrackingEnabled;
        }
    }
}

