/*
 * Decompiled with CFR 0.152.
 */
package com.yy.hiidostatis.inner.util;

import android.annotation.SuppressLint;
import android.content.Context;
import android.content.SharedPreferences;
import android.os.Build;
import com.yy.hiidostatis.inner.util.ProcessUtil;
import java.util.Map;

@SuppressLint(value={"NewApi"})
public class Preference {
    private String name;
    private boolean isBindProcess = false;
    private Object obj = new Object();
    private SharedPreferences cacheSp = null;

    public Preference(String name) {
        this.name = name;
    }

    public Preference(String name, boolean isBindProcess) {
        this.name = name;
        this.isBindProcess = isBindProcess;
    }

    public String getPrefString(Context context, String key, String defaultValue) {
        SharedPreferences settings = this.getSharedPreferences(context);
        return settings.getString(key, defaultValue);
    }

    public void setPrefString(Context context, String key, String value) {
        SharedPreferences settings = this.getSharedPreferences(context);
        if (Build.VERSION.SDK_INT >= 9) {
            settings.edit().putString(key, value).apply();
        } else {
            settings.edit().putString(key, value).commit();
        }
    }

    public boolean getPrefBoolean(Context context, String key, boolean defaultValue) {
        SharedPreferences settings = this.getSharedPreferences(context);
        return settings.getBoolean(key, defaultValue);
    }

    public boolean hasKey(Context context, String key) {
        return this.getSharedPreferences(context).contains(key);
    }

    public void setPrefBoolean(Context context, String key, boolean value) {
        SharedPreferences settings = this.getSharedPreferences(context);
        if (Build.VERSION.SDK_INT >= 9) {
            settings.edit().putBoolean(key, value).apply();
        } else {
            settings.edit().putBoolean(key, value).commit();
        }
    }

    public void setPrefInt(Context context, String key, int value) {
        SharedPreferences settings = this.getSharedPreferences(context);
        if (Build.VERSION.SDK_INT >= 9) {
            settings.edit().putInt(key, value).apply();
        } else {
            settings.edit().putInt(key, value).commit();
        }
    }

    public int getPrefInt(Context context, String key, int defaultValue) {
        SharedPreferences settings = this.getSharedPreferences(context);
        return settings.getInt(key, defaultValue);
    }

    public void setPrefFloat(Context context, String key, float value) {
        SharedPreferences settings = this.getSharedPreferences(context);
        if (Build.VERSION.SDK_INT >= 9) {
            settings.edit().putFloat(key, value).apply();
        } else {
            settings.edit().putFloat(key, value).commit();
        }
    }

    public float getPrefFloat(Context context, String key, float defaultValue) {
        SharedPreferences settings = this.getSharedPreferences(context);
        return settings.getFloat(key, defaultValue);
    }

    public void setPrefLong(Context context, String key, long value) {
        SharedPreferences settings = this.getSharedPreferences(context);
        if (Build.VERSION.SDK_INT >= 9) {
            settings.edit().putLong(key, value).apply();
        } else {
            settings.edit().putLong(key, value).commit();
        }
    }

    public long getPrefLong(Context context, String key, long defaultValue) {
        SharedPreferences settings = this.getSharedPreferences(context);
        return settings.getLong(key, defaultValue);
    }

    public Map<String, ?> getAll(Context context) {
        SharedPreferences settings = this.getSharedPreferences(context);
        return settings.getAll();
    }

    public void clearPreference(Context context) {
        SharedPreferences settings = this.getSharedPreferences(context);
        SharedPreferences.Editor editor = settings.edit();
        editor.clear();
        if (Build.VERSION.SDK_INT >= 9) {
            editor.apply();
        } else {
            editor.commit();
        }
    }

    public void clearKey(Context context, String key) {
        SharedPreferences settings = this.getSharedPreferences(context);
        SharedPreferences.Editor editor = settings.edit();
        editor.remove(key);
        if (Build.VERSION.SDK_INT >= 9) {
            editor.apply();
        } else {
            editor.commit();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private SharedPreferences getSharedPreferences(Context context) {
        if (this.cacheSp != null) {
            return this.cacheSp;
        }
        Object object = this.obj;
        synchronized (object) {
            if (this.cacheSp != null) {
                return this.cacheSp;
            }
            String newFileName = this.isBindProcess ? ProcessUtil.getFileNameBindProcess(context, this.name) : this.name;
            this.cacheSp = context.getSharedPreferences(newFileName, 0);
            return this.cacheSp;
        }
    }
}

