/*
 * Decompiled with CFR 0.152.
 */
package com.yy.hiidostatis.inner.util;

import android.annotation.SuppressLint;
import android.content.Context;
import android.os.Build;
import android.telephony.TelephonyManager;
import com.yy.hiidostatis.api.HiidoSDK;
import com.yy.hiidostatis.inner.util.ArdUtil;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.lang.reflect.Method;
import java.util.ArrayList;

public class FindEmulator {
    private static boolean isEmulator = false;
    private static boolean isCheck = false;
    private static int emurs;
    private static final String[] known_numbers;
    private static final String[] known_device_ids;
    private static final String[] known_imsi_ids;
    private static final String[] known_pipes;
    private static final String[] known_files;
    private static final String[] known_geny_files;
    private static final String[] known_qemu_drivers;

    public static boolean hasPipes() {
        for (String pipe : known_pipes) {
            File qemu_socket = new File(pipe);
            if (!qemu_socket.exists()) continue;
            return true;
        }
        return false;
    }

    public static boolean hasQEmuFiles() {
        for (String pipe : known_files) {
            File qemu_file = new File(pipe);
            if (!qemu_file.exists()) continue;
            return true;
        }
        return false;
    }

    public static boolean hasGenyFiles() {
        for (String file : known_geny_files) {
            File geny_file = new File(file);
            if (!geny_file.exists()) continue;
            return true;
        }
        return false;
    }

    public static boolean hasQEmuDrivers() {
        for (File drivers_file : new File[]{new File("/proc/tty/drivers"), new File("/proc/cpuinfo")}) {
            if (!drivers_file.exists() || !drivers_file.canRead()) continue;
            byte[] data = new byte[1024];
            try {
                FileInputStream is = new FileInputStream(drivers_file);
                ((InputStream)is).read(data);
                ((InputStream)is).close();
            }
            catch (Throwable exception) {
                exception.printStackTrace();
            }
            String driver_data = new String(data);
            for (String known_qemu_driver : known_qemu_drivers) {
                if (driver_data.indexOf(known_qemu_driver) == -1) continue;
                return true;
            }
        }
        return false;
    }

    public static boolean hasKnownDeviceId(Context context) {
        if (HiidoSDK.instance().isUserAgreed() && ArdUtil.checkPermissions(context, "android.permission.READ_PHONE_STATE")) {
            TelephonyManager telephonyManager = (TelephonyManager)context.getSystemService("phone");
            String deviceId = telephonyManager.getDeviceId();
            for (String known_deviceId : known_device_ids) {
                if (!known_deviceId.equalsIgnoreCase(deviceId)) continue;
                return true;
            }
        }
        return false;
    }

    public static boolean hasKnownImsi(Context context) {
        if (HiidoSDK.instance().isUserAgreed() && ArdUtil.checkPermissions(context, "android.permission.READ_PHONE_STATE")) {
            TelephonyManager telephonyManager = (TelephonyManager)context.getSystemService("phone");
            String imsi = telephonyManager.getSubscriberId();
            for (String known_imsi : known_imsi_ids) {
                if (!known_imsi.equalsIgnoreCase(imsi)) continue;
                return true;
            }
        }
        return false;
    }

    @SuppressLint(value={"NewApi"})
    public static boolean hasEmulatorBuild(Context context) {
        String BRAND = Build.BRAND;
        String DEVICE = Build.DEVICE;
        String MODEL = Build.MODEL;
        String PRODUCT = Build.PRODUCT;
        if (BRAND.compareTo("generic") == 0 || DEVICE.compareTo("generic") == 0 || MODEL.compareTo("sdk") == 0 || PRODUCT.compareTo("sdk") == 0) {
            return true;
        }
        if (Build.VERSION.SDK_INT >= 8) {
            String HARDWARE = Build.HARDWARE;
            return HARDWARE.compareTo("goldfish") == 0;
        }
        return false;
    }

    public static boolean isOperatorNameAndroid(Context paramContext) {
        String szOperatorName = ((TelephonyManager)paramContext.getSystemService("phone")).getNetworkOperatorName();
        boolean isAndroid = szOperatorName.equalsIgnoreCase("android");
        return isAndroid;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean hasAdbInEmulator() throws IOException {
        boolean adbInEmulator = false;
        try (BufferedReader reader = null;){
            String line;
            reader = new BufferedReader(new InputStreamReader(new FileInputStream("/proc/net/tcp")), 1000);
            reader.readLine();
            ArrayList<tcp> tcpList = new ArrayList<tcp>();
            while ((line = reader.readLine()) != null) {
                tcpList.add(tcp.create(line.split("\\W+")));
            }
            reader.close();
            int adbPort = -1;
            for (tcp tcpItem : tcpList) {
                if (tcpItem.localIp != 0L) continue;
                adbPort = tcpItem.localPort;
                break;
            }
            if (adbPort != -1) {
                for (tcp tcpItem : tcpList) {
                    if (tcpItem.localIp == 0L || tcpItem.localPort != adbPort) continue;
                    adbInEmulator = true;
                }
            }
        }
        return adbInEmulator;
    }

    public static String getProp(Context context, String property) {
        try {
            if (Build.VERSION.SDK_INT > 27) {
                return null;
            }
            ClassLoader classLoader = context.getClassLoader();
            if (classLoader == null) {
                return null;
            }
            Class<?> systemProperties = classLoader.loadClass("android.os.SystemProperties");
            if (systemProperties == null) {
                return null;
            }
            Method get = systemProperties.getMethod("get", String.class);
            if (get == null) {
                return null;
            }
            Object[] params = new Object[]{property};
            return (String)get.invoke(systemProperties, params);
        }
        catch (Throwable e) {
            e.printStackTrace();
            return null;
        }
    }

    public static boolean isEmulator(Context c) {
        FindEmulator.init(c);
        return isEmulator;
    }

    public static int checkEmu(Context c) {
        FindEmulator.init(c);
        return emurs;
    }

    private static void init(Context c) {
        try {
            if (!isCheck) {
                emurs = FindEmulator.checkEmulator(c);
                isEmulator = emurs > 0;
                isCheck = true;
            }
        }
        catch (Throwable e) {
            e.printStackTrace();
        }
    }

    private static int checkEmulator(Context c) {
        try {
            return (FindEmulator.hasKnownDeviceId(c) ? 1 : 0) | (FindEmulator.hasKnownImsi(c) ? 4 : 0) | (FindEmulator.hasEmulatorBuild(c) ? 8 : 0) | (FindEmulator.hasGenyFiles() ? 16 : 0) | (FindEmulator.hasPipes() ? 32 : 0) | (FindEmulator.hasQEmuFiles() ? 64 : 0) | (FindEmulator.hasQEmuDrivers() ? 128 : 0) | (FindEmulator.hasAdbInEmulator() ? 256 : 0);
        }
        catch (Throwable e) {
            return 0;
        }
    }

    static {
        known_numbers = new String[]{"15555215554", "15555215556", "15555215558", "15555215560", "15555215562", "15555215564", "15555215566", "15555215568", "15555215570", "15555215572", "15555215574", "15555215576", "15555215578", "15555215580", "15555215582", "15555215584"};
        known_device_ids = new String[]{"000000000000000", "e21833235b6eef10", "012345678912345"};
        known_imsi_ids = new String[]{"310260000000000"};
        known_pipes = new String[]{"/dev/socket/qemud", "/dev/qemu_pipe"};
        known_files = new String[]{"/system/lib/libc_malloc_debug_qemu.so", "/sys/qemu_trace", "/init.nox.rc", "/ueventd.nox.rc", "/etc/init.nox.sh"};
        known_geny_files = new String[]{"/dev/socket/genyd", "/dev/socket/baseband_genyd"};
        known_qemu_drivers = new String[]{"goldfish"};
    }

    public static class Property {
        public String name;
        public String seek_value;

        public Property(String name, String seek_value) {
            this.name = name;
            this.seek_value = seek_value;
        }
    }

    public static class tcp {
        public int id;
        public long localIp;
        public int localPort;
        public int remoteIp;
        public int remotePort;

        static tcp create(String[] params) {
            return new tcp(params[1], params[2], params[3], params[4], params[5], params[6], params[7], params[8], params[9], params[10], params[11], params[12], params[13], params[14]);
        }

        public tcp(String id, String localIp, String localPort, String remoteIp, String remotePort, String state, String tx_queue, String rx_queue, String tr, String tm_when, String retrnsmt, String uid, String timeout, String inode) {
            this.id = Integer.parseInt(id, 16);
            this.localIp = Long.parseLong(localIp, 16);
            this.localPort = Integer.parseInt(localPort, 16);
        }
    }
}

