/*
 * Decompiled with CFR 0.152.
 */
package com.yy.hiidostatis.inner.implementation;

import android.content.Context;
import android.text.TextUtils;
import com.yy.hiidostatis.inner.BaseStatisContent;
import com.yy.hiidostatis.inner.util.ArdUtil;
import com.yy.hiidostatis.inner.util.DefaultPreference;
import com.yy.hiidostatis.inner.util.InsideMode;
import com.yy.hiidostatis.inner.util.StringUtil;
import com.yy.hiidostatis.inner.util.Util;
import com.yy.hiidostatis.inner.util.cipher.Coder;
import com.yy.hiidostatis.inner.util.hdid.ClientIdProxy;
import com.yy.hiidostatis.inner.util.hdid.DeviceProxy;
import com.yy.hiidostatis.inner.util.hdid.UuidManager;
import java.util.Locale;

public class CommonFiller {
    public static final int ANDROID_OS = 2;
    private static final String KEY_MAGIC = "HiidoYYSystem";
    private static String mMacAddress = null;
    private static final String mMacAddressKey = "PREF_MAC_ADDRESS";
    private static final Object mMacAddressSyncKey = new Object();
    private static String mImei = null;
    private static final String mImeiKey = "PREF_IMEI";
    private static final Object mImeiSyncKey = new Object();
    private static String mArid = null;
    private static final String mAridKey = "PREF_ARID";
    private static final Object mAridSyncKey = new Object();

    public static BaseStatisContent fillCommonAll(Context c, BaseStatisContent content, String act, String sdkver) {
        CommonFiller.fillCommonNew(c, content, act, sdkver);
        CommonFiller.fillConcreteInfoNew(c, content);
        return content;
    }

    public static BaseStatisContent fillKey(BaseStatisContent content, String act) {
        String timeStamp = String.valueOf(Util.wallTimeSec());
        content.put("act", act);
        content.put("time", timeStamp);
        content.put("key", CommonFiller.calKey(act, timeStamp));
        content.put("guid", StringUtil.geneGuid());
        return content;
    }

    public static BaseStatisContent fillCommonNew(Context c, BaseStatisContent content, String act, String sdkver) {
        CommonFiller.fillKey(content, act);
        content.put("imei", CommonFiller.getIMEI(c));
        content.put("mac", CommonFiller.getMacAddr(c));
        content.put("net", ArdUtil.getNetworkTypeNew(c));
        content.put("act", act);
        content.put("sdkver", sdkver);
        content.put("sys", 2);
        content.put("arid", CommonFiller.getAndroidId(c));
        content.put("hdid", DeviceProxy.getHdid(c));
        content.put("opid", ClientIdProxy.getClientId(c));
        content.put("imc", String.format("%s,%s", ArdUtil.getImei(c), CommonFiller.getMacAddr(c)));
        content.put("imsi", ArdUtil.getImsi(c));
        content.put("idfv", UuidManager.fetchUUid(c));
        return content;
    }

    public static void fillConcreteInfoNew(Context c, BaseStatisContent content) {
        content.put("sjp", ArdUtil.getSjp(c));
        content.put("sjm", ArdUtil.getSjm(c));
        content.put("mbos", ArdUtil.getOS());
        content.put("mbl", ArdUtil.getLang());
        content.put("sr", ArdUtil.getScreenResolution(c));
        content.put("ntm", ArdUtil.getNtm(c));
    }

    public static String calKey(String act, String time) {
        StringBuilder sBuilder = new StringBuilder();
        sBuilder.append(act);
        sBuilder.append(time);
        sBuilder.append(KEY_MAGIC);
        String raw = sBuilder.toString();
        sBuilder.setLength(0);
        sBuilder = null;
        try {
            return Coder.encryptMD5(raw).toLowerCase(Locale.getDefault());
        }
        catch (Throwable e) {
            e.printStackTrace();
            return null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String getMacAddr(Context c) {
        if (!TextUtils.isEmpty((CharSequence)mMacAddress)) {
            return mMacAddress;
        }
        mMacAddress = DefaultPreference.getPreference().getPrefString(c, mMacAddressKey, null);
        if (InsideMode.isSafeMac() && !TextUtils.isEmpty((CharSequence)mMacAddress) || ArdUtil.isValidMac(mMacAddress)) {
            return mMacAddress;
        }
        Object object = mMacAddressSyncKey;
        synchronized (object) {
            if (InsideMode.isSafeMac() && !TextUtils.isEmpty((CharSequence)mMacAddress) || ArdUtil.isValidMac(mMacAddress)) {
                return mMacAddress;
            }
            mMacAddress = ArdUtil.getSafeMacAddr(c);
            if (ArdUtil.isValidMac(mMacAddress)) {
                DefaultPreference.getPreference().setPrefString(c, mMacAddressKey, mMacAddress);
                return mMacAddress;
            }
        }
        return mMacAddress == null ? "" : mMacAddress;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String getIMEI(Context c) {
        if (!Util.empty(mImei)) {
            return mImei;
        }
        mImei = DefaultPreference.getPreference().getPrefString(c, mImeiKey, null);
        if (!Util.empty(mImei)) {
            return mImei;
        }
        Object object = mImeiSyncKey;
        synchronized (object) {
            if (!Util.empty(mImei)) {
                return mImei;
            }
            mImei = ArdUtil.getImei(c);
            if (!Util.empty(mImei)) {
                DefaultPreference.getPreference().setPrefString(c, mImeiKey, mImei);
            }
        }
        return mImei;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String getAndroidId(Context c) {
        if (!Util.empty(mArid)) {
            return mArid;
        }
        mArid = DefaultPreference.getPreference().getPrefString(c, mAridKey, null);
        if (!Util.empty(mArid)) {
            return mArid;
        }
        Object object = mAridSyncKey;
        synchronized (object) {
            if (!Util.empty(mArid)) {
                return mArid;
            }
            mArid = ArdUtil.getAndroidId(c);
            if (!Util.empty(mArid)) {
                DefaultPreference.getPreference().setPrefString(c, mAridKey, mArid);
            }
        }
        return mArid;
    }
}

