/*
 * Decompiled with CFR 0.152.
 */
package com.yy.hiidostatis.defs.controller;

import android.content.Context;
import android.os.Build;
import android.os.Process;
import com.yy.hiidostatis.defs.handler.CrashHandler;
import com.yy.hiidostatis.defs.interf.IOnStatisListener;
import com.yy.hiidostatis.defs.interf.IStatisAPI;
import com.yy.hiidostatis.inner.implementation.CommonFiller;
import com.yy.hiidostatis.inner.util.ArdUtil;
import com.yy.hiidostatis.inner.util.DefaultPreference;
import com.yy.hiidostatis.inner.util.FileUtil;
import com.yy.hiidostatis.inner.util.Preference;
import com.yy.hiidostatis.inner.util.ProcessUtil;
import com.yy.hiidostatis.inner.util.StringUtil;
import com.yy.hiidostatis.inner.util.ThreadPool;
import com.yy.hiidostatis.inner.util.Util;
import com.yy.hiidostatis.inner.util.ZipUtil;
import com.yy.hiidostatis.inner.util.hdid.ClientIdProxy;
import com.yy.hiidostatis.inner.util.hdid.DeviceProxy;
import com.yy.hiidostatis.inner.util.hdid.UuidManager;
import com.yy.hiidostatis.inner.util.http.HttpUtil;
import com.yy.hiidostatis.inner.util.log.L;
import com.yy.hiidostatis.pref.HdStatisConfig;
import java.io.File;
import java.io.FilenameFilter;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import org.json.JSONException;
import org.json.JSONObject;

public class CrashController {
    private CrashHandler mCrashHandler;
    private IStatisAPI mStatisAPI;
    private IOnStatisListener mOnStatisListener;
    private OnCrashListener mOnCrashListener;
    private Context mContext;
    private static final String PREF_NAME = "hd_crash_pref";
    private Preference mPreference = new Preference("hd_crash_pref");
    private String mUploadUrl = "https://hdcrash.hiido.com/hdcrash/UploadServlet";
    private static final int EXPIRES_DAY = 5;
    private boolean mIsSpecialDo = false;

    public CrashController(Context context, IStatisAPI statisAPI, IOnStatisListener onStatisListener, OnCrashListener onCrashListener) {
        this.mContext = context;
        this.mStatisAPI = statisAPI;
        this.mOnStatisListener = onStatisListener;
        this.mOnCrashListener = onCrashListener;
    }

    public void startCrashMonitor() {
        if (this.mCrashHandler != null) {
            L.warn(this, "crash monitor has been started.", new Object[0]);
            return;
        }
        this.mCrashHandler = new CrashHandler(this.mContext, this.mStatisAPI, this.mOnStatisListener, new CrashHandler.OnHandlerListener(){

            @Override
            public void handler(int crashType, String dmpFilePath, String logFilePath) {
                JSONObject json = CrashController.this.fillInfo(crashType, null, dmpFilePath, logFilePath);
                CrashController.this.saveInfo(json);
                CrashController.this.flushCache();
                if (CrashController.this.mOnCrashListener != null) {
                    CrashController.this.mOnCrashListener.handler(json);
                }
            }
        });
        this.mCrashHandler.init();
        this.flushCache();
        L.info(this, "crash monitor start", new Object[0]);
    }

    public void flushCache() {
        ThreadPool.getPool().execute(new Runnable(){

            @Override
            public void run() {
                CrashController.this.doFlushCache();
            }
        });
    }

    private synchronized void doFlushCache() {
        if (!this.mIsSpecialDo && Build.VERSION.SDK_INT >= 21) {
            this.mIsSpecialDo = true;
            this.doSpecial();
        }
        Map<String, ?> map = this.getAll();
        L.brief("all crash size = %d", map == null ? 0 : map.size());
        if (map != null && map.size() > 0) {
            JSONObject json = null;
            Iterator<Map.Entry<String, ?>> it = map.entrySet().iterator();
            String crashId = null;
            Map.Entry<String, ?> entry = null;
            while (it.hasNext()) {
                try {
                    entry = it.next();
                    crashId = entry.getKey();
                    json = new JSONObject((String)entry.getValue());
                    L.brief("get crashid = %s", crashId);
                    if (this.doExpire(json)) continue;
                    if (!this.report(json)) break;
                    this.clearInfo(crashId);
                    this.delFile(json.getString("dpath"));
                    this.delFile(json.getString("lpath"));
                    L.brief("del crashid = %s", crashId);
                }
                catch (Throwable e) {
                    L.warn(this, "flushCache exception=%s", e);
                }
            }
        }
    }

    private void doSpecial() {
        try {
            String dmpPath = this.mCrashHandler.getDmpPath();
            File path = new File(dmpPath);
            File[] files = path.listFiles(new FilenameFilter(){

                @Override
                public boolean accept(File dir, String filename) {
                    return filename != null && !filename.startsWith("J-") && filename.endsWith(".dmp");
                }
            });
            String dmpFilePath = null;
            String logFilePath = null;
            String time = null;
            for (File f : files) {
                dmpFilePath = f.getAbsolutePath();
                logFilePath = dmpFilePath.replace(".dmp", ".log");
                if (FileUtil.isExist(logFilePath)) continue;
                time = String.valueOf(Util.millisToSec(f.lastModified()));
                L.brief("timetime = %s", time);
                FileUtil.writeFile(logFilePath, "");
                JSONObject json = this.fillInfo(2, time, dmpFilePath, logFilePath);
                this.saveInfo(json);
            }
        }
        catch (Throwable e) {
            L.warn(this, "doSpecial exception.%s", e);
        }
    }

    private boolean doExpire(JSONObject json) {
        try {
            long crashTime = Long.parseLong(json.getString("time")) * 1000L;
            long currTime = Util.wallTimeMillis();
            if (Util.daysBetween(crashTime, currTime) > 5) {
                String crashId = json.getString("crashid");
                L.warnOn(CrashController.class, "del expires crash data: crashId = %s", crashId);
                this.clearInfo(crashId);
                this.delFile(json.getString("dpath"));
                this.delFile(json.getString("lpath"));
                return true;
            }
        }
        catch (Throwable e) {
            L.warnOn(CrashController.class, "deal expires error,%s", e);
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean report(JSONObject json) throws Exception {
        if (ArdUtil.isNetworkAvailable(this.mContext)) {
            String dpath = json.getString("dpath");
            String lpath = json.getString("lpath");
            String jpath = this.parseJsonFilePath(dpath);
            String zipPath = this.parseZipFilePath(dpath);
            try {
                boolean isSucceed;
                FileUtil.writeFile(jpath, json.toString());
                try {
                    ZipUtil.zipFiles(new String[]{dpath, lpath, jpath}, zipPath);
                }
                catch (Throwable e) {
                    L.warn(this, "zip file error.%s", e);
                }
                Map<String, String> textMap = null;
                HashMap<String, String> fileMap = new HashMap<String, String>();
                fileMap.put(new File(zipPath).getName(), zipPath);
                String url = String.format("%s?appkey=%s", this.mUploadUrl, this.mStatisAPI.getOption().getAppkey());
                boolean bl = isSucceed = this.doReport(url, textMap, fileMap, 3);
                return bl;
            }
            finally {
                this.delFile(jpath);
                this.delFile(zipPath);
            }
        }
        return false;
    }

    private boolean doReport(String url, Map<String, String> textMap, Map<String, String> fileMap, int maxTryTimes) {
        boolean isSucceed = false;
        HttpUtil.HttpResp resp = null;
        int tryTimes = 0;
        while (tryTimes++ < maxTryTimes) {
            try {
                resp = HttpUtil.postFileByUrlConn(url, textMap, fileMap);
                if (resp.isSucceed) {
                    L.debug(this, "doReport succeed.tryTimes:%d,statusCode:%d,", tryTimes, resp.statusCode);
                    isSucceed = resp.isSucceed;
                    break;
                }
                L.warn(this, "doReport failed.tryTimes:%d,statusCode:%d,reason:%s", tryTimes, resp.statusCode, resp.reason + "");
            }
            catch (Throwable e) {
                L.warn(this, "doReport exception. tryTimes=%d exception=%s", tryTimes, e);
            }
        }
        return isSucceed;
    }

    private JSONObject fillInfo(int crashType, String time, String dmpFilePath, String logFilePath) {
        JSONObject json = new JSONObject();
        try {
            String act = "mbsdkhdcrash";
            if (time == null) {
                time = String.valueOf(Util.wallTimeSec());
            }
            json.put("act", (Object)act);
            json.put("time", (Object)time);
            json.put("key", (Object)CommonFiller.calKey(act, time));
            json.put("lpath", (Object)logFilePath);
            json.put("dpath", (Object)dmpFilePath);
            json.put("crashid", (Object)this.parseCrashId(dmpFilePath));
            json.put("ctyp", crashType);
            json.put("uid", this.mOnStatisListener.getCurrentUid());
            json.put("app", (Object)this.mStatisAPI.getOption().getAppId());
            json.put("appkey", (Object)this.mStatisAPI.getOption().getAppkey());
            json.put("ver", (Object)this.mStatisAPI.getOption().getVer());
            json.put("from", (Object)this.mStatisAPI.getOption().getFrom());
            json.put("sessionid", (Object)this.mStatisAPI.getSession());
            json.put("sdkver", (Object)HdStatisConfig.getConfig(this.mStatisAPI.getOption().getAppkey()).getSdkVer());
            json.put("imei", (Object)CommonFiller.getIMEI(this.mContext));
            json.put("mac", (Object)CommonFiller.getMacAddr(this.mContext));
            json.put("sjp", (Object)ArdUtil.getSjp(this.mContext));
            json.put("sjm", (Object)ArdUtil.getSjm(this.mContext));
            json.put("sys", 2);
            json.put("mbos", (Object)ArdUtil.getOS());
            json.put("mbl", (Object)ArdUtil.getLang());
            json.put("ntm", (Object)ArdUtil.getNtm(this.mContext));
            json.put("net", ArdUtil.getNetworkTypeNew(this.mContext));
            json.put("sr", (Object)ArdUtil.getScreenResolution(this.mContext));
            json.put("rot", ArdUtil.isRoot() ? 1 : 0);
            json.put("tram", ArdUtil.getTotalMemory(this.mContext));
            json.put("trom", ArdUtil.getTotalInternalStorgeSize());
            json.put("tsd", ArdUtil.getTotalExternalStorgeSize());
            json.put("aram", ArdUtil.getAvailMemory(this.mContext));
            json.put("arom", ArdUtil.getAvailInternalStorgeSize());
            json.put("asd", ArdUtil.getAvailExternalStorgeSize());
            json.put("arid", (Object)CommonFiller.getAndroidId(this.mContext));
            json.put("opid", (Object)ClientIdProxy.getClientId(this.mContext));
            json.put("hdid", (Object)DeviceProxy.getHdid(this.mContext));
            json.put("imc", (Object)(ArdUtil.getImei(this.mContext) + "," + CommonFiller.getMacAddr(this.mContext)));
            json.put("imsi", (Object)ArdUtil.getImsi(this.mContext));
            json.put("idfv", (Object)UuidManager.fetchUUid(this.mContext));
            json.put("guid", (Object)StringUtil.geneGuid());
            json.put("rtyp", 1);
            Long launchTime = this.mStatisAPI.getLaunchTime();
            if (launchTime != null) {
                json.put("ltime", (System.currentTimeMillis() - launchTime) / 1000L);
            }
            json.put("cpage", (Object)DefaultPreference.getPreference().getPrefString(this.mContext, "PREF_CPAGE", null));
            json.put("cpkg", (Object)ArdUtil.getPackageName(this.mContext));
            json.put("cthread", (Object)(ProcessUtil.getCurProcessName(this.mContext) + "#" + Process.myTid()));
        }
        catch (Throwable e) {
            e.printStackTrace();
        }
        return json;
    }

    private void saveInfo(JSONObject json) {
        try {
            this.mPreference.setPrefString(this.mContext, json.getString("crashid"), json.toString());
        }
        catch (JSONException e) {
            e.printStackTrace();
        }
    }

    private void clearInfo(String crashId) {
        try {
            this.mPreference.clearKey(this.mContext, crashId);
        }
        catch (Throwable e) {
            L.error(this, e.getMessage(), new Object[0]);
        }
    }

    private Map<String, ?> getAll() {
        return this.mPreference.getAll(this.mContext);
    }

    private String parseCrashId(String dmpFilePath) {
        return new File(dmpFilePath).getName().replaceAll(".dmp", "");
    }

    private String parseZipFilePath(String dmpFilePath) {
        return dmpFilePath.replaceAll(".dmp", ".zip");
    }

    private String parseJsonFilePath(String dmpFilePath) {
        return dmpFilePath.replaceAll(".dmp", ".json");
    }

    private boolean delFile(String filePath) {
        try {
            File f = new File(filePath);
            return f.exists() && f.delete();
        }
        catch (Throwable e) {
            return false;
        }
    }

    public static interface OnCrashListener {
        public void handler(JSONObject var1);
    }
}

