/*
 * Decompiled with CFR 0.152.
 */
package com.yy.hiidostatis.api;

import android.app.Activity;
import android.app.Application;
import android.content.Context;
import android.os.Build;
import android.view.MotionEvent;
import com.yy.hiidostatis.api.ExecutorProvider;
import com.yy.hiidostatis.api.HiidoApi;
import com.yy.hiidostatis.api.HiidoSDKNew;
import com.yy.hiidostatis.api.HiidoSDKOld;
import com.yy.hiidostatis.api.MetricsWorker;
import com.yy.hiidostatis.api.NotInitHiidoApi;
import com.yy.hiidostatis.api.OnLineConfigListener;
import com.yy.hiidostatis.api.OnStatisListener;
import com.yy.hiidostatis.api.StatisContent;
import com.yy.hiidostatis.api.StatisLogWriter;
import com.yy.hiidostatis.api.StatisOption;
import com.yy.hiidostatis.config.ABNameDefine;
import com.yy.hiidostatis.config.ABTestHandler;
import com.yy.hiidostatis.defs.StatisAPI;
import com.yy.hiidostatis.defs.controller.OaidController;
import com.yy.hiidostatis.defs.listener.ActListener;
import com.yy.hiidostatis.defs.listener.HiidoSdkAdditionDelegate;
import com.yy.hiidostatis.defs.obj.Property;
import com.yy.hiidostatis.defs.obj.ShareType;
import com.yy.hiidostatis.inner.AbstractConfig;
import com.yy.hiidostatis.inner.implementation.CommonFiller;
import com.yy.hiidostatis.inner.util.ArdUtil;
import com.yy.hiidostatis.inner.util.InsideMode;
import com.yy.hiidostatis.inner.util.ThreadPool;
import com.yy.hiidostatis.inner.util.hdid.DeviceProxy;
import com.yy.hiidostatis.inner.util.log.ActLog;
import com.yy.hiidostatis.inner.util.log.L;
import com.yy.hiidostatis.message.log.TraceLog;
import com.yy.hiidostatis.message.module.sessionreport.CalAction;
import com.yy.hiidostatis.message.module.sessionreport.EventValue;
import com.yy.hiidostatis.message.utils.KVIO;
import com.yy.hiidostatis.message.utils.NoNull;
import com.yy.hiidostatis.testui.FloatingService;
import com.yy.mobile.perf.taskexecutor.IYYTaskExecutor;
import java.util.Arrays;
import java.util.Date;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;

public class HiidoSDK {
    public static boolean isDebugMode = false;
    private static volatile String HIIDO_HOST = "mlog.hiido.com";
    private static volatile String[] HIIDO_IPS = new String[]{"59.36.225.150", "59.36.238.156", "59.36.238.157", "125.94.239.223"};
    public static final int SDK_SCODE = 50000;
    public static final String SDK_METRICS_NAME = "SDK_METRICS";
    public static final String SDK_SUCCESS_COUNTER_NAME = "SDK_SUC";
    public static final String SDK_FAILED_COUNTER_NAME = "SDK_FAIL";
    public static final String SDK_DURATION_COUNTER_NAME = "SDK_DUR";
    private static HiidoSDK instance = new HiidoSDK();
    private Context appContext;
    private volatile boolean userAgreed;
    private HiidoApi api = new NotInitHiidoApi();
    private Options mOptions = new Options();
    private boolean isInited = false;

    public static HiidoSDK instance() {
        return instance;
    }

    public void setOptions(Options options) {
        this.mOptions = options;
    }

    public Options getOptions() {
        return this.mOptions;
    }

    public void appStartLaunchWithAppKey(Context context, String appKey, String appId, String from, OnStatisListener listener) {
        StatisOption sOption = new StatisOption();
        sOption.setAppId(appId);
        sOption.setAppkey(appKey);
        sOption.setFrom(from);
        this.appStartLaunchWithAppKey(context, sOption, listener);
    }

    public synchronized void appStartLaunchWithAppKey(Context context, StatisOption sOption, OnStatisListener listener) {
        if (this.isInited) {
            return;
        }
        isDebugMode = !NoNull.isEmpty(HiidoSDK.instance().getOptions().testServer);
        this.appContext = context instanceof Application ? context : context.getApplicationContext();
        ABTestHandler.initInstance(this.appContext);
        KVIO.initialize(context);
        this.api = ABTestHandler.getAbBoolean(ABNameDefine.NEW_PACKER_MODULE) ? new HiidoSDKNew() : new HiidoSDKOld();
        this.api.appStartLaunchWithAppKey(context, sOption, listener);
        this.isInited = true;
    }

    public void reportApplist() {
        this.api.reportApplist();
    }

    public boolean registerActivityLifecycleMonitor(Context context) {
        return this.api.registerActivityLifecycleMonitor(context);
    }

    public void appRun() {
        this.api.appRun();
    }

    public void onResume(long uid, String pageId) {
        this.api.onResume(uid, pageId);
    }

    public void onPause(String pageId, PageActionReportOption reportOption) {
        this.api.onPause(pageId, reportOption);
    }

    public void onResume(long uid, Activity activity) {
        this.api.onResume(uid, activity);
    }

    public void onPause(Activity activity, PageActionReportOption reportOption) {
        this.api.onPause(activity, reportOption);
    }

    public void onScreenResume(String screen) {
        this.api.onScreenResume(screen);
    }

    public void onScreenPause(String screen) {
        this.api.onScreenPause(screen);
    }

    public void setCurPageParam(String param) {
        this.api.setCurPageParam(param);
    }

    public void onScreenMonitor(MotionEvent event) {
        this.api.onScreenMonitor(event);
    }

    public Context getContext() {
        return this.api.getContext();
    }

    public HiidoSDK setLogWriter(StatisLogWriter logWriter) {
        L.setLogSetting(logWriter);
        return this;
    }

    public void reportLogin(long uid) {
        this.api.reportLogin(uid);
    }

    public void reportAppsflyer(String data) {
        this.api.reportAppsflyer(data);
    }

    public void reportShare(String platform, int mediaType, String content, ShareType stype, String errmsg, String screen, String userData) {
        this.api.reportShare(platform, mediaType, content, stype, errmsg, screen, userData);
    }

    public void reportIM(String sender, String receiver, String content, Date editTime, Date sendTime, String errormsg, int mediaType, String userData) {
        this.api.reportIM(sender, receiver, content, editTime, sendTime, errormsg, mediaType, userData);
    }

    public void reportReg(String uid, String name, String type, Map<String, String> prop) {
        this.api.reportReg(uid, name, type, prop);
    }

    public void setHeartbeatField(String key, String value) {
        this.api.setHeartbeatField(key, value);
    }

    public void reportErrorEvent(long uid, String errorId, String errorMessage, String param) {
        this.api.reportErrorEvent(uid, errorId, errorMessage, param);
    }

    public void reportStatisticContentTemporary(String act, StatisContent content) {
        this.api.reportStatisticContentTemporary(act, content);
    }

    public void reportStatisticContent(String act, StatisContent content) {
        this.api.reportStatisticContent(act, content);
    }

    public void reportStatisticContent(String act, StatisContent content, boolean isPriority) {
        this.api.reportStatisticContent(act, content, isPriority);
    }

    public void reportStatisticContentWithNoComm(Context context, String act, StatisContent content) {
        this.api.reportStatisticContentWithNoComm(context, act, content);
    }

    public void reportStatisticContentWithNoComm(Context context, String act, StatisContent content, boolean isPriority) {
        this.api.reportStatisticContentWithNoComm(context, act, content, isPriority);
    }

    public void reportCustomContent(long uid, String type, String content) {
        this.api.reportCustomContent(uid, type, content);
    }

    public void reportCrash(long uid, String crashMsg) {
        this.api.reportCrash(uid, crashMsg);
    }

    public void reportCrash(long uid, Throwable throwable) {
        this.api.reportCrash(uid, throwable);
    }

    public void reportTimesEvent(long uid, String eid) {
        this.api.reportTimesEvent(uid, eid);
    }

    public void reportTimesEvent(long uid, String eid, String label) {
        this.api.reportTimesEvent(uid, eid, label);
    }

    public void reportTimesEvent(long uid, String eid, String label, Property property) {
        this.api.reportTimesEvent(uid, eid, label, property);
    }

    public void reportCountEvent(long uid, String eid, double evalue) {
        this.api.reportCountEvent(uid, eid, evalue);
    }

    public void reportCountEvent(long uid, String eid, double evalue, String label) {
        this.api.reportCountEvent(uid, eid, evalue, label);
    }

    public void reportCountEvent(long uid, String eid, double evalue, String label, Property property) {
        this.api.reportCountEvent(uid, eid, evalue, label, property);
    }

    public void reportSuccess(long uid, String aid, String type, long duration, String parm) {
        this.api.reportSuccess(uid, aid, type, duration, parm);
    }

    public void reportFailure(long uid, String aid, String type, String failCode, String failMsg, String parm) {
        this.api.reportFailure(uid, aid, type, failCode, failMsg, parm);
    }

    public void updateOnlineConfigs(Context context) {
        this.api.updateOnlineConfigs(context);
    }

    public String getOnlineConfigParams(Context context, String onlineKey) {
        return this.api.getOnlineConfigParams(context, onlineKey);
    }

    public void setOnLineConfigListener(OnLineConfigListener onLineConfigListener) {
        this.api.setOnLineConfigListener(onLineConfigListener);
    }

    public String getAppId() {
        return this.api.getAppId();
    }

    public String getAppKey() {
        return this.api.getAppKey();
    }

    public String getFrom() {
        return this.api.getFrom();
    }

    public StatisAPI createNewStatisApi() {
        StatisAPI sApi = new StatisAPI();
        sApi.setAbroad(this.getOptions().isAbroad);
        sApi.setTestServer(this.getOptions().testServer);
        sApi.setBusinessType(this.getOptions().businessType);
        return sApi;
    }

    public void addActAdditionListener(ActListener listener) {
        this.api.addActAdditionListener(listener);
    }

    public void setAdditionParamsDelegate(HiidoSdkAdditionDelegate hiidoSdkAdditionDelegate) {
        this.api.setAdditionParamsDelegate(hiidoSdkAdditionDelegate);
    }

    public void removeActAdditionListerner(ActListener listener) {
        this.api.removeActAdditionListerner(listener);
    }

    public StatisOption getStatisOption() {
        return this.api.getStatisOption();
    }

    public OnStatisListener getOnStatisListener() {
        return this.api.getOnStatisListener();
    }

    public String getDeviceId(Context context) {
        return CommonFiller.getIMEI(context);
    }

    public String getMac(Context context) {
        return CommonFiller.getMacAddr(context);
    }

    @Deprecated
    public String getHdid(Context context) {
        return DeviceProxy.getHdid(context);
    }

    public void getHdid(final Context context, final HdidReceiver receiver) {
        ThreadPool.getPool().execute(new Runnable(){

            @Override
            public void run() {
                String hdid = DeviceProxy.getHdid(context);
                receiver.onHdidReceived(hdid);
            }
        });
    }

    public boolean reportFeedBack(String cont, String link, String remk) {
        return this.api.reportFeedBack(cont, link, remk);
    }

    public void reportLocation(double longitude, double latitude, double altitude) {
        this.api.reportLocation(longitude, latitude, altitude);
    }

    public void reportPushToken(String token) {
        this.api.reportPushToken(token);
    }

    public void setABTest(String ... abtest) {
        ABTestHandler.updateValue(this.appContext, abtest);
    }

    public void setABTest(Map<String, String> abtest) {
        ABTestHandler.updateValue(this.appContext, abtest);
    }

    public MetricsWorker addMetricsWorker(String workName, long interval) {
        return this.api.addMetricsWorker(workName, interval);
    }

    public void reportReturnCode(int scode, String uri, long timeConsumption, String code) {
        this.api.reportReturnCode(scode, uri, timeConsumption, code, null);
    }

    public void reportReturnCode(int scode, String uri, long timeConsumption, String code, Map<String, String> moreinfo) {
        this.api.reportReturnCode(scode, uri, timeConsumption, code, moreinfo);
    }

    public void reportCount(int scode, String uri, String countName, long count) {
        this.api.reportCount(scode, uri, countName, count);
    }

    public void reportCount(int scode, String uri, String countName, long count, int times) {
        this.api.reportCount(scode, uri, countName, count, times);
    }

    public void reportReturnCode(String metricsName, int scode, String uri, long timeConsumption, String code) {
        this.api.reportReturnCode(metricsName, scode, uri, timeConsumption, code, null);
    }

    public void reportReturnCode(String metricsName, int scode, String uri, long timeConsumption, String code, Map<String, String> moreinfo) {
        this.api.reportReturnCode(metricsName, scode, uri, timeConsumption, code, moreinfo);
    }

    public void reportCount(String metricsName, int scode, String uri, String countName, long count) {
        this.api.reportCount(metricsName, scode, uri, countName, count, 1);
    }

    public void reportCount(String metricsName, int scode, String uri, String countName, long count, int times) {
        this.api.reportCount(metricsName, scode, uri, countName, count, times);
    }

    public void setUserAgreed(boolean agreed) {
        this.userAgreed = agreed;
    }

    public boolean isUserAgreed() {
        if (Build.VERSION.SDK_INT >= 23 || this.userAgreed) {
            return true;
        }
        String sjp = null;
        try {
            sjp = ArdUtil.getSjp(this.appContext);
            sjp.trim();
        }
        catch (Throwable e) {
            L.error(this, e.toString(), new Object[0]);
        }
        return sjp != null && (sjp.equalsIgnoreCase("OPPO") || sjp.equalsIgnoreCase("VIVO"));
    }

    public void reportSrcData(int scode, String uri, String topic, long val, Map<String, String> extra) {
        this.api.reportSrcData(scode, uri, topic, val, extra);
    }

    public void reportSrcData(String metricsName, int scode, String uri, String topic, long val, Map<String, String> extra) {
        this.api.reportSrcData(metricsName, scode, uri, topic, val, extra);
    }

    public static void setHiidoHost(String host, List<String> ips) {
        if (host != null && !host.isEmpty()) {
            HIIDO_HOST = host;
        }
        if (ips != null && !ips.isEmpty()) {
            String[] arr = new String[ips.size()];
            for (int i = 0; i < ips.size(); ++i) {
                arr[i] = ips.get(i);
            }
            HIIDO_IPS = arr;
        }
    }

    public static String getHiidoHost() {
        return HIIDO_HOST;
    }

    public static String[] getHiidoIps() {
        return HIIDO_IPS;
    }

    public void beginSession(String session, String act, long globePeriod, Map<String, Long> period) {
        this.api.beginSession(session, act, globePeriod, period);
    }

    public boolean pushToSession(String session, String eventId, List<EventValue> values, Map<String, String> dimens, Map<String, String> extra) {
        return this.api.pushToSession(session, eventId, values, dimens, extra);
    }

    public boolean pushToSession(String session, String eventId, CalAction cal, String key, Number value, Map<String, String> dimens, Map<String, String> extra) {
        return this.api.pushToSession(session, eventId, cal, key, value, dimens, extra);
    }

    public boolean flushSession(String session, String eventId) {
        return this.api.flushSession(session, eventId);
    }

    public boolean flushSessionAll(String session) {
        return this.flushSessionAll(session, null);
    }

    public boolean flushSessionAll(String session, Set<String> ignoreEvent) {
        return this.api.flushSessionAll(session, ignoreEvent);
    }

    public void closeSession(String session) {
        this.api.closeSession(session);
    }

    public static interface HdidReceiver {
        public void onHdidReceived(String var1);
    }

    public static enum PageActionReportOption {
        REPORT_ON_FUTURE_RESUME,
        DO_NOT_REPORT_ON_FUTURE_RESUME;

    }

    public static class Options {
        public static final int BEHAVIOR_SEND_THRESHOLD_MAX = 100;
        public static final int BEHAVIOR_SEND_THRESHOLD_DEFAULT = 10;
        public static final int DEFAULT_BASIC_BEHAVIOR_SEND_INTERVAL = 600000;
        public static final int MIN_BASIC_BEHAVIOR_SEND_INTERVAL = 60000;
        public static final int MAX_BASIC_BEHAVIOR_SEND_INTERVAL = 1800000;
        public int behaviorSendThreshold = 10;
        @Deprecated
        public int behaviorSendIntervalMillis = 600000;
        public static final int DEFAULT_BACKGROUND_DURATION_MILLIS_AS_QUIT = 30000;
        @Deprecated
        public long backgroundDurationMillisAsQuit = 30000L;
        @Deprecated
        public volatile String testServer;
        public boolean isOpenCrashMonitor = true;
        public boolean isLogOn = false;
        @Deprecated
        public boolean isOpenDo5 = true;
        @Deprecated
        public boolean isOpenDoShort = true;
        @Deprecated
        private boolean reportApplist = false;
        @Deprecated
        public boolean isAbroad = false;
        private boolean gaidEnable = false;
        @Deprecated
        public int businessType = 100;
        private Set<String> ignoreActivity;
        @Deprecated
        public boolean isNewMac = true;
        private int defaultMetricsExpire = 1800;
        public int defaultMetricsInterval = 60;
        private boolean openSDKMetrics = true;
        public boolean openAutoTrack = false;
        private boolean waitGrant = false;
        float gyroscopeThreshold = 0.5f;
        float accelerometerThreshold = 0.6f;
        float lightThreshold = 15.0f;
        private boolean openSensorMonitor = false;
        private int interval = 30;
        private boolean useOaid = true;

        public boolean isUseOaid() {
            return this.useOaid;
        }

        public int getInterval() {
            return this.interval;
        }

        public Options setUseOaid(boolean useOaid) {
            this.useOaid = useOaid;
            return this;
        }

        public void setInterval(int interval) {
            this.interval = interval;
        }

        public Options addOaidInitListener(OaidController.OaidInitListener l) {
            if (Build.VERSION.SDK_INT < 28) {
                return this;
            }
            OaidController.INSTANCE.addListener(l);
            return this;
        }

        public Options setSensorThreshold(float gyroscope, float accelerometer, float light) {
            this.gyroscopeThreshold = gyroscope;
            this.accelerometerThreshold = accelerometer;
            this.lightThreshold = light;
            return this;
        }

        public boolean isOpenSensorMonitor() {
            return this.openSensorMonitor;
        }

        public Options setOpenSensorMonitor(boolean openSensorMonitor) {
            this.openSensorMonitor = openSensorMonitor;
            return this;
        }

        public Options setHostApp(InsideMode.HostApp hostApp) {
            InsideMode.initHostApp(hostApp);
            return this;
        }

        public Options setActLogEnable(boolean b) {
            ActLog.setLogEnable(b);
            TraceLog.setEnable(b);
            return this;
        }

        public Options setTaskExecutor(IYYTaskExecutor executor) {
            ExecutorProvider.setIyyTaskExecutor(executor);
            return this;
        }

        public Options setMaxDataRetryTimes(int maxTimes) {
            AbstractConfig.MAX_DATA_RETRY_TIME = maxTimes > 10000 ? maxTimes : 10000;
            return this;
        }

        @Deprecated
        public boolean isAbroad() {
            return this.isAbroad;
        }

        @Deprecated
        public Options setAbroad(boolean abroad) {
            this.isAbroad = abroad;
            return this;
        }

        public boolean isGaidEnable() {
            return this.gaidEnable;
        }

        public Options setGaidEnable(boolean enable) {
            this.isAbroad = enable;
            this.gaidEnable = enable;
            return this;
        }

        public Options setMaxDataCacheDay(int maxDay) {
            AbstractConfig.MAX_DATA_CACHE_DAY = maxDay > 5 ? maxDay : 5;
            return this;
        }

        public Set<String> getIgnoreActivity() {
            return this.ignoreActivity;
        }

        public Options setIgnoreActivity(String ... activitys) {
            if (activitys == null) {
                return this;
            }
            if (this.ignoreActivity == null) {
                this.ignoreActivity = new HashSet<String>(activitys.length);
            } else {
                this.ignoreActivity.clear();
            }
            this.ignoreActivity.addAll(Arrays.asList(activitys));
            return this;
        }

        public boolean isWaitGrant() {
            return this.waitGrant;
        }

        public Options setWaitGrant(boolean waitGrant) {
            this.waitGrant = waitGrant;
            return this;
        }

        public int getBehaviorSendThreshold() {
            return this.behaviorSendThreshold;
        }

        public Options setBehaviorSendThreshold(int behaviorSendThreshold) {
            this.behaviorSendThreshold = behaviorSendThreshold;
            return this;
        }

        public long getBackgroundDurationMillisAsQuit() {
            return this.backgroundDurationMillisAsQuit;
        }

        public Options setBackgroundDurationMillisAsQuit(long backgroundDurationMillisAsQuit) {
            this.backgroundDurationMillisAsQuit = backgroundDurationMillisAsQuit;
            return this;
        }

        public boolean isOpenCrashMonitor() {
            return this.isOpenCrashMonitor;
        }

        public Options setOpenCrashMonitor(boolean openCrashMonitor) {
            this.isOpenCrashMonitor = openCrashMonitor;
            return this;
        }

        public boolean isLogOn() {
            return this.isLogOn;
        }

        public Options setLogOn(boolean logOn) {
            this.isLogOn = logOn;
            return this;
        }

        @Deprecated
        public boolean isOpenDoShort() {
            return this.isOpenDoShort;
        }

        @Deprecated
        public Options setOpenDoShort(boolean openDoShort) {
            this.isOpenDoShort = openDoShort;
            return this;
        }

        public int getDefaultMetricsExpire() {
            return this.defaultMetricsExpire;
        }

        public Options setDefaultMetricsExpire(int defaultMetricsExpire) {
            this.defaultMetricsExpire = defaultMetricsExpire;
            return this;
        }

        public int getDefaultMetricsInterval() {
            return this.defaultMetricsInterval;
        }

        public Options setDefaultMetricsInterval(int defaultMetricsInterval) {
            this.defaultMetricsInterval = defaultMetricsInterval;
            return this;
        }

        public boolean isOpenSDKMetrics() {
            return this.openSDKMetrics;
        }

        public Options setOpenSDKMetrics(boolean openSDKMetrics) {
            this.openSDKMetrics = openSDKMetrics;
            return this;
        }

        public boolean isOpenAutoTrack() {
            return this.openAutoTrack;
        }

        public Options setOpenAutoTrack(boolean openAutoTrack) {
            this.openAutoTrack = openAutoTrack;
            return this;
        }

        public boolean isShowFloatingDialog() {
            return FloatingService.INSTANCT.isDebug();
        }

        public Options setShowFloatingDialog(boolean showFloatingDialog) {
            FloatingService.INSTANCT.setDebug(showFloatingDialog);
            return this;
        }

        public Options needUserAgree() {
            HiidoSDK.instance().setUserAgreed(false);
            return this;
        }
    }
}

