/*
 * Decompiled with CFR 0.152.
 */
package com.yy.hiidostatis.inner.implementation;

import com.yy.hiidostatis.inner.util.cipher.Coder;
import java.io.Serializable;
import java.util.UUID;

public class TaskData
implements Serializable {
    private static final long serialVersionUID = -3875880932357283826L;
    private static final String MAGIC_MD5 = "hd!@#$%";
    private String dataId;
    private String content;
    private int tryTimes;
    private long time;
    private String verifyMd5;
    private long order;

    public TaskData() {
        this.order = this.time = System.currentTimeMillis();
    }

    public String getContent() {
        return this.content;
    }

    public void setContent(String content) {
        this.content = content;
    }

    public int getTryTimes() {
        return this.tryTimes;
    }

    public void setTryTimes(int tryTimes) {
        this.tryTimes = tryTimes;
    }

    public long getTime() {
        return this.time;
    }

    public void setTime(long time) {
        this.time = time;
    }

    public void setDataId(String dataId) {
        this.dataId = dataId;
    }

    public String getDataId() {
        return this.dataId;
    }

    public String createDataId() {
        try {
            return UUID.randomUUID().toString();
        }
        catch (Throwable e) {
            return this.content + this.time;
        }
    }

    public String getVerifyMd5() {
        return this.verifyMd5;
    }

    public void setVerifyMd5(String verifyMd5) {
        this.verifyMd5 = verifyMd5;
    }

    public String createVerifyMd5() {
        try {
            return Coder.encryptMD5(String.format("%s%s", this.content, MAGIC_MD5));
        }
        catch (Throwable e) {
            e.printStackTrace();
            return null;
        }
    }

    public boolean verifyMd5() {
        return this.getVerifyMd5() == null || this.getVerifyMd5().trim().length() == 0 || this.getVerifyMd5().equals(this.createVerifyMd5());
    }

    public boolean equals(Object o) {
        return this.hashCode() == o.hashCode();
    }

    public int hashCode() {
        return this.getDataId().hashCode();
    }

    public long getOrder() {
        return this.order;
    }

    public void setOrder(long order) {
        this.order = order;
    }
}

