/*
 * Decompiled with CFR 0.152.
 */
package com.yy.hiidostatis.defs.obj;

import com.yy.hiidostatis.defs.obj.Elem;
import com.yy.hiidostatis.defs.obj.ParamableElem;
import com.yy.hiidostatis.inner.util.Util;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.util.ArrayList;

public class PageElemInfo
extends ParamableElem
implements Elem {
    private static final long serialVersionUID = -5734456734934257499L;
    String page;
    String npage;
    long ltime;
    long dtime;
    long stime;

    public PageElemInfo() {
    }

    public PageElemInfo(String page, String destPage, long ltime, long dtime, long stime) {
        this.page = page;
        this.npage = destPage;
        this.ltime = ltime;
        this.dtime = dtime;
        this.stime = stime;
    }

    private void readObject(ObjectInputStream s) throws IOException, ClassNotFoundException {
        this.page = (String)s.readObject();
        this.npage = (String)s.readObject();
        this.ltime = s.readLong();
        this.dtime = s.readLong();
        this.stime = s.readLong();
    }

    private void writeObject(ObjectOutputStream s) throws IOException {
        s.writeObject(this.page);
        s.writeObject(this.npage);
        s.writeLong(this.ltime);
        s.writeLong(this.dtime);
        s.writeLong(this.stime);
    }

    public String getPage() {
        return this.page;
    }

    public void setPage(String page) {
        this.page = page;
    }

    public String getDestinationPage() {
        return this.npage;
    }

    public void setDestinationPage(String npage) {
        this.npage = npage;
    }

    public long getLingerTime() {
        return this.ltime;
    }

    public void setLtime(long ltime) {
        this.ltime = ltime;
    }

    public long getDelayedTime() {
        return this.dtime;
    }

    public void setDtime(long dtime) {
        this.dtime = dtime;
    }

    public long getStime() {
        return this.stime;
    }

    public void setStime(long stime) {
        this.stime = stime;
    }

    @Override
    public String getStringRep() {
        StringBuilder sb = new StringBuilder();
        sb.append(Util.replaceEncode(this.page, ":"));
        sb.append(":");
        sb.append(Util.replaceEncode(this.npage, ":"));
        sb.append(":");
        sb.append(this.stime);
        sb.append(":");
        sb.append(this.ltime);
        sb.append(":");
        sb.append(this.dtime);
        sb.append(":");
        String paramString = this.getConnectedParams();
        if (!Util.empty(paramString)) {
            sb.append(Util.replaceEncode(paramString, ":"));
        }
        return sb.toString();
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append(" page=");
        sb.append(this.page);
        sb.append(", dest page=");
        sb.append(this.npage);
        sb.append(", stime=");
        sb.append(this.stime);
        sb.append(", lingertime=");
        sb.append(this.ltime);
        sb.append(", dtime=");
        sb.append(this.dtime);
        return sb.toString();
    }

    public boolean isValid() {
        return !Util.empty(this.page) && !Util.empty(this.npage);
    }

    public PageElemInfo copy() {
        PageElemInfo dest = new PageElemInfo();
        dest.dtime = this.dtime;
        dest.ltime = this.ltime;
        dest.stime = this.stime;
        dest.page = this.page;
        dest.npage = this.npage;
        dest.addParams(new ArrayList<String>(this.getParams()));
        return dest;
    }
}

