/*
 * Decompiled with CFR 0.152.
 */
package com.yy.hiidostatis.testui;

import android.app.Activity;
import android.content.Context;
import android.os.Build;
import android.provider.Settings;
import android.view.MotionEvent;
import android.view.View;
import android.view.ViewGroup;
import android.view.WindowManager;
import android.widget.AbsListView;
import android.widget.BaseAdapter;
import android.widget.LinearLayout;
import android.widget.ListAdapter;
import android.widget.ListView;
import android.widget.TextView;
import com.yy.hiidostatis.inner.util.UiThreadExecutor;
import java.util.ArrayList;
import java.util.List;

public enum FloatingService {
    INSTANCT;

    private static final int DEFAULT_BG = 0x70000000;
    private static final int MOVING_BG = 1895611159;
    private WindowManager windowManager;
    private WindowManager.LayoutParams layoutParams = new WindowManager.LayoutParams();
    private List<String> logs = new ArrayList<String>();
    private Context app;
    private LogAdapter adapter = new LogAdapter();
    private volatile boolean init = false;
    private ListView listView;
    private String filterAppkey;
    private boolean isDebug;
    private boolean movingState;

    public String getFilterAppkey() {
        return this.filterAppkey;
    }

    public void setFilterAppkey(String filterAppkey) {
        this.filterAppkey = filterAppkey;
    }

    public boolean isDebug() {
        return this.isDebug;
    }

    public void setDebug(boolean debug) {
        this.isDebug = debug;
    }

    public boolean isInit() {
        return this.init;
    }

    public void showFloatingWindow(Activity ctx) {
        this.isDebug = true;
        this.app = ctx.getApplication();
        if (Build.VERSION.SDK_INT >= 23) {
            if (Settings.canDrawOverlays((Context)this.app)) {
                this.initView();
            }
        } else {
            this.initView();
        }
    }

    private void initView() {
        this.windowManager = (WindowManager)this.app.getSystemService("window");
        ListView lv = new ListView(this.app);
        lv.setAdapter((ListAdapter)this.adapter);
        lv.setBackgroundColor(0x70000000);
        lv.setPadding(10, 10, 10, 10);
        this.listView = lv;
        this.layoutParams.type = Build.VERSION.SDK_INT >= 26 ? 2038 : 2002;
        this.layoutParams.format = 1;
        this.layoutParams.width = -1;
        this.layoutParams.height = 300;
        this.layoutParams.x = 0;
        this.layoutParams.y = 10;
        this.layoutParams.flags = 40;
        this.layoutParams.gravity = 51;
        lv.setOnTouchListener((View.OnTouchListener)new FloatingOnTouchListener());
        this.windowManager.addView((View)lv, (ViewGroup.LayoutParams)this.layoutParams);
        this.init = true;
    }

    public void addLog(String time, String appkey, String type, String guid, String act) {
        if (!this.isDebug) {
            return;
        }
        String temp = null;
        if (this.filterAppkey != null && !this.filterAppkey.isEmpty()) {
            if (!this.filterAppkey.startsWith(appkey)) {
                return;
            }
            temp = String.format("%s  %s  %s  %s", time, type, act, guid);
        } else {
            temp = String.format("%s %s %s %s %s", time, type, act, guid, appkey);
        }
        final String log = temp;
        UiThreadExecutor.runTask(new Runnable(){

            @Override
            public void run() {
                if (FloatingService.this.logs.size() >= 499) {
                    FloatingService.this.logs.remove(0);
                }
                FloatingService.this.logs.add(log);
                if (FloatingService.this.init) {
                    FloatingService.this.adapter.notifyDataSetChanged();
                    FloatingService.this.listView.smoothScrollToPosition(FloatingService.this.logs.size());
                }
            }
        });
    }

    private class FloatingOnTouchListener
    implements View.OnTouchListener {
        private int x;
        private int y;
        private boolean hasDown;
        private long downTime;

        private FloatingOnTouchListener() {
        }

        public boolean onTouch(View view, MotionEvent event) {
            boolean ret = true;
            switch (event.getAction()) {
                case 0: {
                    this.x = (int)event.getRawX();
                    this.y = (int)event.getRawY();
                    int[] point = new int[2];
                    FloatingService.this.listView.getLocationOnScreen(point);
                    if (point[0] < this.x && this.x < point[0] + FloatingService.this.listView.getWidth() && point[1] < this.y && this.y < point[1] + FloatingService.this.listView.getHeight()) {
                        ret = false;
                        this.hasDown = true;
                        this.downTime = System.currentTimeMillis();
                        break;
                    }
                    this.hasDown = false;
                    break;
                }
                case 2: {
                    if (!this.hasDown) break;
                    if (FloatingService.this.movingState) {
                        int nowX = (int)event.getRawX();
                        int nowY = (int)event.getRawY();
                        int movedX = nowX - this.x;
                        int movedY = nowY - this.y;
                        this.x = nowX;
                        this.y = nowY;
                        ((FloatingService)FloatingService.this).layoutParams.x += movedX;
                        ((FloatingService)FloatingService.this).layoutParams.y += movedY;
                        FloatingService.this.windowManager.updateViewLayout(view, (ViewGroup.LayoutParams)FloatingService.this.layoutParams);
                    } else if (System.currentTimeMillis() - this.downTime > 1500L) {
                        FloatingService.this.movingState = true;
                        FloatingService.this.listView.setBackgroundColor(1895611159);
                    }
                    ret = false;
                    break;
                }
                case 1: {
                    if (!this.hasDown) break;
                    this.hasDown = false;
                    ret = false;
                    if (!FloatingService.this.movingState) break;
                    FloatingService.this.movingState = false;
                    FloatingService.this.listView.setBackgroundColor(0x70000000);
                }
            }
            return ret;
        }
    }

    public class LogAdapter
    extends BaseAdapter {
        public int getCount() {
            return FloatingService.this.logs.size();
        }

        public Object getItem(int position) {
            return FloatingService.this.logs.get(position);
        }

        public long getItemId(int position) {
            return position;
        }

        public View getView(int position, View convertView, ViewGroup parent) {
            TextView logTv = null;
            if (convertView == null) {
                LinearLayout layout = new LinearLayout(parent.getContext());
                layout.setLayoutParams((ViewGroup.LayoutParams)new AbsListView.LayoutParams(-1, -1));
                layout.setDividerPadding(0);
                TextView tv = new TextView(parent.getContext());
                tv.setTag((Object)"log");
                tv.setTextColor(-1);
                LinearLayout.LayoutParams lp = new LinearLayout.LayoutParams(-2, -2);
                tv.setLayoutParams((ViewGroup.LayoutParams)lp);
                layout.addView((View)tv, (ViewGroup.LayoutParams)lp);
                convertView = layout;
                logTv = tv;
            } else {
                logTv = (TextView)convertView.findViewWithTag((Object)"log");
            }
            logTv.setText((CharSequence)FloatingService.this.logs.get(position));
            return convertView;
        }
    }
}

