/*
 * Decompiled with CFR 0.152.
 */
package com.yy.hiidostatis.inner.util.cipher;

import com.yy.hiidostatis.inner.util.cipher.Base64Util;
import java.io.UnsupportedEncodingException;
import java.security.Key;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.security.SecureRandom;
import javax.crypto.Cipher;
import javax.crypto.SecretKey;
import javax.crypto.SecretKeyFactory;
import javax.crypto.spec.DESKeySpec;

public final class Coder {
    private static final String KEY_MD5 = "MD5";
    private static final String KEY_DES = "DES";
    private static final String KEY_SHA = "SHA";
    private static final String CHARSET = "UTF-8";

    public static String decryptBASE64(String data) throws Exception {
        return Coder.bytesToString(Base64Util.decode(data));
    }

    public static String encryptBASE64(String data) throws Exception {
        return Base64Util.encode(Coder.StringToBytes(data));
    }

    public static String encryptMD5(String data) throws Exception {
        MessageDigest md5 = MessageDigest.getInstance(KEY_MD5);
        return Coder.bytesToHexString(md5.digest(Coder.StringToBytes(data)));
    }

    public static String encryptSHA(String data) throws Exception {
        MessageDigest sha = MessageDigest.getInstance(KEY_SHA);
        sha.update(Coder.StringToBytes(data));
        return Coder.bytesToHexString(sha.digest());
    }

    public static String sha256Encrypt(String strSrc) {
        MessageDigest md = null;
        String strDes = null;
        byte[] bt = strSrc.getBytes();
        try {
            md = MessageDigest.getInstance("SHA-256");
            md.update(bt);
            strDes = Coder.bytesToHexString(md.digest());
        }
        catch (NoSuchAlgorithmException e) {
            return null;
        }
        catch (UnsupportedEncodingException e) {
            return null;
        }
        return strDes;
    }

    public static String encryptDES(String data, String key) throws Exception {
        byte[] bt = Coder.encryptDES(Coder.StringToBytes(data), Coder.StringToBytes(key));
        String strs = Base64Util.encode(bt);
        return strs;
    }

    public static String decryptDES(String data, String key) throws Exception {
        if (data == null) {
            return null;
        }
        byte[] buf = Base64Util.decode(data);
        byte[] bt = Coder.decryptDES(buf, Coder.StringToBytes(key));
        return Coder.bytesToString(bt);
    }

    public static byte[] encryptDES(byte[] data, byte[] key) throws Exception {
        SecureRandom sr = new SecureRandom();
        DESKeySpec dks = new DESKeySpec(key);
        SecretKeyFactory keyFactory = SecretKeyFactory.getInstance(KEY_DES);
        SecretKey securekey = keyFactory.generateSecret(dks);
        Cipher cipher = Cipher.getInstance(KEY_DES);
        cipher.init(1, (Key)securekey, sr);
        return cipher.doFinal(data);
    }

    public static byte[] decryptDES(byte[] data, byte[] key) throws Exception {
        SecureRandom sr = new SecureRandom();
        DESKeySpec dks = new DESKeySpec(key);
        SecretKeyFactory keyFactory = SecretKeyFactory.getInstance(KEY_DES);
        SecretKey securekey = keyFactory.generateSecret(dks);
        Cipher cipher = Cipher.getInstance(KEY_DES);
        cipher.init(2, (Key)securekey, sr);
        return cipher.doFinal(data);
    }

    public static String bytesToHexString(byte[] b) throws UnsupportedEncodingException {
        StringBuilder sb = new StringBuilder();
        if (b != null) {
            for (int i = 0; i < b.length; ++i) {
                sb.append(Integer.toString((b[i] & 0xFF) + 256, 16).substring(1));
            }
        }
        return sb.toString();
    }

    public static byte[] hexStringToBytes(String hexString) {
        char[] hex = hexString.toCharArray();
        int length = hex.length / 2;
        byte[] rawData = new byte[length];
        for (int i = 0; i < length; ++i) {
            int low;
            int high = Character.digit(hex[i * 2], 16);
            int value = high << 4 | (low = Character.digit(hex[i * 2 + 1], 16));
            if (value > 127) {
                value -= 256;
            }
            rawData[i] = (byte)value;
        }
        return rawData;
    }

    public static String bytesToString(byte[] b) throws UnsupportedEncodingException {
        return new String(b, CHARSET);
    }

    public static byte[] StringToBytes(String data) throws UnsupportedEncodingException {
        return data.getBytes(CHARSET);
    }
}

