/*
 * Decompiled with CFR 0.152.
 */
package com.yy.hiidostatis.inner.implementation;

import android.content.Context;
import com.yy.hiidostatis.inner.implementation.TaskData;
import com.yy.hiidostatis.inner.implementation.TaskDataSet;
import com.yy.hiidostatis.inner.implementation.TaskDataSqLiteDBManager;
import com.yy.hiidostatis.inner.util.ProcessUtil;
import com.yy.hiidostatis.inner.util.log.ActLog;
import com.yy.hiidostatis.inner.util.log.L;
import java.util.Iterator;
import java.util.concurrent.locks.ReentrantLock;

public class TaskDataSqLiteCacheManager {
    private static final int MAX_CACHE_SIZE = 100;
    private TaskDataSet memoryCacheDataSet = new TaskDataSet();
    private ReentrantLock lock = new ReentrantLock();
    private String mCacheFileName;
    private Context mCtx;
    private TaskDataSqLiteDBManager mDbManager;
    private int mLastFileSize = -1;
    private boolean isFirstSyncFromFile = true;

    public TaskDataSqLiteCacheManager(Context ctx, String fileName) {
        this.mCtx = ctx;
        this.mCacheFileName = fileName;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean save(Context context, TaskData data) {
        boolean bl;
        long bTime = System.currentTimeMillis();
        this.lock.lock();
        try {
            if (this.memoryCacheDataSet.size() < 100) {
                this.memoryCacheDataSet.save(data);
            }
            this.getDbManager().save(data);
            L.verbose(this, "save data : %s to file . memory cache dataset size = %d. mLastFileSize = %d", data.getDataId(), this.memoryCacheDataSet.size(), this.mLastFileSize);
            bl = true;
            this.lock.unlock();
        }
        catch (Throwable e) {
            try {
                L.error(this, "Failed to save data : %s Exception:%s", data.getDataId(), e);
                this.lock.unlock();
            }
            catch (Throwable throwable) {
                this.lock.unlock();
                L.brief("save elapsed time :%d ms", System.currentTimeMillis() - bTime);
                throw throwable;
            }
            L.brief("save elapsed time :%d ms", System.currentTimeMillis() - bTime);
            return false;
        }
        L.brief("save elapsed time :%d ms", System.currentTimeMillis() - bTime);
        return bl;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean saveAll(Context context, TaskDataSet tds) {
        boolean it222;
        long bTime = System.currentTimeMillis();
        this.lock.lock();
        try {
            if (this.memoryCacheDataSet.size() < 100) {
                Iterator<TaskData> it222 = tds.iterator();
                while (it222.hasNext()) {
                    this.memoryCacheDataSet.save(it222.next());
                    if (this.memoryCacheDataSet.size() < 100) continue;
                }
            }
            this.getDbManager().saveAll(tds);
            L.verbose(this, "saveAll data : dataSize [%d] to file . memory cache dataset size = %d. mLastFileSize = %d", tds.size(), this.memoryCacheDataSet.size(), this.mLastFileSize);
            it222 = true;
            this.lock.unlock();
        }
        catch (Throwable e) {
            try {
                L.error(this, "Failed to saveAll data : dataSize [%d] Exception:%s", tds.size(), e);
                this.lock.unlock();
            }
            catch (Throwable throwable) {
                this.lock.unlock();
                L.brief("saveAll elapsed time :%d ms", System.currentTimeMillis() - bTime);
                throw throwable;
            }
            L.brief("saveAll elapsed time :%d ms", System.currentTimeMillis() - bTime);
            return false;
        }
        L.brief("saveAll elapsed time :%d ms", System.currentTimeMillis() - bTime);
        return it222;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean update(Context context, TaskData data) {
        boolean bl;
        long bTime = System.currentTimeMillis();
        this.lock.lock();
        try {
            if (this.memoryCacheDataSet.remove(data)) {
                this.memoryCacheDataSet.update(data);
            }
            this.getDbManager().update(data);
            L.verbose(this, "update data : %s to file . memory cache dataset size = %d. mLastFileSize = %d", data.getDataId(), this.memoryCacheDataSet.size(), this.mLastFileSize);
            bl = true;
            this.lock.unlock();
        }
        catch (Throwable e) {
            try {
                L.error(this, "Failed to update data : %s Exception:%s", data.getDataId(), e);
                this.lock.unlock();
            }
            catch (Throwable throwable) {
                this.lock.unlock();
                L.brief("update elapsed time :%d ms", System.currentTimeMillis() - bTime);
                throw throwable;
            }
            L.brief("update elapsed time :%d ms", System.currentTimeMillis() - bTime);
            return false;
        }
        L.brief("update elapsed time :%d ms", System.currentTimeMillis() - bTime);
        return bl;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public TaskData getFirst(Context context) {
        long bTime = System.currentTimeMillis();
        this.lock.lock();
        TaskData data = null;
        try {
            if (this.memoryCacheDataSet.isEmpty()) {
                this.syncFromFile(context);
            }
            if (!this.memoryCacheDataSet.isEmpty()) {
                data = this.memoryCacheDataSet.getFirst();
                if (this.memoryCacheDataSet.size() > 1) {
                    this.memoryCacheDataSet.removeFirst();
                }
            }
            L.verbose(this, "getFirst from  memory cache. memory cache dataset size = %d. mLastFileSize = %d", this.memoryCacheDataSet.size(), this.mLastFileSize);
            this.lock.unlock();
        }
        catch (Throwable e) {
            try {
                L.error(this, "Failed to getFirst data .Exception:%s", e);
                this.lock.unlock();
            }
            catch (Throwable throwable) {
                this.lock.unlock();
                L.brief("getFirst elapsed time :%d ms", System.currentTimeMillis() - bTime);
                throw throwable;
            }
            L.brief("getFirst elapsed time :%d ms", System.currentTimeMillis() - bTime);
        }
        L.brief("getFirst elapsed time :%d ms", System.currentTimeMillis() - bTime);
        return data;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public TaskData getLast(Context context) {
        long bTime = System.currentTimeMillis();
        this.lock.lock();
        TaskData data = null;
        try {
            if (this.memoryCacheDataSet.isEmpty()) {
                this.syncFromFile(context);
            }
            if (!this.memoryCacheDataSet.isEmpty()) {
                data = this.memoryCacheDataSet.getLast();
                if (this.memoryCacheDataSet.size() > 1) {
                    this.memoryCacheDataSet.remove(data);
                }
            }
            L.verbose(this, "getLast from  memory cache. memory cache dataset size = %d. mLastFileSize = %d", this.memoryCacheDataSet.size(), this.mLastFileSize);
            this.lock.unlock();
        }
        catch (Throwable e) {
            try {
                L.error(this, "Failed to getLast data .Exception:%s", e);
                this.lock.unlock();
            }
            catch (Throwable throwable) {
                this.lock.unlock();
                L.brief("getLast elapsed time :%d ms", System.currentTimeMillis() - bTime);
                throw throwable;
            }
            L.brief("getLast elapsed time :%d ms", System.currentTimeMillis() - bTime);
        }
        L.brief("getLast elapsed time :%d ms", System.currentTimeMillis() - bTime);
        return data;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void remove(Context context, TaskData data) {
        long bTime = System.currentTimeMillis();
        this.lock.lock();
        try {
            if (!this.memoryCacheDataSet.isEmpty()) {
                boolean isRemove = this.memoryCacheDataSet.remove(data);
                L.verbose(this, "remove from  memory cache [%b].", isRemove);
            }
            this.getDbManager().remove(data);
            L.verbose(this, "remove data : %s from file . memory cache dataset size = %d. mLastFileSize = %d ", data.getDataId(), this.memoryCacheDataSet.size(), this.mLastFileSize);
            this.lock.unlock();
        }
        catch (Throwable e) {
            try {
                L.error(this, "Failed to remove data .Exception:%s", e);
                this.lock.unlock();
            }
            catch (Throwable throwable) {
                this.lock.unlock();
                L.brief("remove elapsed time :%d ms", System.currentTimeMillis() - bTime);
                throw throwable;
            }
            L.brief("remove elapsed time :%d ms", System.currentTimeMillis() - bTime);
        }
        L.brief("remove elapsed time :%d ms", System.currentTimeMillis() - bTime);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public int size(Context context) {
        int n;
        long bTime = System.currentTimeMillis();
        this.lock.lock();
        try {
            n = this.getDbManager().size();
            this.lock.unlock();
        }
        catch (Throwable e) {
            try {
                L.error(this, "Failed to get size .Exception:%s", e);
                this.lock.unlock();
            }
            catch (Throwable throwable) {
                this.lock.unlock();
                L.brief("get size elapsed time :%d ms", System.currentTimeMillis() - bTime);
                throw throwable;
            }
            L.brief("get size elapsed time :%d ms", System.currentTimeMillis() - bTime);
            return 0;
        }
        L.brief("get size elapsed time :%d ms", System.currentTimeMillis() - bTime);
        return n;
    }

    public void storePendingCommands(Context context) {
    }

    private void syncFromFile(Context context) {
        this.mLastFileSize = this.getDbManager().size();
        int fetchSize = this.isFirstSyncFromFile ? 50 : 100;
        this.isFirstSyncFromFile = false;
        TaskDataSet ds = this.getDbManager().getFirstList(fetchSize);
        if (ds != null) {
            TaskDataSet failTds = new TaskDataSet();
            TaskData td = null;
            int succ = 0;
            int fail = 0;
            while ((td = ds.removeFirst()) != null) {
                if (td.verifyMd5()) {
                    this.memoryCacheDataSet.save(td);
                    ++succ;
                    continue;
                }
                failTds.save(td);
                ++fail;
                L.warn(this, "data verify failure ,give up .data=[%s]", td.getContent());
                ActLog.writeSendFailLog(context, "-", null, td.getContent(), "drop one data.verifyMd5 Failure", "-1", null);
                ActLog.writeActLog(null, "Dis", td.getContent(), null, null, null);
            }
            this.getDbManager().removeAll(failTds);
            L.debug(this, "syncFromFile. succ dataset size = [%d],fail dataset size = [%d], file dataset size = [%d]", succ, fail, this.mLastFileSize);
        } else {
            L.debug(this, "syncFromFile dataset size = 0", new Object[0]);
        }
    }

    private TaskDataSqLiteDBManager getDbManager() {
        if (this.mDbManager != null) {
            return this.mDbManager;
        }
        String dbName = String.format("%s.db", ProcessUtil.getFileNameBindProcess(this.mCtx, this.mCacheFileName));
        L.brief("dbName = %s", dbName);
        this.mDbManager = new TaskDataSqLiteDBManager(this.mCtx, dbName);
        return this.mDbManager;
    }
}

