/*
 * Decompiled with CFR 0.152.
 */
package com.yy.hiidostatis.inner.implementation;

import android.content.Context;
import android.os.Handler;
import android.os.HandlerThread;
import com.yy.hiidostatis.inner.implementation.TaskData;
import com.yy.hiidostatis.inner.implementation.TaskDataSet;
import com.yy.hiidostatis.inner.util.ProcessUtil;
import com.yy.hiidostatis.inner.util.ThreadPool;
import com.yy.hiidostatis.inner.util.cipher.Base64Util;
import com.yy.hiidostatis.inner.util.log.ActLog;
import com.yy.hiidostatis.inner.util.log.L;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.InputStreamReader;
import java.io.OutputStreamWriter;
import java.util.Iterator;
import java.util.concurrent.locks.ReentrantLock;

public class TaskDataMemoryCacheManager {
    private ReentrantLock lock = new ReentrantLock();
    private String mCacheFileName;
    private TaskDataSet memoryCacheDataSet = new TaskDataSet();
    private Context mCtx;
    private Handler mHandler;
    private boolean isSync = false;
    private Runnable syncR = new Runnable(){

        @Override
        public void run() {
            ThreadPool.getPool().execute(TaskDataMemoryCacheManager.this.realR);
        }
    };
    private Runnable realR = new Runnable(){

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            long bTime = System.currentTimeMillis();
            TaskDataMemoryCacheManager.this.lock.lock();
            try {
                TaskDataMemoryCacheManager.this.lastSyncT = System.currentTimeMillis();
                TaskDataMemoryCacheManager.this.syncToFile(TaskDataMemoryCacheManager.this.mCtx, TaskDataMemoryCacheManager.this.memoryCacheDataSet);
                TaskDataMemoryCacheManager.this.lock.unlock();
            }
            catch (Throwable e) {
                try {
                    L.error(this, "Failed to syncToFile .Exception:%s", e);
                    TaskDataMemoryCacheManager.this.lock.unlock();
                }
                catch (Throwable throwable) {
                    TaskDataMemoryCacheManager.this.lock.unlock();
                    L.brief("syncToFile elapsed time :%d ms", System.currentTimeMillis() - bTime);
                    throw throwable;
                }
                L.brief("syncToFile elapsed time :%d ms", System.currentTimeMillis() - bTime);
            }
            L.brief("syncToFile elapsed time :%d ms", System.currentTimeMillis() - bTime);
        }
    };
    private long lastSyncT = 0L;
    private int times = 0;
    private String mFileNameBindProcess = null;

    public TaskDataMemoryCacheManager(Context ctx, String fileName) {
        this.mCtx = ctx;
        HandlerThread ht = new HandlerThread("Statis_SDK_Sync_Delay_Worker");
        ht.start();
        this.mHandler = new Handler(ht.getLooper());
        this.mCacheFileName = fileName;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean save(Context context, TaskData data) {
        boolean bl;
        long bTime = System.currentTimeMillis();
        this.lock.lock();
        try {
            this.syncFromFile(context);
            this.memoryCacheDataSet.save(data);
            L.verbose(this, "save data : %s to memory cache. memory cache dataset size = %d", data.getDataId(), this.memoryCacheDataSet.size());
            this.syncToFile2(context, this.memoryCacheDataSet);
            bl = true;
            this.lock.unlock();
        }
        catch (Throwable e) {
            try {
                L.error(this, "Failed to save data : %s Exception:%s", data.getDataId(), e);
                this.lock.unlock();
            }
            catch (Throwable throwable) {
                this.lock.unlock();
                L.brief("save elapsed time :%d ms", System.currentTimeMillis() - bTime);
                throw throwable;
            }
            L.brief("save elapsed time :%d ms", System.currentTimeMillis() - bTime);
            return false;
        }
        L.brief("save elapsed time :%d ms", System.currentTimeMillis() - bTime);
        return bl;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean update(Context context, TaskData data) {
        boolean bl;
        long bTime = System.currentTimeMillis();
        this.lock.lock();
        try {
            this.syncFromFile(context);
            this.memoryCacheDataSet.update(data);
            L.verbose(this, "update data : %s to memory cache. memory cache dataset size = %d", data.getDataId(), this.memoryCacheDataSet.size());
            this.syncToFile2(context, this.memoryCacheDataSet);
            bl = true;
            this.lock.unlock();
        }
        catch (Throwable e) {
            try {
                L.error(this, "Failed to update data : %s Exception:%s", data.getDataId(), e);
                this.lock.unlock();
            }
            catch (Throwable throwable) {
                this.lock.unlock();
                L.brief("update elapsed time :%d ms", System.currentTimeMillis() - bTime);
                throw throwable;
            }
            L.brief("update elapsed time :%d ms", System.currentTimeMillis() - bTime);
            return false;
        }
        L.brief("update elapsed time :%d ms", System.currentTimeMillis() - bTime);
        return bl;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public TaskData getFirst(Context context) {
        TaskData data;
        long bTime;
        block4: {
            TaskData taskData;
            bTime = System.currentTimeMillis();
            this.lock.lock();
            data = null;
            try {
                this.syncFromFile(context);
                if (this.memoryCacheDataSet.isEmpty()) break block4;
                L.verbose(this, "getFirst from  memory cache. memory cache dataset size = %d", this.memoryCacheDataSet.size());
                taskData = this.memoryCacheDataSet.getFirst();
                this.lock.unlock();
            }
            catch (Throwable e) {
                try {
                    L.error(this, "Failed to getFirst data .Exception:%s", e);
                    this.lock.unlock();
                }
                catch (Throwable throwable) {
                    this.lock.unlock();
                    L.brief("getFirst elapsed time :%d ms", System.currentTimeMillis() - bTime);
                    throw throwable;
                }
                L.brief("getFirst elapsed time :%d ms", System.currentTimeMillis() - bTime);
            }
            L.brief("getFirst elapsed time :%d ms", System.currentTimeMillis() - bTime);
            return taskData;
        }
        this.lock.unlock();
        L.brief("getFirst elapsed time :%d ms", System.currentTimeMillis() - bTime);
        return data;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public TaskData getLast(Context context) {
        TaskData data;
        long bTime;
        block4: {
            TaskData taskData;
            bTime = System.currentTimeMillis();
            this.lock.lock();
            data = null;
            try {
                this.syncFromFile(context);
                if (this.memoryCacheDataSet.isEmpty()) break block4;
                L.verbose(this, "getLast from  memory cache. memory cache dataset size = %d", this.memoryCacheDataSet.size());
                taskData = this.memoryCacheDataSet.getLast();
                this.lock.unlock();
            }
            catch (Throwable e) {
                try {
                    L.error(this, "Failed to getLast data .Exception:%s", e);
                    this.lock.unlock();
                }
                catch (Throwable throwable) {
                    this.lock.unlock();
                    L.brief("getLast elapsed time :%d ms", System.currentTimeMillis() - bTime);
                    throw throwable;
                }
                L.brief("getLast elapsed time :%d ms", System.currentTimeMillis() - bTime);
            }
            L.brief("getLast elapsed time :%d ms", System.currentTimeMillis() - bTime);
            return taskData;
        }
        this.lock.unlock();
        L.brief("getLast elapsed time :%d ms", System.currentTimeMillis() - bTime);
        return data;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public TaskData getRandom(Context context) {
        TaskData data;
        long bTime;
        block4: {
            TaskData taskData;
            bTime = System.currentTimeMillis();
            this.lock.lock();
            data = null;
            try {
                this.syncFromFile(context);
                if (this.memoryCacheDataSet.isEmpty()) break block4;
                L.verbose(this, "getRandom from  memory cache. memory cache dataset size = %d", this.memoryCacheDataSet.size());
                taskData = this.memoryCacheDataSet.getRandom();
                this.lock.unlock();
            }
            catch (Throwable e) {
                try {
                    L.error(this, "Failed to getRandom data .Exception:%s", e);
                    this.lock.unlock();
                }
                catch (Throwable throwable) {
                    this.lock.unlock();
                    L.brief("getRandom elapsed time :%d ms", System.currentTimeMillis() - bTime);
                    throw throwable;
                }
                L.brief("getRandom elapsed time :%d ms", System.currentTimeMillis() - bTime);
            }
            L.brief("getRandom elapsed time :%d ms", System.currentTimeMillis() - bTime);
            return taskData;
        }
        this.lock.unlock();
        L.brief("getRandom elapsed time :%d ms", System.currentTimeMillis() - bTime);
        return data;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void remove(Context context, TaskData data) {
        long bTime = System.currentTimeMillis();
        this.lock.lock();
        try {
            this.syncFromFile(context);
            if (!this.memoryCacheDataSet.isEmpty()) {
                boolean isRemove = this.memoryCacheDataSet.remove(data);
                L.verbose(this, "remove from  memory cache [%b]. memory cache dataset size = %d", isRemove, this.memoryCacheDataSet.size());
            }
            this.syncToFile2(context, this.memoryCacheDataSet);
            this.lock.unlock();
        }
        catch (Throwable e) {
            try {
                L.error(this, "Failed to remove data .Exception:%s", e);
                this.lock.unlock();
            }
            catch (Throwable throwable) {
                this.lock.unlock();
                L.brief("remove elapsed time :%d ms", System.currentTimeMillis() - bTime);
                throw throwable;
            }
            L.brief("remove elapsed time :%d ms", System.currentTimeMillis() - bTime);
        }
        L.brief("remove elapsed time :%d ms", System.currentTimeMillis() - bTime);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public int size(Context context) {
        int n;
        long bTime = System.currentTimeMillis();
        this.lock.lock();
        try {
            this.syncFromFile(context);
            n = this.memoryCacheDataSet.size();
            this.lock.unlock();
        }
        catch (Throwable e) {
            try {
                L.error(this, "Failed to get size .Exception:%s", e);
                this.lock.unlock();
            }
            catch (Throwable throwable) {
                this.lock.unlock();
                L.brief("get size elapsed time :%d ms", System.currentTimeMillis() - bTime);
                throw throwable;
            }
            L.brief("get size elapsed time :%d ms", System.currentTimeMillis() - bTime);
            return 0;
        }
        L.brief("get size elapsed time :%d ms", System.currentTimeMillis() - bTime);
        return n;
    }

    public void storePendingCommands(Context context) {
    }

    private void syncFromFile(Context context) {
        if (!this.isSync) {
            TaskDataSet ds = this.loadStoredDataByLine(context);
            L.debug(this, "syncFromFile dataset size = %d", ds == null ? 0 : ds.size());
            if (ds != null) {
                TaskData td = null;
                int succ = 0;
                int fail = 0;
                while ((td = ds.removeFirst()) != null) {
                    if (td.verifyMd5()) {
                        this.memoryCacheDataSet.save(td);
                        ++succ;
                        continue;
                    }
                    ++fail;
                    L.warn(this, "data verify failure ,give up .data=[%s]", td.getContent());
                    ActLog.writeSendFailLog(context, "-", null, td.getContent(), "drop one data.verifyMd5 Failure", "-1", null);
                    ActLog.writeActLog(null, "Dis", td.getContent(), null, null, null);
                }
                L.debug(this, "syncFromFile. succ size = [%d],fail size = [%d]", succ, fail);
            }
            this.isSync = true;
        }
    }

    private void syncToFile2(Context context, TaskDataSet dataSet) {
        if (this.times++ % 100 == 0 || System.currentTimeMillis() - this.lastSyncT >= 120000L) {
            this.mHandler.removeCallbacks(this.syncR);
            ThreadPool.getPool().execute(this.realR);
        } else {
            this.mHandler.removeCallbacks(this.syncR);
            this.mHandler.postDelayed(this.syncR, 1000L);
        }
    }

    private void syncToFile(Context context, TaskDataSet dataSet) {
        this.saveStoredDataByLine(context, dataSet);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    private TaskDataSet loadStoredDataByLine(Context context) {
        File file;
        InputStreamReader fr;
        BufferedReader br;
        TaskDataSet ds;
        long bTime;
        block26: {
            bTime = System.currentTimeMillis();
            ds = new TaskDataSet();
            br = null;
            fr = null;
            file = new File(context.getFilesDir(), this.getFileNameBindProcess(context, this.mCacheFileName));
            if (file.exists()) break block26;
            L.brief("file is not exist.", new Object[0]);
            TaskDataSet taskDataSet = ds;
            try {
                if (fr != null) {
                    fr.close();
                    fr = null;
                }
                if (br != null) {
                    br.close();
                    br = null;
                }
            }
            catch (Throwable e) {
                L.error(this, e.getMessage(), new Object[0]);
            }
            L.brief("loadStoredData elapsed time :%d ms", System.currentTimeMillis() - bTime);
            return taskDataSet;
        }
        fr = new FileReader(file);
        br = new BufferedReader(fr);
        String line = null;
        TaskData td = null;
        while ((line = br.readLine()) != null) {
            try {
                line = this.decode(line);
                String[] d = line.split("[|]");
                td = new TaskData();
                td.setDataId(d[0]);
                td.setContent(d[1]);
                td.setTime(Long.parseLong(d[2]));
                td.setTryTimes(Integer.parseInt(d[3]));
                if (d.length >= 5) {
                    td.setVerifyMd5(d[4]);
                }
                if (d.length >= 6) {
                    td.setOrder(Long.parseLong(d[5]));
                }
                ds.save(td);
            }
            catch (Throwable e) {
                L.warn(this, "data read exception ,give up :%s.\n %s", line, e);
            }
        }
        L.brief("loadStoredData dataSet size = %d", ds == null ? 0 : ds.size());
        TaskDataSet taskDataSet = ds;
        try {
            if (fr != null) {
                fr.close();
                fr = null;
            }
            if (br != null) {
                br.close();
                br = null;
            }
        }
        catch (Throwable e) {
            L.error(this, e.getMessage(), new Object[0]);
        }
        L.brief("loadStoredData elapsed time :%d ms", System.currentTimeMillis() - bTime);
        return taskDataSet;
        catch (Throwable e) {
            TaskDataSet taskDataSet2;
            try {
                taskDataSet2 = ds;
            }
            catch (Throwable throwable) {
                try {
                    if (fr != null) {
                        fr.close();
                        fr = null;
                    }
                    if (br != null) {
                        br.close();
                        br = null;
                    }
                }
                catch (Throwable e2) {
                    L.error(this, e2.getMessage(), new Object[0]);
                }
                L.brief("loadStoredData elapsed time :%d ms", System.currentTimeMillis() - bTime);
                throw throwable;
            }
            try {
                if (fr != null) {
                    fr.close();
                    fr = null;
                }
                if (br != null) {
                    br.close();
                    br = null;
                }
            }
            catch (Throwable e3) {
                L.error(this, e3.getMessage(), new Object[0]);
            }
            L.brief("loadStoredData elapsed time :%d ms", System.currentTimeMillis() - bTime);
            return taskDataSet2;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    private void saveStoredDataByLine(Context context, TaskDataSet ds) {
        block19: {
            File file;
            long bTime = System.currentTimeMillis();
            OutputStreamWriter fw = null;
            BufferedWriter bw = null;
            if (ds == null) {
                ds = new TaskDataSet();
            }
            if (!(file = new File(context.getFilesDir(), this.getFileNameBindProcess(context, this.mCacheFileName))).exists()) {
                L.brief("file is not exist. create it", new Object[0]);
                file.createNewFile();
            }
            fw = new FileWriter(file);
            bw = new BufferedWriter(fw);
            TaskData td = null;
            int i = 0;
            String verifyMd5 = null;
            Iterator<TaskData> it = ds.iterator();
            StringBuffer lineSb = new StringBuffer();
            String line = null;
            while (it.hasNext()) {
                td = it.next();
                lineSb.setLength(0);
                lineSb.append(td.getDataId()).append("|");
                lineSb.append(td.getContent()).append("|");
                lineSb.append(td.getTime() + "").append("|");
                lineSb.append(td.getTryTimes() + "").append("|");
                verifyMd5 = td.getVerifyMd5();
                lineSb.append(verifyMd5 == null ? "" : verifyMd5);
                lineSb.append("|");
                lineSb.append(td.getOrder());
                line = this.encode(lineSb.toString());
                bw.append(line);
                bw.newLine();
                if (i++ % 100 != 0) continue;
                bw.flush();
                fw.flush();
            }
            bw.flush();
            fw.flush();
            lineSb.setLength(0);
            lineSb = null;
            it = null;
            L.brief("saveStoredData dataSet size = %d", ds == null ? 0 : ds.size());
            try {
                if (fw != null) {
                    fw.close();
                    fw = null;
                }
                if (bw != null) {
                    bw.close();
                    bw = null;
                }
            }
            catch (Throwable e) {
                L.error(this, e.getMessage(), new Object[0]);
            }
            L.brief("saveStoredData elapsed time :%d ms", System.currentTimeMillis() - bTime);
            break block19;
            catch (Throwable e) {
                try {
                    L.error(this, "saveStoredData exception:%s", e);
                }
                catch (Throwable throwable) {
                    try {
                        if (fw != null) {
                            fw.close();
                            fw = null;
                        }
                        if (bw != null) {
                            bw.close();
                            bw = null;
                        }
                    }
                    catch (Throwable e2) {
                        L.error(this, e2.getMessage(), new Object[0]);
                    }
                    L.brief("saveStoredData elapsed time :%d ms", System.currentTimeMillis() - bTime);
                    throw throwable;
                }
                try {
                    if (fw != null) {
                        fw.close();
                        fw = null;
                    }
                    if (bw != null) {
                        bw.close();
                        bw = null;
                    }
                }
                catch (Throwable e3) {
                    L.error(this, e3.getMessage(), new Object[0]);
                }
                L.brief("saveStoredData elapsed time :%d ms", System.currentTimeMillis() - bTime);
            }
        }
    }

    private String encode(String str) {
        try {
            return Base64Util.encode(str.getBytes("UTF-8"));
        }
        catch (Throwable e) {
            e.printStackTrace();
            return str;
        }
    }

    private String decode(String str) {
        try {
            return new String(Base64Util.decode(str), "UTF-8");
        }
        catch (Throwable e) {
            e.printStackTrace();
            return str;
        }
    }

    private String getFileNameBindProcess(Context ctx, String fileName) {
        if (this.mFileNameBindProcess == null) {
            this.mFileNameBindProcess = ProcessUtil.getFileNameBindProcess(ctx, fileName);
        }
        L.brief("mFileNameBindProcess = %s", this.mFileNameBindProcess);
        return this.mFileNameBindProcess;
    }
}

