/*
 * Decompiled with CFR 0.152.
 */
package com.yy.hiidostatis.defs.monitor;

import android.view.MotionEvent;

public enum ScreenMonitor {
    instance;

    private float x1 = 0.0f;
    private float x2 = 0.0f;
    private float y1 = 0.0f;
    private float y2 = 0.0f;
    private int slide = 0;
    private int click = 0;
    private long lastClickTime = 0L;

    public void onTouchEvent(MotionEvent event) {
        if (event.getAction() == 0) {
            this.clickCount();
            this.x1 = event.getX();
            this.y1 = event.getY();
        }
        if (event.getAction() == 1) {
            this.x2 = event.getX();
            this.y2 = event.getY();
            if (this.y1 - this.y2 > 50.0f) {
                this.slideCount();
            } else if (this.y2 - this.y1 > 50.0f) {
                this.slideCount();
            } else if (this.x1 - this.x2 > 50.0f) {
                this.slideCount();
            } else if (this.x2 - this.x1 > 50.0f) {
                this.slideCount();
            }
        }
    }

    public void reset() {
        this.slide = 0;
        this.click = 0;
    }

    public int getSlide() {
        return this.slide;
    }

    public int getClick() {
        return this.click;
    }

    private void clickCount() {
        long currTime = System.currentTimeMillis();
        if (this.lastClickTime == 0L || currTime - this.lastClickTime > 200L) {
            ++this.click;
        }
        this.lastClickTime = currTime;
    }

    private void slideCount() {
        ++this.slide;
    }
}

