/*
 * Decompiled with CFR 0.152.
 */
package com.yy.hiidostatis.defs.listener;

import com.yy.hiidostatis.api.StatisContent;
import com.yy.hiidostatis.defs.interf.IAct;
import com.yy.hiidostatis.defs.listener.ActAdditionListener;
import com.yy.hiidostatis.defs.listener.ActBakAdditionListener;
import com.yy.hiidostatis.defs.listener.ActListener;
import com.yy.hiidostatis.defs.listener.HiidoSdkAdditionDelegate;
import com.yy.hiidostatis.defs.obj.Act;
import com.yy.hiidostatis.inner.util.Util;
import com.yy.hiidostatis.inner.util.log.L;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;

public class ActAdditionListenerController {
    private Map<IAct, ActListener> actMap = new HashMap<IAct, ActListener>();
    private HiidoSdkAdditionDelegate hiidoSdkAdditionDelegate;

    public ActListener add(ActListener listener) {
        ActListener old = this.actMap.put(listener.getAct(), listener);
        L.info(this, "add ActListener act[%s] new listener[%s],old listener[%s]", listener.getAct(), listener, listener);
        return old;
    }

    public HiidoSdkAdditionDelegate getHiidoSdkAdditionDelegate() {
        return this.hiidoSdkAdditionDelegate;
    }

    public void setHiidoSdkAdditionDelegate(HiidoSdkAdditionDelegate hiidoSdkAdditionDelegate) {
        this.hiidoSdkAdditionDelegate = hiidoSdkAdditionDelegate;
    }

    public ActListener remove(ActListener listener) {
        try {
            L.info(this, "remove ActListener act[%s] listener[%s]", listener.getAct(), listener);
            return this.actMap.remove(listener.getAct());
        }
        catch (Throwable e) {
            L.error(this, "error %s", e);
            return null;
        }
    }

    public ActListener getListerner(IAct act) {
        return this.actMap.get(act);
    }

    public StatisContent getActAddition(Act act, ActListener listener) {
        Map<String, String> params;
        StatisContent content = null;
        if (listener != null) {
            ActListener l;
            int size = 0;
            if (listener instanceof ActAdditionListener) {
                l = (ActAdditionListener)listener;
                if (l.getAdditionMap() != null && !l.getAdditionMap().isEmpty()) {
                    content = new StatisContent();
                    size = l.getAdditionMap().size();
                    for (Map.Entry<String, String> entry : l.getAdditionMap().entrySet()) {
                        if (Util.empty(entry.getKey()) || Util.empty(entry.getValue())) continue;
                        content.put(entry.getKey(), entry.getValue());
                    }
                }
            } else if (listener instanceof ActBakAdditionListener) {
                l = (ActBakAdditionListener)listener;
                content = new StatisContent();
                if (!Util.empty(l.getBak1())) {
                    content.put("bak1", l.getBak1());
                    ++size;
                }
                if (!Util.empty(l.getBak2())) {
                    content.put("bak2", l.getBak2());
                    ++size;
                }
                if (!Util.empty(l.getBak3())) {
                    content.put("bak3", l.getBak3());
                    ++size;
                }
            }
            L.debug(this, "getActAddition act[%s], listener[%s], ActAddition size[%d]", listener.getAct(), listener, size);
        }
        if (this.hiidoSdkAdditionDelegate != null && (params = this.hiidoSdkAdditionDelegate.getAdditionParams(act)) != null && !params.isEmpty()) {
            if (content == null) {
                content = new StatisContent();
            }
            Set<Map.Entry<String, String>> kvs = params.entrySet();
            for (Map.Entry<String, String> kv : kvs) {
                if (Util.empty(kv.getKey()) || Util.empty(kv.getValue())) continue;
                content.put(kv.getKey(), kv.getValue());
            }
        }
        return content;
    }
}

