/*
 * Decompiled with CFR 0.152.
 */
package com.yy.hiidostatis.defs.handler;

import android.content.Context;
import com.yy.hiidostatis.api.MetricsWorker;
import com.yy.hiidostatis.defs.controller.HttpSendController;
import com.yy.hiidostatis.inner.AbstractConfig;
import com.yy.hiidostatis.inner.util.SharedTimerTask;
import com.yy.hiidostatis.inner.util.ThreadPool;
import com.yy.hiidostatis.inner.util.http.MetricsHttpEncryptUtil;
import com.yy.hiidostatis.inner.util.log.L;
import com.yy.hiidostatis.pref.HdStatisConfig;
import java.io.File;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;

public class MetricsHandler {
    private Map<String, MetricsWorker> metricsWorkerMap = new ConcurrentHashMap<String, MetricsWorker>();
    private Map<String, TimeWorker> timers = new ConcurrentHashMap<String, TimeWorker>();
    private HttpSendController metricsSend;
    private Context mContext;
    private String appkey;
    private String ver;
    long defaultMetricsExpire;

    public MetricsHandler(Context mContext, String appkey, String ver, long defaultMetricsExpire) {
        this.mContext = mContext;
        this.appkey = appkey;
        this.ver = ver;
        this.defaultMetricsExpire = defaultMetricsExpire;
    }

    private MetricsWorker addMetricsWorker(String workName, long expire, long interval) {
        MetricsWorker worker = this.createMetricsWorker(expire, interval);
        if (worker != null) {
            this.metricsWorkerMap.put(workName, worker);
            TimeWorker tw = new TimeWorker(worker, interval);
            tw.beginTimer();
            this.timers.put(workName, tw);
        } else {
            L.errorOn(this, "Create %s MetricsWorker error", workName);
        }
        return worker;
    }

    public MetricsWorker addMetricsWorker(String workName, long interval) {
        if (this.metricsWorkerMap.containsKey(workName)) {
            return null;
        }
        return this.addMetricsWorker(workName, this.defaultMetricsExpire, interval);
    }

    private MetricsWorker createMetricsWorker(long expire, long interval) {
        return this.createMetricsWorker(expire, interval, this.appkey, this.ver);
    }

    private MetricsWorker createMetricsWorker(long expire, long interval, String appkey, String appVer) {
        try {
            AbstractConfig config = HdStatisConfig.getConfig(appkey);
            String path = this.mContext.getCacheDir().getAbsolutePath() + "/hiido_metrics";
            File dir = new File(path);
            dir.mkdirs();
            if (this.metricsSend == null) {
                MetricsHttpEncryptUtil httpUtil = new MetricsHttpEncryptUtil(config.getUrlHost(), config.getUrlAddress());
                httpUtil.setTestServer(config.getTestServer());
                this.metricsSend = new HttpSendController(httpUtil, dir, 20, 2);
            }
            MetricsWorker worker = new MetricsWorker(this.mContext, 10, this.metricsSend, expire, appkey, appVer, config.getSdkVer());
            return worker;
        }
        catch (Throwable e) {
            return null;
        }
    }

    public boolean containMetric(String metricName) {
        return this.metricsWorkerMap.containsKey(metricName);
    }

    public void onBackground() {
        ThreadPool.getPool().executeQueue(new Runnable(){

            @Override
            public void run() {
                for (Map.Entry entry : MetricsHandler.this.metricsWorkerMap.entrySet()) {
                    ((MetricsWorker)entry.getValue()).sendNow();
                }
            }
        });
    }

    public void onExit() {
        ThreadPool.getPool().executeQueue(new Runnable(){

            @Override
            public void run() {
                for (Map.Entry entry : MetricsHandler.this.timers.entrySet()) {
                    ((TimeWorker)entry.getValue()).stopTimer();
                }
                for (Map.Entry entry : MetricsHandler.this.metricsWorkerMap.entrySet()) {
                    ((MetricsWorker)entry.getValue()).sendNow();
                }
            }
        });
    }

    public void onForeground() {
        ThreadPool.getPool().executeQueue(new Runnable(){

            @Override
            public void run() {
                for (Map.Entry entry : MetricsHandler.this.timers.entrySet()) {
                    ((TimeWorker)entry.getValue()).beginTimer();
                }
            }
        });
    }

    private MetricsWorker getMetricsWorkerByName(String name) {
        if (name == null || name.isEmpty()) {
            return null;
        }
        MetricsWorker mw = this.metricsWorkerMap.get(name);
        return mw;
    }

    public void reportReturnCode(final String metricsName, final int scode, final String uri, final long timeConsumption, final String code) {
        ThreadPool.getPool().executeQueue(new Runnable(){

            @Override
            public void run() {
                MetricsWorker mw = MetricsHandler.this.getMetricsWorkerByName(metricsName);
                if (mw != null) {
                    mw.reportReturnCode(scode, uri, timeConsumption, code);
                } else {
                    L.warnOn(this, "NOT Init %s MetricsWork", metricsName);
                }
            }
        });
    }

    public void reportCount(final String metricsName, final int scode, final String uri, final String countName, final long count) {
        ThreadPool.getPool().executeQueue(new Runnable(){

            @Override
            public void run() {
                MetricsWorker mw = MetricsHandler.this.getMetricsWorkerByName(metricsName);
                if (mw != null) {
                    mw.reportCount(scode, uri, countName, count);
                } else {
                    L.warnOn(this, "NOT Init %s MetricsWork", metricsName);
                }
            }
        });
    }

    public void reportCount(final String metricsName, final int scode, final String uri, final String countName, final long count, final int times) {
        ThreadPool.getPool().executeQueue(new Runnable(){

            @Override
            public void run() {
                MetricsWorker mw = MetricsHandler.this.getMetricsWorkerByName(metricsName);
                if (mw != null) {
                    mw.reportCount(scode, uri, countName, count, times);
                } else {
                    L.warnOn(this, "NOT Init %s MetricsWork", metricsName);
                }
            }
        });
    }

    public void reportSrcData(final String metricsName, final int scode, final String uri, final String topic, final long val, final Map<String, String> extra) {
        ThreadPool.getPool().executeQueue(new Runnable(){

            @Override
            public void run() {
                MetricsWorker mw = MetricsHandler.this.getMetricsWorkerByName(metricsName);
                if (mw != null) {
                    mw.reportSrcData(scode, uri, topic, val, extra);
                } else {
                    L.warnOn(this, "NOT Init %s MetricsWork", metricsName);
                }
            }
        });
    }

    private class TimeWorker {
        private MetricsWorker worker;
        private long interval;
        private volatile SharedTimerTask timerTask;

        public TimeWorker(MetricsWorker worker, long interval) {
            this.worker = worker;
            this.interval = interval;
        }

        public synchronized void beginTimer() {
            if (this.timerTask != null) {
                return;
            }
            this.timerTask = new SharedTimerTask(){

                @Override
                public void run() {
                    TimeWorker.this.worker.sendNow();
                }
            };
            ThreadPool.getPool().getTimer().schedule(this.timerTask, this.interval * 1000L, this.interval * 1000L);
        }

        public synchronized void stopTimer() {
            if (this.timerTask == null) {
                return;
            }
            this.timerTask.cancel();
            this.timerTask = null;
        }
    }
}

