/*
 * Decompiled with CFR 0.152.
 */
package com.yy.hiidostatis.defs.controller;

import android.content.Context;
import com.yy.hiidostatis.inner.util.DefaultPreference;
import com.yy.hiidostatis.inner.util.Util;
import com.yy.hiidostatis.inner.util.cipher.Base64Util;

public class CacheManager {
    private Context c;
    private String mCacheKey;
    private String mCacheValue;
    private String mPrefCacheKey;
    private String mPrefCacheValue;

    public CacheManager(Context c, String prefCacheKey, String prefCacheValue) {
        this.c = c;
        this.mPrefCacheKey = prefCacheKey;
        this.mPrefCacheValue = prefCacheValue;
        this.mCacheKey = this.getCacheKey();
        this.mCacheValue = this.getCacheValue(c, this.mCacheKey);
    }

    private String getCacheKey() {
        try {
            return Util.formatDate("yyyyMMdd", System.currentTimeMillis());
        }
        catch (Throwable e) {
            e.printStackTrace();
            return null;
        }
    }

    private String getCacheValue(Context c, String cacheKey) {
        String tmp;
        String value = "";
        String cachekey = DefaultPreference.getPreference().getPrefString(c, this.mPrefCacheKey, null);
        if (cachekey != null && cachekey.equals(this.mCacheKey) && (tmp = DefaultPreference.getPreference().getPrefString(c, this.mPrefCacheValue, null)) != null) {
            value = new String(Base64Util.decode(tmp));
        }
        return value;
    }

    private void saveCacheValue(Context c, String cacheKey, String cacheValue) {
        DefaultPreference.getPreference().clearKey(c, DefaultPreference.getPreference().getPrefString(c, this.mPrefCacheKey, ""));
        DefaultPreference.getPreference().setPrefString(c, this.mPrefCacheKey, cacheKey);
        DefaultPreference.getPreference().setPrefString(c, this.mPrefCacheValue, Base64Util.encode(cacheValue.getBytes()));
    }

    boolean isContains(String procName) {
        return this.mCacheValue.contains("|" + procName + "|");
    }

    void add(String cacheValue) {
        if (this.mCacheValue.length() == 0) {
            this.mCacheValue = "|";
        }
        this.mCacheValue = this.mCacheValue + cacheValue + "|";
    }

    void finish() {
        this.saveCacheValue(this.c, this.mCacheKey, this.mCacheValue);
        this.mCacheValue = null;
    }
}

