/*
 * Decompiled with CFR 0.152.
 */
package com.yy.hiidostatis.defs.controller;

import android.content.Context;
import android.os.Handler;
import com.yy.hiidostatis.api.HiidoSDK;
import com.yy.hiidostatis.api.StatisContent;
import com.yy.hiidostatis.defs.StatisAPI;
import com.yy.hiidostatis.defs.controller.SensorController;
import com.yy.hiidostatis.defs.interf.IOnStatisListener;
import com.yy.hiidostatis.defs.interf.IStatisAPI;
import com.yy.hiidostatis.defs.obj.AppaElemInfo;
import com.yy.hiidostatis.defs.obj.AppaInfo;
import com.yy.hiidostatis.defs.obj.Info;
import com.yy.hiidostatis.defs.obj.PageElemInfo;
import com.yy.hiidostatis.defs.obj.PageInfo;
import com.yy.hiidostatis.inner.util.DefaultPreference;
import com.yy.hiidostatis.inner.util.ThreadPool;
import com.yy.hiidostatis.inner.util.Util;
import com.yy.hiidostatis.inner.util.log.L;

public class BasicBehaviorController {
    private static final String KEY_QUIT_TIME = "PREF_KEY_StatisSDK_QuitTime";
    private static final String KEY_UID = "PREF_KEY_StatisSDK_UID";
    private static final String KEY_SESSION = "PREF_KEY_StatisSDK_SESSION";
    private static final String KEY_LAST_ONPAUSE_TIME = "PREF_KEY_StatisSDK_LAST_ONPAUSE_TIME";
    private static final String KEY_BEHAVIOR_PAGE = "PREF_KEY_BEHAVIOR_PAGE";
    private static final String KEY_BEHAVIOR_APPA = "PREF_KEY_BEHAVIOR_APPA";
    private final AppActionReporter mAppActionCollector = new AppActionReporter();
    private final PageActionReporter mPageActionCollector = new PageActionReporter();
    private final Context mContext;
    private static final long EMPTY_VALUE = 0L;
    private volatile boolean mIsLoaded = false;
    private long mLastReportCpuMillis;
    private final IOnStatisListener mOnStatisListener;
    private IStatisAPI mStatisAPI;
    private long mBackgroundDurationMillisAsQuit;
    private int mbehaviorSendThreshold;
    private int mMaxbehaviorSendThreshold;
    public static final boolean EMPTY_DATA_FORBIDDEN = false;

    public BasicBehaviorController(Context c, Handler h, IOnStatisListener l, IStatisAPI statisAPI, long backgroundDurationMillisAsQuit, int behaviorSendThreshold, int maxbehaviorSendThreshold) {
        this.mContext = c;
        this.mOnStatisListener = l;
        this.mStatisAPI = statisAPI;
        this.mBackgroundDurationMillisAsQuit = backgroundDurationMillisAsQuit;
        this.mbehaviorSendThreshold = behaviorSendThreshold;
        this.mMaxbehaviorSendThreshold = maxbehaviorSendThreshold;
        this.loadStoredAsync();
    }

    public long getLastReportCpuMillis() {
        return this.mLastReportCpuMillis;
    }

    public boolean isReported() {
        return this.mLastReportCpuMillis != 0L;
    }

    public PageActionReporter getPageActionCollector() {
        return this.mPageActionCollector;
    }

    public AppActionReporter getAppActionCollector() {
        return this.mAppActionCollector;
    }

    private void recordPagePath(String pageId) {
        this.getAppActionCollector().onRecordPagePath(new String[]{pageId});
    }

    private void saveTmpAppa(String param) {
        this.getAppActionCollector().onSaveTmpAppa(param);
    }

    private void onNewDataAdded(long uid) {
        this.sendReportIfReach(this.getThreshold());
    }

    public void sendReportForce(boolean sendEmptyIfNoData) {
        int thresholdForImmediateSend = sendEmptyIfNoData ? -1 : 1;
        this.sendReportIfReach(thresholdForImmediateSend);
    }

    private int getThreshold() {
        int original = this.mbehaviorSendThreshold;
        int maxVal = this.mMaxbehaviorSendThreshold;
        int ret = Math.max(1, Math.min(original, maxVal));
        if (ret < 1 || ret > maxVal) {
            L.error(this, "Error : logical error , threshold result : %d", ret);
        }
        return ret;
    }

    private void sendReportIfReach(int threshold) {
        Context context = this.mContext;
        if (context == null) {
            L.error(this, "Illegal state : Context is null.", new Object[0]);
        }
        PageInfo pageInfo = this.mPageActionCollector.getPageInfo();
        int pageActionElemCount = pageInfo.getElemsCount();
        AppaInfo appaInfo = this.mAppActionCollector.getAppaInfo();
        int appaInfoCount = appaInfo.getElemsCount();
        L.brief("page %d appa %d, threshold %d", pageActionElemCount, appaInfoCount, threshold);
        if (appaInfoCount >= threshold) {
            this.reportBasicBehavior(context, this.mOnStatisListener.getCurrentUid(), appaInfo, null);
            this.mAppActionCollector.clear();
        }
        if (pageActionElemCount >= threshold) {
            this.reportBasicBehavior(context, this.mOnStatisListener.getCurrentUid(), null, pageInfo);
            this.mPageActionCollector.clear();
        }
    }

    private void loadStoredAsync() {
        if (!this.mIsLoaded) {
            this.mIsLoaded = true;
            L.brief("Load stored async", new Object[0]);
            this.loadStoredAsyncSend();
        }
    }

    private void loadStoredAsyncSend() {
        Context c = this.mContext;
        if (c == null) {
            L.error(this, "Illegal state error : no Context set.", new Object[0]);
            return;
        }
        Runnable r = new Runnable(){

            @Override
            public void run() {
                try {
                    String appa = BasicBehaviorController.this.loadStoredAppaInfo();
                    String page = BasicBehaviorController.this.loadStoredPageInfo();
                    L.brief("clear stored info", new Object[0]);
                    BasicBehaviorController.this.clearStoredPageInfo();
                    BasicBehaviorController.this.clearStoredAppaInfo();
                    if (Util.empty(appa) && Util.empty(page)) {
                        L.brief("Input appa is null && page is null ", new Object[0]);
                        return;
                    }
                    long storedUid = BasicBehaviorController.this.getStoredUid(0L);
                    String storedSession = BasicBehaviorController.this.getStoredSession();
                    L.brief("Send old behavior report, for uid %d, session %s", storedUid, storedSession);
                    StatisAPI sApi = HiidoSDK.instance().createNewStatisApi();
                    sApi.setSession(storedSession);
                    sApi.init(BasicBehaviorController.this.mContext, BasicBehaviorController.this.mStatisAPI.getOption());
                    L.info(this, "report stored basicBehavior with new statisAPI [%s]", sApi);
                    if (!Util.empty(appa)) {
                        StatisContent sensor = SensorController.loadFileAndClear(BasicBehaviorController.this.mContext);
                        sApi.reportLanuch(storedUid, appa, sensor);
                    }
                    if (!Util.empty(page)) {
                        sApi.reportPage(storedUid, page);
                    }
                }
                catch (Throwable e) {
                    L.error(this, "loadStoredAsyncSend exception = %s", e);
                    e.printStackTrace();
                }
            }
        };
        ThreadPool.getPool().executeQueue(r);
    }

    private void reportBasicBehavior(Context context, long uid, AppaInfo appa, PageInfo page) {
        if (context == null) {
            L.error("BasicStatisAPI", "Null context when reporting to hiido, cancelled.", new Object[0]);
            return;
        }
        if (BasicBehaviorController.empty(appa) && BasicBehaviorController.empty(page)) {
            L.debug(BasicBehaviorController.class, "BasicBehaviour discarded, None of appa, page has value, %s, %s", appa, page);
        }
        L.brief("To report Appa info %s", appa);
        L.brief("To report Page info %s", page);
        if (appa != null && appa.getElemsCount() > 0) {
            StatisContent sensor = SensorController.loadFileAndClear(context);
            this.mStatisAPI.reportLanuch(uid, appa.getResult(), sensor);
        }
        if (page != null && page.getElemsCount() > 0) {
            this.mStatisAPI.reportPage(uid, page.getResult());
        }
    }

    private static boolean empty(Info<?> info) {
        return info == null || info.getElemsCount() == 0;
    }

    private String loadStoredPageInfo() {
        return DefaultPreference.getPreference().getPrefString(this.mContext, KEY_BEHAVIOR_PAGE, null);
    }

    private void clearStoredPageInfo() {
        DefaultPreference.getPreference().setPrefString(this.mContext, KEY_BEHAVIOR_PAGE, null);
    }

    private void savePageInfo(PageInfo pageInfo) {
        DefaultPreference.getPreference().setPrefString(this.mContext, KEY_BEHAVIOR_PAGE, pageInfo.getResult());
        this.saveUid();
        this.saveSession();
    }

    private String loadStoredAppaInfo() {
        return DefaultPreference.getPreference().getPrefString(this.mContext, KEY_BEHAVIOR_APPA, null);
    }

    private void clearStoredAppaInfo() {
        DefaultPreference.getPreference().setPrefString(this.mContext, KEY_BEHAVIOR_APPA, null);
    }

    private void saveAppaInfo(AppaInfo appaInfo) {
        DefaultPreference.getPreference().setPrefString(this.mContext, KEY_BEHAVIOR_APPA, appaInfo.getResult());
        this.saveUid();
        this.saveSession();
    }

    private long getStoredUid(long defaultValue) {
        return DefaultPreference.getPreference().getPrefLong(this.mContext, KEY_UID, defaultValue);
    }

    private void saveUid() {
        DefaultPreference.getPreference().setPrefLong(this.mContext, KEY_UID, this.mOnStatisListener.getCurrentUid());
    }

    private String getStoredSession() {
        return DefaultPreference.getPreference().getPrefString(this.mContext, KEY_SESSION, null);
    }

    private void saveSession() {
        DefaultPreference.getPreference().setPrefString(this.mContext, KEY_SESSION, this.mStatisAPI.getSession());
    }

    public long getLastOnPauseTime() {
        return DefaultPreference.getPreference().getPrefLong(this.mContext, KEY_LAST_ONPAUSE_TIME, 0L);
    }

    public void saveLastOnPauseTime(long LastOnPauseTime) {
        DefaultPreference.getPreference().setPrefLong(this.mContext, KEY_LAST_ONPAUSE_TIME, LastOnPauseTime);
    }

    private long getLastQuitTime() {
        return DefaultPreference.getPreference().getPrefLong(this.mContext, KEY_QUIT_TIME, 0L);
    }

    private void saveQuitTimeMillis(long quitTime) {
        DefaultPreference.getPreference().setPrefLong(this.mContext, KEY_QUIT_TIME, quitTime);
    }

    public class AppActionReporter {
        private final AppaInfo mAppaInfo = new AppaInfo();
        private volatile AppaElemInfo mElemInfo;
        private long mBeginStartCpuTimeMillis;
        private long mEndStartCpuTimeMillis;

        AppaInfo getAppaInfo() {
            return this.mAppaInfo;
        }

        void clear() {
            this.mAppaInfo.clear();
            this.onSaveAppaFile(this.mAppaInfo);
        }

        public void onStartApp() {
            L.brief("appa onStartApp: init app data", new Object[0]);
            this.resetData();
            this.createElemIfNull();
            this.mBeginStartCpuTimeMillis = Util.wallTimeMillis();
            L.brief("Begin Start Cpu Time Millis is %d", this.mBeginStartCpuTimeMillis);
            if (this.mElemInfo != null) {
                this.mElemInfo.setStime(this.mBeginStartCpuTimeMillis);
            }
            long lastQuitTime = BasicBehaviorController.this.getLastQuitTime();
            L.brief("Loaded last quit time is %d", lastQuitTime);
            if (lastQuitTime != 0L) {
                long ftime = this.mBeginStartCpuTimeMillis - lastQuitTime;
                L.brief("set ftime wall time %d - last quit time %d = %d", this.mBeginStartCpuTimeMillis, lastQuitTime, ftime);
                if (this.mElemInfo != null) {
                    this.mElemInfo.setFtime(ftime);
                }
            } else {
                L.debug(this, "Last quit time is empty value %d", lastQuitTime);
            }
        }

        public void onAppStarted() {
            L.brief("appa onAppStarted: entry", new Object[0]);
            if (this.isStartedCalled()) {
                L.error(this, "appa onAppStarted : already called. mEndStartCpuTimeMillis is %d", this.mEndStartCpuTimeMillis);
            } else {
                this.mEndStartCpuTimeMillis = Util.wallTimeMillis();
                long duration = 0L;
                if (this.isStartCalled()) {
                    duration = this.mEndStartCpuTimeMillis - this.mBeginStartCpuTimeMillis;
                    L.brief("appa :launch delayed : %d millis", duration);
                    if (this.mElemInfo != null) {
                        this.mElemInfo.setDtime(duration);
                    }
                }
                L.brief("appa onAppStarted: mBeginStartCpuTimeMillis [%d],mEndStartCpuTimeMillis[%d],Dtimes[%d] ", this.mBeginStartCpuTimeMillis, this.mEndStartCpuTimeMillis, duration);
            }
        }

        public void onExitApp(boolean flushCommands, boolean isNormal) {
            this.onExitApp(false, flushCommands, isNormal);
        }

        public void addParams(String ... params) {
            if (this.mElemInfo == null) {
                this.createElemIfNull();
            }
            try {
                if (params != null) {
                    for (String e : params) {
                        this.mElemInfo.addParam(e);
                    }
                }
            }
            catch (Throwable e) {
                L.warn(this, "addParams :exception %s", e);
            }
        }

        private void onRecordPagePath(String ... pageId) {
            this.addParams(pageId);
        }

        private void onSaveTmpAppa(String param) {
            AppaInfo info = new AppaInfo();
            info.add(this.mAppaInfo);
            AppaElemInfo elemInfo = this.mElemInfo.copy();
            long ltime = Util.wallTimeMillis() - this.mBeginStartCpuTimeMillis;
            elemInfo.setLingerTime(ltime);
            if (!Util.empty(param)) {
                elemInfo.addParam(param);
            }
            info.addElem(elemInfo);
            this.onSaveAppaFile(info);
        }

        private void onExitApp(boolean shutDown, boolean flushCommands, boolean isNormal) {
            L.brief("appa onExitApp: shutdown %b flush commands %b. isNormal %b", shutDown, flushCommands, isNormal);
            AppaElemInfo elemInfo = this.mElemInfo;
            long quitTime = Util.wallTimeMillis();
            if (isNormal) {
                long lastOnPauseTime = BasicBehaviorController.this.getLastOnPauseTime();
                long t = BasicBehaviorController.this.mBackgroundDurationMillisAsQuit;
                if (lastOnPauseTime < quitTime && lastOnPauseTime - this.mBeginStartCpuTimeMillis > 0L && quitTime - lastOnPauseTime > t - t / 2L && quitTime - lastOnPauseTime < t + t / 2L) {
                    L.brief("appa onExitApp:get the lastOnPauseTime[%d] instead of quitTime[%d]", lastOnPauseTime, quitTime);
                    quitTime = lastOnPauseTime;
                }
            }
            if (elemInfo != null && this.isStartCalled() && this.isStartedCalled()) {
                long lTime = 0L;
                long beginMillis = this.mBeginStartCpuTimeMillis;
                L.brief("Start CPU time millis is %d", beginMillis);
                if (beginMillis != 0L) {
                    lTime = quitTime - beginMillis;
                    L.brief("Calculated usage time, begin %d,end %d, lasts %d", beginMillis, quitTime, lTime);
                    if (lTime != 0L) {
                        L.brief("set app linger time %d sec", lTime);
                        elemInfo.setLingerTime(lTime);
                    } else {
                        L.error(this, "appa onExitApp:Cannot calculate app action linger time.", new Object[0]);
                    }
                    if (lTime > 21600000L || lTime < 0L) {
                        L.warn(this, "appa onExitApp:app action linger time [%d] is off normal.", lTime);
                    } else {
                        L.brief("appa onExitApp:normal", lTime);
                    }
                    this.mAppaInfo.addElem(elemInfo);
                }
            } else {
                L.error(this, "appa onExitApp:Failed to statis app usage time .elemInfo[%s] is null or mBeginStartCpuTimeMillis[%d]=0 or mEndStartCpuTimeMillis[%d]=0", elemInfo, this.mBeginStartCpuTimeMillis, this.mEndStartCpuTimeMillis);
                BasicBehaviorController.this.clearStoredAppaInfo();
            }
            this.resetData();
            BasicBehaviorController.this.saveQuitTimeMillis(quitTime);
            BasicBehaviorController.this.saveUid();
            BasicBehaviorController.this.sendReportForce(false);
        }

        private void createElemIfNull() {
            if (this.mElemInfo == null) {
                this.mElemInfo = new AppaElemInfo();
            }
        }

        private boolean isStartCalled() {
            return this.mBeginStartCpuTimeMillis != 0L;
        }

        private boolean isStartedCalled() {
            return this.mEndStartCpuTimeMillis != 0L;
        }

        private void resetData() {
            this.mElemInfo = null;
            this.mEndStartCpuTimeMillis = 0L;
            this.mBeginStartCpuTimeMillis = 0L;
        }

        private void onSaveAppaFile(final AppaInfo info) {
            ThreadPool.getPool().executeQueue(new Runnable(){

                @Override
                public void run() {
                    BasicBehaviorController.this.saveAppaInfo(info);
                }
            });
        }
    }

    public class PageActionReporter {
        private final PageInfo mPageInfo = new PageInfo();
        private PageElemInfo mPageElemInfo;
        private long mEnterTimeStamp;
        private long mStartJumpingTimeStamp;

        PageInfo getPageInfo() {
            return this.mPageInfo;
        }

        void clear() {
            this.mPageInfo.clear();
            this.onSavePageFile(this.mPageInfo);
        }

        public void clearCurPageElement() {
            this.mPageElemInfo = null;
            this.mEnterTimeStamp = 0L;
            this.mStartJumpingTimeStamp = 0L;
            L.brief("clear curpage element !", new Object[0]);
        }

        private void onSaveTmpPage() {
            PageInfo info = new PageInfo();
            info.add(this.mPageInfo);
            info.addElem(this.mPageElemInfo);
            this.onSavePageFile(info);
            BasicBehaviorController.this.saveTmpAppa(this.mPageElemInfo.getPage());
        }

        public void onResumeUI(long uid, String pageId) {
            if (this.mPageElemInfo != null) {
                this.onFinishGotoUI(uid, pageId, false);
            }
            this.clearCurPageElement();
            this.mPageElemInfo = new PageElemInfo();
            this.mPageElemInfo.setPage(pageId);
            this.mEnterTimeStamp = Util.wallTimeMillis();
            this.mPageElemInfo.setStime(this.mEnterTimeStamp);
            L.brief("page onResumeUI [%s]:normal. init page data,pageid[%s],mEnterTimeStamp[%d]", pageId, pageId, this.mEnterTimeStamp);
        }

        public void onLeavingUI(String pageId, String destPageId) {
            if (this.mPageElemInfo == null) {
                L.error(this, "page onLeavingUI [%s]: Illegal state exception, is onResumeUI not called? mPageElemInfo is null. ", pageId);
                return;
            }
            String curPageId = this.mPageElemInfo.getPage();
            if (!(Util.empty(curPageId) || Util.empty(pageId) || pageId.equals(curPageId))) {
                L.error(this, "page onLeavingUI [%s]: onLeavingUI page[%s] is not euqal onResumeUI page[%s]", curPageId, pageId, curPageId);
                return;
            }
            if (curPageId == null) {
                L.brief("page onLeavingUI [%s]:onResumeUI page[%s] is null,the onLeavingUI page instead of it", pageId, curPageId, pageId);
                curPageId = pageId;
                this.mPageElemInfo.setPage(curPageId);
            }
            if (!Util.empty(curPageId) && this.mEnterTimeStamp != 0L && this.mStartJumpingTimeStamp == 0L) {
                this.mStartJumpingTimeStamp = Util.wallTimeMillis();
                long lingerTimeMillis = this.mStartJumpingTimeStamp - this.mEnterTimeStamp;
                this.mPageElemInfo.setLtime(lingerTimeMillis);
                this.mPageElemInfo.setDestinationPage(destPageId);
                L.brief("page onLeavingUI [%s]:normal. pageid[%s], lingerTimeMillis[%d], mStartJumpingTimeStamp[%d]", curPageId, curPageId, lingerTimeMillis, this.mStartJumpingTimeStamp);
                this.onSaveTmpPage();
            } else {
                L.error(this, "page onLeavingUI[%s], Illegal state exception. pageid[%s] is null or mEnterTimeStamp[%d] = 0 or mStartJumpingTimeStamp[%d]!=0.", curPageId, curPageId, this.mEnterTimeStamp, this.mStartJumpingTimeStamp);
            }
        }

        public void setCurPageParam(String param) {
            if (this.mPageElemInfo != null) {
                this.mPageElemInfo.clearParams();
                this.mPageElemInfo.addParam(param);
            }
        }

        public void onFinishGotoUI(long uid, String destPageId, boolean isExitApp) {
            if (this.mPageElemInfo != null) {
                String oldCurrent = this.mPageElemInfo.getPage();
                if (!Util.empty(oldCurrent) && this.mStartJumpingTimeStamp != 0L && this.mEnterTimeStamp != 0L) {
                    if (isExitApp) {
                        this.mPageElemInfo.setDestinationPage(null);
                        this.mPageElemInfo.setDtime(0L);
                    } else {
                        long curMillis = Util.wallTimeMillis();
                        this.mPageElemInfo.setDestinationPage(destPageId);
                        this.mPageElemInfo.setDtime(curMillis - this.mStartJumpingTimeStamp);
                    }
                    if (this.mPageElemInfo.getDelayedTime() > BasicBehaviorController.this.mBackgroundDurationMillisAsQuit * 3L) {
                        L.warn(this, "page onFinishGotoUI [%s]: Dtime[%d] is off normal,this page data not report", oldCurrent, this.mPageElemInfo.getDelayedTime());
                        this.clearCurPageElement();
                        return;
                    }
                    L.brief("page onFinishGotoUI [%s]:normal. report from page [%s] to destPageId [%s]", oldCurrent, oldCurrent, destPageId);
                    PageElemInfo elem = this.mPageElemInfo;
                    this.mPageInfo.addElem(elem);
                    this.clearCurPageElement();
                    L.brief("Page elements %d", this.mPageInfo.getElemsCount());
                    BasicBehaviorController.this.onNewDataAdded(uid);
                    this.onSavePageFile(this.mPageInfo);
                    BasicBehaviorController.this.recordPagePath(oldCurrent);
                    BasicBehaviorController.this.saveTmpAppa(null);
                } else {
                    L.error(this, "page onFinishGotoUI [%s]: Illegal state exception.pageid[%s] is null or mEnterTimeStamp[%d]=0 or mStartJumpingTimeStamp[%d]=0 ", oldCurrent, oldCurrent, this.mEnterTimeStamp, this.mStartJumpingTimeStamp);
                }
            } else {
                L.error(this, "page onFinishGotoUI , Illegal state exception, is onResumeUI,onLeavingUI not called? mPageElemInfo is null", new Object[0]);
            }
        }

        private void onSavePageFile(final PageInfo info) {
            ThreadPool.getPool().executeQueue(new Runnable(){

                @Override
                public void run() {
                    BasicBehaviorController.this.savePageInfo(info);
                }
            });
        }
    }
}

