/*
 * Decompiled with CFR 0.152.
 */
package com.yy.hiidostatis.inner;

import com.yy.hiidostatis.inner.util.Util;
import com.yy.hiidostatis.inner.util.log.L;
import java.io.UnsupportedEncodingException;
import java.net.URLEncoder;
import java.util.Comparator;
import java.util.Map;
import java.util.TreeMap;

public class BaseStatisContent {
    public static final String ACT = "act";
    public static final String TIME = "time";
    public static final String APPKEY = "appkey";
    public static final String APPID = "app";
    public static final String VER = "ver";
    public static final String SDKVER = "sdkver";
    public static final String FROM = "from";
    public static final String KEY = "key";
    public static final String GUID = "guid";
    public static final String IMEI = "imei";
    public static final String MAC = "mac";
    public static final String NET = "net";
    public static final String SYS = "sys";
    public static final String SJP = "sjp";
    public static final String SJM = "sjm";
    public static final String MBOS = "mbos";
    public static final String MBL = "mbl";
    public static final String SR = "sr";
    public static final String NTM = "ntm";
    public static final String CHANNEL = "chn";
    public static final String ARID = "arid";
    public static final String HDID = "hdid";
    public static final String OPID = "opid";
    public static final String IMC = "imc";
    public static final String IMSI = "imsi";
    public static final String IDFV = "idfv";
    public static final String MDSR = "mdsr";
    public static final String TIMEZONE = "timezone";
    public static final String OAID = "oaid";
    protected static final Comparator<String> COMPARATOR = new Comparator<String>(){

        @Override
        public int compare(String o1, String o2) {
            boolean equals1 = BaseStatisContent.ACT.equals(o1);
            boolean equals2 = BaseStatisContent.ACT.equals(o2);
            if (!equals1 && !equals2) {
                return o1.compareTo(o2);
            }
            if (!equals1 && equals2) {
                return 1;
            }
            if (equals1 && !equals2) {
                return -1;
            }
            if (equals1 && equals2) {
                return 0;
            }
            return 0;
        }
    };
    protected TreeMap<String, String> raw = new TreeMap(COMPARATOR);

    public String put(String key, int value) {
        return this.put(key, String.valueOf(value));
    }

    public String put(String key, long value) {
        return this.put(key, String.valueOf(value));
    }

    public String put(String key, double value) {
        return this.put(key, String.valueOf(value));
    }

    public String get(String key) {
        return this.raw.get(key);
    }

    public boolean containsKey(String key) {
        return this.raw.containsKey(key);
    }

    public synchronized String put(String key, String value) {
        if (Util.empty(key)) {
            L.error(BaseStatisContent.class, "key is invalid for value %s", value);
            return null;
        }
        value = Util.asEmptyOnNull(value);
        return this.raw.put(key, value);
    }

    public synchronized String put(String key, String value, boolean isCover) {
        if (Util.empty(key)) {
            L.error(BaseStatisContent.class, "key is invalid for value %s", value);
            return null;
        }
        value = Util.asEmptyOnNull(value);
        if (isCover) {
            return this.raw.put(key, value);
        }
        if (this.raw.containsKey(key)) {
            return this.raw.get(key);
        }
        return this.raw.put(key, value);
    }

    public synchronized String getContent() {
        StringBuilder sb = new StringBuilder();
        TreeMap<String, String> localRaw = this.raw;
        for (Map.Entry<String, String> e : localRaw.entrySet()) {
            String value = e.getValue();
            if (Util.empty(value)) {
                L.verbose(this, "No value for key %s", e.getKey());
                continue;
            }
            sb.append(e.getKey());
            sb.append("=");
            try {
                sb.append(URLEncoder.encode(value, "UTF-8"));
            }
            catch (UnsupportedEncodingException e1) {
                L.error(this, "encoding fail for key %s", e.getKey());
            }
            sb.append("&");
        }
        if (sb.length() == 0) {
            L.warn(this, "Warn : http content may be null?", new Object[0]);
            sb = null;
            return null;
        }
        if (sb.length() > 0) {
            sb.append("hd_p=E&");
        }
        sb.replace(sb.length() - 1, sb.length(), "");
        String tmp = sb.toString();
        sb.setLength(0);
        sb = null;
        return tmp;
    }

    public String toString() {
        return this.getContent();
    }

    public boolean isEmpty() {
        return this.raw.isEmpty();
    }

    public BaseStatisContent copy() {
        BaseStatisContent dest = new BaseStatisContent();
        dest.raw = new TreeMap(COMPARATOR);
        dest.raw.putAll(this.raw);
        return dest;
    }

    public synchronized void putContent(BaseStatisContent content, boolean isCover) {
        if (content == null || content.isEmpty()) {
            return;
        }
        String oldValue = null;
        for (Map.Entry<String, String> entry : content.raw.entrySet()) {
            if (isCover) {
                oldValue = this.put(entry.getKey(), entry.getValue());
                if (oldValue == null) continue;
                L.brief("value-cover:isCover=%b,key=%s,old-value=%s,new-value=%s", isCover, entry.getKey(), oldValue, entry.getValue());
                continue;
            }
            if (!this.containsKey(entry.getKey())) {
                this.put(entry.getKey(), entry.getValue());
                continue;
            }
            L.brief("value-cover:isCover=%b,key=%s,old-value=%s,new-value=%s,ignore-value=%s", isCover, entry.getKey(), this.get(entry.getKey()), this.get(entry.getKey()), entry.getValue());
        }
    }
}

